/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import net.frozenblock.wilderwild.particle.options.SeedParticleOptions;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2521;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MilkweedBlock
extends class_2521 {
    public static final int GROWTH_CHANCE = 5;
    public static final int MIN_SEEDS_ON_RUSTLE = 14;
    public static final int MAX_SEEDS_ON_RUSTLE = 30;
    public static final int MIN_PODS_FROM_HARVEST = 1;
    public static final int MAX_PODS_FROM_HARVEST = 3;
    public static final class_2758 AGE = class_2741.field_12497;
    private static final int MAX_AGE = 3;

    public MilkweedBlock(@NotNull class_4970.class_2251 settings) {
        super(settings);
    }

    public static boolean isFullyGrown(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 3;
    }

    public static boolean isLower(@NotNull class_2680 state) {
        return state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607;
    }

    public static void onShear(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, @Nullable class_1657 player) {
        class_1799 stack = new class_1799((class_1935)WWItems.MILKWEED_POD);
        stack.method_7939(level.method_8409().method_39332(1, 3));
        MilkweedBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)stack);
        level.method_8396(null, pos, class_3417.field_34896, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28730, pos);
        MilkweedBlock.setAgeOnBothHalves(state.method_26204(), state, level, pos, 0, false);
    }

    public static void setAgeOnBothHalves(class_2248 block, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, int age, boolean spawnParticles) {
        if (age > 3) {
            return;
        }
        level.method_8501(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age)));
        boolean isUpper = state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609;
        boolean hasSecondState = false;
        class_2338 movedPos = isUpper ? pos.method_10074() : pos.method_10084();
        class_2680 secondState = level.method_8320(movedPos);
        if (secondState.method_27852(block)) {
            level.method_8501(movedPos, (class_2680)secondState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age)));
            hasSecondState = true;
        }
        if (spawnParticles && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            int particles = (int)((double)serverLevel.method_8409().method_39332(14, 30) * 0.5);
            double firstYHeight = isUpper ? 0.3 : 0.5;
            double firstYOffset = isUpper ? 0.3 : 0.5;
            class_243 offset = state.method_26226((class_1922)level, pos);
            serverLevel.method_14199((class_2394)SeedParticleOptions.unControlled(true), (double)pos.method_10263() + 0.5 + offset.field_1352, (double)pos.method_10264() + firstYHeight, (double)pos.method_10260() + 0.5 + offset.field_1350, particles, 0.1, firstYOffset, 0.1, 0.0);
            if (hasSecondState) {
                double secondYHeight = isUpper ? -0.5 : 1.3;
                double secondYOffset = isUpper ? 0.3 : 0.5;
                serverLevel.method_14199((class_2394)SeedParticleOptions.unControlled(true), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + secondYHeight, (double)pos.method_10260() + 0.5, particles, 0.2, secondYOffset, 0.2, 0.0);
            }
        }
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE});
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (random.method_43048(5) == 0 && MilkweedBlock.isLower(state) && !MilkweedBlock.isFullyGrown(state)) {
            MilkweedBlock.setAgeOnBothHalves((class_2248)this, state, (class_1937)level, pos, (Integer)state.method_11654((class_2769)AGE) + 1, false);
        }
    }

    @NotNull
    public class_9062 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (stack.method_31574(class_1802.field_8324)) {
            return class_9062.field_47732;
        }
        if (MilkweedBlock.isFullyGrown(state)) {
            if (level instanceof class_3218) {
                if (stack.method_31574(class_1802.field_8868)) {
                    stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                    player.method_7259(class_3468.field_15372.method_14956((Object)class_1802.field_8868));
                    MilkweedBlock.onShear(level, pos, state, player);
                } else {
                    this.pickAndSpawnSeeds(level, state, pos);
                }
            }
            return class_9062.field_47728;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 entity, class_3965 hitResult) {
        if (MilkweedBlock.isFullyGrown(state)) {
            if (level instanceof class_3218) {
                this.pickAndSpawnSeeds(level, state, pos);
            }
            return class_1269.field_5812;
        }
        return super.method_55766(state, level, pos, entity, hitResult);
    }

    public void pickAndSpawnSeeds(@NotNull class_1937 level, class_2680 state, class_2338 pos) {
        level.method_8396(null, pos, WWSounds.BLOCK_MILKWEED_RUSTLE, class_3419.field_15245, 0.8f, 0.9f + level.method_8409().method_43057() * 0.15f);
        MilkweedBlock.setAgeOnBothHalves((class_2248)this, state, level, pos, 0, true);
    }

    public void method_9652(@NotNull class_3218 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        if (!MilkweedBlock.isFullyGrown(state)) {
            MilkweedBlock.setAgeOnBothHalves((class_2248)this, state, (class_1937)level, pos, (Integer)state.method_11654((class_2769)AGE) + 1, false);
            return;
        }
        super.method_9652(level, random, pos, state);
    }
}

