/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.wilderwild.config.WWBlockConfig;
import net.frozenblock.wilderwild.particle.options.SeedParticleOptions;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import net.minecraft.class_9298;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeedingFlowerBlock
extends class_2356 {
    public static final float SEED_SPAWN_CHANCE = 0.04f;
    public static final double SEED_SPAWN_HEIGHT = 0.5;
    public static final int MIN_SEEDS = 1;
    public static final int MAX_SEEDS = 2;
    public static final int MIN_SEEDS_DESTROY = 3;
    public static final int MAX_SEEDS_DESTROY = 7;
    public static final MapCodec<SeedingFlowerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)field_46354.forGetter(class_2356::method_53233), (App)class_7923.field_41175.method_39673().fieldOf("non_seeding_flower").forGetter(SeedingFlowerBlock::getNonSeedingFlower), (App)SeedingFlowerBlock.method_54096()).apply((Applicative)instance, SeedingFlowerBlock::new));
    private final class_2248 nonSeedingFlower;

    public SeedingFlowerBlock(@NotNull class_6880<class_1291> suspiciousStewEffect, int effectDuration, class_2248 nonSeedingFlower, @NotNull class_4970.class_2251 settings) {
        super(suspiciousStewEffect, (float)effectDuration, settings);
        this.nonSeedingFlower = nonSeedingFlower;
    }

    public SeedingFlowerBlock(class_9298 suspiciousStewEffects, class_2248 nonSeedingFlower, class_4970.class_2251 settings) {
        super(suspiciousStewEffects, settings);
        this.nonSeedingFlower = nonSeedingFlower;
    }

    @NotNull
    public MapCodec<? extends SeedingFlowerBlock> method_53969() {
        return CODEC;
    }

    public class_2248 getNonSeedingFlower() {
        return this.nonSeedingFlower;
    }

    public boolean canShearIntoOriginalFlower(class_4538 world, class_2338 pos, class_2680 state) {
        if (this == WWBlocks.SEEDING_DANDELION) {
            return WWBlockConfig.get().flower.shearSeedingDandelions;
        }
        return true;
    }

    @NotNull
    public class_9062 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (this.canShearIntoOriginalFlower((class_4538)level, pos, state) && stack.method_31574(class_1802.field_8868)) {
            this.onPlayerShear(level, pos, state, player, hand, stack);
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    public void onPlayerShear(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_1799 stack) {
        level.method_8501(pos, this.getNonSeedingFlower().method_9564());
        if (!level.field_9236) {
            this.onShear(level, pos, state, (class_1297)player);
            stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
        }
    }

    public void onShear(@NotNull class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1297 entity) {
        level.method_8501(pos, this.getNonSeedingFlower().method_9564());
        if (!level.field_9236) {
            level.method_8396(null, pos, class_3417.field_34896, class_3419.field_15245, 1.0f, 1.0f);
            this.spawnSeedsFrom(level, pos, state, 3, 7, null);
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
            level.method_33596(entity, (class_6880)class_5712.field_28730, pos);
        }
    }

    public void spawnSeedsFrom(class_1937 level, class_2338 pos, @NotNull class_2680 blockState, int minSeeds, int maxSeeds, class_243 velocity) {
        SeedParticleOptions options;
        class_243 offset = blockState.method_26226((class_1922)level, pos);
        double x = (double)pos.method_10263() + 0.5 + offset.field_1352;
        double y = (double)pos.method_10264() + 0.5;
        double z = (double)pos.method_10260() + 0.5 + offset.field_1350;
        int count = level.method_8409().method_39332(minSeeds, maxSeeds);
        SeedParticleOptions seedParticleOptions = options = velocity != null ? SeedParticleOptions.controlled(false, velocity.field_1352, 0.3, velocity.field_1350) : SeedParticleOptions.unControlled(false);
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            server.method_14199((class_2394)options, x, y, z, count, 0.0, 0.0, 0.0, 0.0);
        } else {
            for (int i = 0; i < count; ++i) {
                level.method_8406((class_2394)options, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void method_9496(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (random.method_43057() <= 0.04f) {
            this.spawnSeedsFrom(level, pos, state, 1, 2, null);
        }
    }

    public void method_9548(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity) {
        if (!level.field_9236) {
            return;
        }
        class_238 shape = this.method_9530(state, (class_1922)level, pos, class_3726.method_16195((class_1297)entity)).method_1107().method_996(pos);
        if (shape.method_994(entity.method_5829())) {
            class_243 movement = entity.method_18798();
            double horizontalDistance = movement.method_37267();
            double horizontalVelocity = horizontalDistance * 1.5;
            if ((double)level.field_9229.method_43057() < horizontalVelocity * 1.45) {
                int min = Math.min((int)(horizontalVelocity * 2.5), 3);
                int max = Math.min((int)(horizontalVelocity * 3.5), 5);
                this.spawnSeedsFrom(level, pos, state, min, max, movement.method_1029().method_1021(Math.min(horizontalDistance, 0.5)));
            }
        }
    }

    @NotNull
    public class_2680 method_9576(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1657 player) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            this.spawnSeedsFrom((class_1937)server, pos, state, 3, 7, null);
        }
        return super.method_9576(level, pos, state, player);
    }
}

