/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.mixin.block.chest;

import java.util.Optional;
import net.frozenblock.wilderwild.block.entity.impl.ChestBlockEntityInterface;
import net.frozenblock.wilderwild.block.impl.ChestUtil;
import net.frozenblock.wilderwild.config.WWBlockConfig;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2595.class})
public class ChestBlockEntityMixin
implements ChestBlockEntityInterface {
    @Unique
    private boolean wilderWild$canBubble = true;

    @ModifyVariable(method={"playSound"}, at=@At(value="HEAD"), argsOnly=true)
    private static class_3414 wilderWild$playSound(class_3414 soundEvent, class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (blockState.method_26227().method_39360((class_3611)class_3612.field_15910) && WWBlockConfig.get().chestBubbling) {
            if (soundEvent == class_3417.field_14982) {
                soundEvent = WWSounds.BLOCK_CHEST_OPEN_UNDERWATER;
            } else if (soundEvent == class_3417.field_14823) {
                soundEvent = WWSounds.BLOCK_CHEST_CLOSE_UNDERWATER;
            }
        }
        return soundEvent;
    }

    @Override
    @Unique
    public void wilderWild$bubble(class_1937 level, class_2338 pos, class_2680 state) {
        if (level == null) {
            return;
        }
        if (this.wilderWild$canBubble && state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            ChestBlockEntityMixin.wilderWild$sendBubbleSeedParticle(level, pos);
            this.wilderWild$canBubble = false;
            Optional<class_2595> possibleCoupledChest = ChestUtil.getCoupledChestBlockEntity((class_1936)level, pos, state);
            possibleCoupledChest.ifPresent(coupledChest -> {
                ChestBlockEntityMixin.wilderWild$sendBubbleSeedParticle(level, coupledChest.method_11016());
                if (coupledChest instanceof ChestBlockEntityInterface) {
                    ChestBlockEntityInterface coupledChestInterface = (ChestBlockEntityInterface)coupledChest;
                    coupledChestInterface.wilderWild$setCanBubble(false);
                }
            });
        }
    }

    @Unique
    private static void wilderWild$sendBubbleSeedParticle(class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_243 centerPos = class_243.method_24953((class_2382)pos);
            serverLevel.method_14199((class_2394)WWParticleTypes.CHEST_BUBBLE_SPAWNER, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Unique
    public void wilderWild$bubbleBurst(class_2680 state) {
        class_2595 chest = (class_2595)class_2595.class.cast(this);
        class_1937 class_19372 = chest.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (WWBlockConfig.get().chestBubbling) {
                class_2338 pos = chest.method_11016();
                if (state.method_26227().method_39360((class_3611)class_3612.field_15910) && this.wilderWild$getCanBubble()) {
                    server.method_14199((class_2394)class_2398.field_11247, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.625, (double)pos.method_10260() + 0.5, server.field_9229.method_43051(18, 25), 0.21875, 0.0, 0.21875, 0.25);
                }
            }
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    public void load(class_2487 tag, class_7225.class_7874 provider, CallbackInfo info) {
        if (tag.method_10545("wilderwild_can_bubble")) {
            this.wilderWild$canBubble = tag.method_10577("wilderwild_can_bubble");
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void saveAdditional(class_2487 tag, class_7225.class_7874 provider, CallbackInfo info) {
        tag.method_10556("wilderwild_can_bubble", this.wilderWild$canBubble);
    }

    @Override
    @Unique
    public boolean wilderWild$getCanBubble() {
        return this.wilderWild$canBubble;
    }

    @Override
    @Unique
    public void wilderWild$setCanBubble(boolean b) {
        this.wilderWild$canBubble = b;
    }

    @Override
    @Unique
    public void wilderWild$syncBubble(class_2595 chest1, class_2595 chest2) {
        if (chest1 instanceof ChestBlockEntityInterface) {
            ChestBlockEntityInterface chest1Interface = (ChestBlockEntityInterface)chest1;
            if (chest2 instanceof ChestBlockEntityInterface) {
                ChestBlockEntityInterface chest2Interface = (ChestBlockEntityInterface)chest2;
                if (!chest1Interface.wilderWild$getCanBubble() || !chest2Interface.wilderWild$getCanBubble()) {
                    chest1Interface.wilderWild$setCanBubble(false);
                    chest2Interface.wilderWild$setCanBubble(false);
                }
            }
        }
    }
}

