/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.mixin.client.wind.particlerain;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.wilderwild.wind.WWClientWindManager;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pigcart.particlerain.ParticleRainClient;
import pigcart.particlerain.particle.RainParticle;
import pigcart.particlerain.particle.WeatherParticle;

@Pseudo
@Environment(value=EnvType.CLIENT)
@Mixin(value={RainParticle.class})
public abstract class RainParticleMixin
extends WeatherParticle {
    @Unique
    private static final Vector3f WILDER_WILD$NORMALIZED_QUAT_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    @Unique
    private float wilderWild$prevYRot;
    @Unique
    private float wilderWild$yRot;
    @Unique
    private float wilderWild$prevXRot;
    @Unique
    private float wilderWild$xRot;
    @Unique
    private float wilderWild$prevRotMultiplier;
    @Unique
    private float wilderWild$rotMultiplier;

    protected RainParticleMixin(class_638 level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @ModifyExpressionValue(method={"<init>"}, at={@At(value="FIELD", target="Lpigcart/particlerain/ModConfig$RainOptions;stormWindStrength:F")}, remap=false, require=0)
    public float wilderWild$modifyStormWindStrength(float original) {
        if (WWClientWindManager.shouldUseWind()) {
            return (float)ClientWindManager.windX * 0.5f;
        }
        return original;
    }

    @ModifyExpressionValue(method={"<init>"}, at={@At(value="FIELD", target="Lpigcart/particlerain/ModConfig$RainOptions;windStrength:F")}, remap=false, require=0)
    public float wilderWild$modifyWindStrength(float original) {
        if (WWClientWindManager.shouldUseWind()) {
            return (float)ClientWindManager.windX * 0.5f;
        }
        return original;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, require=0)
    public void wilderWild$modifyWindZ(class_638 level, double x, double y, double z, CallbackInfo info) {
        if (WWClientWindManager.shouldUseWind()) {
            this.field_3850 = this.field_3844 * (float)ClientWindManager.windZ * 0.5f;
        }
        if (ParticleRainClient.config.yLevelWindAdjustment) {
            this.field_3850 *= ParticleRainClient.yLevelWindAdjustment((double)y);
        }
        double horizontalDistance = Math.sqrt(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850);
        this.wilderWild$yRot += (float)class_3532.method_15349((double)this.field_3852, (double)this.field_3850) * 57.295776f;
        this.wilderWild$xRot += (float)class_3532.method_15349((double)horizontalDistance, (double)this.field_3869) * 57.295776f;
        this.wilderWild$prevYRot = this.wilderWild$yRot;
        this.wilderWild$prevXRot = this.wilderWild$xRot;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, require=0)
    public void wilderWild$captureRotationData(CallbackInfo info) {
        this.wilderWild$prevYRot = this.wilderWild$yRot;
        this.wilderWild$prevXRot = this.wilderWild$xRot;
        double horizontalDistance = Math.sqrt(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850);
        double newYRot = class_3532.method_15349((double)this.field_3852, (double)this.field_3850) * 57.2957763671875;
        double newXRot = class_3532.method_15349((double)horizontalDistance, (double)this.field_3869) * 57.2957763671875;
        if (Math.abs(newYRot - (double)this.wilderWild$prevYRot) > 180.0) {
            newYRot += 360.0;
        }
        if (Math.abs(newXRot - (double)this.wilderWild$prevXRot) > 180.0) {
            newXRot += 360.0;
        }
        double newYRotDifference = newYRot - (double)this.wilderWild$yRot;
        double newXRotDifference = newXRot - (double)this.wilderWild$xRot;
        this.wilderWild$yRot += (float)newYRotDifference * 0.25f;
        this.wilderWild$xRot += (float)newXRotDifference * 0.25f;
        if (this.wilderWild$yRot > 360.0f) {
            this.wilderWild$yRot -= 360.0f;
            this.wilderWild$prevYRot -= 360.0f;
        } else if (this.wilderWild$yRot < 0.0f) {
            this.wilderWild$yRot += 360.0f;
            this.wilderWild$prevYRot += 360.0f;
        }
        if (this.wilderWild$xRot > 360.0f) {
            this.wilderWild$xRot -= 360.0f;
            this.wilderWild$prevXRot -= 360.0f;
        } else if (this.wilderWild$xRot < 0.0f) {
            this.wilderWild$xRot += 360.0f;
            this.wilderWild$prevXRot += 360.0f;
        }
        this.wilderWild$prevRotMultiplier = this.wilderWild$rotMultiplier;
        this.wilderWild$rotMultiplier = (float)Math.sin(this.wilderWild$xRot * (float)Math.PI / 180.0f);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void wilderWild$renderWithNewRotation(class_4588 buffer, class_4184 renderInfo, float partialTicks, CallbackInfo info) {
        info.cancel();
        float yRot = class_3532.method_16439((float)partialTicks, (float)this.wilderWild$prevYRot, (float)this.wilderWild$yRot) * ((float)Math.PI / 180);
        float xRot = class_3532.method_16439((float)partialTicks, (float)this.wilderWild$prevXRot, (float)this.wilderWild$xRot) * ((float)(-Math.PI) / 180);
        float cameraRotWhileVertical = -renderInfo.method_19330() * (1.0f - class_3532.method_16439((float)partialTicks, (float)this.wilderWild$prevRotMultiplier, (float)this.wilderWild$rotMultiplier)) * ((float)Math.PI / 180);
        float cameraXRot = renderInfo.method_19329();
        float x = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874);
        float y = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854);
        float z = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871);
        class_243 particlePos = new class_243((double)x, (double)y, (double)z);
        double particleRotation = AdvancedMath.getAngleFromOriginXZ((class_243)new class_243(this.field_3852, 0.0, this.field_3850));
        double angleToParticle = AdvancedMath.getAngleBetweenXZ((class_243)particlePos, (class_243)renderInfo.method_19326());
        double relativeParticleAngle = (360.0 + (angleToParticle - particleRotation)) % 360.0;
        float fixedRotation = 90.0f + cameraXRot;
        if (relativeParticleAngle > 0.0 && relativeParticleAngle < 180.0) {
            fixedRotation *= -1.0f;
        }
        float cameraRotWhileSideways = fixedRotation * class_3532.method_16439((float)partialTicks, (float)this.wilderWild$prevRotMultiplier, (float)this.wilderWild$rotMultiplier) * ((float)Math.PI / 180);
        this.wilderWild$renderParticle(buffer, renderInfo, partialTicks, false, transforms -> transforms.rotateY(yRot).rotateX(-xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical));
        this.wilderWild$renderParticle(buffer, renderInfo, partialTicks, true, transforms -> transforms.rotateY((float)(-Math.PI) + yRot).rotateX(xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical));
    }

    @Unique
    private void wilderWild$renderParticle(class_4588 buffer, @NotNull class_4184 renderInfo, float partialTicks, boolean flipped, @NotNull Consumer<Quaternionf> quaternionConsumer) {
        class_243 vec3 = renderInfo.method_19326();
        float f = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - vec3.method_10216());
        float g = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - vec3.method_10214());
        float h = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - vec3.method_10215());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, WILDER_WILD$NORMALIZED_QUAT_VECTOR.x(), WILDER_WILD$NORMALIZED_QUAT_VECTOR.y(), WILDER_WILD$NORMALIZED_QUAT_VECTOR.z());
        quaternionConsumer.accept(quaternionf);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float i = this.method_18132(partialTicks);
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f2 = vector3fs[j];
            vector3f2.rotate((Quaternionfc)quaternionf);
            vector3f2.mul(i);
            vector3f2.add(f, g, h);
        }
        float k = !flipped ? this.method_18133() : this.method_18134();
        float l = !flipped ? this.method_18134() : this.method_18133();
        float m = this.method_18135();
        float n = this.method_18136();
        int light = this.method_3068(partialTicks);
        buffer.method_22912(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).method_22913(l, n).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        buffer.method_22912(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).method_22913(l, m).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        buffer.method_22912(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).method_22913(k, m).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        buffer.method_22912(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).method_22913(k, n).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
    }
}

