/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.frozenblock.wilderwild.worldgen.impl.feature.config.LargeMesogleaConfig;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeMesogleaFeature
extends class_3031<LargeMesogleaConfig> {
    public LargeMesogleaFeature(Codec<LargeMesogleaConfig> codec) {
        super(codec);
    }

    @NotNull
    private static LargeMesoglea makeMesoglea(@NotNull class_2338 root, boolean pointingUp, @NotNull class_5819 random, int radius, @NotNull class_5863 bluntnessBase, @NotNull class_5863 scaleBase) {
        return new LargeMesoglea(root, pointingUp, radius, bluntnessBase.method_33920(random), scaleBase.method_33920(random));
    }

    protected static boolean isEmptyOrWater(@NotNull class_1936 level, @NotNull class_2338 pos) {
        return level.method_16358(pos, class_5726::method_33014);
    }

    protected static boolean isCircleMostlyEmbeddedInStone(@NotNull class_5281 level, @NotNull class_2338 pos, int radius) {
        if (LargeMesogleaFeature.isEmptyOrWaterOrLava((class_1936)level, pos)) {
            return false;
        }
        float g = 6.0f / (float)radius;
        for (float h = 0.0f; h < (float)Math.PI * 2; h += g) {
            int j;
            int i = (int)(class_3532.method_15362((float)h) * (float)radius);
            if (!LargeMesogleaFeature.isEmptyOrWaterOrLava((class_1936)level, pos.method_10069(i, 0, j = (int)(class_3532.method_15374((float)h) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWaterOrLava(@NotNull class_1936 level, @NotNull class_2338 pos) {
        return level.method_16358(pos, LargeMesogleaFeature::isEmptyOrWaterOrLava);
    }

    public static boolean isEmptyOrWaterOrLava(@NotNull class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10164);
    }

    protected static double getMesogleaHeight(double radius, double maxRadius, double scale, double minRadius) {
        if (radius < minRadius) {
            radius = minRadius;
        }
        double e = radius / maxRadius * 0.384;
        double f = 0.75 * Math.pow(e, 1.3333333333333333);
        double g = Math.pow(e, 0.6666666666666666);
        double h = 0.3333333333333333 * Math.log(e);
        double i = Math.max(scale * (f - g - h), 0.0);
        return i / 0.384 * maxRadius;
    }

    public boolean method_13151(@NotNull class_5821<LargeMesogleaConfig> context) {
        Object t;
        class_5281 worldGenLevel = context.method_33652();
        class_2338 blockPos = context.method_33655();
        LargeMesogleaConfig largeMesogleaConfig = (LargeMesogleaConfig)context.method_33656();
        class_5819 randomSource = context.method_33654();
        if (!LargeMesogleaFeature.isEmptyOrWater((class_1936)worldGenLevel, blockPos)) {
            return false;
        }
        Optional optional = class_5721.method_32982((class_3746)worldGenLevel, (class_2338)blockPos, (int)largeMesogleaConfig.floorToCeilingSearchRange, class_5726::method_33014, class_5726::method_33387);
        if (optional.isPresent() && (t = optional.get()) instanceof class_5721.class_5723) {
            class_5721.class_5723 range = (class_5721.class_5723)t;
            if (range.method_32992() < 4) {
                return false;
            }
            int i = (int)((float)range.method_32992() * largeMesogleaConfig.maxColumnRadiusToCaveHeightRatio);
            int j = class_3532.method_15340((int)i, (int)largeMesogleaConfig.columnRadius.method_35009(), (int)largeMesogleaConfig.columnRadius.method_35011());
            int k = class_3532.method_32751((class_5819)randomSource, (int)largeMesogleaConfig.columnRadius.method_35009(), (int)j);
            LargeMesoglea largeMesoglea = LargeMesogleaFeature.makeMesoglea(blockPos.method_33096(range.method_32990() - 1), false, randomSource, k, largeMesogleaConfig.stalactiteBluntness, largeMesogleaConfig.heightScale);
            LargeMesoglea largeMesoglea2 = LargeMesogleaFeature.makeMesoglea(blockPos.method_33096(range.method_32991() + 1), true, randomSource, k, largeMesogleaConfig.stalagmiteBluntness, largeMesogleaConfig.heightScale);
            WindOffsetter windOffsetter = largeMesoglea.isSuitableForWind(largeMesogleaConfig) && largeMesoglea2.isSuitableForWind(largeMesogleaConfig) ? new WindOffsetter(blockPos.method_10264(), randomSource, largeMesogleaConfig.windSpeed) : WindOffsetter.noWind();
            boolean bl = largeMesoglea.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
            boolean bl2 = largeMesoglea2.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldGenLevel, windOffsetter);
            if (bl) {
                largeMesoglea.placeBlocks(worldGenLevel, randomSource, windOffsetter, largeMesogleaConfig);
            }
            if (bl2) {
                largeMesoglea2.placeBlocks(worldGenLevel, randomSource, windOffsetter, largeMesogleaConfig);
            }
            return true;
        }
        return false;
    }

    static final class LargeMesoglea {
        private final boolean pointingUp;
        private final double bluntness;
        private final double scale;
        private class_2338 root;
        private int radius;

        LargeMesoglea(@NotNull class_2338 root, boolean pointingUp, int radius, double bluntness, double scale) {
            this.root = root;
            this.pointingUp = pointingUp;
            this.radius = radius;
            this.bluntness = bluntness;
            this.scale = scale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(@NotNull class_5281 level, @NotNull WindOffsetter windOffsetter) {
            while (this.radius > 1) {
                class_2338.class_2339 mutableBlockPos = this.root.method_25503();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (level.method_8320((class_2338)mutableBlockPos).method_27852(class_2246.field_10164)) {
                        return false;
                    }
                    if (LargeMesogleaFeature.isCircleMostlyEmbeddedInStone(level, windOffsetter.offset((class_2338)mutableBlockPos), this.radius)) {
                        this.root = mutableBlockPos;
                        return true;
                    }
                    mutableBlockPos.method_10098(this.pointingUp ? class_2350.field_11033 : class_2350.field_11036);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float radius) {
            return (int)LargeMesogleaFeature.getMesogleaHeight(radius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(@NotNull class_5281 level, @NotNull class_5819 random, @NotNull WindOffsetter windOffsetter, @NotNull LargeMesogleaConfig config) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = class_3532.method_15355((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)random.method_43057() < 0.2) {
                        k = (int)((float)k * class_3532.method_32750((class_5819)random, (float)0.8f, (float)1.0f));
                    }
                    class_2338.class_2339 mutableBlockPos = this.root.method_10069(i, 0, j).method_25503();
                    boolean bl = false;
                    int l = this.pointingUp ? level.method_8624(class_2902.class_2903.field_13194, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()) : Integer.MAX_VALUE;
                    for (int m = 0; m < k && mutableBlockPos.method_10264() < l; ++m) {
                        class_2338 blockPos = windOffsetter.offset((class_2338)mutableBlockPos);
                        if (LargeMesogleaFeature.isEmptyOrWaterOrLava((class_1936)level, blockPos)) {
                            bl = true;
                            level.method_8652(blockPos, config.pathBlock.method_23455(random, (class_2338)mutableBlockPos), 3);
                        } else if (bl && level.method_8320(blockPos).method_26164(class_3481.field_25806)) continue block1;
                        mutableBlockPos.method_10098(this.pointingUp ? class_2350.field_11036 : class_2350.field_11033);
                    }
                }
            }
        }

        boolean isSuitableForWind(@NotNull LargeMesogleaConfig config) {
            return this.radius >= config.minRadiusForWind && this.bluntness >= (double)config.minBluntnessForWind;
        }
    }

    private static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final class_243 windSpeed;

        WindOffsetter(int originY, @NotNull class_5819 random, @NotNull class_5863 magnitude) {
            this.originY = originY;
            float f = magnitude.method_33920(random);
            float g = class_3532.method_32750((class_5819)random, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new class_243((double)(class_3532.method_15362((float)g) * f), 0.0, (double)(class_3532.method_15374((float)g) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        @NotNull
        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        @NotNull
        class_2338 offset(@NotNull class_2338 pos) {
            if (this.windSpeed == null) {
                return pos;
            }
            int i = this.originY - pos.method_10264();
            class_243 vec3 = this.windSpeed.method_1021((double)i);
            return pos.method_10081((class_2382)class_2338.method_49637((double)vec3.field_1352, (double)0.0, (double)vec3.field_1350));
        }
    }
}

