/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MapleFoliagePlacer
extends class_4647 {
    public static final MapCodec<MapleFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> MapleFoliagePlacer.mapleFoliagePlacerParts(instance).apply((Applicative)instance, MapleFoliagePlacer::new));
    protected final class_6017 length;

    @Contract(value="_ -> new")
    protected static <P extends MapleFoliagePlacer> // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Products.P3<// Could not load outer class - annotation placement on inner may be incorrect
    RecordCodecBuilder.Mu<P>, class_6017, class_6017, class_6017> mapleFoliagePlacerParts(RecordCodecBuilder.Instance<P> instance) {
        return MapleFoliagePlacer.method_30411(instance).and((App)class_6017.method_35004((int)0, (int)24).fieldOf("length").forGetter(placer -> placer.length));
    }

    public MapleFoliagePlacer(class_6017 radius, class_6017 offset, class_6017 foliageHeight) {
        super(radius, offset);
        this.length = foliageHeight;
    }

    @NotNull
    protected class_4648<?> method_28843() {
        return WWFeatures.MAPLE_FOLIAGE_PLACER;
    }

    protected void method_23448(class_3746 world, class_4647.class_8179 placer, @NotNull class_5819 random, class_4643 config, int trunkHeight, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_4647.class_5208 node, int foliageHeight, int radius, int offset) {
        int totalHeight;
        class_2338 blockPos = node.method_27388();
        int currentHeight = totalHeight = offset + foliageHeight;
        for (int l = offset; l >= -foliageHeight; --l) {
            this.placeLeavesInCircle(world, placer, random, config, blockPos, radius, l, node.method_27390(), totalHeight, currentHeight, foliageHeight);
            --currentHeight;
        }
    }

    protected void placeLeavesInCircle(class_3746 world, class_4647.class_8179 placer, @NotNull class_5819 random, class_4643 config, class_2338 centerPos, int providedRadius, int y, boolean giantTrunk, int totalHeight, int currentHeight, int trunkHeight) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        double radius = (double)providedRadius + (random.method_43058() - this.getRandomRadiusShrink()) * 0.4;
        double increment = radius * 0.05;
        for (double j = -radius; j <= radius; j += increment) {
            for (double k = -radius; k <= radius; k += increment) {
                if (this.shouldSkipMapleLocationSigned(j, k, radius, giantTrunk, totalHeight, currentHeight, trunkHeight)) continue;
                mutableBlockPos.method_25504((class_2382)centerPos, (int)j, y, (int)k);
                MapleFoliagePlacer.method_34359((class_3746)world, (class_4647.class_8179)placer, (class_5819)random, (class_4643)config, (class_2338)mutableBlockPos);
            }
        }
    }

    protected double getRandomRadiusShrink() {
        return -0.5;
    }

    protected boolean shouldSkipMapleLocationSigned(double dx, double dz, double radius, boolean giantTrunk, int totalHeight, int currentHeight, int trunkHeight) {
        double j;
        double i;
        if (giantTrunk) {
            i = Math.min(Math.abs(dx), Math.abs(dx - 1.0));
            j = Math.min(Math.abs(dz), Math.abs(dz - 1.0));
        } else {
            i = Math.abs(dx);
            j = Math.abs(dz);
        }
        return this.shouldSkipMapleLocation(i, j, radius, totalHeight, currentHeight, trunkHeight);
    }

    protected boolean shouldSkipMapleLocation(double xDistance, double zDistance, double radius, int totalHeight, int currentHeight, int trunkHeight) {
        double mapleFunction = this.getMapleFoliageFunction(totalHeight, currentHeight, radius, currentHeight <= trunkHeight);
        double distance = new class_243(xDistance, 0.0, zDistance).method_37267();
        return distance > mapleFunction && distance > 0.4;
    }

    protected double getMapleFoliageFunction(double totalHeight, double height, double radius, boolean hot) {
        double flippedHeight = totalHeight - height;
        double functionHeight = totalHeight - 1.0;
        double functionInput = flippedHeight + height / functionHeight;
        double functionNumerator = functionInput * functionInput * Math.PI;
        double functionDenominator = functionHeight * functionHeight + functionHeight * 2.5 + totalHeight * radius;
        double function = Math.sin(functionNumerator / functionDenominator);
        double finalFunction = function * (radius * 0.75) + 0.45;
        double min = hot ? 1.2 : 0.0;
        return Math.max(finalFunction, min);
    }

    public int method_26989(class_5819 random, int trunkHeight, class_4643 config) {
        return Math.max(5, trunkHeight - this.length.method_35008(random));
    }

    protected boolean method_23451(class_5819 random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

