/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.rootplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.frozenblock.wilderwild.worldgen.impl.rootplacers.WillowRootPlacement;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4651;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_7387;
import net.minecraft.class_7388;
import net.minecraft.class_7398;
import org.jetbrains.annotations.NotNull;

public class WillowRootPlacer
extends class_7387 {
    public static final MapCodec<WillowRootPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> WillowRootPlacer.method_43182((RecordCodecBuilder.Instance)instance).and((App)WillowRootPlacement.CODEC.fieldOf("willow_root_placement").forGetter(willowRootPlacer -> willowRootPlacer.willowRootPlacement)).apply((Applicative)instance, WillowRootPlacer::new));
    private final WillowRootPlacement willowRootPlacement;

    public WillowRootPlacer(class_6017 intProvider, class_4651 blockStateProvider, Optional<class_7398> optional, WillowRootPlacement mangroveRootPlacement) {
        super(intProvider, blockStateProvider, optional);
        this.willowRootPlacement = mangroveRootPlacement;
    }

    public boolean method_43168(class_3746 levelSimulatedReader, BiConsumer<class_2338, class_2680> biConsumer, class_5819 randomSource, @NotNull class_2338 blockPos, @NotNull class_2338 blockPos2, class_4643 treeConfiguration) {
        ArrayList list = Lists.newArrayList();
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        while (mutableBlockPos.method_10264() < blockPos2.method_10264()) {
            if (!this.method_43167(levelSimulatedReader, (class_2338)mutableBlockPos)) {
                return false;
            }
            mutableBlockPos.method_10098(class_2350.field_11036);
        }
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            ArrayList list2;
            class_2338 blockPos3 = blockPos2.method_10093(direction);
            if (!this.simulateRoots(levelSimulatedReader, randomSource, blockPos3, direction, blockPos2, list2 = Lists.newArrayList(), 0)) {
                return false;
            }
            list.addAll(list2);
            list.add(blockPos2.method_10093(direction));
        }
        ArrayList columnPoses = Lists.newArrayList();
        for (class_2338 rootPoses : list) {
            columnPoses.addAll(this.potentialColumnRootPositions(levelSimulatedReader, rootPoses));
        }
        list.addAll(columnPoses);
        for (class_2338 blockPos4 : list) {
            this.method_43172(levelSimulatedReader, biConsumer, randomSource, blockPos4, treeConfiguration);
        }
        return true;
    }

    private boolean simulateRoots(class_3746 levelSimulatedReader, class_5819 randomSource, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, List<class_2338> list, int i) {
        int maxLength = this.willowRootPlacement.maxRootLength();
        if (i != maxLength && list.size() <= maxLength) {
            for (class_2338 blockPos3 : this.potentialRootPositions(blockPos, direction, randomSource, blockPos2)) {
                if (!this.method_43167(levelSimulatedReader, blockPos3)) continue;
                list.add(blockPos3);
                if (this.simulateRoots(levelSimulatedReader, randomSource, blockPos3, direction, blockPos2, list, i + 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<class_2338> potentialColumnRootPositions(class_3746 levelSimulatedReader, @NotNull class_2338 blockPos) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        mutableBlockPos.method_10101((class_2382)blockPos);
        while (this.method_43167(levelSimulatedReader, (class_2338)mutableBlockPos.method_10098(class_2350.field_11033))) {
            positions.add(mutableBlockPos.method_10062());
        }
        return positions;
    }

    protected List<class_2338> potentialRootPositions(@NotNull class_2338 blockPos, class_2350 direction, class_5819 randomSource, class_2338 blockPos2) {
        class_2338 blockPos3 = blockPos.method_10074();
        class_2338 blockPos4 = blockPos.method_10093(direction);
        int i = blockPos.method_19455((class_2382)blockPos2);
        int j = this.willowRootPlacement.maxRootWidth();
        float f = this.willowRootPlacement.randomSkewChance();
        if (i > j - 3 && i <= j) {
            return randomSource.method_43057() < f ? List.of(blockPos3, blockPos4.method_10074()) : List.of(blockPos3);
        }
        if (i > j) {
            return List.of(blockPos3);
        }
        if (randomSource.method_43057() < f) {
            return List.of(blockPos3);
        }
        return randomSource.method_43056() ? List.of(blockPos4) : List.of(blockPos3);
    }

    protected boolean method_43167(class_3746 levelSimulatedReader, class_2338 blockPos) {
        return super.method_43167(levelSimulatedReader, blockPos) || levelSimulatedReader.method_16358(blockPos, blockState -> blockState.method_40143(this.willowRootPlacement.canGrowThrough()));
    }

    @NotNull
    protected class_7388<?> method_43165() {
        return WWFeatures.WILLOW_ROOT_PLACER;
    }
}

