/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.frozenblock.lib.block.api.shape.FrozenShapes;
import net.frozenblock.wilderwild.block.state.properties.BubbleDirection;
import net.frozenblock.wilderwild.config.WWBlockConfig;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.tag.WWEntityTags;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1690;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2258;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MesogleaBlock
extends class_2373 {
    public static final MapCodec<MesogleaBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("pearlescent").forGetter(MesogleaBlock::isPearlescent), (App)Codec.INT.fieldOf("water_fog_color").forGetter(MesogleaBlock::getWaterFogColorOverride), (App)class_2398.field_25125.fieldOf("drip_particle").forGetter(mesogleaBlock -> mesogleaBlock.dripParticle), (App)class_2398.field_25125.fieldOf("bubble_particle").forGetter(mesogleaBlock -> mesogleaBlock.bubbleParticle), (App)class_2398.field_25125.fieldOf("bubble_column_up_particle").forGetter(mesogleaBlock -> mesogleaBlock.bubbleColumnUpParticle), (App)class_2398.field_25125.fieldOf("current_down_particle").forGetter(mesogleaBlock -> mesogleaBlock.currentDownParticle), (App)class_2398.field_25125.fieldOf("splash_particle").forGetter(mesogleaBlock -> mesogleaBlock.splashParticle), (App)MesogleaBlock.method_54096()).apply((Applicative)instance, MesogleaBlock::new));
    public static final float JELLYFISH_COLLISION_FROM_SIDE = 0.25f;
    public static final double ITEM_SLOWDOWN = 0.999;
    public static final double ITEM_VERTICAL_BOOST = 0.025;
    public static final class_243 ITEM_SLOWDOWN_VEC3 = new class_243(0.999, 0.999, 0.999);
    public static final double BOAT_MAX_VERTICAL_SPEED = 0.175;
    public static final double BOAT_VERTICAL_BOOST = 0.05;
    public static final double BOAT_VERTICAL_SLOWDOWN_SCALE_WHEN_FALLING = 0.125;
    public static final int DRIP_PARTICLE_CHANCE = 50;
    public static final int LIGHT_BLOCK = 2;
    public static final int AMBIENT_WHIRLPOOL_SOUND_CHANCE = 200;
    public static final int TICK_DELAY = 5;
    public static final class_2754<BubbleDirection> BUBBLE_DIRECTION = WWBlockStateProperties.BUBBLE_DIRECTION;
    private final boolean pearlescent;
    private final int waterFogColor;
    private final class_2394 dripParticle;
    private final class_2394 bubbleParticle;
    private final class_2394 bubbleColumnUpParticle;
    private final class_2394 currentDownParticle;
    private final class_2394 splashParticle;

    public MesogleaBlock(boolean pearlescent, int waterFogColor, class_2394 dripParticle, class_2394 bubbleParticle, class_2394 bubbleColumnUpParticle, class_2394 currentDownParticle, class_2394 splashParticle, @NotNull class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.NONE)));
        this.pearlescent = pearlescent;
        this.waterFogColor = waterFogColor;
        this.dripParticle = dripParticle;
        this.bubbleParticle = bubbleParticle;
        this.bubbleColumnUpParticle = bubbleColumnUpParticle;
        this.currentDownParticle = currentDownParticle;
        this.splashParticle = splashParticle;
    }

    public static boolean isMesoglea(@NotNull class_2680 blockState) {
        return blockState.method_28498(BUBBLE_DIRECTION) && blockState.method_26204() instanceof MesogleaBlock;
    }

    public static boolean isColumnSupportingMesoglea(class_2680 blockState) {
        return MesogleaBlock.isMesoglea(blockState) && WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS;
    }

    public static boolean hasBubbleColumn(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) && blockState.method_11654(BUBBLE_DIRECTION) != BubbleDirection.NONE;
    }

    public static boolean isDraggingDown(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) && blockState.method_11654(BUBBLE_DIRECTION) == BubbleDirection.DOWN;
    }

    public static Optional<class_2350> getDragDirection(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) ? ((BubbleDirection)((Object)blockState.method_11654(MesogleaBlock.BUBBLE_DIRECTION))).direction : Optional.empty();
    }

    public static boolean canColumnSurvive(@NotNull class_4538 level, @NotNull class_2338 pos) {
        class_2680 blockState = level.method_8320(pos.method_10074());
        return WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS && (blockState.method_27852(class_2246.field_10422) || blockState.method_27852(class_2246.field_10092) || blockState.method_27852(class_2246.field_10114) || MesogleaBlock.hasBubbleColumn(blockState));
    }

    public static void updateColumn(class_1936 level, class_2338 pos, class_2680 state) {
        MesogleaBlock.updateColumn(level, pos, level.method_8320(pos), state);
    }

    public static void updateColumn(class_1936 level, class_2338 pos, class_2680 mesoglea, class_2680 state) {
        if (MesogleaBlock.canExistIn(mesoglea)) {
            class_2680 mutableState;
            level.method_8652(pos, MesogleaBlock.getColumnState(mesoglea, state), 2);
            class_2338.class_2339 mutableBlockPos = pos.method_25503().method_10098(class_2350.field_11036);
            while (MesogleaBlock.canExistIn(mutableState = level.method_8320((class_2338)mutableBlockPos))) {
                if (!level.method_8652((class_2338)mutableBlockPos, MesogleaBlock.getColumnState(mutableState, state), 2)) {
                    return;
                }
                mutableBlockPos.method_10098(class_2350.field_11036);
            }
            class_2258.method_34268((class_1936)level, (class_2338)mutableBlockPos, (class_2680)state);
            return;
        }
    }

    @NotNull
    private static class_2680 getColumnState(@NotNull class_2680 mesogleaState, @NotNull class_2680 blockState) {
        if (WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS) {
            if (blockState.method_27852(class_2246.field_10422)) {
                return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)((Boolean)blockState.method_11654((class_2769)class_2741.field_12526) != false ? BubbleDirection.DOWN : BubbleDirection.UP)));
            }
            if (blockState.method_27852(class_2246.field_10114)) {
                return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.UP));
            }
            if (blockState.method_27852(class_2246.field_10092)) {
                return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.DOWN));
            }
        }
        return (class_2680)mesogleaState.method_11657(BUBBLE_DIRECTION, (Comparable)((Object)BubbleDirection.NONE));
    }

    private static boolean canExistIn(class_2680 blockState) {
        return MesogleaBlock.isColumnSupportingMesoglea(blockState) && blockState.method_26227().method_15761() >= 8 && blockState.method_26227().method_15771();
    }

    @NotNull
    protected MapCodec<? extends MesogleaBlock> method_53969() {
        return CODEC;
    }

    public boolean isPearlescent() {
        return this.pearlescent;
    }

    public int getWaterFogColorOverride() {
        return this.waterFogColor;
    }

    public class_2394 getBubbleParticle() {
        return this.bubbleParticle;
    }

    public class_2394 getBubbleColumnUpParticle() {
        return this.bubbleColumnUpParticle;
    }

    public class_2394 getSplashParticle() {
        return this.splashParticle;
    }

    public class_2394 getCurrentDownParticle() {
        return this.currentDownParticle;
    }

    protected void method_9615(class_2680 blockState, @NotNull class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (level.method_8597().comp_644()) {
            level.method_22352(blockPos, false);
            level.method_20290(2009, blockPos, 0);
            level.method_8396(null, blockPos, WWSounds.BLOCK_MESOGLEA_EVAPORATE, class_3419.field_15245, 1.0f, (1.0f + level.method_8409().method_43057() * 0.2f) * 0.7f);
        }
    }

    public void method_9548(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity) {
        Optional<class_2350> dragDirection = MesogleaBlock.getDragDirection(state);
        if (this.isPearlescent() && (dragDirection.isEmpty() || !WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS)) {
            if (entity instanceof class_1542) {
                class_1542 item = (class_1542)entity;
                item.method_5844(state, ITEM_SLOWDOWN_VEC3);
                item.method_45319(new class_243(0.0, 0.025, 0.0));
            }
            if (entity instanceof class_1690) {
                class_1690 boat = (class_1690)entity;
                class_243 deltaMovement = boat.method_18798();
                if (boat.method_5869() && deltaMovement.field_1351 < 0.175) {
                    boat.method_18800(deltaMovement.field_1352, Math.min(0.175, deltaMovement.field_1351 + 0.05), deltaMovement.field_1350);
                } else if (deltaMovement.field_1351 < 0.0) {
                    boat.method_18800(deltaMovement.field_1352, deltaMovement.field_1351 * 0.125, deltaMovement.field_1350);
                }
            }
        }
        if (dragDirection.isPresent() && WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS) {
            class_2680 blockState = level.method_8320(pos.method_10084());
            if (blockState.method_26215()) {
                entity.method_5700(dragDirection.get() == class_2350.field_11033);
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    for (int i = 0; i < 2; ++i) {
                        serverLevel.method_14199(this.getSplashParticle(), (double)pos.method_10263() + level.field_9229.method_43058(), (double)pos.method_10264() + 1.0, (double)pos.method_10260() + level.field_9229.method_43058(), 1, 0.0, 0.0, 0.0, 1.0);
                        serverLevel.method_14199(this.getBubbleParticle(), (double)pos.method_10263() + level.field_9229.method_43058(), (double)pos.method_10264() + 1.0, (double)pos.method_10260() + level.field_9229.method_43058(), 1, 0.0, 0.01, 0.0, 0.2);
                    }
                }
            } else {
                entity.method_5764(dragDirection.get() == class_2350.field_11033);
            }
        }
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_3726 collisionContext) {
        class_3727 entityCollisionContext;
        class_265 shape = class_259.method_1073();
        if (collisionContext instanceof class_3727 && (entityCollisionContext = (class_3727)collisionContext).method_32480() != null) {
            class_1297 entity = entityCollisionContext.method_32480();
            if (entity != null && entity.method_5864().method_20210(WWEntityTags.STAYS_IN_MESOGLEA) && !entity.method_5765() && !entity.method_21752()) {
                class_1308 mob;
                if (entity instanceof class_1308 && (mob = (class_1308)entity).method_60953()) {
                    return shape;
                }
                class_2680 insideState = entity.method_25936();
                if (entity.method_5799() || insideState.method_26204() instanceof MesogleaBlock) {
                    for (class_2350 direction : class_2350.values()) {
                        if (direction == class_2350.field_11036 || blockGetter.method_8316(blockPos.method_10093(direction)).method_15767(class_3486.field_15517)) continue;
                        shape = class_259.method_1084((class_265)shape, (class_265)FrozenShapes.makePlaneFromDirection((class_2350)direction, (float)0.25f));
                    }
                }
            }
            return shape;
        }
        return shape;
    }

    @NotNull
    protected class_265 method_25959(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return class_259.method_1077();
    }

    public void method_9496(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_5819 randomSource) {
        Optional<class_2350> dragDirection;
        super.method_9496(blockState, level, blockPos, randomSource);
        double d = blockPos.method_10263();
        double e = blockPos.method_10264();
        double f = blockPos.method_10260();
        if (blockState.method_26204() instanceof MesogleaBlock && randomSource.method_43051(0, 50) == 0 && level.method_8316(blockPos.method_10074()).method_15769() && level.method_8320(blockPos.method_10074()).method_26215()) {
            level.method_8406(this.dripParticle, d + randomSource.method_43058(), e, f + randomSource.method_43058(), 0.0, 0.0, 0.0);
        }
        if ((dragDirection = MesogleaBlock.getDragDirection(blockState)).isPresent()) {
            if (dragDirection.get() == class_2350.field_11033) {
                level.method_8494(this.getCurrentDownParticle(), d + 0.5, e + 0.8, f, 0.0, 0.0, 0.0);
                if (randomSource.method_43048(200) == 0) {
                    level.method_8486(d, e, f, class_3417.field_14650, class_3419.field_15245, 0.2f + randomSource.method_43057() * 0.2f, 0.9f + randomSource.method_43057() * 0.15f, false);
                }
            } else if (dragDirection.get() == class_2350.field_11036) {
                level.method_8494(this.getBubbleColumnUpParticle(), d + 0.5, e, f + 0.5, 0.0, 0.04, 0.0);
                level.method_8494(this.getBubbleColumnUpParticle(), d + randomSource.method_43058(), e + randomSource.method_43058(), f + randomSource.method_43058(), 0.0, 0.04, 0.0);
                if (randomSource.method_43048(200) == 0) {
                    level.method_8486(d, e, f, class_3417.field_15161, class_3419.field_15245, 0.2f + randomSource.method_43057() * 0.2f, 0.9f + randomSource.method_43057() * 0.15f, false);
                }
            }
        }
    }

    public int method_9505(@NotNull class_2680 blockState) {
        return 2;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 blockPlaceContext) {
        class_2680 blockState = blockPlaceContext.method_8045().method_8320(blockPlaceContext.method_8037());
        return (class_2680)this.method_9564().method_11657(BUBBLE_DIRECTION, (Comparable)((Object)(blockState.method_27852(class_2246.field_10422) && WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS ? (((Boolean)blockState.method_11654((class_2769)class_2741.field_12526)).booleanValue() ? BubbleDirection.DOWN : BubbleDirection.UP) : BubbleDirection.NONE)));
    }

    @NotNull
    protected class_2680 method_9559(class_2680 blockState, class_4538 levelReader, @NotNull class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        if (WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS) {
            if (MesogleaBlock.hasBubbleColumn(blockState) && (!MesogleaBlock.canColumnSurvive(levelReader, blockPos) || direction == class_2350.field_11033 || direction == class_2350.field_11036 && !MesogleaBlock.hasBubbleColumn(neighborState) && MesogleaBlock.canExistIn(neighborState))) {
                scheduledTickAccess.method_64310(blockPos, (class_2248)this, 5);
            }
            if (direction == class_2350.field_11033 && neighborState.method_27852(class_2246.field_10422)) {
                scheduledTickAccess.method_64310(blockPos, (class_2248)this, 5);
            }
        }
        return super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborPos, neighborState, randomSource);
    }

    protected void method_9612(class_2680 blockState, class_1937 level, class_2338 pos, class_2248 neighborBlock, @Nullable class_9904 orientation, boolean movedByPiston) {
        if (WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS) {
            level.method_64310(pos, (class_2248)this, 5);
        }
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (WWBlockConfig.MESOGLEA_BUBBLE_COLUMNS) {
            MesogleaBlock.updateColumn((class_1936)level, pos, state, level.method_8320(pos.method_10074()));
            class_2258.method_34268((class_1936)level, (class_2338)pos.method_10084(), (class_2680)state);
        }
    }

    @NotNull
    public class_3610 method_9545(@NotNull class_2680 blockState) {
        return class_3612.field_15910.method_15729(false);
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{BUBBLE_DIRECTION});
    }

    public boolean method_9522(@NotNull class_2680 blockState, @NotNull class_2680 blockState2, @NotNull class_2350 direction) {
        return blockState2.method_27852((class_2248)this);
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 state) {
        return WWBlockConfig.Client.MESOGLEA_FLUID ? class_2464.field_11455 : class_2464.field_11458;
    }
}

