/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datafix.minecraft;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.DisplayLanternComponentizationFix;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.DisplayLanternItemComponentizationFix;
import net.minecraft.class_1220;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixerBuilder;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixes;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.SimpleFixes;

public final class WWMinecraftDataFixer {
    public static final int DATA_VERSION = 3;

    private WWMinecraftDataFixer() {
        throw new UnsupportedOperationException("WWMinecraftDataFixer contains only static declarations.");
    }

    public static void applyDataFixes(@NotNull ModContainer mod) {
        WWConstants.log("Applying Minecraft-Version-Based DataFixes for Wilder Wild with Data Version 3", true);
        QuiltDataFixerBuilder builder = new QuiltDataFixerBuilder(3);
        builder.addSchema(0, QuiltDataFixes.BASE_SCHEMA);
        Schema schemaV2 = builder.addSchema(2, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_grass to potted_short_grass", (class_2960)WWConstants.id("potted_grass"), (class_2960)WWConstants.id("potted_short_grass"), (Schema)schemaV2);
        Schema schemaV3 = builder.addSchema(3, class_1220::new);
        builder.addFixer((DataFix)new DisplayLanternComponentizationFix(schemaV3));
        builder.addFixer((DataFix)new DisplayLanternItemComponentizationFix(schemaV3));
        QuiltDataFixes.buildAndRegisterMinecraftFixer((ModContainer)mod, (QuiltDataFixerBuilder)builder);
        WWConstants.log("Minecraft-Version-Specific DataFixes for Wilder Wild have been applied", true);
    }
}

