/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.entity.api.NoFlopAbstractFish;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.ai.jellyfish.JellyfishAi;
import net.frozenblock.wilderwild.entity.ai.jellyfish.JellyfishTemptGoal;
import net.frozenblock.wilderwild.entity.variant.jellyfish.JellyfishVariant;
import net.frozenblock.wilderwild.entity.variant.jellyfish.JellyfishVariants;
import net.frozenblock.wilderwild.networking.packet.WWJellyfishStingPacket;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.frozenblock.wilderwild.tag.WWBiomeTags;
import net.frozenblock.wilderwild.tag.WWEntityTags;
import net.minecraft.class_10209;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_7988;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jellyfish
extends NoFlopAbstractFish
implements class_7988<JellyfishVariant> {
    private static final float MAX_TARGET_DISTANCE = 4.0f;
    public static final int POISON_DURATION_IN_SECONDS_BABY = 4;
    public static final int POISON_DURATION_IN_SECONDS = 10;
    public static final float STING_PITCH = 1.0f;
    public static final float STING_PITCH_BABY = 1.2f;
    public static final int SPAWN_CHANCE = 110;
    public static final int SPAWN_HEIGHT_NORMAL_SEA_OFFSET = 13;
    public static final double HIDABLE_PLAYER_DISTANCE = 24.0;
    public static final int HIDABLE_TICKS_SINCE_SPAWN = 150;
    public static final int HIDING_CHANCE = 25;
    @NotNull
    public static final class_2960 JELLYFISH_MOVEMENT_SPEED_MODIFIER_BABY_UUID = WWConstants.id("movement_speed_modifier_baby");
    public static final class_1322 JELLYFISH_MOVEMENT_SPEED_MODIFIER_BABY = new class_1322(JELLYFISH_MOVEMENT_SPEED_MODIFIER_BABY_UUID, 0.5, class_1322.class_1323.field_6331);
    private static final class_2940<String> VARIANT = class_2945.method_12791(Jellyfish.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> CAN_REPRODUCE = class_2945.method_12791(Jellyfish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_BABY = class_2945.method_12791(Jellyfish.class, (class_2941)class_2943.field_13323);
    public final class_4051 targetingConditions = class_4051.method_36626().method_18424().method_36627().method_18420(this::canTargetEntity);
    public float xBodyRot;
    public float xRot1;
    public float xRot2;
    public float xRot3;
    public float xRot4;
    public float xRot5;
    public float xRot6;
    public float xRot7;
    public float xRot8;
    public float xRot9;
    public boolean vanishing;
    public boolean growing;
    public float prevScale = 1.0f;
    public float scale = 1.0f;
    public int ticksSinceSpawn;
    public int age;
    public int fullness;
    public int reproductionCooldown;
    private int forcedAge;
    private int forcedAgeTimer;
    private Optional<JellyfishVariant> jellyfishVariant = Optional.empty();

    public Jellyfish(@NotNull class_1299<? extends Jellyfish> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.method_5942().method_6354(false);
    }

    public static boolean checkJellyfishSpawnRules(@NotNull class_1299<Jellyfish> type, @NotNull class_5425 level, @NotNull class_3730 spawnReason, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (class_3730.method_54986((class_3730)spawnReason)) {
            return true;
        }
        if (!WWEntityConfig.get().jellyfish.spawnJellyfish) {
            return false;
        }
        class_6880 biome = level.method_23753(pos);
        if (biome.method_40220(WWBiomeTags.JELLYFISH_COMMON_SPAWN) && level.method_22335(pos, 0) <= 7 && random.method_43048(level.method_22335(pos, 0) + 3) >= 1) {
            return true;
        }
        int seaLevel = level.method_8615();
        return random.method_43051(0, 110) == 0 && pos.method_10264() <= seaLevel && pos.method_10264() >= seaLevel - 13;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)JellyfishVariants.DEFAULT.method_29177().toString());
        builder.method_56912(CAN_REPRODUCE, (Object)false);
        builder.method_56912(IS_BABY, (Object)false);
    }

    @NotNull
    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23717, 4.0);
    }

    public static void spawnFromChest(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2338 pos, boolean checkConfig) {
        if (checkConfig && !WWEntityConfig.get().jellyfish.spawnJellyfish) {
            return;
        }
        Jellyfish jellyfish = new Jellyfish(WWEntityTypes.JELLYFISH, level);
        double additionalX = 0.0;
        double additionalZ = 0.0;
        if (state.method_28498((class_2769)class_2741.field_12506) && state.method_11654((class_2769)class_2741.field_12506) != class_2745.field_12569) {
            class_2350 direction = class_2281.method_9758((class_2680)state);
            additionalX += (double)direction.method_10148() * 0.25;
            additionalZ += (double)direction.method_10165() * 0.25;
        }
        jellyfish.method_5814((double)pos.method_10263() + 0.5 + additionalX, (double)pos.method_10264() + 0.75, (double)pos.method_10260() + 0.5 + additionalZ);
        jellyfish.method_18800(0.0, 0.1 + level.field_9229.method_43058() * 0.07, 0.0);
        jellyfish.prevScale = 0.0f;
        jellyfish.scale = 0.0f;
        level.method_8649((class_1297)jellyfish);
        level.method_8421((class_1297)jellyfish, (byte)5);
    }

    public static int getSpeedUpSecondsWhenFeeding(int ticksUntilAdult) {
        return (int)((float)ticksUntilAdult / 20.0f * 0.1f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(3, (class_1352)new JellyfishTemptGoal(this, 1.25));
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData) {
        JellyfishGroupData jellyfishGroupData;
        if (spawnData instanceof JellyfishGroupData) {
            JellyfishGroupData jellyGroupData = (JellyfishGroupData)spawnData;
            this.setVariant((JellyfishVariant)jellyGroupData.variant.comp_349());
            jellyfishGroupData = jellyGroupData;
        } else {
            class_6880 holder = level.method_23753(this.method_24515());
            class_6880<JellyfishVariant> jellyfishVariantHolder = JellyfishVariants.getSpawnVariant(this.method_56673(), (class_6880<class_1959>)holder, level.method_8409());
            jellyfishGroupData = new JellyfishGroupData(true, jellyfishVariantHolder);
            spawnData = jellyfishGroupData;
            this.setVariant((JellyfishVariant)jellyfishVariantHolder.comp_349());
        }
        if (jellyfishGroupData.isShouldSpawnBaby() && level.method_8409().method_43057() <= jellyfishGroupData.getBabySpawnChance()) {
            this.method_7217(true);
        }
        jellyfishGroupData.increaseGroupSizeByOne();
        return super.method_5943(level, difficulty, reason, spawnData);
    }

    public void method_5674(@NotNull class_2940<?> key) {
        if (IS_BABY.equals(key)) {
            this.method_18382();
        }
        if (VARIANT.equals(key)) {
            this.jellyfishVariant = Optional.of(this.getVariant());
        }
        super.method_5674(key);
    }

    protected class_3414 method_5994() {
        return this.method_5816() ? WWSounds.ENTITY_JELLYFISH_AMBIENT_WATER : null;
    }

    @NotNull
    protected class_3414 method_5737() {
        return WWSounds.ENTITY_JELLYFISH_SWIM;
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return this.method_5816() ? WWSounds.ENTITY_JELLYFISH_HURT_WATER : WWSounds.ENTITY_JELLYFISH_HURT;
    }

    protected class_3414 method_6002() {
        return this.method_5816() ? WWSounds.ENTITY_JELLYFISH_DEATH_WATER : WWSounds.ENTITY_JELLYFISH_DEATH;
    }

    public boolean method_5931() {
        return !this.method_60953();
    }

    protected float method_6107() {
        return 0.4f;
    }

    @NotNull
    public class_4095.class_5303<Jellyfish> method_28306() {
        return class_4095.method_28311(JellyfishAi.MEMORY_TYPES, JellyfishAi.SENSOR_TYPES);
    }

    @NotNull
    protected class_4095<Jellyfish> method_18867(@NotNull Dynamic<?> dynamic) {
        return JellyfishAi.makeBrain(this, (class_4095<Jellyfish>)this.method_28306().method_28335(dynamic));
    }

    @NotNull
    public class_4095<Jellyfish> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_18868().method_18904(class_4140.field_22355).orElse(null);
    }

    public void setAttackTarget(class_1309 entity) {
        this.method_18868().method_24525(class_4140.field_22355, (Object)entity, 60L);
    }

    public void method_6007() {
        this.prevScale = this.scale;
        super.method_6007();
        this.xRot9 = this.xRot8;
        this.xRot8 = this.xRot7;
        this.xRot7 = this.xRot6;
        this.xRot6 = this.xRot5;
        this.xRot5 = this.xRot4;
        this.xRot4 = this.xRot3;
        this.xRot3 = this.xRot2;
        this.xRot2 = this.xRot1;
        this.xRot1 = this.xBodyRot;
        ++this.ticksSinceSpawn;
        if (this.method_5816()) {
            this.method_6025(0.02f);
            class_243 vec3 = this.method_18798();
            if (vec3.method_37267() > 0.005) {
                this.field_6283 += (float)((-class_3532.method_15349((double)vec3.field_1352, (double)vec3.field_1350) * 57.2957763671875 - (double)this.field_6283) * (double)0.1f);
                this.method_36456(this.field_6283);
            }
            this.xBodyRot += (float)((-class_3532.method_15349((double)vec3.method_37267(), (double)vec3.field_1351) * 57.2957763671875 - (double)this.xBodyRot) * (double)0.1f);
        } else {
            this.xBodyRot += (-90.0f - this.xBodyRot) * 0.02f;
        }
        this.stingEntities();
        class_1309 target = this.method_5968();
        if (target != null) {
            this.method_5942().method_6340();
            this.moveToAccurate((class_1297)target, 2.0);
        }
        if (this.growing) {
            if (this.scale < 1.0f) {
                this.scale += 0.5f;
            } else {
                this.scale = 1.0f;
                this.growing = false;
            }
        } else if (this.vanishing) {
            if (this.prevScale <= 0.0f) {
                this.method_31472();
                this.method_5783(WWSounds.ENTITY_JELLYFISH_HIDE, 0.8f, this.method_6017());
                return;
            }
            this.scale -= 0.25f;
        }
        if (this.method_37908().field_9236) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.method_5805()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
        this.reproductionCooldown = Math.max(0, this.reproductionCooldown - 1);
        this.setCanReproduce(this.reproductionCooldown == 0 && this.method_5816() && this.method_5869() && !this.vanishing && !this.growing && !this.method_6109() && this.method_5805() && !this.method_31481());
        class_1324 movementSpeed = this.method_6127().method_45329(class_5134.field_23719);
        if (movementSpeed != null) {
            if (this.method_6109()) {
                movementSpeed.method_55696(JELLYFISH_MOVEMENT_SPEED_MODIFIER_BABY);
            } else {
                movementSpeed.method_6200(JELLYFISH_MOVEMENT_SPEED_MODIFIER_BABY_UUID);
            }
        }
    }

    public void method_5711(byte id) {
        if (id == 4) {
            this.vanishing = true;
        } else if (id == 5) {
            this.growing = true;
            this.scale = 0.0f;
            this.prevScale = 0.0f;
        } else if (id == 7) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        } else if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(id);
        }
    }

    public void stingEntities() {
        if (this.method_5805() && !this.method_37908().field_9236) {
            List list = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(0.08));
            boolean baby = this.method_6109();
            float damage = baby ? 1.0f : 3.0f;
            int poisonDuration = baby ? 4 : 10;
            class_3218 level = (class_3218)this.method_37908();
            for (class_1309 entity : list) {
                if (!this.targetingConditions.method_18419(level, (class_1309)this, entity) || !entity.method_64397(level, this.method_48923().method_48812((class_1309)this), damage)) continue;
                entity.method_37222(new class_1293(class_1294.field_5899, poisonDuration * 20, 0), (class_1297)this);
                if (this.method_5701()) continue;
                class_3222 playSoundForExcept = null;
                if (entity instanceof class_3222) {
                    class_3222 player;
                    playSoundForExcept = player = (class_3222)entity;
                    WWJellyfishStingPacket.sendTo(player, baby);
                }
                this.method_37908().method_43128((class_1657)playSoundForExcept, entity.method_23317(), entity.method_23318(), entity.method_23321(), WWSounds.ENTITY_JELLYFISH_STING, this.method_5634(), 1.0f, baby ? 1.2f : 1.0f);
            }
        }
    }

    protected void method_18249(@NotNull class_1657 player, @NotNull class_1308 child) {
        if (child instanceof Jellyfish) {
            Jellyfish jellyfish = (Jellyfish)child;
            jellyfish.setVariant(this.getVariant());
        }
    }

    public void moveToAccurate(@NotNull class_1297 entity, double speed) {
        class_11 path = this.method_5942().method_6349(entity, 0);
        if (path != null) {
            this.method_5942().method_6334(path, speed);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable class_1297 entity, class_3218 level) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_37908() != livingEntity.method_37908()) return false;
        if (this.method_37908().method_8407().equals((Object)class_1267.field_5801)) return false;
        if (!class_1301.field_6156.test(livingEntity)) return false;
        if (this.method_5722((class_1297)livingEntity)) return false;
        if (livingEntity.method_5864() == class_1299.field_6131) return false;
        if (livingEntity.method_5864() == WWEntityTypes.JELLYFISH) return false;
        if (livingEntity.method_5655()) return false;
        if (livingEntity.method_29504()) return false;
        if (livingEntity.method_31481()) return false;
        if (!(livingEntity.method_5739((class_1297)this) < 4.0f)) return false;
        if (livingEntity.method_5864().method_20210(WWEntityTags.JELLYFISH_CANT_STING)) return false;
        if (!this.method_37908().method_8621().method_11966(livingEntity.method_5829())) return false;
        return true;
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("jellyfishBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("jellyfishActivityUpdate");
        JellyfishAi.updateActivity(this);
        profiler.method_15407();
        super.method_5958(level);
    }

    public boolean shouldHide() {
        return this.method_37908().method_18460((class_1297)this, 24.0) == null && this.ticksSinceSpawn >= 150 && !this.method_17326() && !this.method_5947() && !this.method_16914() && !this.method_60953() && WWEntityConfig.get().jellyfish.jellyfishHiding && this.method_5685().isEmpty() && this.method_5968() == null && this.field_5974.method_43048(25) == 0;
    }

    @NotNull
    public class_3414 method_35171() {
        return WWSounds.ITEM_BUCKET_FILL_JELLYFISH;
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8705)) {
            return super.method_5992(player, hand);
        }
        if (!itemStack.method_53187(this.getVariant().getReproductionFood())) {
            return class_1269.field_5811;
        }
        if (this.method_6109()) {
            itemStack.method_57008(1, (class_1309)player);
            this.ageUp(Jellyfish.getSpeedUpSecondsWhenFeeding(-this.getAge()), true);
            return class_1269.field_5812;
        }
        if (this.canReproduce()) {
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                itemStack.method_57008(1, (class_1309)player);
                ++this.fullness;
                this.ticksSinceSpawn = 0;
                if (this.fullness >= 8 && this.field_5974.method_43048(3) == 0) {
                    this.spawnChild(serverLevel);
                    this.fullness = 0;
                    this.method_37908().method_8421((class_1297)this, (byte)18);
                    this.reproductionCooldown = 6000;
                    this.setCanReproduce(false);
                    return class_1269.field_5812;
                }
                this.method_37908().method_8421((class_1297)this, (byte)7);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public void spawnChild(class_3218 level) {
        Jellyfish jellyfish = (Jellyfish)WWEntityTypes.JELLYFISH.method_5883((class_1937)level, class_3730.field_16466);
        if (jellyfish == null) {
            return;
        }
        jellyfish.method_7217(true);
        float bbHeight = this.method_17682();
        class_243 vec3 = this.rotateVector(new class_243(0.0, (double)(-bbHeight), 0.0)).method_1031(this.method_23317(), this.method_23318(), this.method_23321());
        jellyfish.method_5808(vec3.field_1352, vec3.field_1351 + (double)bbHeight * 0.5, vec3.field_1350, -this.method_36454(), -this.method_36455());
        jellyfish.method_18799(this.method_18798().method_1021(-0.5));
        jellyfish.setVariant(this.getVariant());
        level.method_8421((class_1297)this, (byte)18);
        if (level.method_64395().method_8355(class_1928.field_19391)) {
            level.method_8649((class_1297)new class_1303((class_1937)level, this.method_23317(), this.method_23318(), this.method_23321(), this.method_59922().method_43048(7) + 1));
        }
        level.method_30771((class_1297)jellyfish);
    }

    @NotNull
    private class_243 rotateVector(@NotNull class_243 vector) {
        class_243 vec3 = vector.method_1037(this.xRot1 * ((float)Math.PI / 180));
        vec3 = vec3.method_1024(-this.field_6220 * ((float)Math.PI / 180));
        return vec3;
    }

    public boolean method_64397(class_3218 level, @NotNull class_1282 source, float amount) {
        if (super.method_64397(level, source, amount)) {
            class_1309 target;
            if (level.method_8407() != class_1267.field_5801 && !this.method_5987() && this.field_18321.method_18904(class_4140.field_22355).isEmpty() && this.canTargetEntity((class_1297)(target = this.method_6065()), level)) {
                this.setAttackTarget(target);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public class_1799 method_6452() {
        return new class_1799((class_1935)WWItems.JELLYFISH_BUCKET);
    }

    public class_2960 getVariantLocation() {
        return class_2960.method_60654((String)((String)this.field_6011.method_12789(VARIANT)));
    }

    public JellyfishVariant getVariantByLocation() {
        return (JellyfishVariant)this.method_56673().method_30530(WilderWildRegistries.JELLYFISH_VARIANT).method_63535(this.getVariantLocation());
    }

    public class_6880<JellyfishVariant> getVariantAsHolder() {
        return (class_6880)this.method_56673().method_30530(WilderWildRegistries.JELLYFISH_VARIANT).method_10223(this.getVariantLocation()).orElseThrow();
    }

    public JellyfishVariant getVariantForRendering() {
        return this.jellyfishVariant.orElse((JellyfishVariant)this.method_56673().method_30530(WilderWildRegistries.JELLYFISH_VARIANT).method_29107(JellyfishVariants.DEFAULT));
    }

    public void setVariant(@NotNull JellyfishVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)Objects.requireNonNull(this.method_56673().method_30530(WilderWildRegistries.JELLYFISH_VARIANT).method_10221((Object)variant)).toString());
    }

    @NotNull
    public JellyfishVariant getVariant() {
        return this.getVariantByLocation();
    }

    public void setVariant(@NotNull class_2960 variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.toString());
    }

    public boolean canReproduce() {
        return (Boolean)this.field_6011.method_12789(CAN_REPRODUCE);
    }

    public void setCanReproduce(boolean bl) {
        this.field_6011.method_12778(CAN_REPRODUCE, (Object)bl);
    }

    public boolean isRGB() {
        String name = this.method_5477().getString();
        return this.method_16914() && (name.equals("jeb_") || name.equals("AroundTheWorld"));
    }

    public void ageUp(int amount, boolean forced) {
        int i;
        int j = i = this.getAge();
        if ((i += amount * 20) > 0) {
            i = 0;
        }
        int k = i - j;
        this.setAge(i);
        if (forced) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int amount) {
        this.ageUp(amount, false);
    }

    public int getAge() {
        if (this.method_37908().field_9236) {
            return (Boolean)this.field_6011.method_12789(IS_BABY) != false ? -1 : 1;
        }
        return this.age;
    }

    public void setAge(int age) {
        int i = this.getAge();
        this.age = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.field_6011.method_12778(IS_BABY, (Object)(age < 0 ? 1 : 0));
            this.ageBoundaryReached();
        }
    }

    public void ageBoundaryReached() {
        class_1690 boat;
        class_1297 class_12972;
        if (!this.method_6109() && this.method_5765() && (class_12972 = this.method_5854()) instanceof class_1690 && !(boat = (class_1690)class_12972).method_64488((class_1297)this)) {
            this.method_5848();
        }
    }

    public boolean method_6109() {
        return this.getAge() < 0;
    }

    public void method_7217(boolean baby) {
        this.setAge(baby ? -24000 : 0);
    }

    @NotNull
    public Optional<class_5321<class_52>> method_5991() {
        class_2960 resourceLocation = class_7923.field_41177.method_10221(WWEntityTypes.JELLYFISH);
        class_2960 variantLocation = this.getVariantLocation();
        return Optional.of(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)variantLocation.method_12836(), (String)("entities/" + resourceLocation.method_12832() + "_" + variantLocation.method_12832()))));
    }

    public void method_6455(@NotNull class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, compoundTag -> {
            compoundTag.method_10582("variant", this.getVariantLocation().toString());
            compoundTag.method_10556("canReproduce", this.canReproduce());
            compoundTag.method_10569("fullness", this.fullness);
            compoundTag.method_10569("reproductionCooldown", this.reproductionCooldown);
            compoundTag.method_10569("age", this.getAge());
            compoundTag.method_10569("forcedAge", this.forcedAge);
            compoundTag.method_10556("isBaby", this.method_6109());
        });
    }

    public void method_35170(@NotNull class_2487 tag) {
        class_5761.method_35168((class_1308)this, (class_2487)tag);
        Optional.ofNullable(class_2960.method_12829((String)tag.method_10558("variant"))).map(resourceLocation -> class_5321.method_29179(WilderWildRegistries.JELLYFISH_VARIANT, (class_2960)resourceLocation)).flatMap(resourceKey -> this.method_56673().method_30530(WilderWildRegistries.JELLYFISH_VARIANT).method_46746(resourceKey)).ifPresent(reference -> this.setVariant((JellyfishVariant)reference.comp_349()));
        if (tag.method_10545("canReproduce")) {
            this.setCanReproduce(tag.method_10577("canReproduce"));
        }
        this.fullness = tag.method_10550("fullness");
        this.reproductionCooldown = tag.method_10550("reproductionCooldown");
        this.setAge(tag.method_10550("age"));
        this.forcedAge = tag.method_10550("forcedAge");
        this.method_7217(tag.method_10577("isBaby"));
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10582("variant", this.getVariantLocation().toString());
        compoundTag.method_10569("ticksSinceSpawn", this.ticksSinceSpawn);
        compoundTag.method_10556("canReproduce", this.canReproduce());
        compoundTag.method_10569("fullness", this.fullness);
        compoundTag.method_10569("reproductionCooldown", this.reproductionCooldown);
        compoundTag.method_10569("age", this.getAge());
        compoundTag.method_10569("forcedAge", this.forcedAge);
        compoundTag.method_10556("isBaby", this.method_6109());
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        Optional.ofNullable(class_2960.method_12829((String)compoundTag.method_10558("variant"))).map(resourceLocation -> class_5321.method_29179(WilderWildRegistries.JELLYFISH_VARIANT, (class_2960)resourceLocation)).flatMap(resourceKey -> this.method_56673().method_30530(WilderWildRegistries.JELLYFISH_VARIANT).method_46746(resourceKey)).ifPresent(reference -> this.setVariant((JellyfishVariant)reference.comp_349()));
        this.ticksSinceSpawn = compoundTag.method_10550("ticksSinceSpawn");
        if (compoundTag.method_10545("canReproduce")) {
            this.setCanReproduce(compoundTag.method_10577("canReproduce"));
        }
        this.fullness = compoundTag.method_10550("fullness");
        this.reproductionCooldown = compoundTag.method_10550("reproductionCooldown");
        this.setAge(compoundTag.method_10550("age"));
        this.forcedAge = compoundTag.method_10550("forcedAge");
        this.method_7217(compoundTag.method_10577("isBaby"));
    }

    public static class JellyfishGroupData
    implements class_1315 {
        private final boolean shouldSpawnBaby;
        private final float babySpawnChance;
        private final class_6880<JellyfishVariant> variant;
        private int groupSize;

        private JellyfishGroupData(boolean shouldSpawnBaby, float babySpawnChance, class_6880<JellyfishVariant> variant) {
            this.shouldSpawnBaby = shouldSpawnBaby;
            this.babySpawnChance = babySpawnChance;
            this.variant = variant;
        }

        public JellyfishGroupData(boolean shouldSpawnBaby, class_6880<JellyfishVariant> variant) {
            this(shouldSpawnBaby, 0.15f, variant);
        }

        public JellyfishGroupData(float babySpawnChance, class_6880<JellyfishVariant> variant) {
            this(true, babySpawnChance, variant);
        }

        public int getGroupSize() {
            return this.groupSize;
        }

        public void increaseGroupSizeByOne() {
            ++this.groupSize;
        }

        public boolean isShouldSpawnBaby() {
            return this.shouldSpawnBaby;
        }

        public float getBabySpawnChance() {
            return this.babySpawnChance;
        }
    }
}

