/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.screenshake.api.ScreenShakeManager;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichAi;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichBodyRotationControl;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichLookControl;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichMoveControl;
import net.frozenblock.wilderwild.registry.WWDamageTypes;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.frozenblock.wilderwild.tag.WWItemTags;
import net.minecraft.class_10209;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1316;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1330;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3695;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ostrich
extends class_1496
implements class_1316,
class_5146 {
    @NotNull
    public static final class_2960 ATTACK_MODIFIER_UUID = WWConstants.id("additional_damage_rider");
    @NotNull
    public static final class_2960 KNOCKBACK_MODIFIER_UUID = WWConstants.id("additional_knockback_rider");
    public static final int BEAK_COOLDOWN_TICKS = 30;
    public static final int BEAK_COOLDOWN_TICKS_SUCCESSFUL_HIT = 20;
    public static final int BEAK_STUCK_TICKS = 36;
    public static final int BEAK_STUCK_TICKS_AGGRESSIVE = 20;
    public static final float MAX_ATTACK_DAMAGE = 6.0f;
    public static final float ADDITIONAL_DAMAGE_RIDER = 1.0f;
    public static final float ADDITIONAL_KNOCKBACK_RIDER = 0.5f;
    public static final double ATTACK_BOX_WIDTH = 0.5;
    public static final double ATTACK_BOX_HEIGHT = (double)0.6f;
    public static final double DIMENSION_PERCENTAGE_AT_NECK = 0.5163043478260869;
    public static final class_1322 ADDITIONAL_DAMAGE_RIDER_MODIFIER = new class_1322(ATTACK_MODIFIER_UUID, 1.0, class_1322.class_1323.field_6328);
    public static final class_2940<Float> TARGET_BEAK_ANIM_PROGRESS = class_2945.method_12791(Ostrich.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> TARGET_STRAIGHT_PROGRESS = class_2945.method_12791(Ostrich.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Boolean> IS_ATTACKING = class_2945.method_12791(Ostrich.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> BEAK_COOLDOWN = class_2945.method_12791(Ostrich.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> STUCK_TICKS = class_2945.method_12791(Ostrich.class, (class_2941)class_2943.field_13327);
    public boolean attackHasCommander;
    public boolean commanderWasPlayer;
    private float prevStraightProgress;
    private float straightProgress;
    private float prevBeakAnimProgress;
    private float beakAnimProgress;
    @Nullable
    private UUID lastAttackCommander;
    @Nullable
    private class_243 prevBeakPosition;
    @Nullable
    private class_243 beakPosition;
    @Nullable
    private class_2680 beakState;
    @Nullable
    private class_265 beakVoxelShape;

    public Ostrich(class_1299<? extends Ostrich> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new OstrichMoveControl(this);
        this.field_6206 = new OstrichLookControl(this);
        class_1409 groundPathNavigation = (class_1409)this.method_5942();
        groundPathNavigation.method_6354(true);
    }

    @NotNull
    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_47761, 1.5).method_26868(class_5134.field_23721, 6.0);
    }

    public static boolean checkOstrichSpawnRules(class_1299<? extends Ostrich> ostrich, @NotNull class_1936 level, class_3730 spawnType, @NotNull class_2338 pos, class_5819 random) {
        if (!class_3730.method_54986((class_3730)spawnType) && !WWEntityConfig.get().ostrich.spawnOstriches) {
            return false;
        }
        return class_1429.method_20663(ostrich, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TARGET_BEAK_ANIM_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(TARGET_STRAIGHT_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(IS_ATTACKING, (Object)false);
        builder.method_56912(BEAK_COOLDOWN, (Object)0);
        builder.method_56912(STUCK_TICKS, (Object)0);
    }

    public void method_5959() {
    }

    @NotNull
    public class_4095.class_5303<Ostrich> method_28306() {
        return OstrichAi.brainProvider();
    }

    @NotNull
    public class_4095<Ostrich> method_18868() {
        return super.method_18868();
    }

    @NotNull
    public class_4095<Ostrich> method_18867(@NotNull Dynamic<?> dynamic) {
        return OstrichAi.makeBrain(this, (class_4095<Ostrich>)this.method_28306().method_28335(dynamic));
    }

    protected void method_48565(float limbDistance) {
        float fastDistance = limbDistance * 4.0f;
        float f = Math.min(fastDistance, 1.0f);
        float difference = fastDistance - f;
        this.field_42108.method_48568(f + difference * 0.15f, 0.4f, this.method_6109() ? 3.0f : 1.0f);
    }

    public void method_5958(class_3218 level) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("ostrichBrain");
        class_4095<Ostrich> brain = this.method_18868();
        brain.method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("ostrichActivityUpdate");
        OstrichAi.updateActivity(this);
        profiler.method_15407();
        super.method_5958(level);
    }

    public void method_5773() {
        this.prevBeakAnimProgress = this.getTargetBeakAnimProgress();
        this.prevBeakPosition = this.getBeakPos();
        super.method_5773();
        if (this.getBeakCooldown() <= 1 && (this.isBeakTouchingFluid() || this.isEyeTouchingFluid() || this.isBeakTouchingCollidingBlock(false))) {
            this.setBeakCooldown(2);
        }
        if (this.getBeakCooldown() > 0) {
            this.setBeakCooldown(this.getBeakCooldown() - 1);
            if (this.getBeakCooldown() == 0) {
                this.setTargetBeakAnimProgress(0.0f);
            }
        }
        if (this.refuseToMove()) {
            this.clampHeadRotationToBody((class_1297)this, 0.0f);
        }
        this.prevBeakAnimProgress = this.beakAnimProgress;
        this.beakAnimProgress += (this.getTargetBeakAnimProgress() - this.beakAnimProgress) * this.getBeakEaseAmount();
        this.beakPosition = this.makeBeakPos();
        this.beakState = this.makeBeakState();
        this.beakVoxelShape = this.getBeakState().method_26194((class_1922)this.method_37908(), class_2338.method_49638((class_2374)this.getBeakPos()), class_3726.method_16195((class_1297)this));
        if (!this.method_37908().field_9236) {
            this.handleAttackAndStuck((class_3218)this.method_37908());
            if (this.method_31483() != null || this.method_6510()) {
                this.setTargetStraightProgress(1.0f);
            } else {
                this.setTargetStraightProgress(0.0f);
            }
            this.method_19540(this.hasAttackTarget());
        }
        this.prevStraightProgress = this.straightProgress;
        this.straightProgress += (this.getTargetStraightProgress() - this.straightProgress) * 0.3f;
        if (this.isStuck()) {
            this.method_5942().method_6340();
        }
    }

    public class_238 createAttackBox(float tickDelta) {
        double height = (double)0.6f * (double)this.method_55693();
        double width = 0.5 * (double)this.method_55693();
        return class_238.method_30048((class_243)this.getBeakPos(tickDelta), (double)width, (double)height, (double)width).method_989(0.0, -height * 0.5, 0.0);
    }

    private void handleAttackAndStuck(class_3218 level) {
        if (this.isAttacking()) {
            boolean strongEnoughToAttack;
            if (!WWEntityConfig.get().ostrich.allowAttack && this.attackHasCommander) {
                this.cancelAttack(true);
            }
            class_2338 beakBlockPos = class_2338.method_49638((class_2374)this.getBeakPos());
            boolean hasAttacked = false;
            class_238 attackBox = this.createAttackBox(1.0f);
            if (this.isBeakTouchingFluid()) {
                this.cancelAttack(false);
            }
            if (this.isBeakTouchingCollidingBlock(false)) {
                class_2498 soundType = this.getBeakState().method_26231();
                if (!this.method_5701()) {
                    this.method_37908().method_8396(null, beakBlockPos, soundType.method_10596(), this.method_5634(), soundType.method_10597(), soundType.method_10599());
                }
                this.spawnBlockParticles(false, false);
                this.cancelAttack(false);
            }
            boolean bl = strongEnoughToAttack = this.getBeakAnimProgress(1.0f) >= 0.2f;
            if (strongEnoughToAttack) {
                List entities = this.method_37908().method_8335((class_1297)this, attackBox);
                for (class_1297 entity : entities) {
                    if (!this.method_5626(entity)) {
                        class_1297 commander = this.getLastAttackCommander();
                        if (commander != null) {
                            if (!commander.method_5722(entity) && commander != entity) {
                                hasAttacked = this.doHurtOnEntity(level, commander, entity);
                            }
                        } else {
                            if (this.attackHasCommander) {
                                this.cancelAttack(false);
                                return;
                            }
                            if (this.canTargetEntity(entity)) {
                                hasAttacked = this.doHurtOnEntity(level, null, entity);
                            }
                        }
                    }
                    if (!hasAttacked) continue;
                    this.cancelAttack(true);
                    return;
                }
                if (this.isBeakTouchingCollidingBlock(true)) {
                    this.setBeakCooldown(this.method_6510() ? 40 : 66);
                    this.setStuckTicks(this.method_6510() ? 20 : 36);
                    this.setAttacking(false);
                    this.setTargetBeakAnimProgress(this.getBeakAnimProgress(1.0f));
                    if (!this.method_5701()) {
                        boolean inbred = this.isInbred();
                        class_3414 stuckSoundEvent = inbred ? WWSounds.ENTITY_OSTRICH_INBRED_BEAK_STUCK : WWSounds.ENTITY_OSTRICH_BEAK_STUCK;
                        float volume = inbred ? 8.0f : this.method_6107();
                        this.method_37908().method_8396(null, beakBlockPos, stuckSoundEvent, this.method_5634(), volume, this.method_6017());
                        if (inbred) {
                            ScreenShakeManager.addEntityScreenShake((class_1297)this, (float)3.5f, (int)40, (float)16.0f);
                        }
                    }
                    this.spawnBlockParticles(true, false);
                    return;
                }
            }
            if (this.getBeakAnimProgress(1.0f) >= this.getClampedTargetBeakAnimProgress() - 0.025f) {
                this.cancelAttack(false);
            }
        } else if (this.getStuckTicks() > 0) {
            this.setStuckTicks(this.getStuckTicks() - 1);
            if (this.getStuckTicks() == 0 || !this.isBeakTouchingCollidingBlock(true)) {
                this.emergeBeak();
            }
        }
    }

    public boolean doHurtOnEntity(class_3218 level, @Nullable class_1297 commander, @NotNull class_1297 entity) {
        float beakProgress = (this.getBeakAnimProgress(1.0f) + this.getClampedTargetBeakAnimProgress()) * 0.5f;
        float beakDamage = beakProgress * (float)this.method_5996(class_5134.field_23721).method_6194();
        class_1324 knockback = this.method_5996(class_5134.field_23722);
        knockback.method_55696(new class_1322(KNOCKBACK_MODIFIER_UUID, (double)(beakProgress * 0.5f), class_1322.class_1323.field_6328));
        boolean didHurt = entity.method_64397(level, this.method_48923().method_48796(WWDamageTypes.OSTRICH, (class_1297)(commander != null ? commander : this)), beakDamage);
        if (!didHurt) {
            knockback.method_6200(KNOCKBACK_MODIFIER_UUID);
        } else if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_6005(knockback.method_6194(), this.method_23317() - livingEntity.method_23317(), this.method_23321() - livingEntity.method_23321());
        }
        return didHurt;
    }

    public void method_23667(@NotNull class_1268 hand, boolean updateSelf) {
        if (!this.isAttacking() && this.getBeakCooldown() <= 0 && !this.isStuck()) {
            this.performAttack(0.6f + this.field_5974.method_43057() * 0.4f, null);
        }
    }

    public void cancelAttack(boolean successful) {
        this.setTargetBeakAnimProgress(0.0f);
        this.setAttacking(false);
        this.setBeakCooldown(successful || this.method_6510() ? 20 : 30);
        this.setLastAttackCommander(null);
        this.method_5996(class_5134.field_23721).method_6200(ATTACK_MODIFIER_UUID);
        this.method_5996(class_5134.field_23722).method_6200(KNOCKBACK_MODIFIER_UUID);
    }

    public void emergeBeak() {
        this.setStuckTicks(0);
        this.setBeakCooldown(this.method_6510() ? 20 : 30);
        this.setTargetBeakAnimProgress(0.0f);
    }

    @Nullable
    public class_1297 getLastAttackCommander() {
        class_1657 commander;
        block4: {
            Object object;
            commander = null;
            if (this.lastAttackCommander == null || !((object = this.method_37908()) instanceof class_3218)) break block4;
            class_3218 serverLevel = (class_3218)object;
            if (this.commanderWasPlayer) {
                for (class_1657 player : serverLevel.method_18456()) {
                    if (!player.method_5667().equals(this.lastAttackCommander)) continue;
                    commander = player;
                    break;
                }
            } else {
                for (class_1297 entity : serverLevel.field_26935.method_31841().method_31803()) {
                    if (!entity.method_5667().equals(this.lastAttackCommander)) continue;
                    commander = entity;
                    break;
                }
            }
        }
        return commander;
    }

    public void setLastAttackCommander(@Nullable class_1297 entity) {
        if (entity != null) {
            this.attackHasCommander = true;
            this.lastAttackCommander = entity.method_5667();
            this.commanderWasPlayer = entity instanceof class_1657;
        } else {
            this.attackHasCommander = false;
            this.lastAttackCommander = null;
            this.commanderWasPlayer = false;
        }
    }

    @NotNull
    public class_238 method_53511() {
        float scale = this.method_55693();
        double attackBBOffset = 0.2 * (double)scale;
        return super.method_53511().method_1009(attackBBOffset, 0.0, attackBBOffset).method_989(0.0, -attackBBOffset, 0.0);
    }

    public boolean method_6062() {
        return this.isStuck() || super.method_6062();
    }

    public float method_6120() {
        return 0.96f;
    }

    public boolean method_48155() {
        return true;
    }

    public void method_49481(@NotNull class_1657 player, @NotNull class_243 travelVector) {
        class_241 vec2 = this.method_49489((class_1309)player);
        this.method_5710(vec2.field_1342, vec2.field_1343);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        if (this.method_5787()) {
            if (WWEntityConfig.get().ostrich.allowAttack && this.field_6976 > 0.0f) {
                this.method_45343(this.field_6976, travelVector);
            }
            this.field_6976 = 0.0f;
        }
    }

    public void method_45343(float playerJumpPendingScale, @NotNull class_243 travelVector) {
        this.field_6007 = true;
    }

    public void method_6155(int jumpPower) {
        float powerPercent = (float)jumpPower * 0.0125f;
        this.performAttack(powerPercent, this.method_31483());
    }

    public void performAttack(float power, @Nullable class_1297 commander) {
        if (commander != null && !WWEntityConfig.get().ostrich.allowAttack) {
            return;
        }
        this.setBeakCooldown(30);
        this.setAttacking(true);
        this.setTargetBeakAnimProgress(power);
        this.setLastAttackCommander(commander);
        class_3414 soundEvent = this.isInbred() ? WWSounds.ENTITY_OSTRICH_INBRED_SWING : WWSounds.ENTITY_OSTRICH_SWING;
        this.method_5783(soundEvent, 0.4f, 0.9f + this.field_5974.method_43057() * 0.2f);
        if (this.attackHasCommander) {
            this.method_5996(class_5134.field_23721).method_55696(ADDITIONAL_DAMAGE_RIDER_MODIFIER);
        }
    }

    public void method_6156() {
    }

    public int method_45327() {
        return this.getBeakCooldown();
    }

    public boolean refuseToMove() {
        return this.isStuck();
    }

    public boolean isStuck() {
        return this.getStuckTicks() > 0;
    }

    public float method_49485(@NotNull class_1657 player) {
        return (float)this.method_45325(class_5134.field_23719) + this.getAdditionalSpeed();
    }

    public float getAdditionalSpeed() {
        class_1657 player;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_5624() && this.method_45327() == 0 ? 0.2f : 0.0f;
    }

    @NotNull
    public class_241 method_49489(@NotNull class_1309 entity) {
        return this.refuseToMove() ? new class_241(this.method_36455(), this.method_36454()) : super.method_49489(entity);
    }

    @NotNull
    public class_243 method_49482(@NotNull class_1657 player, @NotNull class_243 travelVector) {
        return this.refuseToMove() ? class_243.field_1353 : super.method_49482(player, travelVector);
    }

    public boolean method_6153() {
        return WWEntityConfig.get().ostrich.allowAttack && !this.refuseToMove() && super.method_6153();
    }

    public void method_6154(int jumpPower) {
        if (this.method_6725() && this.getBeakCooldown() <= 0) {
            super.method_6154(jumpPower);
        }
    }

    public boolean method_5810() {
        return !this.refuseToMove() && super.method_5810();
    }

    public boolean method_5675() {
        return this.isBeakTouchingFluid();
    }

    public boolean method_6481(@NotNull class_1799 stack) {
        return stack.method_31573(WWItemTags.OSTRICH_FOOD);
    }

    public boolean method_60956(class_1297 entity, float distance) {
        if (distance > 6.0f && this.isStuck()) {
            this.emergeBeak();
        }
        super.method_60956(entity, distance);
        return true;
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack;
        boolean isGrownAndTamedWithShiftHeldDown;
        if (this.method_6510() && !this.method_6727()) {
            return class_1269.field_5814;
        }
        boolean bl = isGrownAndTamedWithShiftHeldDown = !this.method_6109() && this.method_6727() && player.method_21823();
        if (!this.method_5782() && !isGrownAndTamedWithShiftHeldDown && !(itemStack = player.method_5998(hand)).method_7960() && this.method_6481(itemStack)) {
            OstrichAi.removeAttackAndAngerTarget(this);
            return this.method_30009(player, itemStack);
        }
        return super.method_5992(player, hand);
    }

    public void method_6726(class_1657 player) {
        super.method_6726(player);
        OstrichAi.removeAttackAndAngerTarget(this);
    }

    public boolean method_6742(@NotNull class_1657 player, @NotNull class_1799 stack) {
        class_3414 soundEvent;
        boolean isBaby;
        boolean bl2;
        boolean isHurt;
        if (!this.method_6481(stack)) {
            return false;
        }
        boolean bl = isHurt = this.method_6032() < this.method_6063();
        if (isHurt) {
            this.method_6025(2.0f);
        }
        boolean bl3 = bl2 = this.method_6727() && this.method_5618() == 0 && this.method_6482();
        if (bl2) {
            this.method_6480(player);
        }
        if (isBaby = this.method_6109()) {
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            if (!this.method_37908().field_9236) {
                this.method_5615(10);
            }
        }
        if (!(isHurt || bl2 || isBaby)) {
            return false;
        }
        if (!this.method_5701() && (soundEvent = this.method_28368()) != null) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        this.method_32876((class_6880)class_5712.field_28735);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable class_1297 entity) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_37908() != livingEntity.method_37908()) return false;
        if (this.method_37908().method_8407().equals((Object)class_1267.field_5801)) return false;
        if (!class_1301.field_6156.test(livingEntity)) return false;
        if (this.method_5722((class_1297)livingEntity)) return false;
        if (livingEntity.method_5864() == class_1299.field_6131) return false;
        if (livingEntity.method_5864() == WWEntityTypes.OSTRICH) return false;
        if (this.method_5782()) return false;
        if (livingEntity instanceof class_1657) {
            if (this.method_6727()) return false;
        }
        if (livingEntity.method_5655()) return false;
        if (livingEntity.method_29504()) return false;
        if (livingEntity.method_31481()) return false;
        if (!this.method_37908().method_8621().method_11966(livingEntity.method_5829())) return false;
        return true;
    }

    public boolean method_5747(float fallDistance, float multiplier, @NotNull class_1282 source) {
        int i = this.method_23329(fallDistance, multiplier);
        if (i <= 0) {
            return false;
        }
        if (fallDistance >= 6.0f) {
            this.method_64419(source, i);
            if (this.method_5782()) {
                for (class_1297 entity : this.method_5736()) {
                    entity.method_64419(source, (float)i);
                }
            }
        }
        this.method_23328();
        return true;
    }

    public boolean method_64397(class_3218 level, @NotNull class_1282 source, float amount) {
        class_1297 class_12972;
        boolean bl = super.method_64397(level, source, amount);
        if (bl && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            OstrichAi.wasHurtBy(level, this, livingEntity);
        }
        return bl;
    }

    @NotNull
    private class_243 makeBeakPos() {
        double scale = this.method_55693() * this.method_17825();
        float beakAnimProgress = this.getBeakAnimProgress(0.0f);
        class_243 currentPos = this.method_19538().method_1031(0.0, 0.5163043478260869 * (double)this.method_5751(), 0.0);
        class_243 lookOrientation = class_243.method_1034((class_241)new class_241(0.0f, this.method_5791()));
        class_243 neckBasePos = currentPos.method_1019(lookOrientation.method_1021(0.475 * scale));
        class_243 headBaseRotPos = AdvancedMath.rotateAboutX((class_243)class_243.field_1353, (double)(0.275 * scale), (double)((double)beakAnimProgress * 180.0 * 0.3 + 90.0));
        class_243 headBasePos = neckBasePos.method_1031(0.0, headBaseRotPos.method_10216(), 0.0).method_1019(lookOrientation.method_1021(headBaseRotPos.method_10215()));
        class_243 beakRotPos = AdvancedMath.rotateAboutX((class_243)class_243.field_1353, (double)(1.15 * scale), (double)((double)beakAnimProgress * 180.0 * 0.7 + 10.0));
        double downFactor = Math.max(0.0, (double)beakAnimProgress - 0.5) * 0.75 * 1.75 * scale;
        class_243 beakPos = headBasePos.method_1031(0.0, beakRotPos.method_10216() - downFactor, 0.0).method_1019(lookOrientation.method_1021(beakRotPos.method_10215() - downFactor));
        return beakPos;
    }

    @NotNull
    public List<class_243> getDebugRenderingPoses(float tickDelta) {
        ArrayList<class_243> poses = new ArrayList<class_243>();
        double scale = this.method_55693() * this.method_17825();
        float beakAnimProgress = this.getBeakAnimProgress(tickDelta);
        class_243 currentPos = this.method_30950(tickDelta).method_1031(0.0, 0.5163043478260869 * (double)this.method_5751(), 0.0);
        class_243 lookOrientation = class_243.method_1034((class_241)new class_241(0.0f, class_3532.method_16439((float)tickDelta, (float)this.field_6259, (float)this.field_6241)));
        class_243 neckBasePos = currentPos.method_1019(lookOrientation.method_1021(0.475 * scale));
        class_243 headBaseRotPos = AdvancedMath.rotateAboutX((class_243)class_243.field_1353, (double)(0.275 * scale), (double)((double)beakAnimProgress * 180.0 * 0.3 + 90.0));
        class_243 headBasePos = neckBasePos.method_1031(0.0, headBaseRotPos.method_10216(), 0.0).method_1019(lookOrientation.method_1021(headBaseRotPos.method_10215()));
        class_243 beakRotPos = AdvancedMath.rotateAboutX((class_243)class_243.field_1353, (double)(1.15 * scale), (double)((double)beakAnimProgress * 180.0 * 0.7 + 10.0));
        double downFactor = Math.max(0.0, (double)beakAnimProgress - 0.5) * 0.75 * 1.75 * scale;
        class_243 beakPos = headBasePos.method_1031(0.0, beakRotPos.method_10216() - downFactor, 0.0).method_1019(lookOrientation.method_1021(beakRotPos.method_10215() - downFactor));
        poses.add(neckBasePos);
        poses.add(headBasePos);
        poses.add(beakPos);
        return poses;
    }

    @NotNull
    private class_243 getPrevBeakPos() {
        return this.prevBeakPosition != null ? this.prevBeakPosition : (this.prevBeakPosition = this.makeBeakPos());
    }

    @NotNull
    private class_243 getBeakPos() {
        return this.beakPosition != null ? this.beakPosition : (this.beakPosition = this.makeBeakPos());
    }

    @NotNull
    public class_243 getBeakPos(float tickDelta) {
        return this.getPrevBeakPos().method_35590(this.getBeakPos(), (double)tickDelta);
    }

    @NotNull
    public class_2680 getBeakState() {
        return this.beakState != null ? this.beakState : (this.beakState = this.makeBeakState());
    }

    @NotNull
    private class_2680 makeBeakState() {
        return this.method_37908().method_8320(class_2338.method_49638((class_2374)this.getBeakPos()));
    }

    public boolean canGetHeadStuckInState(@NotNull class_2680 blockState) {
        return blockState.method_26164(WWBlockTags.OSTRICH_BEAK_BURYABLE);
    }

    public boolean isBeakTouchingFluid() {
        class_243 beakVec = this.getBeakPos();
        class_2338 beakPos = class_2338.method_49638((class_2374)beakVec);
        class_3610 fluidState = this.getBeakState().method_26227();
        return !fluidState.method_15769() && (double)(fluidState.method_15763((class_1922)this.method_37908(), beakPos) + (float)beakPos.method_10264()) >= beakVec.method_10214();
    }

    public boolean isBeakTouchingCollidingBlock(boolean canGetStuck) {
        class_243 beakVec = this.getBeakPos();
        class_2338 beakPos = class_2338.method_49638((class_2374)beakVec);
        if (this.beakVoxelShape != null && !this.beakVoxelShape.method_1110() && this.beakVoxelShape != class_259.method_1073()) {
            class_238 collisionShape = this.beakVoxelShape.method_1107().method_996(beakPos);
            return canGetStuck == this.canGetHeadStuckInState(this.getBeakState()) && collisionShape.method_1006(beakVec);
        }
        return false;
    }

    public boolean isEyeTouchingFluid() {
        class_243 eyeVec = this.method_33571();
        class_2338 eyePos = class_2338.method_49638((class_2374)eyeVec);
        class_3610 fluidState = this.getBeakState().method_26227();
        return !fluidState.method_15769() && (double)(fluidState.method_15763((class_1922)this.method_37908(), eyePos) + (float)eyePos.method_10264()) >= eyeVec.method_10214();
    }

    public int method_6755() {
        return 150;
    }

    protected boolean method_45349() {
        return false;
    }

    public boolean method_6762() {
        return false;
    }

    public boolean method_6474(@NotNull class_1429 otherAnimal) {
        if (otherAnimal != this && otherAnimal instanceof Ostrich) {
            Ostrich ostrich = (Ostrich)otherAnimal;
            return this.method_6734() && ostrich.method_6734();
        }
        return false;
    }

    public boolean method_6734() {
        return !this.hasAttackTarget() && super.method_6734();
    }

    public boolean hasAttackTarget() {
        return this.method_18868().method_18896(class_4140.field_22355);
    }

    public void method_24650(@NotNull class_3218 level, @NotNull class_1429 mate) {
        this.method_49794(level, mate, null);
        this.method_18868().method_18878(class_4140.field_37443, (Object)class_3902.field_17274);
    }

    public boolean isPregnant() {
        return this.method_18868().method_18896(class_4140.field_37443);
    }

    public void revokePregnancy() {
        this.method_18868().method_18875(class_4140.field_37443);
    }

    @Nullable
    public Ostrich getBreedOffspring(@NotNull class_3218 level, @NotNull class_1296 otherParent) {
        return (Ostrich)WWEntityTypes.OSTRICH.method_5883((class_1937)level, class_3730.field_16466);
    }

    public void method_6074(class_3218 level, @NotNull class_1282 damageSource, float damageAmount) {
        this.emergeBeak();
        super.method_6074(level, damageSource, damageAmount);
    }

    @NotNull
    public class_243 method_29919() {
        return new class_243(0.0, 0.5163043478260869 * (double)this.method_5751(), (double)this.method_17681() * 0.5);
    }

    public void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    @NotNull
    public class_1330 method_5963() {
        return new OstrichBodyRotationControl(this);
    }

    public float getBeakEaseAmount() {
        return this.isAttacking() ? 0.3f : 0.1f;
    }

    private float getTargetBeakAnimProgress() {
        return ((Float)this.field_6011.method_12789(TARGET_BEAK_ANIM_PROGRESS)).floatValue();
    }

    public void setTargetBeakAnimProgress(float progress) {
        this.field_6011.method_12778(TARGET_BEAK_ANIM_PROGRESS, (Object)Float.valueOf(progress));
    }

    private float getClampedTargetBeakAnimProgress() {
        return Math.min(((Float)this.field_6011.method_12789(TARGET_BEAK_ANIM_PROGRESS)).floatValue(), 1.0f);
    }

    public float getBeakAnimProgress(float delta) {
        return Math.min(class_3532.method_16439((float)delta, (float)this.prevBeakAnimProgress, (float)this.beakAnimProgress), 1.0f);
    }

    private float getTargetStraightProgress() {
        return ((Float)this.field_6011.method_12789(TARGET_STRAIGHT_PROGRESS)).floatValue();
    }

    public void setTargetStraightProgress(float progress) {
        this.field_6011.method_12778(TARGET_STRAIGHT_PROGRESS, (Object)Float.valueOf(progress));
    }

    public float getTargetStraightProgress(float delta) {
        return class_3532.method_16439((float)delta, (float)this.prevStraightProgress, (float)this.straightProgress);
    }

    private boolean isAttacking() {
        return (Boolean)this.field_6011.method_12789(IS_ATTACKING);
    }

    private void setAttacking(boolean isAttacking) {
        this.field_6011.method_12778(IS_ATTACKING, (Object)isAttacking);
    }

    private int getBeakCooldown() {
        return (Integer)this.field_6011.method_12789(BEAK_COOLDOWN);
    }

    private void setBeakCooldown(int cooldown) {
        this.field_6011.method_12778(BEAK_COOLDOWN, (Object)cooldown);
    }

    private int getStuckTicks() {
        return (Integer)this.field_6011.method_12789(STUCK_TICKS);
    }

    private void setStuckTicks(int stuckTicks) {
        this.field_6011.method_12778(STUCK_TICKS, (Object)stuckTicks);
    }

    private void clampHeadRotationToBody(@NotNull class_1297 entity, float maxYRot) {
        float f = entity.method_5791();
        float g = class_3532.method_15393((float)(this.field_6283 - f));
        float h = class_3532.method_15363((float)class_3532.method_15393((float)(this.field_6283 - f)), (float)(-maxYRot), (float)maxYRot);
        float i = f + g - h;
        entity.method_5847(i);
    }

    @Nullable
    public class_3414 method_28368() {
        if (this.isInbred()) {
            return WWSounds.ENTITY_OSTRICH_INBRED_IDLE_AH;
        }
        return WWSounds.ENTITY_OSTRICH_EAT;
    }

    @NotNull
    public class_3414 method_45328() {
        return WWSounds.ENTITY_OSTRICH_SADDLE;
    }

    @Nullable
    public class_3414 method_6747() {
        if (this.isInbred()) {
            return WWSounds.ENTITY_OSTRICH_INBRED_IDLE_AH;
        }
        return WWSounds.ENTITY_OSTRICH_GRUNT;
    }

    public int method_5970() {
        return !this.method_6510() ? super.method_5970() : 50;
    }

    @Nullable
    public class_3414 method_5994() {
        if (this.isInbred()) {
            return this.field_5974.method_43057() <= 0.555f ? WWSounds.ENTITY_OSTRICH_INBRED_IDLE_AH : WWSounds.ENTITY_OSTRICH_INBRED_IDLE_BOCK;
        }
        return !this.method_6510() ? WWSounds.ENTITY_OSTRICH_IDLE : (this.field_5974.method_43056() ? WWSounds.ENTITY_OSTRICH_HISS : WWSounds.ENTITY_OSTRICH_GRUNT);
    }

    @Nullable
    public class_3414 method_6011(@NotNull class_1282 damageSource) {
        if (this.isInbred()) {
            return WWSounds.ENTITY_OSTRICH_INBRED_HURT;
        }
        return WWSounds.ENTITY_OSTRICH_HURT;
    }

    @Nullable
    public class_3414 method_6002() {
        if (this.isInbred()) {
            return WWSounds.ENTITY_OSTRICH_INBRED_DEATH;
        }
        return WWSounds.ENTITY_OSTRICH_DEATH;
    }

    public float method_5867() {
        return this.field_5994 + 1.0f + (this.method_5782() ? 0.75f : 0.0f) + this.getAdditionalSpeed() * 5.0f;
    }

    public void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
        boolean inbred = this.isInbred();
        class_3414 soundEvent = inbred ? WWSounds.ENTITY_OSTRICH_INBRED_STEP : WWSounds.ENTITY_OSTRICH_STEP;
        float volume = inbred ? 0.5f : 0.1f;
        this.method_5783(soundEvent, volume, 0.9f + this.field_5974.method_43057() * 0.2f);
    }

    @NotNull
    public class_243 method_52533(@NotNull class_1297 entity, @NotNull class_4048 dimensions, float scale) {
        return new class_243(0.0, (double)dimensions.comp_2186() * 0.775, (double)dimensions.comp_2185() * -0.1).method_1024(-this.method_36454() * ((float)Math.PI / 180));
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6727();
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_6727() && super.method_5974(distanceToClosestPlayer);
    }

    public boolean isInbred() {
        return this.method_16914() && this.method_5797().getString().equalsIgnoreCase("shadownite64");
    }

    public void spawnBlockParticles(boolean beakBury, boolean backwards) {
        class_1937 class_19372;
        if (!this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (this.beakVoxelShape != null && this.getBeakState().method_45475() && this.getBeakState().method_26217() != class_2464.field_11455) {
                class_243 particlePos = this.getBeakPos();
                class_243 deltaBeakPos = particlePos.method_1020(this.getPrevBeakPos()).method_1021(!backwards ? 2.0 : -2.0);
                class_3965 beakHitResult = this.getBeakHitResult(backwards);
                if (beakHitResult.method_17783() != class_239.class_240.field_1333) {
                    int count = !beakBury ? this.field_5974.method_43051(7, 12) : this.field_5974.method_43051(12, 20);
                    class_2388 blockParticleOption = new class_2388(class_2398.field_11217, this.getBeakState());
                    class_243 hitLocation = beakHitResult.method_17784();
                    server.method_14199((class_2394)blockParticleOption, hitLocation.method_10216(), hitLocation.method_10214(), hitLocation.method_10215(), count, 0.0, 0.0, 0.0, 0.05 + deltaBeakPos.method_1033());
                }
            }
        }
    }

    public class_3965 getBeakHitResult(boolean backwards) {
        return this.method_37908().method_17742(new class_3959(!backwards ? this.getPrevBeakPos() : this.getBeakPos(), !backwards ? this.getBeakPos() : this.getPrevBeakPos(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("BeakCooldown", this.getBeakCooldown());
        compound.method_10548("TargetBeakAnimProgress", this.getTargetBeakAnimProgress());
        compound.method_10548("TargetStraightProgress", this.getTargetStraightProgress());
        compound.method_10556("IsAttacking", this.isAttacking());
        compound.method_10569("StuckTicks", this.getStuckTicks());
        compound.method_10548("BeakAnimProgress", this.beakAnimProgress);
        if (this.lastAttackCommander != null) {
            compound.method_25927("LastAttackCommander", this.lastAttackCommander);
        }
        compound.method_10556("AttackHasCommander", this.attackHasCommander);
        compound.method_10556("CommanderWasPlayer", this.commanderWasPlayer);
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setBeakCooldown(compound.method_10550("BeakCooldown"));
        this.setTargetBeakAnimProgress(compound.method_10583("TargetBeakAnimProgress"));
        this.setTargetStraightProgress(compound.method_10583("TargetStraightProgress"));
        this.setAttacking(compound.method_10577("IsAttacking"));
        this.setStuckTicks(compound.method_10550("StuckTicks"));
        this.beakAnimProgress = compound.method_10583("BeakAnimProgress");
        if (compound.method_10545("LastAttackCommander")) {
            this.lastAttackCommander = compound.method_25926("LastAttackCommander");
        }
        this.attackHasCommander = compound.method_10577("AttackHasCommander");
        this.commanderWasPlayer = compound.method_10577("CommanderWasPlayer");
    }
}

