/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.biome;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.frozenblock.lib.worldgen.biome.api.FrozenBiome;
import net.frozenblock.lib.worldgen.biome.api.parameters.OverworldBiomeBuilderParameters;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.mod_compat.WWModIntegrations;
import net.frozenblock.wilderwild.worldgen.WWSharedWorldgen;
import net.frozenblock.wilderwild.worldgen.features.placed.WWMiscPlaced;
import net.frozenblock.wilderwild.worldgen.features.placed.WWPlacedFeatures;
import net.minecraft.class_1143;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3864;
import net.minecraft.class_4761;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5478;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AridForest
extends FrozenBiome {
    public static final class_6544.class_6546 TEMPERATURE = class_6544.class_6546.method_38121((float)0.53f, (float)0.57f);
    public static final class_6544.class_6546 HUMIDITY = class_6544.class_6546.method_38121((float)-0.095f, (float)0.15f);
    public static final class_6544.class_6546 HUMIDITY_MODIFIED_JUNGLE = class_6544.class_6546.method_38121((float)-0.095f, (float)0.1f);
    public static final float TEMP = 1.75f;
    public static final float DOWNFALL = 0.05f;
    public static final int WATER_COLOR = 4159204;
    public static final int WATER_FOG_COLOR = 329011;
    public static final int FOG_COLOR = 12638463;
    public static final int SKY_COLOR = class_5478.method_30932((float)1.75f);
    public static final AridForest INSTANCE = new AridForest();

    public String modID() {
        return "wilderwild";
    }

    public String biomeID() {
        return "arid_forest";
    }

    public float temperature() {
        return 1.75f;
    }

    public float downfall() {
        return 0.05f;
    }

    public boolean hasPrecipitation() {
        return false;
    }

    public int skyColor() {
        return SKY_COLOR;
    }

    public int fogColor() {
        return 12638463;
    }

    public int waterColor() {
        return 4159204;
    }

    public int waterFogColor() {
        return 329011;
    }

    @Nullable
    public Integer foliageColorOverride() {
        return null;
    }

    @Nullable
    public Integer grassColorOverride() {
        return null;
    }

    @Nullable
    public class_4761 ambientParticleSettings() {
        return null;
    }

    @Nullable
    public class_6880<class_3414> ambientLoopSound() {
        return null;
    }

    @Nullable
    public class_4968 ambientMoodSettings() {
        return class_4968.field_23146;
    }

    @Nullable
    public class_4967 ambientAdditionsSound() {
        return null;
    }

    @Nullable
    public class_5195 backgroundMusic() {
        return class_1143.method_27283((class_6880)class_3417.field_44693);
    }

    public void addFeatures(@NotNull class_5485.class_5495 features) {
        features.method_30992(class_2893.class_2895.field_13178, WWPlacedFeatures.ARID_FOREST_TREES.getKey());
        WWSharedWorldgen.addBasicFeatures(features, false);
        class_3864.method_16966((class_5485.class_5495)features);
        class_3864.method_38568((class_5485.class_5495)features);
        class_3864.method_17010((class_5485.class_5495)features);
        class_3864.method_16978((class_5485.class_5495)features);
        class_3864.method_16968((class_5485.class_5495)features);
        class_3864.method_16982((class_5485.class_5495)features);
        class_3864.method_16984((class_5485.class_5495)features);
        features.method_30992(class_2893.class_2895.field_13178, WWPlacedFeatures.ARID_CACTUS_PLACED.getKey());
        features.method_30992(class_2893.class_2895.field_13176, WWMiscPlaced.GRASS_PATH_RARE.getKey());
    }

    public void addSpawns(class_5483.class_5496 spawns) {
        class_3864.method_30583((class_5483.class_5496)spawns);
    }

    public void injectToOverworld(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6554.class_10317 modifier) {
        if (WWModIntegrations.BIOLITH_INTEGRATION.modLoaded()) {
            return;
        }
        if (WWWorldgenConfig.get().biomeGeneration.generateAridForest) {
            class_6544.class_6546 humidity = WWWorldgenConfig.get().biomePlacement.modifyJunglePlacement ? HUMIDITY_MODIFIED_JUNGLE : HUMIDITY;
            for (class_6544.class_4762 point : OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9424)) {
                this.addSurfaceBiome(parameters, TEMPERATURE, humidity, point.comp_107(), point.comp_108(), point.comp_110(), point.comp_111());
            }
        }
    }
}

