/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import net.frozenblock.wilderwild.worldgen.impl.feature.config.IcicleClusterConfig;
import net.frozenblock.wilderwild.worldgen.impl.util.IcicleUtils;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5861;
import org.jetbrains.annotations.NotNull;

public class IcicleClusterFeature
extends class_3031<IcicleClusterConfig> {
    public IcicleClusterFeature(@NotNull Codec<IcicleClusterConfig> codec) {
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<IcicleClusterConfig> context) {
        class_5281 worldGenLevel = context.method_33652();
        class_2338 blockPos = context.method_33655();
        IcicleClusterConfig config = (IcicleClusterConfig)context.method_33656();
        class_5819 randomSource = context.method_33654();
        if (!IcicleUtils.isEmptyOrWater((class_1936)worldGenLevel, blockPos)) {
            return false;
        }
        int height = config.height.method_35008(randomSource);
        float g = config.density.method_33920(randomSource);
        int j = config.radius.method_35008(randomSource);
        int k = config.radius.method_35008(randomSource);
        for (int l = -j; l <= j; ++l) {
            for (int m = -k; m <= k; ++m) {
                double icicleChance = this.getChanceOfIcicle(j, k, l, m, config);
                class_2338 blockPos2 = blockPos.method_10069(l, 0, m);
                this.placeColumn(worldGenLevel, randomSource, blockPos2, l, m, icicleChance, height, g, config);
            }
        }
        return true;
    }

    private void placeColumn(class_5281 worldGenLevel, class_5819 randomSource, class_2338 blockPos, int i, int j, double icicleChance, int height, float g, @NotNull IcicleClusterConfig icicleClusterConfig) {
        Optional optional = class_5721.method_32982((class_3746)worldGenLevel, (class_2338)blockPos, (int)icicleClusterConfig.floorToCeilingSearchRange, class_5726::method_33014, class_5726::method_40074);
        if (optional.isPresent()) {
            OptionalInt optionalInt = ((class_5721)optional.get()).method_32985();
            OptionalInt optionalInt2 = ((class_5721)optional.get()).method_32987();
            if (optionalInt.isPresent() || optionalInt2.isPresent()) {
                boolean bl4;
                int w;
                int p;
                int o;
                boolean canPlaceIcicleA;
                class_5721 column = (class_5721)optional.get();
                OptionalInt optionalInt3 = column.method_32987();
                boolean bl = canPlaceIcicleA = randomSource.method_43058() < icicleChance;
                if (optionalInt.isPresent() && canPlaceIcicleA && !this.isLava((class_4538)worldGenLevel, blockPos.method_33096(optionalInt.getAsInt()))) {
                    int m = icicleClusterConfig.iceLayerThickness.method_35008(randomSource);
                    this.replaceBlocksWithIceBlocks(worldGenLevel, blockPos.method_33096(optionalInt.getAsInt()), m, class_2350.field_11036);
                    int n = optionalInt3.isPresent() ? Math.min(height, optionalInt.getAsInt() - optionalInt3.getAsInt()) : height;
                    o = this.getIcicleHeight(randomSource, i, j, g, n, icicleClusterConfig);
                } else {
                    o = 0;
                }
                if (optionalInt.isPresent() && optionalInt3.isPresent() && optionalInt.getAsInt() - o <= optionalInt3.getAsInt()) {
                    int q = optionalInt3.getAsInt();
                    int r = optionalInt.getAsInt();
                    int s = Math.max(r - o, q + 1);
                    int t = Math.min(q, r - 1);
                    int u = class_3532.method_32751((class_5819)randomSource, (int)s, (int)(t + 1));
                    int v = u - 1;
                    p = r - u;
                    w = v - q;
                } else {
                    p = o;
                    w = 0;
                }
                boolean bl2 = bl4 = randomSource.method_43056() && p > 0 && w > 0 && column.method_33385().isPresent() && p + w == column.method_33385().getAsInt();
                if (optionalInt.isPresent()) {
                    IcicleUtils.growIcicle((class_1936)worldGenLevel, blockPos.method_33096(optionalInt.getAsInt() - 1), class_2350.field_11033, p, bl4);
                }
                if (optionalInt3.isPresent()) {
                    IcicleUtils.growIcicle((class_1936)worldGenLevel, blockPos.method_33096(optionalInt3.getAsInt() + 1), class_2350.field_11036, w, bl4);
                }
            }
        }
    }

    private boolean isLava(@NotNull class_4538 levelReader, class_2338 blockPos) {
        return levelReader.method_8320(blockPos).method_27852(class_2246.field_10164);
    }

    private int getIcicleHeight(@NotNull class_5819 randomSource, int i, int j, float f, int k, IcicleClusterConfig icicleClusterConfig) {
        if (randomSource.method_43057() > f) {
            return 0;
        }
        int l = Math.abs(i) + Math.abs(j);
        float g = class_3532.method_37958((float)l, (float)0.0f, (float)icicleClusterConfig.maxDistanceFromCenterAffectingHeightBias, (float)((float)k / 2.0f), (float)0.0f);
        return (int)IcicleClusterFeature.randomBetweenBiased(randomSource, 0.0f, k, g, icicleClusterConfig.heightDeviation);
    }

    private void replaceBlocksWithIceBlocks(class_5281 worldGenLevel, @NotNull class_2338 blockPos, int i, class_2350 direction) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (int j = 0; j < i; ++j) {
            if (!IcicleUtils.placeIceBlockIfPossible((class_1936)worldGenLevel, (class_2338)mutableBlockPos)) {
                return;
            }
            mutableBlockPos.method_10098(direction);
        }
    }

    private double getChanceOfIcicle(int i, int j, int k, int l, @NotNull IcicleClusterConfig icicleClusterConfig) {
        return class_3532.method_37958((float)Math.min(i - Math.abs(k), j - Math.abs(l)), (float)0.0f, (float)icicleClusterConfig.maxDistanceFromEdgeAffectingChanceOfIcicle, (float)icicleClusterConfig.chanceOfIcicleAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float randomBetweenBiased(class_5819 randomSource, float f, float g, float h, float i) {
        return class_5861.method_33903((class_5819)randomSource, (float)h, (float)i, (float)f, (float)g);
    }
}

