/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3486;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FallenLargeTrunkPlacer
extends class_5141 {
    public static final MapCodec<FallenLargeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> FallenLargeTrunkPlacer.fallenTrunkCodec(instance).apply((Applicative)instance, FallenLargeTrunkPlacer::new));
    public final float successInWaterChance;
    public final int minHeight;
    public final int maxHeight;

    public FallenLargeTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, float successInWaterChance) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.minHeight = baseHeight;
        this.maxHeight = baseHeight + firstRandomHeight + secondRandomHeight;
        this.successInWaterChance = successInWaterChance;
    }

    @Contract(value="_ -> new")
    protected static <P extends FallenLargeTrunkPlacer> // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Products.P4<// Could not load outer class - annotation placement on inner may be incorrect
    RecordCodecBuilder.Mu<P>, Integer, Integer, Integer, Float> fallenTrunkCodec(RecordCodecBuilder.Instance<P> builder) {
        return FallenLargeTrunkPlacer.method_28904(builder).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("success_in_water_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.successInWaterChance)));
    }

    private static boolean isWaterAt(@NotNull class_3746 level, @NotNull class_2338 blockpos) {
        return level.method_35237(blockpos, fluidState -> fluidState.method_15767(class_3486.field_15517));
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return WWFeatures.FALLEN_LARGE_TRUNK_PLACER;
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, int height, @NotNull class_2338 startPos, @NotNull class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2350 logDir = class_2350.class_2353.field_11062.method_10183(random);
        if (FallenLargeTrunkPlacer.isWaterAt(level, startPos) && random.method_43057() > this.successInWaterChance) {
            return list;
        }
        List<class_2338> poses = this.getAllSectionPoses(level, startPos, random, logDir);
        for (class_2338 blockPos : poses) {
            this.method_27402(level, replacer, random, blockPos, config, state -> (class_2680)state.method_47968((class_2769)class_2465.field_11459, (Comparable)logDir.method_10166()));
        }
        return list;
    }

    @NotNull
    private List<class_2338> getAllSectionPoses(@NotNull class_3746 level, class_2338 startPos, class_5819 random, class_2350 logDir) {
        ArrayList poses = Lists.newArrayList();
        List<class_2338> firstPoses = this.getSectionPoses(true, level, startPos, random.method_39332(this.minHeight, this.maxHeight), logDir);
        if (!firstPoses.isEmpty()) {
            class_2350.class_2351 axis = logDir.method_10166();
            if (axis == class_2350.class_2351.field_11048) {
                axis = class_2350.class_2351.field_11051;
            } else if (axis == class_2350.class_2351.field_11051) {
                axis = class_2350.class_2351.field_11048;
            }
            class_2350 secondOffset = AdvancedMath.randomDir((class_2350.class_2351)axis);
            List<class_2338> secondPoses = this.getSectionPoses(true, level, startPos.method_10093(secondOffset), random.method_39332(this.minHeight, this.maxHeight), logDir);
            if (!secondPoses.isEmpty()) {
                List<class_2338> thirdPoses = this.getSectionPoses(false, level, startPos.method_10093(class_2350.field_11036), random.method_39332(this.minHeight, this.maxHeight), logDir);
                List<class_2338> fourthPoses = this.getSectionPoses(false, level, startPos.method_10093(class_2350.field_11036).method_10093(secondOffset), random.method_39332(this.minHeight, this.maxHeight), logDir);
                poses.addAll(firstPoses);
                poses.addAll(secondPoses);
                poses.addAll(thirdPoses);
                poses.addAll(fourthPoses);
            }
        }
        return poses;
    }

    @NotNull
    private List<class_2338> getSectionPoses(boolean requiresUnderneath, @NotNull class_3746 level, @NotNull class_2338 startPos, int height, @NotNull class_2350 logDir) {
        ArrayList finalizedPoses = Lists.newArrayList();
        class_2338 endPos = startPos.method_10079(logDir, height);
        class_2338 secondToEndPos = endPos.method_10093(logDir.method_10153());
        int aboveSolidAmount = 0;
        boolean isEndAboveSolid = false;
        Iterable poses = class_2338.method_10097((class_2338)startPos, (class_2338)endPos);
        if (!requiresUnderneath) {
            poses.forEach(pos -> finalizedPoses.add(pos.method_10062()));
            return finalizedPoses;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 blockPos : poses) {
            mutable.method_10101((class_2382)blockPos);
            if (class_2944.method_27371((class_3746)level, (class_2338)mutable)) {
                if (!class_2944.method_27371((class_3746)level, (class_2338)mutable.method_10098(class_2350.field_11033)) && !class_2944.method_16420((class_3746)level, (class_2338)mutable)) {
                    ++aboveSolidAmount;
                    mutable.method_10098(class_2350.field_11036);
                    if (!mutable.equals((Object)endPos) && !mutable.equals((Object)secondToEndPos)) continue;
                    isEndAboveSolid = true;
                    continue;
                }
                mutable.method_10098(class_2350.field_11036);
                if (!mutable.equals((Object)startPos)) continue;
                return List.of();
            }
            return List.of();
        }
        if (isEndAboveSolid || (double)aboveSolidAmount / (double)height > 0.5) {
            poses.forEach(pos -> finalizedPoses.add(pos.method_10062()));
            return finalizedPoses;
        }
        return List.of();
    }
}

