/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.lib.item.api.ItemBlockStateTagUtils;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EchoGlassBlock
extends class_8923 {
    public static final int MIN_CRACK_PARTICLES = 18;
    public static final int MAX_DAMAGE_PARTICLES = 25;
    public static final class_2758 DAMAGE = WWBlockStateProperties.DAMAGE;
    public static final MapCodec<EchoGlassBlock> CODEC = EchoGlassBlock.method_54094(EchoGlassBlock::new);

    public EchoGlassBlock(@NotNull class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)DAMAGE, (Comparable)Integer.valueOf(0)));
    }

    public static boolean canDamage(@NotNull class_2680 state) {
        return state.method_28498((class_2769)DAMAGE) && (Integer)state.method_11654((class_2769)DAMAGE) < 3;
    }

    public static void setDamagedState(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 blockState) {
        level.method_8501(pos, (class_2680)blockState.method_28493((class_2769)DAMAGE));
    }

    public static void damage(@NotNull class_1937 level, @NotNull class_2338 pos, class_2680 blockState, boolean shouldDrop) {
        if (!EchoGlassBlock.canDamage(blockState)) {
            level.method_22352(pos, shouldDrop);
            return;
        }
        EchoGlassBlock.setDamagedState(level, pos, blockState);
        level.method_8396(null, pos, WWSounds.BLOCK_ECHO_GLASS_CRACK, class_3419.field_15245, 0.5f, 0.9f + level.field_9229.method_43057() * 0.2f);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_65096((class_2394)new class_2388(class_2398.field_11217, blockState), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, level.field_9229.method_43051(18, 25), (double)0.3f, (double)0.3f, (double)0.3f, 0.05);
        }
    }

    public static void heal(@NotNull class_1937 level, @NotNull class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (!state.method_28498((class_2769)DAMAGE)) {
            return;
        }
        int damage = (Integer)state.method_11654((class_2769)DAMAGE);
        if (damage > 0) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)DAMAGE, (Comparable)Integer.valueOf(damage - 1)));
            level.method_8396(null, pos, WWSounds.BLOCK_ECHO_GLASS_REPAIR, class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.1f + 0.9f);
        }
    }

    public static int getLightLevel(@NotNull class_1937 level, @NotNull class_2338 blockPos) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        int finalLight = 0;
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_25505((class_2382)blockPos, direction);
            int newLight = !level.method_8419() ? level.method_22339((class_2338)mutableBlockPos) : level.method_8314(class_1944.field_9282, (class_2338)mutableBlockPos);
            finalLight = Math.max(finalLight, newLight);
        }
        return finalLight;
    }

    @NotNull
    public MapCodec<? extends EchoGlassBlock> method_53969() {
        return CODEC;
    }

    protected boolean method_9579(class_2680 blockState) {
        return false;
    }

    public int method_9505(class_2680 state) {
        return 15;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DAMAGE});
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (EchoGlassBlock.getLightLevel((class_1937)level, pos) <= 8) {
            if (random.method_43056()) {
                EchoGlassBlock.heal((class_1937)level, pos);
            }
        } else if (random.method_43057() <= 0.75f) {
            EchoGlassBlock.damage((class_1937)level, pos, state, true);
        }
    }

    public void method_9556(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_2586 blockEntity, @NotNull class_1799 stack) {
        class_6880.class_6883 silkTouch = level.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9099);
        if (EchoGlassBlock.canDamage(state) && class_1890.method_8225((class_6880)silkTouch, (class_1799)player.method_6047()) < 1 && !player.method_7337()) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)DAMAGE, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)DAMAGE) + 1)));
            player.method_7322(0.005f);
        } else {
            super.method_9556(level, player, pos, state, blockEntity, stack);
            level.method_8396(null, pos, class_3417.field_15081, class_3419.field_15245, 0.9f, level.field_9229.method_43057() * 0.1f + 0.8f);
        }
    }

    public void method_19286(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_3965 hit, @NotNull class_1676 projectile) {
        super.method_19286(level, state, hit, projectile);
        EchoGlassBlock.damage(level, hit.method_17777(), state, true);
    }

    protected class_1799 method_9574(class_4538 levelReader, class_2338 blockPos, class_2680 blockState, boolean bl) {
        class_1799 superStack = super.method_9574(levelReader, blockPos, blockState, bl);
        int damage = (Integer)blockState.method_11654((class_2769)WWBlockStateProperties.DAMAGE);
        if (damage != 0) {
            ItemBlockStateTagUtils.setProperty((class_1799)superStack, (class_2769)WWBlockStateProperties.DAMAGE, (Comparable)Integer.valueOf(damage));
        }
        return superStack;
    }
}

