/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.frozenblock.lib.particle.client.options.WindParticleOptions;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.wilderwild.block.impl.FallingLeafUtil;
import net.frozenblock.wilderwild.particle.options.WWFallingLeavesParticleOptions;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2577;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class LeafLitterBlock
extends class_2577 {
    public static final MapCodec<LeafLitterBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("leaves_block").forGetter(litterBlock -> litterBlock.leavesBlock), (App)LeafLitterBlock.method_54096()).apply((Applicative)instance, LeafLitterBlock::new));
    public static final class_2746 PERSISTENT = class_2741.field_12514;
    private final class_2248 leavesBlock;

    public LeafLitterBlock(class_2248 leavesBlock, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(false)));
        this.leavesBlock = leavesBlock;
    }

    @NotNull
    public MapCodec<? extends LeafLitterBlock> method_53969() {
        return CODEC;
    }

    protected boolean method_9542(@NotNull class_2680 state) {
        return this.decaying(state);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.decaying(state) && random.method_43048(55) == 0) {
            LeafLitterBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
            world.method_8650(pos, false);
            this.spawnWindParticle((class_1937)world, pos);
        }
    }

    protected boolean decaying(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)PERSISTENT) == false;
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        this.spawnLeafParticles(world, pos, null, true);
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        this.spawnLeafParticles(world, pos, entity, false);
    }

    public void spawnWindParticle(class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_243 windMovement = WindManager.getWindManager((class_3218)serverLevel).getWindMovement(pos).method_1029().method_1021(0.1);
            serverLevel.method_65096((class_2394)new WindParticleOptions(5, windMovement), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.05);
        }
    }

    public void spawnLeafParticles(class_1937 level, class_2338 pos, class_1297 entity, boolean destroy) {
        if (level instanceof class_3218) {
            Optional<class_2396<WWFallingLeavesParticleOptions>> optionalParticle;
            int count;
            class_3218 serverLevel = (class_3218)level;
            float chance = destroy ? 1.0f : 0.005f;
            int n = count = destroy ? 4 : 1;
            if (!destroy && entity != null) {
                chance = (float)(entity.method_18798().method_1033() * 0.35);
            }
            if (serverLevel.field_9229.method_43057() <= chance && (optionalParticle = LeafLitterParticleRegistry.getParticleForCarpet(this)).isPresent()) {
                class_2396<WWFallingLeavesParticleOptions> particleType = optionalParticle.get();
                FallingLeafUtil.LeafParticleData particleData = FallingLeafUtil.getLeafParticleData(particleType);
                WWFallingLeavesParticleOptions particleOptions = WWFallingLeavesParticleOptions.create(particleType, particleData.textureSize(), particleData.particleGravityScale(), particleData.windScale(), particleData.swirl());
                serverLevel.method_65096((class_2394)particleOptions, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, count, 0.3, 0.0, 0.3, 0.05);
            }
        }
    }

    public boolean method_9558(class_2680 state, @NotNull class_4538 world, @NotNull class_2338 pos) {
        class_2680 belowState = world.method_8320(pos.method_10074());
        if (belowState.method_26164(WWBlockTags.LEAF_LITTER_CANNOT_SURVIVE_ON)) {
            return false;
        }
        return belowState.method_26164(WWBlockTags.LEAF_LITTER_CAN_SURVIVE_ON) || class_2248.method_9501((class_265)belowState.method_26220((class_1922)world, pos.method_10074()), (class_2350)class_2350.field_11036);
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PERSISTENT});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(true));
    }

    public class_2248 getLeavesBlock() {
        return this.leavesBlock;
    }

    public static class LeafLitterParticleRegistry {
        private static final Map<LeafLitterBlock, class_2396<WWFallingLeavesParticleOptions>> LEAF_PARTICLE_MAP = new LinkedHashMap<LeafLitterBlock, class_2396<WWFallingLeavesParticleOptions>>();

        public static class_2396<WWFallingLeavesParticleOptions> registerLeafParticle(@NotNull LeafLitterBlock leafCarpet, @NotNull class_2396<WWFallingLeavesParticleOptions> particleOptions) {
            LEAF_PARTICLE_MAP.put(leafCarpet, particleOptions);
            return particleOptions;
        }

        public static Optional<class_2396<WWFallingLeavesParticleOptions>> getParticleForCarpet(@NotNull LeafLitterBlock leafCarpet) {
            return Optional.ofNullable(LEAF_PARTICLE_MAP.getOrDefault((Object)leafCarpet, null));
        }
    }
}

