/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.renderer.blockentity;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.block.StoneChestBlock;
import net.frozenblock.wilderwild.block.entity.StoneChestBlockEntity;
import net.frozenblock.wilderwild.client.WWModelLayers;
import net.frozenblock.wilderwild.client.model.StoneChestModel;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_4739;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class StoneChestRenderer<T extends StoneChestBlockEntity>
implements class_827<T> {
    public static final class_4730 STONE = StoneChestRenderer.getStoneChestTextureId("stone");
    public static final class_4730 STONE_LEFT = StoneChestRenderer.getStoneChestTextureId("stone_left");
    public static final class_4730 STONE_RIGHT = StoneChestRenderer.getStoneChestTextureId("stone_right");
    public static final class_4730 STONE_SCULK = StoneChestRenderer.getStoneChestTextureId("ancient");
    public static final class_4730 STONE_LEFT_SCULK = StoneChestRenderer.getStoneChestTextureId("ancient_left");
    public static final class_4730 STONE_RIGHT_SCULK = StoneChestRenderer.getStoneChestTextureId("ancient_right");
    private final StoneChestModel singleModel;
    private final StoneChestModel doubleLeftModel;
    private final StoneChestModel doubleRightModel;

    public StoneChestRenderer(@NotNull class_5614.class_5615 context) {
        this.singleModel = new StoneChestModel(context.method_32140(WWModelLayers.STONE_CHEST));
        this.doubleLeftModel = new StoneChestModel(context.method_32140(WWModelLayers.DOUBLE_STONE_CHEST_LEFT));
        this.doubleRightModel = new StoneChestModel(context.method_32140(WWModelLayers.DOUBLE_STONE_CHEST_RIGHT));
    }

    @NotNull
    public static class_4730 getStoneChestTexture(@NotNull class_2745 type, boolean sculk) {
        return !sculk ? StoneChestRenderer.getStoneChestTexture(type, STONE, STONE_LEFT, STONE_RIGHT) : StoneChestRenderer.getStoneChestTexture(type, STONE_SCULK, STONE_LEFT_SCULK, STONE_RIGHT_SCULK);
    }

    @NotNull
    private static class_4730 getStoneChestTexture(@NotNull class_2745 type, @NotNull class_4730 single, @NotNull class_4730 left, @NotNull class_4730 right) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case class_2745.field_12574 -> left;
            case class_2745.field_12571 -> right;
            case class_2745.field_12569 -> single;
        };
    }

    @NotNull
    public static class_4730 getStoneChestTextureId(@NotNull String variant) {
        return new class_4730(class_4722.field_21709, WWConstants.id("entity/stone_chest/" + variant));
    }

    public void render(@NotNull T entity, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int light, int overlay) {
        class_1937 level = entity.method_10997();
        boolean bl = level != null;
        class_2680 blockState = bl ? entity.method_11010() : (class_2680)WWBlocks.STONE_CHEST.method_9564().method_11657((class_2769)StoneChestBlock.field_10768, (Comparable)class_2350.field_11035);
        class_2745 chestType = blockState.method_28498((class_2769)StoneChestBlock.field_10770) ? (class_2745)blockState.method_11654((class_2769)StoneChestBlock.field_10770) : class_2745.field_12569;
        class_2248 block = blockState.method_26204();
        if (block instanceof class_4739) {
            class_4739 abstractStoneChestBlock = (class_4739)block;
            boolean isDouble = chestType != class_2745.field_12569;
            poseStack.method_22903();
            float chestRotation = ((class_2350)blockState.method_11654((class_2769)StoneChestBlock.field_10768)).method_10144();
            poseStack.method_46416(0.5f, 0.5f, 0.5f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-chestRotation));
            poseStack.method_46416(-0.5f, -0.5f, -0.5f);
            class_4732.class_4734 propertySource = bl ? abstractStoneChestBlock.method_24167(blockState, level, entity.method_11016(), true) : class_4732.class_3923::method_24174;
            float openProg = ((StoneChestBlockEntity)((Object)entity)).getOpenProgress(partialTick);
            openProg = 1.0f - openProg;
            openProg = 1.0f - openProg * openProg * openProg;
            int i = ((Int2IntFunction)propertySource.apply((class_4732.class_3923)new class_4737())).applyAsInt(light);
            class_4730 spriteIdentifier = StoneChestRenderer.getStoneChestTexture(chestType, (Boolean)entity.method_11010().method_11654((class_2769)WWBlockStateProperties.HAS_SCULK));
            class_4588 vertexConsumer = spriteIdentifier.method_24145(buffer, class_1921::method_23576);
            if (isDouble) {
                if (chestType == class_2745.field_12574) {
                    this.render(poseStack, vertexConsumer, this.doubleLeftModel, openProg, i, overlay);
                } else {
                    this.render(poseStack, vertexConsumer, this.doubleRightModel, openProg, i, overlay);
                }
            } else {
                this.render(poseStack, vertexConsumer, this.singleModel, openProg, i, overlay);
            }
            poseStack.method_22909();
        }
    }

    private void render(@NotNull class_4587 poseStack, @NotNull class_4588 vertices, @NotNull StoneChestModel stoneChestModel, float liftProgress, int light, int overlay) {
        stoneChestModel.setupAnim(liftProgress);
        stoneChestModel.method_60879(poseStack, vertices, light, overlay);
    }
}

