/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.renderer.blockentity;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.block.StoneChestBlock;
import net.frozenblock.wilderwild.block.entity.StoneChestBlockEntity;
import net.frozenblock.wilderwild.client.WWModelLayers;
import net.frozenblock.wilderwild.client.model.StoneChestModel;
import net.frozenblock.wilderwild.client.renderer.blockentity.state.StoneChestRenderState;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class StoneChestRenderer<T extends StoneChestBlockEntity>
implements class_827<T, StoneChestRenderState> {
    public static final class_4730 STONE = StoneChestRenderer.getStoneChestTextureId("stone");
    public static final class_4730 STONE_LEFT = StoneChestRenderer.getStoneChestTextureId("stone_left");
    public static final class_4730 STONE_RIGHT = StoneChestRenderer.getStoneChestTextureId("stone_right");
    public static final class_4730 STONE_SCULK = StoneChestRenderer.getStoneChestTextureId("ancient");
    public static final class_4730 STONE_LEFT_SCULK = StoneChestRenderer.getStoneChestTextureId("ancient_left");
    public static final class_4730 STONE_RIGHT_SCULK = StoneChestRenderer.getStoneChestTextureId("ancient_right");
    private final class_11701 materials;
    private final StoneChestModel singleModel;
    private final StoneChestModel doubleLeftModel;
    private final StoneChestModel doubleRightModel;

    public StoneChestRenderer(@NotNull class_5614.class_5615 context) {
        this.materials = context.comp_4541();
        this.singleModel = new StoneChestModel(context.method_32140(WWModelLayers.STONE_CHEST));
        this.doubleLeftModel = new StoneChestModel(context.method_32140(WWModelLayers.DOUBLE_STONE_CHEST_LEFT));
        this.doubleRightModel = new StoneChestModel(context.method_32140(WWModelLayers.DOUBLE_STONE_CHEST_RIGHT));
    }

    @NotNull
    public static class_4730 getStoneChestTexture(boolean sculk, @NotNull class_2745 type) {
        return !sculk ? StoneChestRenderer.getStoneChestTexture(type, STONE, STONE_LEFT, STONE_RIGHT) : StoneChestRenderer.getStoneChestTexture(type, STONE_SCULK, STONE_LEFT_SCULK, STONE_RIGHT_SCULK);
    }

    @NotNull
    private static class_4730 getStoneChestTexture(@NotNull class_2745 type, @NotNull class_4730 single, @NotNull class_4730 left, @NotNull class_4730 right) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case class_2745.field_12574 -> left;
            case class_2745.field_12571 -> right;
            case class_2745.field_12569 -> single;
        };
    }

    @NotNull
    public static class_4730 getStoneChestTextureId(@NotNull String variant) {
        return new class_4730(class_4722.field_21709, WWConstants.id("entity/stone_chest/" + variant));
    }

    public void submit(@NotNull StoneChestRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderState.angle));
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        float openProgress = renderState.open;
        openProgress = 1.0f - openProgress;
        openProgress = 1.0f - openProgress * openProgress * openProgress;
        class_4730 material = StoneChestRenderer.getStoneChestTexture(renderState.hasSculk, renderState.type);
        class_1921 renderType = material.method_24146(class_1921::method_23576);
        class_1058 sprite = this.materials.method_73030(material);
        if (renderState.type != class_2745.field_12569) {
            submitNodeCollector.method_73490((class_3879)(renderState.type == class_2745.field_12574 ? this.doubleLeftModel : this.doubleRightModel), (Object)Float.valueOf(openProgress), poseStack, renderType, renderState.field_62676, class_4608.field_21444, -1, sprite, 0, renderState.field_62677);
        } else {
            submitNodeCollector.method_73490((class_3879)this.singleModel, (Object)Float.valueOf(openProgress), poseStack, renderType, renderState.field_62676, class_4608.field_21444, -1, sprite, 0, renderState.field_62677);
        }
        poseStack.method_22909();
    }

    @NotNull
    public StoneChestRenderState createRenderState() {
        return new StoneChestRenderState();
    }

    public void extractRenderState(@NotNull T stoneChest, @NotNull StoneChestRenderState renderState, float partialTicks, @NotNull class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_4732.class_4734 neighborCombineResult;
        class_2248 class_22482;
        super.method_74331(stoneChest, (class_11954)renderState, partialTicks, cameraPos, crumblingOverlay);
        boolean levelExists = stoneChest.method_10997() != null;
        class_2680 blockState = levelExists ? stoneChest.method_11010() : (class_2680)WWBlocks.STONE_CHEST.method_9564().method_11657((class_2769)StoneChestBlock.field_10768, (Comparable)class_2350.field_11035);
        renderState.type = blockState.method_28498((class_2769)StoneChestBlock.field_10770) ? (class_2745)blockState.method_11654((class_2769)StoneChestBlock.field_10770) : class_2745.field_12569;
        renderState.angle = ((class_2350)blockState.method_11654((class_2769)StoneChestBlock.field_10768)).method_10144();
        renderState.hasSculk = blockState.method_28500((class_2769)WWBlockStateProperties.HAS_SCULK).orElse(false);
        if (levelExists && (class_22482 = blockState.method_26204()) instanceof class_2281) {
            class_2281 chestBlock = (class_2281)class_22482;
            neighborCombineResult = chestBlock.method_24167(blockState, stoneChest.method_10997(), stoneChest.method_11016(), true);
        } else {
            neighborCombineResult = class_4732.class_3923::method_24174;
        }
        renderState.open = ((Float2FloatFunction)neighborCombineResult.apply(StoneChestBlock.method_24166(stoneChest))).get(partialTicks);
        if (renderState.type != class_2745.field_12569) {
            renderState.field_62676 = ((Int2IntFunction)neighborCombineResult.apply((class_4732.class_3923)new class_4737())).applyAsInt(renderState.field_62676);
        }
    }
}

