/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.frozenblock.lib.block.api.dripstone.DripstoneDripApi;
import net.frozenblock.wilderwild.block.entity.ScorchedBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScorchedBlock
extends class_2237 {
    public static final float RAIN_HYDRATION_CHANCE = 0.75f;
    public static final Map<class_2680, class_2680> SCORCH_MAP = new Object2ObjectOpenHashMap();
    public static final Map<class_2680, class_2680> HYDRATE_MAP = new Object2ObjectOpenHashMap();
    public static final MapCodec<ScorchedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2680.field_24734.fieldOf("previous_state").forGetter(scorchedBlock -> scorchedBlock.wetState), (App)Codec.BOOL.fieldOf("brushable").forGetter(scorchedBlock -> scorchedBlock.canBrush), (App)class_3414.field_41698.fieldOf("brush_sound").forGetter(scorchedBlock -> scorchedBlock.brushSound), (App)class_3414.field_41698.fieldOf("brush_completed_sound").forGetter(scorchedBlock -> scorchedBlock.brushCompletedSound), (App)ScorchedBlock.method_54096()).apply((Applicative)instance, ScorchedBlock::new));
    private static final class_2758 DUSTED = class_2741.field_42836;
    public final boolean canBrush;
    public final class_2680 wetState;
    public final class_3414 brushSound;
    public final class_3414 brushCompletedSound;

    public ScorchedBlock(@NotNull class_2680 wetState, boolean canBrush, @NotNull class_3414 brushSound, @NotNull class_3414 brushCompletedSound, @NotNull class_4970.class_2251 settings) {
        super(settings);
        this.canBrush = canBrush;
        this.brushSound = brushSound;
        this.brushCompletedSound = brushCompletedSound;
        this.wetState = wetState;
        this.fillScorchMap(this.wetState, this.method_9564());
    }

    public static boolean canScorch(@NotNull class_2680 state) {
        return SCORCH_MAP.containsKey(ScorchedBlock.stateWithoutDusting(state));
    }

    public static void scorch(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos) {
        if (!ScorchedBlock.canScorch(state = ScorchedBlock.stateWithoutDusting(state))) {
            return;
        }
        level.method_8501(pos, SCORCH_MAP.get(state));
        level.method_33596(null, (class_6880)class_5712.field_28733, pos);
    }

    public static boolean canHydrate(@NotNull class_2680 state) {
        return HYDRATE_MAP.containsKey(ScorchedBlock.stateWithoutDusting(state));
    }

    public static void hydrate(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos) {
        if (!ScorchedBlock.canHydrate(state = ScorchedBlock.stateWithoutDusting(state))) {
            return;
        }
        level.method_8501(pos, HYDRATE_MAP.get(state));
        level.method_33596(null, (class_6880)class_5712.field_28733, pos);
    }

    @NotNull
    private static class_2680 stateWithoutDusting(@NotNull class_2680 state) {
        return state.method_28498((class_2769)DUSTED) ? (class_2680)state.method_11657((class_2769)DUSTED, (Comparable)Integer.valueOf(0)) : state;
    }

    @NotNull
    protected MapCodec<? extends ScorchedBlock> method_53969() {
        return CODEC;
    }

    public void fillScorchMap(class_2680 wetState, class_2680 defaultState) {
        SCORCH_MAP.put(wetState, defaultState);
        HYDRATE_MAP.put(defaultState, wetState);
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DUSTED});
    }

    public void method_9504(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382 && level.method_8409().method_43057() < 0.75f) {
            ScorchedBlock.hydrate(state, level, pos);
        }
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        return new ScorchedBlockEntity(blockPos, blockState);
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (level.method_8316(pos.method_10084()).method_15767(class_3486.field_15517)) {
            ScorchedBlock.hydrate(state, (class_1937)level, pos);
        }
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        class_2586 class_25862;
        class_3611 fluid = DripstoneDripApi.getDripstoneFluid((class_3218)level, (class_2338)pos);
        if (fluid == class_3612.field_15908) {
            if (random.method_43056()) {
                ScorchedBlock.scorch(state, (class_1937)level, pos);
            }
        } else if (fluid == class_3612.field_15910) {
            ScorchedBlock.hydrate(state, (class_1937)level, pos);
        }
        if ((class_25862 = level.method_8321(pos)) instanceof ScorchedBlockEntity) {
            ScorchedBlockEntity scorchedBlock = (ScorchedBlockEntity)class_25862;
            scorchedBlock.checkReset();
        }
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11458;
    }
}

