/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.renderer.debug;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.debug.client.impl.DebugRenderManager;
import net.frozenblock.wilderwild.entity.Ostrich;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_761;
import net.minecraft.class_863;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class OstrichDebugRenderer
implements class_863.class_864 {
    private static final int NECK_LINE_COLOR = class_5253.class_5254.method_27764((int)255, (int)100, (int)255, (int)255);
    private final class_310 minecraft;
    private List<class_1297> surroundEntities = Collections.emptyList();

    public OstrichDebugRenderer(class_310 client) {
        this.minecraft = client;
    }

    public void tick() {
        this.surroundEntities = ImmutableList.copyOf((Iterable)this.minecraft.field_1687.method_18112());
    }

    public void method_20414() {
        this.surroundEntities = Collections.emptyList();
    }

    public void method_23109(class_4587 matrices, @NotNull class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        for (class_1297 entity : this.surroundEntities) {
            if (!(entity instanceof Ostrich)) continue;
            Ostrich ostrich = (Ostrich)entity;
            class_238 attackBox = ostrich.createAttackBox(DebugRenderManager.PARTIAL_TICK).method_989(-cameraX, -cameraY, -cameraZ);
            class_761.method_22982((class_4587)matrices, (class_4588)vertexConsumers.getBuffer(class_1921.method_23594()), (class_238)attackBox, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            List<class_243> debugPoses = ostrich.getDebugRenderingPoses(DebugRenderManager.PARTIAL_TICK);
            for (int i = 1; i < debugPoses.size(); ++i) {
                class_243 previous = debugPoses.get(i - 1);
                class_243 target = debugPoses.get(i);
                OstrichDebugRenderer.drawLine(matrices, vertexConsumers, cameraX, cameraY, cameraZ, previous, target, NECK_LINE_COLOR);
            }
            debugPoses.forEach(vec3 -> OstrichDebugRenderer.renderFilledBox(matrices, vertexConsumers, class_238.method_30048((class_243)vec3, (double)0.1, (double)0.1, (double)0.1), cameraX, cameraY, cameraZ));
        }
    }

    private static void renderFilledBox(class_4587 matrices, class_4597 vertexConsumers, @NotNull class_238 box, double cameraX, double cameraY, double cameraZ) {
        class_243 vec3 = new class_243(-cameraX, -cameraY, -cameraZ);
        class_863.method_23102((class_4587)matrices, (class_4597)vertexConsumers, (class_238)box.method_997(vec3), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawLine(@NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ, @NotNull class_243 start, @NotNull class_243 target, int color) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_49043((double)4.0));
        vertexConsumer.method_56824(matrices.method_23760(), (float)(start.field_1352 - cameraX), (float)(start.field_1351 - cameraY), (float)(start.field_1350 - cameraZ)).method_39415(color);
        vertexConsumer.method_56824(matrices.method_23760(), (float)(target.field_1352 - cameraX), (float)(target.field_1351 - cameraY), (float)(target.field_1350 - cameraZ)).method_39415(color);
    }
}

