/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datagen;

import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.frozenblock.lib.feature_flag.api.FeatureFlagApi;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.block.termite.TermiteBlockBehaviors;
import net.frozenblock.wilderwild.datagen.WWFeatureBootstrap;
import net.frozenblock.wilderwild.datagen.WWRegistryProvider;
import net.frozenblock.wilderwild.datagen.advancement.WWAdvancementProvider;
import net.frozenblock.wilderwild.datagen.loot.WWBlockLootProvider;
import net.frozenblock.wilderwild.datagen.loot.WWEntityLootProvider;
import net.frozenblock.wilderwild.datagen.model.WWModelProvider;
import net.frozenblock.wilderwild.datagen.recipe.WWRecipeProvider;
import net.frozenblock.wilderwild.datagen.tag.WWBiomeTagProvider;
import net.frozenblock.wilderwild.datagen.tag.WWBlockTagProvider;
import net.frozenblock.wilderwild.datagen.tag.WWDamageTypeTagProvider;
import net.frozenblock.wilderwild.datagen.tag.WWEntityTagProvider;
import net.frozenblock.wilderwild.datagen.tag.WWGameEventTagProvider;
import net.frozenblock.wilderwild.datagen.tag.WWInstrumentTagProvider;
import net.frozenblock.wilderwild.datagen.tag.WWItemTagProvider;
import net.frozenblock.wilderwild.entity.variant.butterfly.ButterflyVariants;
import net.frozenblock.wilderwild.entity.variant.crab.CrabVariants;
import net.frozenblock.wilderwild.entity.variant.firefly.FireflyColors;
import net.frozenblock.wilderwild.entity.variant.jellyfish.JellyfishVariants;
import net.frozenblock.wilderwild.entity.variant.moobloom.MoobloomVariants;
import net.frozenblock.wilderwild.registry.WWBiomes;
import net.frozenblock.wilderwild.registry.WWDamageTypes;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.frozenblock.wilderwild.worldgen.impl.noise.WWNoise;
import net.minecraft.class_7877;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public final class WWDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(@NotNull FabricDataGenerator dataGenerator) {
        FeatureFlagApi.rebuild();
        FabricDataGenerator.Pack pack = dataGenerator.createPack();
        pack.addProvider(WWModelProvider::new);
        pack.addProvider(WWRegistryProvider::new);
        pack.addProvider(WWBlockLootProvider::new);
        pack.addProvider(WWBiomeTagProvider::new);
        pack.addProvider(WWBlockTagProvider::new);
        pack.addProvider(WWDamageTypeTagProvider::new);
        pack.addProvider(WWItemTagProvider::new);
        pack.addProvider(WWInstrumentTagProvider::new);
        pack.addProvider(WWEntityTagProvider::new);
        pack.addProvider(WWGameEventTagProvider::new);
        pack.addProvider(WWEntityLootProvider::new);
        pack.addProvider(WWRecipeProvider::new);
        pack.addProvider(WWAdvancementProvider::new);
    }

    public void buildRegistry(@NotNull class_7877 registryBuilder) {
        WWConstants.logWithModId("Generating dynamic registries for", WWConstants.UNSTABLE_LOGGING);
        registryBuilder.method_46777(class_7924.field_42534, WWDamageTypes::bootstrap);
        registryBuilder.method_46777(class_7924.field_41239, WWFeatureBootstrap::bootstrapConfigured);
        registryBuilder.method_46777(class_7924.field_41245, WWFeatureBootstrap::bootstrapPlaced);
        registryBuilder.method_46777(class_7924.field_41236, WWBiomes::bootstrap);
        registryBuilder.method_46777(class_7924.field_41244, WWNoise::bootstrap);
        registryBuilder.method_46777(WilderWildRegistries.FIREFLY_COLOR, FireflyColors::bootstrap);
        registryBuilder.method_46777(WilderWildRegistries.BUTTERFLY_VARIANT, ButterflyVariants::bootstrap);
        registryBuilder.method_46777(WilderWildRegistries.JELLYFISH_VARIANT, JellyfishVariants::bootstrap);
        registryBuilder.method_46777(WilderWildRegistries.CRAB_VARIANT, CrabVariants::bootstrap);
        registryBuilder.method_46777(WilderWildRegistries.MOOBLOOM_VARIANT, MoobloomVariants::bootstrap);
        registryBuilder.method_46777(WilderWildRegistries.TERMITE_BLOCK_BEHAVIOR, TermiteBlockBehaviors::bootstrap);
    }

    @NotNull
    public String getEffectiveModId() {
        return "wilderwild";
    }
}

