/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.trunk.branch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.worldgen.impl.util.TrunkPlacerHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_3481;
import net.minecraft.class_3746;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import org.jetbrains.annotations.NotNull;

public class TrunkBranchPlacement {
    public static final MapCodec<TrunkBranchPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_placement_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.branchChance)), (App)class_6017.field_33450.lenientOptionalFieldOf("max_branch_count", (Object)class_6016.field_29942).forGetter(trunkPlacer -> trunkPlacer.maxBranchCount), (App)class_6017.field_33450.lenientOptionalFieldOf("branch_cutoff_from_top", (Object)class_6016.field_29942).forGetter(trunkPlacer -> trunkPlacer.branchCutoffFromTop), (App)class_6017.field_33450.fieldOf("branch_length").forGetter(trunkPlacer -> trunkPlacer.branchLength), (App)Codec.FLOAT.fieldOf("offset_last_log_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.offsetLastLogChance)), (App)Codec.intRange((int)0, (int)16).fieldOf("minimum_branch_length_for_offset").forGetter(trunkPlacer -> trunkPlacer.minBranchLengthForOffset), (App)Codec.FLOAT.fieldOf("foliage_placement_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.foliagePlacementChance)), (App)Codec.intRange((int)0, (int)3).lenientOptionalFieldOf("foliage_radius_shrink", (Object)0).forGetter(trunkPlacer -> trunkPlacer.foliageRadiusShrink)).apply((Applicative)instance, TrunkBranchPlacement::new));
    private final float branchChance;
    private final class_6017 maxBranchCount;
    private final class_6017 branchCutoffFromTop;
    private final class_6017 branchLength;
    private final float offsetLastLogChance;
    private final int minBranchLengthForOffset;
    private final float foliagePlacementChance;
    private final int foliageRadiusShrink;

    public TrunkBranchPlacement(float branchChance, @NotNull class_6017 maxBranchCount, @NotNull class_6017 branchCutoffFromTop, @NotNull class_6017 branchLength, float offsetLastLogChance, int minBranchLengthForOffset, float foliagePlacementChance, int foliageRadiusShrink) {
        this.branchChance = branchChance;
        this.maxBranchCount = maxBranchCount;
        this.branchCutoffFromTop = branchCutoffFromTop;
        this.branchLength = branchLength;
        this.offsetLastLogChance = offsetLastLogChance;
        this.minBranchLengthForOffset = minBranchLengthForOffset;
        this.foliagePlacementChance = foliagePlacementChance;
        this.foliageRadiusShrink = foliageRadiusShrink;
    }

    public boolean canPlaceBranch(@NotNull class_5819 random) {
        return random.method_43057() <= this.branchChance;
    }

    public int getMaxBranchCount(class_5819 random) {
        return this.maxBranchCount.method_35008(random);
    }

    public class_6017 getBranchCutoffFromTop() {
        return this.branchCutoffFromTop;
    }

    public int getBranchLength(class_5819 random) {
        return this.branchLength.method_35008(random);
    }

    public boolean canOffsetLastLog(@NotNull class_5819 random, int length) {
        return random.method_43057() <= this.offsetLastLogChance && length > this.minBranchLengthForOffset;
    }

    public boolean canPlaceFoliage(@NotNull class_5819 random) {
        return random.method_43057() <= this.foliagePlacementChance;
    }

    public int getFoliageRadiusShrink() {
        return this.foliageRadiusShrink;
    }

    public void generateExtraBranchForFallenLog(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, @NotNull class_4651 blockStateProvider, @NotNull class_2338 startPos, @NotNull class_2350 direction, @NotNull class_2350 trunkDirection) {
        class_2338.class_2339 branchPos = startPos.method_25503();
        int totalLength = this.getBranchLength(random);
        boolean hasPassedConfigCheck = false;
        for (int length = 1; length <= totalLength; ++length) {
            boolean canOffsetLog;
            branchPos.method_25504((class_2382)startPos, direction.method_10148() * length, direction.method_10164() * length, direction.method_10165() * length);
            boolean bl = canOffsetLog = length == totalLength && this.canOffsetLastLog(random, length);
            if (canOffsetLog) {
                branchPos.method_10098(trunkDirection);
            }
            if (!class_2944.method_27371((class_3746)level, (class_2338)branchPos)) continue;
            class_2680 logState = TrunkPlacerHelper.getLogBlockState(level, blockStateProvider, (class_2338)branchPos, canOffsetLog ? trunkDirection : direction, random);
            if (hasPassedConfigCheck || TrunkBranchPlacement.verifyBranchMatchesConfig(logState)) {
                hasPassedConfigCheck = true;
                replacer.accept((class_2338)branchPos, logState);
                continue;
            }
            return;
        }
    }

    public void generateExtraBranch(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, @NotNull class_4651 blockStateProvider, @NotNull class_2338 startPos, @NotNull class_2350 direction, List<class_4647.class_5208> foliageAttachments) {
        class_2338.class_2339 branchPos = startPos.method_25503();
        int totalLength = this.getBranchLength(random);
        boolean hasPassedConfigCheck = false;
        for (int length = 1; length <= totalLength; ++length) {
            boolean placeUpwards;
            branchPos.method_25504((class_2382)startPos, direction.method_10148() * length, 0, direction.method_10165() * length);
            boolean isLastLog = length == totalLength;
            boolean bl = placeUpwards = isLastLog && this.canOffsetLastLog(random, length);
            if (placeUpwards) {
                branchPos.method_10098(class_2350.field_11036);
            }
            if (!class_2944.method_27371((class_3746)level, (class_2338)branchPos)) continue;
            class_2680 logState = TrunkPlacerHelper.getLogBlockState(level, blockStateProvider, (class_2338)branchPos, placeUpwards ? class_2350.field_11036 : direction, random);
            if (hasPassedConfigCheck || TrunkBranchPlacement.verifyBranchMatchesConfig(logState)) {
                hasPassedConfigCheck = true;
                replacer.accept((class_2338)branchPos, logState);
                if (!isLastLog || !this.canPlaceFoliage(random)) continue;
                foliageAttachments.add(new class_4647.class_5208(branchPos.method_10098(class_2350.field_11036).method_10062(), -this.getFoliageRadiusShrink(), false));
                continue;
            }
            return;
        }
    }

    private static boolean verifyBranchMatchesConfig(class_2680 logState) {
        if (!WWWorldgenConfig.BIRCH_BRANCHES && logState.method_26164(class_3481.field_15498)) {
            return false;
        }
        if (!WWWorldgenConfig.OAK_BRANCHES && logState.method_26164(class_3481.field_15482)) {
            return false;
        }
        return WWWorldgenConfig.DARK_OAK_BRANCHES || !logState.method_26164(class_3481.field_15485);
    }

    public static class Builder {
        private float branchChance = 0.0f;
        private class_6017 maxBranchCount = class_6016.field_29942;
        private class_6017 branchCutoffFromTop = class_6016.field_29942;
        private class_6017 branchLength = class_6016.field_29942;
        private float offsetLastLogChance = 0.0f;
        private int minBranchLengthForOffset = 1;
        private float foliagePlacementChance = 0.0f;
        private int foliageRadiusShrink = 0;

        public Builder branchChance(float branchChance) {
            this.branchChance = branchChance;
            return this;
        }

        public Builder maxBranchCount(int maxBranchCount) {
            this.maxBranchCount = class_6016.method_34998((int)maxBranchCount);
            return this;
        }

        public Builder maxBranchCount(class_6017 maxBranchCount) {
            this.maxBranchCount = maxBranchCount;
            return this;
        }

        public Builder branchCutoffFromTop(class_6017 branchCutoffFromTop) {
            this.branchCutoffFromTop = branchCutoffFromTop;
            return this;
        }

        public Builder branchLength(class_6017 branchLength) {
            this.branchLength = branchLength;
            return this;
        }

        public Builder offsetLastLogChance(Float offsetLastLogChance) {
            this.offsetLastLogChance = offsetLastLogChance.floatValue();
            return this;
        }

        public Builder foliagePlacementChance(Float foliagePlacementChance) {
            this.foliagePlacementChance = foliagePlacementChance.floatValue();
            return this;
        }

        public Builder minBranchLengthForOffset(int minBranchLengthForOffset) {
            this.minBranchLengthForOffset = minBranchLengthForOffset;
            return this;
        }

        public Builder foliageRadiusShrink(int foliageRadiusShrink) {
            this.foliageRadiusShrink = foliageRadiusShrink;
            return this;
        }

        public TrunkBranchPlacement build() {
            return new TrunkBranchPlacement(this.branchChance, this.maxBranchCount, this.branchCutoffFromTop, this.branchLength, this.offsetLastLogChance, this.minBranchLengthForOffset, this.foliagePlacementChance, this.foliageRadiusShrink);
        }
    }
}

