/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.networking.FrozenByteBufCodecs;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.entity.Firefly;
import net.frozenblock.wilderwild.entity.ai.firefly.FireflyAi;
import net.frozenblock.wilderwild.entity.variant.firefly.FireflyColor;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWDataComponents;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public class DisplayLanternBlockEntity
extends class_2586 {
    public static final int MAX_FIREFLY_AGE = 20;
    private final ArrayList<Occupant> fireflies = new ArrayList();
    private final boolean hanging;
    public class_2371<class_1799> inventory;
    public int age;
    private boolean firstTick;

    public DisplayLanternBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 blockState) {
        super(WWBlockEntityTypes.DISPLAY_LANTERN, pos, blockState);
        this.hanging = (Boolean)blockState.method_11654((class_2769)class_2741.field_16561);
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    }

    public void serverTick(@NotNull class_1937 level, @NotNull class_2338 pos) {
        boolean hasFireflies;
        boolean bl = hasFireflies = !this.fireflies.isEmpty();
        if (!this.firstTick) {
            this.firstTick = true;
            if (hasFireflies) {
                class_2680 state = this.method_11010();
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)WWBlockStateProperties.DISPLAY_LIGHT, (Comparable)Integer.valueOf(class_3532.method_15340((int)(this.fireflies.size() * 3), (int)0, (int)15))));
            }
        }
        if (hasFireflies) {
            for (Occupant firefly : this.fireflies) {
                firefly.tick(level);
            }
        }
    }

    public void clientTick(class_1937 level) {
        ++this.age;
        if (!this.fireflies.isEmpty()) {
            for (Occupant firefly : this.fireflies) {
                firefly.tick(level);
            }
        }
    }

    public boolean isHanging() {
        return this.hanging;
    }

    public void markForUpdate() {
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    public boolean invEmpty() {
        return this.getItem().method_7960();
    }

    public class_1799 getItem() {
        return (class_1799)this.inventory.getFirst();
    }

    public boolean noFireflies() {
        return this.getFireflies().isEmpty();
    }

    public void method_11014(@NotNull class_11368 valueInput) {
        super.method_11014(valueInput);
        this.fireflies.clear();
        valueInput.method_71426("fireflies", Occupant.LIST_CODEC).ifPresent(this.fireflies::addAll);
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)valueInput, this.inventory);
        this.age = valueInput.method_71424("age", 0);
    }

    protected void method_11007(@NotNull class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71468("fireflies", Occupant.LIST_CODEC, this.fireflies);
        class_1262.method_5426((class_11372)valueOutput, this.inventory);
        valueOutput.method_71465("age", this.age);
    }

    protected void method_57568(class_9473 dataComponentGetter) {
        super.method_57568(dataComponentGetter);
        this.fireflies.clear();
        List occupants = (List)dataComponentGetter.method_58695(WWDataComponents.FIREFLIES, List.of());
        this.fireflies.addAll(occupants);
    }

    public void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(WWDataComponents.FIREFLIES, this.fireflies);
    }

    public void method_57569(class_11372 valueOutput) {
        super.method_57569(valueOutput);
        valueOutput.method_71478("fireflies");
    }

    @NotNull
    public List<Occupant> getFireflies() {
        return this.fireflies;
    }

    public void addFirefly(@NotNull class_1936 levelAccessor, @NotNull class_2960 color, @NotNull String name) {
        class_5819 random = levelAccessor.method_8409();
        class_243 newVec = new class_243(0.5 + (0.15 - random.method_43058() * 0.3), 0.0, 0.5 + (0.15 - random.method_43058() * 0.3));
        Occupant firefly = new Occupant(newVec, color, name, random.method_43048(20), 0.0);
        this.fireflies.add(firefly);
        if (this.field_11863 != null) {
            this.field_11863.method_8455(this.method_11016(), this.method_11010().method_26204());
        }
    }

    public void removeFirefly(@NotNull Occupant firefly) {
        this.fireflies.remove(firefly);
    }

    public void spawnFireflies() {
        if (this.field_11863 == null) {
            return;
        }
        if (!this.field_11863.field_9236) {
            this.spawnFireflies(this.field_11863);
        }
    }

    public void spawnFireflies(@NotNull class_1937 level) {
        if (!this.getFireflies().isEmpty()) {
            this.doFireflySpawns(level);
        }
    }

    private void doFireflySpawns(@NotNull class_1937 level) {
        double extraHeight = (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_16561) != false ? 0.155 : 0.0;
        for (Occupant firefly : this.getFireflies()) {
            Firefly entity = (Firefly)WWEntityTypes.FIREFLY.method_5883(level, class_3730.field_52444);
            if (entity == null) continue;
            entity.method_5808((double)this.field_11867.method_10263() + firefly.pos.field_1352, (double)this.field_11867.method_10264() + firefly.y + extraHeight + 0.07, (double)this.field_11867.method_10260() + firefly.pos.field_1350, 0.0f, 0.0f);
            entity.wilderWild$setFromBottle(true);
            if (level.method_8649((class_1297)entity)) {
                FireflyAi.rememberHome((class_1309)entity, entity.method_24515());
                entity.setColor(firefly.color);
                entity.setAnimScale(1.0f);
                if (Objects.equals(firefly.customName, "")) continue;
                entity.method_5665(class_2561.method_30163((String)firefly.customName));
                continue;
            }
            WWConstants.printStackTrace("Couldn't spawn Firefly from Display Lantern!", true);
        }
    }

    public int getComparatorOutput() {
        if (!this.invEmpty()) {
            return 15;
        }
        if (!this.noFireflies()) {
            return class_3532.method_15340((int)(this.getFireflies().size() * 4), (int)0, (int)15);
        }
        return 0;
    }

    public static class Occupant {
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_243.field_38277.fieldOf("pos").forGetter(Occupant::getPos), (App)class_2960.field_25139.fieldOf("color").forGetter(Occupant::getColor), (App)Codec.STRING.fieldOf("custom_name").orElse((Object)"").forGetter(Occupant::getCustomName), (App)Codec.INT.fieldOf("age").forGetter(Occupant::getAge), (App)Codec.DOUBLE.fieldOf("y").forGetter(Occupant::getY)).apply((Applicative)instance, Occupant::new));
        public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
        public static final class_9139<class_9129, Occupant> STREAM_CODEC = class_9139.method_56906((class_9139)FrozenByteBufCodecs.VEC3, Occupant::getPos, (class_9139)class_2960.field_48267, Occupant::getColor, (class_9139)class_9135.field_48554, Occupant::getCustomName, (class_9139)class_9135.field_49675, Occupant::getAge, (class_9139)class_9135.field_48553, Occupant::getY, Occupant::new);
        public class_243 pos;
        public class_2960 color;
        public String customName;
        public int age;
        public double y;
        private Optional<FireflyColor> colorForRendering = Optional.empty();

        public Occupant(@NotNull class_243 pos, @NotNull class_2960 color, @NotNull String customName, int age, double y) {
            this.pos = pos;
            this.color = color;
            this.customName = customName;
            this.age = age;
            this.y = y;
        }

        public void tick(class_1937 level) {
            ++this.age;
            this.y = Math.sin((double)this.age * 0.03) * 0.15;
            if (this.colorForRendering.isEmpty()) {
                this.colorForRendering = level.method_30349().method_30530(WilderWildRegistries.FIREFLY_COLOR).method_17966(this.color);
            }
        }

        @NotNull
        public class_243 getPos() {
            return this.pos;
        }

        @NotNull
        public class_2960 getColor() {
            return this.color;
        }

        public boolean canRender() {
            return this.colorForRendering.isPresent();
        }

        public FireflyColor getColorForRendering() {
            return this.colorForRendering.get();
        }

        @NotNull
        public String getCustomName() {
            return this.customName;
        }

        public int getAge() {
            return this.age;
        }

        public double getY() {
            return this.y;
        }
    }
}

