/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.block.HangingTendrilBlock;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5703;
import net.minecraft.class_5705;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8514;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangingTendrilBlockEntity
extends class_2586
implements class_5714.class_8513<class_8514.class_8516>,
class_8514 {
    public static final int MILK_FRAMES = 4;
    public static final int MILK_ANIM_SPEED = 2;
    public static final int ACTIVE_FRAMES = 5;
    public static final int ACTIVE_ANIM_SPEED = 1;
    public static final int TWITCHING_FRAMES = 4;
    public static final int TWITCHING_ANIM_SPEED = 50;
    public static final int INACTIVE_FRAMES = 6;
    public static final int INACTIVE_ANIM_SPEED = 6;
    public static final double MILK_XP_PERCENTAGE = 0.5;
    private static final String BASE_TEXTURE = "textures/entity/hanging_tendril/";
    private final class_8514.class_8516 vibrationListener;
    private final class_8514.class_5719 vibrationUser = this.createVibrationUser();
    private class_8514.class_8515 vibrationData;
    private int lastVibrationFrequency;
    public int ticksToStopTwitching;
    private int storedXP;
    public int ringOutTicksLeft;
    private int activeTicks;
    private class_2960 texture = WWConstants.id("textures/entity/hanging_tendril/inactive1.png");

    public HangingTendrilBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        super(WWBlockEntityTypes.HANGING_TENDRIL, pos, state);
        this.vibrationData = new class_8514.class_8515();
        this.vibrationListener = new class_8514.class_8516((class_8514)this);
    }

    public void serverTick(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        if (this.ticksToStopTwitching <= 0) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)HangingTendrilBlock.TWITCHING, (Comparable)Boolean.valueOf(false)));
        }
        --this.ticksToStopTwitching;
        if (this.ringOutTicksLeft >= 0) {
            --this.ringOutTicksLeft;
        } else if (((Boolean)state.method_11654((class_2769)HangingTendrilBlock.WRINGING_OUT)).booleanValue()) {
            state = (class_2680)state.method_11657((class_2769)HangingTendrilBlock.WRINGING_OUT, (Comparable)Boolean.valueOf(false));
            level.method_8501(pos, state);
            if (this.storedXP > 0) {
                int droppedXP = this.storedXP > 1 ? (int)((double)this.storedXP * 0.5) : 1;
                class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24955((class_2382)pos), (int)droppedXP);
                this.storedXP -= droppedXP;
                level.method_33596(null, (class_6880)class_5712.field_28733, pos);
            }
        }
        if (this.activeTicks >= 60) {
            this.activeTicks = 0;
            HangingTendrilBlock.deactivate(level, pos, state, level.field_9229);
        } else if (state.method_11654(HangingTendrilBlock.PHASE) == class_5705.field_28122) {
            ++this.activeTicks;
        }
        class_8514.class_8517.method_51406((class_1937)level, (class_8514.class_8515)this.method_51298(), (class_8514.class_5719)this.method_51299());
    }

    public void clientTick(@NotNull class_1937 level, @NotNull class_2680 state) {
        if (!level.field_9236) {
            return;
        }
        boolean twitching = this.ticksToStopTwitching > 0;
        boolean milking = this.ringOutTicksLeft > 0;
        boolean active = !class_5703.method_32909((class_2680)state);
        long time = level.method_8510();
        this.texture = milking ? WWConstants.id("textures/entity/hanging_tendril/milk" + (time / 2L % 4L + 1L) + ".png") : (active ? WWConstants.id("textures/entity/hanging_tendril/active" + (time / 1L % 5L + 1L) + ".png") : (twitching ? WWConstants.id("textures/entity/hanging_tendril/twitch" + (time / 50L % 4L + 1L) + ".png") : WWConstants.id("textures/entity/hanging_tendril/inactive" + (time / 6L % 6L + 1L) + ".png")));
    }

    public class_2960 getClientTexture() {
        return this.texture;
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public void setStoredXP(int i) {
        this.storedXP = i;
    }

    public int getActiveTicks() {
        return this.activeTicks;
    }

    public void setActiveTicks(int i) {
        this.activeTicks = i;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), WWConstants.LOGGER);){
            class_11362 tagValueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)provider);
            this.saveClientUsableNbt((class_11372)tagValueOutput);
            class_2487 class_24872 = tagValueOutput.method_71475();
            return class_24872;
        }
    }

    public void method_11014(@NotNull class_11368 valueInput) {
        super.method_11014(valueInput);
        this.lastVibrationFrequency = valueInput.method_71424("last_vibration_frequency", 0);
        this.ticksToStopTwitching = valueInput.method_71424("ticksToStopTwitching", 0);
        this.storedXP = valueInput.method_71424("storedXP", 0);
        this.ringOutTicksLeft = valueInput.method_71424("ringOutTicksLeft", 0);
        this.activeTicks = valueInput.method_71424("activeTicks", 0);
        this.vibrationData = valueInput.method_71426("listener", class_8514.class_8515.field_44640).orElseGet(class_8514.class_8515::new);
    }

    protected void method_11007(@NotNull class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71465("last_vibration_frequency", this.lastVibrationFrequency);
        if (this.storedXP > 0) {
            valueOutput.method_71465("storedXP", this.storedXP);
        }
        if (this.activeTicks > 0) {
            valueOutput.method_71465("activeTicks", this.activeTicks);
        }
        this.saveClientUsableNbt(valueOutput);
        valueOutput.method_71468("listener", class_8514.class_8515.field_44640, (Object)this.vibrationData);
    }

    public void saveClientUsableNbt(class_11372 valueOutput) {
        if (this.ticksToStopTwitching > 0) {
            valueOutput.method_71465("ticksToStopTwitching", this.ticksToStopTwitching);
        }
        if (this.ringOutTicksLeft > 0) {
            valueOutput.method_71465("ringOutTicksLeft", this.ringOutTicksLeft);
        }
    }

    @NotNull
    public class_8514.class_5719 createVibrationUser() {
        return new VibrationUser(this.method_11016());
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    public void setLastVibrationFrequency(int lastVibrationFrequency) {
        this.lastVibrationFrequency = lastVibrationFrequency;
    }

    @NotNull
    public class_8514.class_8516 getListener() {
        return this.vibrationListener;
    }

    @NotNull
    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    @NotNull
    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    public class VibrationUser
    implements class_8514.class_5719 {
        public static final int LISTENER_RANGE = 4;
        protected final class_2338 blockPos;
        private final class_5716 positionSource;

        public VibrationUser(class_2338 pos) {
            this.blockPos = pos;
            this.positionSource = new class_5707(pos);
        }

        public int method_49797() {
            return 4;
        }

        @NotNull
        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_43695() {
            return true;
        }

        public boolean method_32970(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_6880<class_5712> gameEvent, @Nullable class_5712.class_7397 context) {
            if (pos.equals((Object)this.blockPos) && (gameEvent == class_5712.field_28165 || gameEvent == class_5712.field_28164)) {
                return false;
            }
            class_2680 state = level.method_8320(HangingTendrilBlockEntity.this.method_11016());
            return state.method_26204() instanceof HangingTendrilBlock && HangingTendrilBlock.canActivate(state) && (Boolean)state.method_11654((class_2769)HangingTendrilBlock.WRINGING_OUT) == false;
        }

        public void method_32969(@NotNull class_3218 world, @NotNull class_2338 pos, @NotNull class_6880<class_5712> gameEvent, @Nullable class_1297 entity, @Nullable class_1297 entity2, float f) {
            class_2680 blockState = HangingTendrilBlockEntity.this.method_11010();
            if (class_5703.method_32909((class_2680)blockState)) {
                HangingTendrilBlockEntity.this.setLastVibrationFrequency(class_8514.method_55783(gameEvent));
                int i = class_8514.method_51384((float)f, (int)this.method_49797());
                class_2248 block = blockState.method_26204();
                if (block instanceof HangingTendrilBlock) {
                    HangingTendrilBlock hangingTendrilBlock = (HangingTendrilBlock)block;
                    hangingTendrilBlock.activate(entity, (class_1937)world, this.blockPos, blockState, gameEvent, i, HangingTendrilBlockEntity.this.getLastVibrationFrequency());
                }
            }
        }

        public void method_42672() {
            HangingTendrilBlockEntity.this.method_5431();
        }

        public boolean method_51363() {
            return true;
        }
    }
}

