/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.config;

import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.json.JsonConfig;
import net.frozenblock.lib.config.api.instance.json.JsonType;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.api.sync.SyncBehavior;
import net.frozenblock.lib.config.api.sync.annotation.EntrySyncData;
import net.frozenblock.wilderwild.WWPreLoadConstants;

public final class WWEntityConfig {
    public static final Config<WWEntityConfig> INSTANCE = ConfigRegistry.register((Config)new JsonConfig<WWEntityConfig>("wilderwild", WWEntityConfig.class, WWPreLoadConstants.configPath("entity", true), JsonType.JSON5){

        public void onSave() throws Exception {
            super.onSave();
            this.onSync(null);
        }

        public void onSync(WWEntityConfig syncInstance) {
            WWEntityConfig config = (WWEntityConfig)this.config();
            WARDEN_SWIMS = config.warden.wardenSwims;
            FIREFLY_SWARMS = config.firefly.fireflySwarm;
            FIREFLY_SWARMS_BUSH = config.firefly.fireflySwarmsBush;
            REACH_AFFECTS_ATTACK = config.crab.reachAffectsAttack;
            CRAB_CLAW_GIVES_REACH = config.crab.crabClawGivesReach;
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                Client.SPAWN_FIREFLY_PARTICLES = config.firefly.spawnFireflyParticles;
                Client.TUMBLEWEED_ROTATES_TO_LOOK_DIRECTION = config.tumbleweed.tumbleweedRotatesToLookDirection;
                Client.ALLAY_KEYFRAME_DANCE = config.allay.keyframeAllayDance;
                Client.WARDEN_SWIM_ANIMATION = config.warden.wardenSwimAnimation;
                Client.WARDEN_CUSTOM_TENDRIL_ANIMATION = config.warden.wardenCustomTendrils;
                Client.WARDEN_IMPROVED_DIG_ANIMATION = config.warden.wardenImprovedDig;
                Client.WARDEN_IMPROVED_EMERGE_ANIMATION = config.warden.wardenImprovedEmerge;
                Client.WARDEN_IMPROVED_SNIFF_ANIMATION = config.warden.wardenBedrockSniff;
                Client.WARDEN_DEATH_ANIMATION = config.warden.wardenDeathAnimation;
                Client.JELLYFISH_PLANE_TENTACLES = config.jellyfish.planeTentacles;
                Client.JELLYFISH_ORAL_ARM = config.jellyfish.oralArm;
            }
        }
    });
    public static volatile boolean WARDEN_SWIMS = true;
    public static volatile boolean FIREFLY_SWARMS = true;
    public static volatile boolean FIREFLY_SWARMS_BUSH = true;
    public static volatile boolean REACH_AFFECTS_ATTACK = false;
    public static volatile boolean CRAB_CLAW_GIVES_REACH = false;
    @ConfigEntry.Gui.CollapsibleObject
    public final LightningConfig lightning = new LightningConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final AllayConfig allay = new AllayConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final EnderManConfig enderMan = new EnderManConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final FireflyConfig firefly = new FireflyConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final ButterflyConfig butterfly = new ButterflyConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final JellyfishConfig jellyfish = new JellyfishConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final CrabConfig crab = new CrabConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final OstrichConfig ostrich = new OstrichConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final ScorchedConfig scorched = new ScorchedConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final MoobloomConfig moobloom = new MoobloomConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final PenguinConfig penguin = new PenguinConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final TumbleweedConfig tumbleweed = new TumbleweedConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final WardenConfig warden = new WardenConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final VillagerConfig villager = new VillagerConfig();
    @EntrySyncData(value="unpassableRail")
    public boolean unpassableRail = false;

    public static WWEntityConfig get() {
        return WWEntityConfig.get(false);
    }

    public static WWEntityConfig get(boolean real) {
        if (real) {
            return (WWEntityConfig)INSTANCE.instance();
        }
        return (WWEntityConfig)INSTANCE.config();
    }

    public static WWEntityConfig getWithSync() {
        return (WWEntityConfig)INSTANCE.configWithSync();
    }

    public static class LightningConfig {
        @EntrySyncData(value="lightningScorchesSand")
        public boolean lightningScorchesSand = true;
        @EntrySyncData(value="lightningBlockParticles", behavior=SyncBehavior.UNSYNCABLE)
        public boolean lightningBlockParticles = true;
        @EntrySyncData(value="lightningSmokeParticles", behavior=SyncBehavior.UNSYNCABLE)
        public boolean lightningSmokeParticles = true;
    }

    public static class AllayConfig {
        @EntrySyncData(value="keyframeAllayDance", behavior=SyncBehavior.UNSYNCABLE)
        public boolean keyframeAllayDance = true;
    }

    public static class EnderManConfig {
        @EntrySyncData(value="angerLoopSound")
        public boolean angerLoopSound = true;
        @EntrySyncData(value="movingStareSound", behavior=SyncBehavior.UNSYNCABLE)
        public boolean movingStareSound = true;
    }

    public static class FireflyConfig {
        @EntrySyncData(value="spawnFireflyParticles", behavior=SyncBehavior.UNSYNCABLE)
        public boolean spawnFireflyParticles = false;
        @EntrySyncData(value="spawnFireflies")
        public boolean spawnFireflies = true;
        @EntrySyncData(value="firefliesNeedBush")
        public boolean firefliesNeedBush = true;
        @EntrySyncData(value="fireflySpawnCap")
        public int fireflySpawnCap = 56;
        @EntrySyncData(value="fireflySwarm")
        public boolean fireflySwarm = true;
        @EntrySyncData(value="fireflySwarmsBush")
        public boolean fireflySwarmsBush = true;
    }

    public static class ButterflyConfig {
        @EntrySyncData(value="spawnButterflies")
        public boolean spawnButterflies = true;
        @EntrySyncData(value="butterflySpawnCap")
        public int butterflySpawnCap = 10;
    }

    public static class JellyfishConfig {
        @EntrySyncData(value="spawnJellyfish")
        public boolean spawnJellyfish = true;
        @EntrySyncData(value="jellyfishSpawnCap")
        public int jellyfishSpawnCap = 30;
        @EntrySyncData(value="jellyfishHiding")
        public boolean jellyfishHiding = true;
        @EntrySyncData(value="jellyfishTentacles", behavior=SyncBehavior.UNSYNCABLE)
        public int jellyfishTentacles = 8;
        @EntrySyncData(value="planeTentacles", behavior=SyncBehavior.UNSYNCABLE)
        public boolean planeTentacles = true;
        @EntrySyncData(value="oralArm", behavior=SyncBehavior.UNSYNCABLE)
        public boolean oralArm = true;
    }

    public static class CrabConfig {
        @EntrySyncData(value="spawnCrabs")
        public boolean spawnCrabs = true;
        @EntrySyncData(value="crabSpawnCap")
        public int crabSpawnCap = 6;
        @EntrySyncData(value="reachAffectsAttack")
        public boolean reachAffectsAttack = false;
        @EntrySyncData(value="crabClawGivesReach")
        public boolean crabClawGivesReach = false;
    }

    public static class OstrichConfig {
        @EntrySyncData(value="spawnOstriches")
        public boolean spawnOstriches = true;
        @EntrySyncData(value="allowAttack")
        public boolean allowAttack = true;
    }

    public static class ScorchedConfig {
        @EntrySyncData(value="spawnScorched")
        public boolean spawnScorched = true;
        @EntrySyncData(value="scorchedInTrialChambers")
        public boolean scorchedInTrialChambers = true;
    }

    public static class MoobloomConfig {
        @EntrySyncData(value="spawnMooblooms")
        public boolean spawnMooblooms = true;
    }

    public static class PenguinConfig {
        @EntrySyncData(value="spawnPenguins")
        public boolean spawnPenguins = true;
    }

    public static class TumbleweedConfig {
        @EntrySyncData(value="spawnTumbleweed")
        public boolean spawnTumbleweed = true;
        @EntrySyncData(value="tumbleweedSpawnCap")
        public int tumbleweedSpawnCap = 10;
        @EntrySyncData(value="leashedTumbleweed")
        public boolean leashedTumbleweed = false;
        @EntrySyncData(value="tumbleweedDestroysCrops")
        public boolean tumbleweedDestroysCrops = true;
        @EntrySyncData(value="tumbleweedRotatesToLookDirection", behavior=SyncBehavior.UNSYNCABLE)
        public boolean tumbleweedRotatesToLookDirection = false;
    }

    public static class WardenConfig {
        @EntrySyncData(value="wardenAttacksImmediately")
        public boolean wardenAttacksImmediately = true;
        @EntrySyncData(value="wardenSwims")
        public boolean wardenSwims = true;
        @EntrySyncData(value="wardenSwimAnimation", behavior=SyncBehavior.UNSYNCABLE)
        public boolean wardenSwimAnimation = true;
        @EntrySyncData(value="wardenCustomTendrils", behavior=SyncBehavior.UNSYNCABLE)
        public boolean wardenCustomTendrils = true;
        @EntrySyncData(value="wardenImprovedDig", behavior=SyncBehavior.UNSYNCABLE)
        public boolean wardenImprovedDig = true;
        @EntrySyncData(value="wardenImprovedEmerge", behavior=SyncBehavior.UNSYNCABLE)
        public boolean wardenImprovedEmerge = true;
        @EntrySyncData(value="wardenBedrockSniff", behavior=SyncBehavior.UNSYNCABLE)
        public boolean wardenBedrockSniff = true;
        @EntrySyncData(value="wardenDeathAnimation")
        public boolean wardenDeathAnimation = true;
        @EntrySyncData(value="wardenEmergesFromCommand")
        public boolean wardenEmergesFromCommand = false;
        @EntrySyncData(value="wardenEmergesFromEgg")
        public boolean wardenEmergesFromEgg = false;

        public boolean swimAndAnimationConfigEnabled() {
            return this.wardenSwims && this.wardenSwimAnimation;
        }
    }

    public static class VillagerConfig {
        @EntrySyncData(value="wanderingWillowTrade")
        public boolean wanderingWillowTrade = true;
        @EntrySyncData(value="wanderingCypressTrade")
        public boolean wanderingCypressTrade = true;
        @EntrySyncData(value="wanderingBaobabTrade")
        public boolean wanderingBaobabTrade = true;
        @EntrySyncData(value="wanderingPalmTrade")
        public boolean wanderingPalmTrade = true;
        @EntrySyncData(value="wanderingMapleTrade")
        public boolean wanderingMapleTrade = true;
        @EntrySyncData(value="wanderingCarnationTrade")
        public boolean wanderingCarnationTrade = true;
        @EntrySyncData(value="wanderingHibiscusTrade")
        public boolean wanderingHibiscusTrade = true;
        @EntrySyncData(value="wanderingSeedingDandelionTrade")
        public boolean wanderingSeedingDandelionTrade = true;
        @EntrySyncData(value="wanderingMarigoldTrade")
        public boolean wanderingMarigoldTrade = true;
        @EntrySyncData(value="wanderingPasqueflowerTrade")
        public boolean wanderingPasqueflowerTrade = true;
        @EntrySyncData(value="wanderingTumbleweedTrade")
        public boolean wanderingTumbleweedTrade = true;
        @EntrySyncData(value="wanderingPricklyPearTrade")
        public boolean wanderingPricklyPearTrade = true;
        @EntrySyncData(value="wanderingIcicleTrade")
        public boolean wanderingIcicleTrade = true;
        @EntrySyncData(value="wanderingBarnaclesTrade")
        public boolean wanderingBarnaclesTrade = true;
        @EntrySyncData(value="wanderingSeaAnemoneTrade")
        public boolean wanderingSeaAnemoneTrade = true;
        @EntrySyncData(value="wanderingSeaWhipTrade")
        public boolean wanderingSeaWhipTrade = true;
        @EntrySyncData(value="wanderingAlgaeTrade")
        public boolean wanderingAlgaeTrade = true;
        @EntrySyncData(value="wanderingPlanktonTrade")
        public boolean wanderingPlanktonTrade = true;
        @EntrySyncData(value="wanderingAuburnMossTrade")
        public boolean wanderingAuburnMossTrade = true;
        @EntrySyncData(value="wanderingGeyserTrade")
        public boolean wanderingGeyserTrade = true;
        @EntrySyncData(value="fishermanDesertPalmBoat")
        public boolean fishermanDesertPalmBoat = true;
        @EntrySyncData(value="fishermanCrabForEmeralds")
        public boolean fishermanCrabForEmeralds = true;
        @EntrySyncData(value="fishermanJellyfishForEmeralds")
        public boolean fishermanJellyfishForEmeralds = true;
    }

    public static final class Client {
        public static volatile boolean SPAWN_FIREFLY_PARTICLES = false;
        public static volatile boolean TUMBLEWEED_ROTATES_TO_LOOK_DIRECTION = false;
        public static volatile boolean ALLAY_KEYFRAME_DANCE = false;
        public static volatile boolean WARDEN_SWIM_ANIMATION = true;
        public static volatile boolean WARDEN_CUSTOM_TENDRIL_ANIMATION = true;
        public static volatile boolean WARDEN_IMPROVED_DIG_ANIMATION = true;
        public static volatile boolean WARDEN_IMPROVED_EMERGE_ANIMATION = true;
        public static volatile boolean WARDEN_IMPROVED_SNIFF_ANIMATION = true;
        public static volatile boolean WARDEN_DEATH_ANIMATION = true;
        public static volatile boolean JELLYFISH_PLANE_TENTACLES = true;
        public static volatile boolean JELLYFISH_ORAL_ARM = true;
    }
}

