/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datafix.minecraft.datafixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.frozenblock.wilderwild.WWConstants;
import net.minecraft.class_1208;
import net.minecraft.class_1220;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class MobBucketVariantComponentizationFix
extends DataFix {
    private static final String BUCKET_ENTITY_DATA_FIELD = WWConstants.vanillaId("bucket_entity_data").toString();
    private final String fixName;
    private final String itemId;
    private final String newTagField;

    public MobBucketVariantComponentizationFix(Schema outputSchema, String fixName, @NotNull class_2960 itemId, String newTagField) {
        super(outputSchema, false);
        this.fixName = fixName;
        this.itemId = itemId.toString();
        this.newTagField = newTagField;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(class_1208.field_5712);
        return this.fixTypeEverywhereTyped(this.fixName, type, this.createFixer(type, this::fixItemStack));
    }

    @NotNull
    private UnaryOperator<Typed<?>> createFixer(@NotNull Type<?> type, UnaryOperator<Dynamic<?>> unaryOperator) {
        OpticFinder idFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)class_1208.field_5713.typeName(), (Type)class_1220.method_28295()));
        OpticFinder components = type.findField("components");
        return typed -> {
            Optional optional = typed.getOptional(idFinder);
            return optional.isPresent() && ((String)((Pair)optional.get()).getSecond()).equals(this.itemId) ? typed.updateTyped(components, typedx -> typedx.update(DSL.remainderFinder(), (Function)unaryOperator)) : typed;
        };
    }

    private Dynamic<?> fixItemStack(@NotNull Dynamic<?> componentData) {
        Dynamic bottleEntityTag;
        OptionalDynamic optionalVariant;
        OptionalDynamic optionalBottleEntityData = componentData.get(BUCKET_ENTITY_DATA_FIELD);
        if (optionalBottleEntityData.result().isPresent() && (optionalVariant = (bottleEntityTag = (Dynamic)optionalBottleEntityData.result().get()).get("variant")).result().isPresent()) {
            componentData = componentData.set(this.newTagField, (Dynamic)optionalVariant.result().get());
            bottleEntityTag = bottleEntityTag.remove("variant");
            componentData = componentData.set(BUCKET_ENTITY_DATA_FIELD, bottleEntityTag);
        }
        return componentData;
    }
}

