/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.ai.butterfly.ButterflyAi;
import net.frozenblock.wilderwild.entity.impl.WWBottleable;
import net.frozenblock.wilderwild.entity.variant.butterfly.ButterflyVariant;
import net.frozenblock.wilderwild.entity.variant.butterfly.ButterflyVariants;
import net.frozenblock.wilderwild.registry.WWDataComponents;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.frozenblock.wilderwild.tag.WWBiomeTags;
import net.minecraft.class_10209;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Butterfly
extends class_1314
implements class_1432,
WWBottleable {
    public static final int TICKS_PER_FLAP = 3;
    private static final class_2940<Boolean> FROM_BOTTLE = class_2945.method_12791(Butterfly.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> VARIANT = class_2945.method_12791(Butterfly.class, (class_2941)class_2943.field_13326);
    private float prevFlyingXRot;
    private float flyingXRot;
    private float prevDownProgress;
    private float downProgress;
    private float prevGroundProgress;
    private float groundProgress;
    private Optional<ButterflyVariant> butterflyVariant = Optional.empty();

    public Butterfly(@NotNull class_1299<? extends Butterfly> entityType, @NotNull class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
    }

    public float method_6144(class_2338 blockPos, @NotNull class_4538 levelReader) {
        float bonus = levelReader.method_8320(blockPos).method_26164(class_3481.field_20339) ? 7.0f : 0.0f;
        return levelReader.method_42309(blockPos) + bonus;
    }

    public static boolean checkButterflySpawnRules(class_1299<Butterfly> type, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        if (!class_3730.method_54986((class_3730)reason) && !WWEntityConfig.get().butterfly.spawnButterflies) {
            return false;
        }
        if (!class_3730.method_54987((class_3730)reason) && !class_1429.method_39448((class_1920)level, (class_2338)pos)) {
            return true;
        }
        if (level.method_23753(pos).method_40220(WWBiomeTags.BUTTERFLY_VERY_RARE_SPAWN) && random.method_43048(30) != 0) {
            return false;
        }
        return level.method_8320(pos.method_10074()).method_26164(class_3481.field_35567);
    }

    @NotNull
    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, 0.1).method_26868(class_5134.field_23720, 0.8).method_26868(class_5134.field_23717, 32.0);
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData) {
        boolean shouldSetHome = Butterfly.shouldSetHome(reason);
        if (shouldSetHome) {
            ButterflyAi.rememberHome((class_1309)this, this.method_24515());
        } else {
            ButterflyAi.setNatural(this);
        }
        if (spawnData instanceof ButterflySpawnGroupData) {
            ButterflySpawnGroupData butterflySpawnGroupData = (ButterflySpawnGroupData)((Object)spawnData);
            this.setVariant((ButterflyVariant)butterflySpawnGroupData.type.comp_349());
        } else {
            Optional optionalButterflyVariant = class_10704.method_71969((class_10701)class_10701.method_67169((class_5425)level, (class_2338)this.method_24515()), WilderWildRegistries.BUTTERFLY_VARIANT);
            if (optionalButterflyVariant.isPresent()) {
                spawnData = new ButterflySpawnGroupData((class_6880<ButterflyVariant>)((class_6880)optionalButterflyVariant.get()));
                this.setVariant((ButterflyVariant)((class_6880.class_6883)optionalButterflyVariant.get()).comp_349());
            }
        }
        return super.method_5943(level, difficulty, reason, spawnData);
    }

    private static boolean shouldSetHome(class_3730 reason) {
        return reason == class_3730.field_16470 || reason == class_3730.field_16473;
    }

    public int method_6130(int currentAir) {
        int newSupply = super.method_6130(currentAir);
        return newSupply == currentAir - 1 ? newSupply - 1 : newSupply;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FROM_BOTTLE, (Object)false);
        builder.method_56912(VARIANT, (Object)ButterflyVariants.DEFAULT.method_29177().toString());
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        super.method_5674(entityDataAccessor);
        if (entityDataAccessor.equals(VARIANT)) {
            this.butterflyVariant = Optional.of(this.getVariant());
        }
    }

    @NotNull
    protected class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        return WWBottleable.bottleMobPickup(player, hand, this).orElse(super.method_5992(player, hand));
    }

    public boolean method_5727(double x, double y, double z) {
        return true;
    }

    @NotNull
    protected class_4095.class_5303<Butterfly> method_28306() {
        return ButterflyAi.brainProvider();
    }

    @NotNull
    protected class_4095<?> method_18867(@NotNull Dynamic<?> dynamic) {
        return ButterflyAi.makeBrain(this, (class_4095<Butterfly>)this.method_28306().method_28335(dynamic));
    }

    @Override
    public boolean wilderWild$fromBottle() {
        return (Boolean)this.field_6011.method_12789(FROM_BOTTLE);
    }

    @Override
    public void wilderWild$setFromBottle(boolean value) {
        this.field_6011.method_12778(FROM_BOTTLE, (Object)value);
    }

    @Override
    public void wilderWild$saveToBottleTag(class_1799 itemStack) {
        WWBottleable.saveDefaultDataToBottleTag((class_1308)this, itemStack);
        itemStack.method_66697(WWDataComponents.BUTTERFLY_VARIANT, (class_9473)this);
    }

    @Override
    public void wilderWild$loadFromBottleEntityDataTag(class_2487 compoundTag) {
        WWBottleable.loadDefaultDataFromBottleTag((class_1308)this, compoundTag);
    }

    @Override
    public void wilderWild$loadFromBottleItemStack(@NotNull class_1799 itemStack) {
        class_6880 variant = (class_6880)itemStack.method_58695(WWDataComponents.BUTTERFLY_VARIANT, (Object)this.method_56673().method_66874(ButterflyVariants.DEFAULT));
        this.setVariant((ButterflyVariant)variant.comp_349());
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> dataComponentType) {
        if (dataComponentType == WWDataComponents.BUTTERFLY_VARIANT) {
            return (T)Butterfly.method_66651(dataComponentType, this.getVariantAsHolder());
        }
        return (T)super.method_58694(dataComponentType);
    }

    protected void method_66649(class_9473 dataComponentGetter) {
        this.method_66650(dataComponentGetter, WWDataComponents.BUTTERFLY_VARIANT);
        super.method_66649(dataComponentGetter);
    }

    protected <T> boolean method_66654(class_9331<T> dataComponentType, T object) {
        if (dataComponentType == WWDataComponents.BUTTERFLY_VARIANT) {
            this.setVariant((ButterflyVariant)((class_6880)Butterfly.method_66651(WWDataComponents.BUTTERFLY_VARIANT, object)).comp_349());
            return true;
        }
        return super.method_66654(dataComponentType, object);
    }

    @Override
    public void wilderWild$onCapture() {
    }

    @Override
    public void wilderWild$onBottleRelease() {
        ButterflyAi.rememberHome((class_1309)this, this.method_24515());
    }

    @Override
    public class_1799 wilderWild$getBottleItemStack() {
        return new class_1799((class_1935)WWItems.BUTTERFLY_BOTTLE);
    }

    @Override
    public class_3414 wilderWild$getBottleCatchSound() {
        return WWSounds.ITEM_BOTTLE_CATCH_BUTTERFLY;
    }

    public boolean method_18410() {
        return this.method_18868().method_18896(class_4140.field_18438);
    }

    public class_2960 getVariantLocation() {
        return class_2960.method_60654((String)((String)this.field_6011.method_12789(VARIANT)));
    }

    public ButterflyVariant getVariantByLocation() {
        return (ButterflyVariant)this.method_56673().method_30530(WilderWildRegistries.BUTTERFLY_VARIANT).method_63535(this.getVariantLocation());
    }

    public class_6880<ButterflyVariant> getVariantAsHolder() {
        return (class_6880)this.method_56673().method_30530(WilderWildRegistries.BUTTERFLY_VARIANT).method_10223(this.getVariantLocation()).orElseThrow();
    }

    public ButterflyVariant getVariantForRendering() {
        return this.butterflyVariant.orElse((ButterflyVariant)this.method_56673().method_30530(WilderWildRegistries.BUTTERFLY_VARIANT).method_29107(ButterflyVariants.DEFAULT));
    }

    public void setVariant(@NotNull ButterflyVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)Objects.requireNonNull(this.method_56673().method_30530(WilderWildRegistries.BUTTERFLY_VARIANT).method_10221((Object)variant)).toString());
    }

    public void setVariant(@NotNull class_2960 variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.toString());
    }

    public ButterflyVariant getVariant() {
        return this.getVariantByLocation();
    }

    public boolean method_17326() {
        return super.method_17326() || this.wilderWild$fromBottle();
    }

    @NotNull
    public class_4095<Butterfly> method_18868() {
        return super.method_18868();
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        class_1407 birdNavigation = new class_1407((class_1308)this, level);
        birdNavigation.method_70687(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_6342().method_15(true);
        return birdNavigation;
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
    }

    protected void method_5623(double heightDifference, boolean onGround, @NotNull class_2680 state, @NotNull class_2338 landedPosition) {
    }

    protected class_3414 method_5994() {
        return null;
    }

    protected class_3414 method_6011(@NotNull class_1282 source) {
        return WWSounds.ENTITY_BUTTERFLY_HURT;
    }

    protected class_3414 method_6002() {
        return WWSounds.ENTITY_BUTTERFLY_DEATH;
    }

    public void method_5773() {
        class_1937 class_19372;
        super.method_5773();
        if (!this.method_5805()) {
            this.method_5875(false);
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_243 wind = WindManager.getOrCreateWindManager((class_3218)serverLevel).getWindMovement(this.method_19538(), 1.0, 100.0, 100.0).method_1021(0.01);
            wind = wind.method_1023(0.0, wind.field_1351 * 0.7, 0.0);
            this.method_18799(this.method_18798().method_1019(wind.method_1021(0.02)));
        }
        class_243 deltaMovement = this.method_18798();
        float targetFlyingXRot = (float)Math.clamp(deltaMovement.field_1351 * 10.0, -1.0, 1.0);
        this.prevFlyingXRot = this.flyingXRot;
        this.flyingXRot += (targetFlyingXRot - this.flyingXRot) * 0.1f;
        this.prevDownProgress = this.downProgress;
        this.downProgress += ((deltaMovement.field_1351 < 0.0 ? 1.0f : 0.0f) - this.downProgress) * 0.05f;
        this.prevGroundProgress = this.groundProgress;
        this.groundProgress += ((this.method_24828() ? 1.0f : 0.0f) - this.groundProgress) * 0.2f;
    }

    public float getFlyingXRot(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevFlyingXRot, (float)this.flyingXRot);
    }

    public float getDownProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevDownProgress, (float)this.downProgress);
    }

    public float getGroundProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevGroundProgress, (float)this.groundProgress);
    }

    protected void method_5958(class_3218 serverLevel) {
        class_3695 profilerFiller = class_10209.method_64146();
        profilerFiller.method_15396("butterflyBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        profilerFiller.method_15407();
        profilerFiller.method_15396("butterflyActivityUpdate");
        ButterflyAi.updateActivities(this);
        profilerFiller.method_15407();
        super.method_5958(serverLevel);
    }

    public boolean method_5776() {
        return this.method_6581() && this.field_6012 % 3 == 0;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.wilderWild$fromBottle() && !this.method_16914();
    }

    public void method_5652(@NotNull class_11372 valueOutput) {
        super.method_5652(valueOutput);
        class_10704.method_67177((class_11372)valueOutput, this.getVariantAsHolder());
        valueOutput.method_71472("fromBottle", this.wilderWild$fromBottle());
    }

    public void method_5749(@NotNull class_11368 valueInput) {
        super.method_5749(valueInput);
        class_10704.method_67178((class_11368)valueInput, WilderWildRegistries.BUTTERFLY_VARIANT).ifPresent(butterflyVariantHolder -> this.setVariant((ButterflyVariant)butterflyVariantHolder.comp_349()));
        this.wilderWild$setFromBottle(valueInput.method_71433("fromBottle", false));
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public boolean method_5747(double fallDistance, float damageMultiplier, @NotNull class_1282 source) {
        return false;
    }

    protected void method_6087(@NotNull class_1297 entity) {
    }

    protected void method_6070() {
    }

    public static class ButterflySpawnGroupData
    extends class_1296.class_4697 {
        public final class_6880<ButterflyVariant> type;

        public ButterflySpawnGroupData(class_6880<ButterflyVariant> holder) {
            super(false);
            this.type = holder;
        }
    }
}

