/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.variant.moobloom;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.entity.variant.moobloom.MoobloomVariant;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.minecraft.class_10701;
import net.minecraft.class_10726;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3175;
import net.minecraft.class_4638;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_7891;

public final class MoobloomVariants {
    public static final class_5321<MoobloomVariant> DANDELION = MoobloomVariants.createKey("dandelion");
    public static final class_5321<MoobloomVariant> POPPY = MoobloomVariants.createKey("poppy");
    public static final class_5321<MoobloomVariant> AZURE_BLUET = MoobloomVariants.createKey("azure_bluet");
    public static final class_5321<MoobloomVariant> RED_TULIP = MoobloomVariants.createKey("red_tulip");
    public static final class_5321<MoobloomVariant> ORANGE_TULIP = MoobloomVariants.createKey("orange_tulip");
    public static final class_5321<MoobloomVariant> WHITE_TULIP = MoobloomVariants.createKey("white_tulip");
    public static final class_5321<MoobloomVariant> PINK_TULIP = MoobloomVariants.createKey("pink_tulip");
    public static final class_5321<MoobloomVariant> OXEYE_DAISY = MoobloomVariants.createKey("oxeye_daisy");
    public static final class_5321<MoobloomVariant> CORNFLOWER = MoobloomVariants.createKey("cornflower");
    public static final class_5321<MoobloomVariant> LILY_OF_THE_VALLEY = MoobloomVariants.createKey("lily_of_the_valley");
    public static final class_5321<MoobloomVariant> ALLIUM = MoobloomVariants.createKey("allium");
    public static final class_5321<MoobloomVariant> BLUE_ORCHID = MoobloomVariants.createKey("blue_orchid");
    public static final class_5321<MoobloomVariant> CARNATION = MoobloomVariants.createKey("carnation");
    public static final class_5321<MoobloomVariant> MARIGOLD = MoobloomVariants.createKey("marigold");
    public static final class_5321<MoobloomVariant> PASQUEFLOWER = MoobloomVariants.createKey("pasqueflower");
    public static final class_5321<MoobloomVariant> DEFAULT = DANDELION;

    private static class_5321<MoobloomVariant> createKey(String string) {
        return class_5321.method_29179(WilderWildRegistries.MOOBLOOM_VARIANT, (class_2960)WWConstants.id(string));
    }

    private static void register(class_7891<MoobloomVariant> bootstrapContext, class_5321<MoobloomVariant> resourceKey, class_2248 flowerBlock, String name) {
        String texturePath = "entity/moobloom/moobloom_" + name;
        bootstrapContext.method_46838(resourceKey, (Object)new MoobloomVariant(new class_10726(WWConstants.id(texturePath)), flowerBlock.method_9564(), Optional.empty()));
    }

    public static Optional<class_6880.class_6883<MoobloomVariant>> selectVariantToSpawn(class_5819 randomSource, class_5455 registryAccess, class_10701 spawnContext) {
        class_2378 registry = registryAccess.method_30530(WilderWildRegistries.MOOBLOOM_VARIANT);
        List flowerFeatures = ((class_1959)spawnContext.comp_3582().comp_349()).method_30970().method_30982();
        ArrayList<class_2680> biomeFlowerStates = new ArrayList<class_2680>();
        for (class_2975 feature : flowerFeatures) {
            class_3037 class_30372 = feature.comp_333();
            if (!(class_30372 instanceof class_4638)) continue;
            class_4638 randomPatchConfiguration = (class_4638)class_30372;
            class_2975 configuredPlacedFeature = (class_2975)((class_6796)randomPatchConfiguration.comp_155().comp_349()).comp_334().comp_349();
            biomeFlowerStates.addAll(MoobloomVariants.getBlockStatesFromConfiguredFeature(configuredPlacedFeature, spawnContext.comp_3580(), randomSource));
        }
        List<class_6880.class_6883> variants = registry.method_42017().filter(reference -> biomeFlowerStates.contains(((MoobloomVariant)reference.comp_349()).getFlowerBlockState())).toList();
        return class_156.method_40083(variants, (class_5819)randomSource);
    }

    private static List<class_2680> getBlockStatesFromConfiguredFeature(class_2975<?, ?> feature, class_2338 pos, class_5819 random) {
        ArrayList<class_2680> blockStates = new ArrayList<class_2680>();
        class_3037 config = feature.comp_333();
        if (config instanceof class_4638) {
            class_4638 randomPatchConfiguration = (class_4638)config;
            class_2975 configuredPlacedFeature = (class_2975)((class_6796)randomPatchConfiguration.comp_155().comp_349()).comp_334().comp_349();
            blockStates.addAll(MoobloomVariants.getBlockStatesFromConfiguredFeature(configuredPlacedFeature, pos, random));
        } else if (config instanceof class_3175) {
            class_3175 simpleBlockConfiguration = (class_3175)config;
            blockStates.add(simpleBlockConfiguration.comp_156().method_23455(random, pos));
        }
        for (class_2975 nestedFeature : config.method_30649().toList()) {
            blockStates.addAll(MoobloomVariants.getBlockStatesFromConfiguredFeature(nestedFeature, pos, random));
        }
        return blockStates;
    }

    public static void bootstrap(class_7891<MoobloomVariant> bootstrapContext) {
        MoobloomVariants.register(bootstrapContext, DANDELION, class_2246.field_10182, "dandelion");
        MoobloomVariants.register(bootstrapContext, POPPY, class_2246.field_10449, "poppy");
        MoobloomVariants.register(bootstrapContext, AZURE_BLUET, class_2246.field_10573, "azure_bluet");
        MoobloomVariants.register(bootstrapContext, RED_TULIP, class_2246.field_10270, "red_tulip");
        MoobloomVariants.register(bootstrapContext, ORANGE_TULIP, class_2246.field_10048, "orange_tulip");
        MoobloomVariants.register(bootstrapContext, WHITE_TULIP, class_2246.field_10156, "white_tulip");
        MoobloomVariants.register(bootstrapContext, PINK_TULIP, class_2246.field_10315, "pink_tulip");
        MoobloomVariants.register(bootstrapContext, OXEYE_DAISY, class_2246.field_10554, "oxeye_daisy");
        MoobloomVariants.register(bootstrapContext, CORNFLOWER, class_2246.field_9995, "cornflower");
        MoobloomVariants.register(bootstrapContext, LILY_OF_THE_VALLEY, class_2246.field_10548, "lily_of_the_valley");
        MoobloomVariants.register(bootstrapContext, ALLIUM, class_2246.field_10226, "allium");
        MoobloomVariants.register(bootstrapContext, BLUE_ORCHID, class_2246.field_10086, "blue_orchid");
        MoobloomVariants.register(bootstrapContext, CARNATION, (class_2248)WWBlocks.CARNATION, "carnation");
        MoobloomVariants.register(bootstrapContext, MARIGOLD, (class_2248)WWBlocks.MARIGOLD, "marigold");
        MoobloomVariants.register(bootstrapContext, PASQUEFLOWER, (class_2248)WWBlocks.PASQUEFLOWER, "pasqueflower");
    }
}

