/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.frozenblock.wilderwild.block.SpongeBudBlock;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.worldgen.impl.feature.config.SpongeBudFeatureConfig;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6646;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpongeBudFeature
extends class_3031<SpongeBudFeatureConfig> {
    public SpongeBudFeature(@NotNull Codec<SpongeBudFeatureConfig> codec) {
        super(codec);
    }

    public static boolean generate(@NotNull class_5281 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull SpongeBudFeatureConfig config, @NotNull List<class_2350> directions) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        for (class_2350 direction : directions) {
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_25505((class_2382)pos, direction));
            if (!blockState.method_26164(config.canPlaceOn)) continue;
            class_2680 blockState2 = SpongeBudFeature.getStateForPlacement(level.method_8409(), state, (class_1922)level, pos, direction);
            if (blockState2 == null) {
                return false;
            }
            if (!((Boolean)blockState2.method_11654((class_2769)SpongeBudBlock.WATERLOGGED)).booleanValue()) continue;
            level.method_8652(pos, blockState2, 3);
            level.method_22350(pos).method_12039(pos);
            return true;
        }
        return false;
    }

    @Nullable
    private static class_2680 getStateForPlacement(class_5819 random, @NotNull class_2680 currentState, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_2350 lookingDirection) {
        SpongeBudBlock sponge = WWBlocks.SPONGE_BUD;
        if (!SpongeBudFeature.isValidStateForPlacement(level, pos, lookingDirection)) {
            return null;
        }
        class_2680 blockState = currentState.method_27852((class_2248)sponge) ? currentState : (currentState.method_26227().method_33659((class_3611)class_3612.field_15910) ? (class_2680)sponge.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)) : sponge.method_9564());
        blockState = lookingDirection.method_10166() == class_2350.class_2351.field_11052 ? (class_2680)((class_2680)blockState.method_11657((class_2769)SpongeBudBlock.field_11007, (Comparable)(lookingDirection == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475))).method_11657((class_2769)SpongeBudBlock.field_11177, (Comparable)class_2350.class_2353.field_11062.method_10183(random)) : (class_2680)((class_2680)blockState.method_11657((class_2769)SpongeBudBlock.field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)SpongeBudBlock.field_11177, (Comparable)lookingDirection.method_10153());
        return (class_2680)blockState.method_11657((class_2769)SpongeBudBlock.AGE, (Comparable)Integer.valueOf(random.method_43048(2)));
    }

    private static boolean isValidStateForPlacement(@NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction);
        return SpongeBudFeature.canAttachTo(level, direction, blockPos, level.method_8320(blockPos));
    }

    private static boolean canAttachTo(@NotNull class_1922 level, @NotNull class_2350 direction, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return class_2248.method_9501((class_265)state.method_26222(level, pos), (class_2350)direction.method_10153()) || class_2248.method_9501((class_265)state.method_26220(level, pos), (class_2350)direction.method_10153());
    }

    public boolean method_13151(@NotNull class_5821<SpongeBudFeatureConfig> context) {
        class_5281 worldGenLevel = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 randomSource = context.method_33654();
        SpongeBudFeatureConfig config = (SpongeBudFeatureConfig)context.method_33656();
        if (!class_6646.field_35697.test((Object)worldGenLevel, (Object)blockPos)) {
            return false;
        }
        List<class_2350> directions = config.shuffleDirections(randomSource);
        if (SpongeBudFeature.generate(worldGenLevel, blockPos, worldGenLevel.method_8320(blockPos), config, directions)) {
            return true;
        }
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        block0: for (class_2350 direction : directions) {
            mutableBlockPos.method_10101((class_2382)blockPos);
            List<class_2350> directions2 = config.shuffleDirections(randomSource, direction.method_10153());
            for (int i = 0; i < config.searchRange; ++i) {
                mutableBlockPos.method_25505((class_2382)blockPos, direction);
                class_2680 blockState = worldGenLevel.method_8320((class_2338)mutableBlockPos);
                if (!class_6646.field_35697.test((Object)worldGenLevel, (Object)mutableBlockPos) && !blockState.method_27852((class_2248)WWBlocks.SPONGE_BUD)) continue block0;
                if (!SpongeBudFeature.generate(worldGenLevel, (class_2338)mutableBlockPos, blockState, config, directions2)) continue;
                return true;
            }
        }
        return false;
    }
}

