/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4646;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.jetbrains.annotations.NotNull;

public class MapleFoliagePlacer
extends class_4646 {
    public static final MapCodec<MapleFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> MapleFoliagePlacer.method_28838((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.hangingLeavesChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hanging_leaves_extension_chance").forGetter(foliagePlacer -> Float.valueOf(foliagePlacer.hangingLeavesExtensionChance)), (App)class_4647.field_24931.fieldOf("alt_foliage_placer").forGetter(placer -> placer.altFoliagePlacer))).apply((Applicative)instance, MapleFoliagePlacer::new));
    private final float hangingLeavesChance;
    private final float hangingLeavesExtensionChance;
    private final class_4647 altFoliagePlacer;

    public MapleFoliagePlacer(class_6017 radius, class_6017 offset, int height, float hangingLeavesChance, float hangingLeavesExtensionChance, class_4647 altFoliagePlacer) {
        super(radius, offset, height);
        this.hangingLeavesChance = hangingLeavesChance;
        this.hangingLeavesExtensionChance = hangingLeavesExtensionChance;
        this.altFoliagePlacer = altFoliagePlacer;
    }

    @NotNull
    protected class_4648<?> method_28843() {
        return WWFeatures.MAPLE_FOLIAGE_PLACER;
    }

    public void method_23448(class_3746 level, class_4647.class_8179 setter, class_5819 random, class_4643 config, int trunkHeight, class_4647.class_5208 foliageAttachment, int foliageHeight, int radius, int offset) {
        if (!WWWorldgenConfig.NEW_MAPLES) {
            this.altFoliagePlacer.method_27385(level, setter, random, config, trunkHeight, foliageAttachment, this.altFoliagePlacer.method_26989(random, trunkHeight, config), this.altFoliagePlacer.method_23452(random, trunkHeight));
            return;
        }
        for (int relativeY = offset; relativeY >= offset - foliageHeight; --relativeY) {
            int newRadius = Math.max(radius + foliageAttachment.method_27389() - 1 - relativeY / 2, 0);
            if (relativeY <= offset - foliageHeight) {
                this.method_49247(level, setter, random, config, foliageAttachment.method_27388().method_10086(2), newRadius, relativeY, foliageAttachment.method_27390(), this.hangingLeavesChance, this.hangingLeavesExtensionChance);
                continue;
            }
            this.method_23449(level, setter, random, config, foliageAttachment.method_27388().method_10086(2), newRadius, relativeY, foliageAttachment.method_27390());
        }
    }
}

