/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3486;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class FallenLargeTrunkPlacer
extends class_5141 {
    private static final int STUMP_GEN_ATTEMPTS = 3;
    private static final class_6017 STUMP_DISTANCE_FROM_TRUNK = class_6019.method_35017((int)2, (int)4);
    private static final int MAX_STUMP_HEIGHT = 3;
    private static final class_6017 STUMP_HEIGHT = class_6019.method_35017((int)1, (int)3);
    private static final int STUMP_MAX_SEARCH_POSITIVE_Y = 10;
    private static final int STUMP_MAX_SEARCH_NEGATIVE_Y = 3;
    public static final MapCodec<FallenLargeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> FallenLargeTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("success_in_water_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.successInWaterChance))).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stump_placement_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.stumpPlacementChance))).apply((Applicative)instance, FallenLargeTrunkPlacer::new));
    public final float successInWaterChance;
    public final int minHeight;
    public final int maxHeight;
    public final float stumpPlacementChance;

    public FallenLargeTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, float successInWaterChance, float stumpPlacementChance) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.minHeight = baseHeight;
        this.maxHeight = baseHeight + firstRandomHeight + secondRandomHeight;
        this.successInWaterChance = successInWaterChance;
        this.stumpPlacementChance = stumpPlacementChance;
    }

    private static boolean isWaterAt(@NotNull class_3746 level, @NotNull class_2338 blockpos) {
        return level.method_35237(blockpos, fluidState -> fluidState.method_15767(class_3486.field_15517));
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return WWFeatures.FALLEN_LARGE_TRUNK_PLACER;
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, int height, @NotNull class_2338 startPos, @NotNull class_4643 config) {
        ArrayList foliageAttachments = Lists.newArrayList();
        class_2350 trunkDirection = class_2350.class_2353.field_11062.method_10183(random);
        if (FallenLargeTrunkPlacer.isWaterAt(level, startPos) && this.successInWaterChance <= random.method_43057()) {
            return foliageAttachments;
        }
        Pair<List<class_2338>, Optional<class_2350>> posesAndOffset = this.getAllSectionPoses(level, startPos, random, trunkDirection);
        for (class_2338 blockPos : (List)posesAndOffset.getFirst()) {
            this.method_27402(level, replacer, random, blockPos, config, state -> (class_2680)state.method_47968((class_2769)class_2465.field_11459, (Comparable)trunkDirection.method_10166()));
        }
        Optional optionalOffsetDirection = (Optional)posesAndOffset.getSecond();
        if (optionalOffsetDirection.isPresent() && this.stumpPlacementChance <= random.method_43057()) {
            class_2350 offsetDirection = (class_2350)optionalOffsetDirection.get();
            List<class_2338> stumpPoses = FallenLargeTrunkPlacer.findStumpPoses(level, random, startPos, trunkDirection, offsetDirection);
            class_2338.class_2339 stumpPos = new class_2338.class_2339();
            for (class_2338 blockPos : stumpPoses) {
                int stumpHeight = STUMP_HEIGHT.method_35008(random);
                for (int i = 0; i < stumpHeight; ++i) {
                    this.method_35375(level, replacer, random, (class_2338)stumpPos.method_25504((class_2382)blockPos, 0, i, 0), config);
                }
            }
        }
        return foliageAttachments;
    }

    @NotNull
    private Pair<List<class_2338>, Optional<class_2350>> getAllSectionPoses(@NotNull class_3746 level, class_2338 startPos, @NotNull class_5819 random, class_2350 trunkDirection) {
        ArrayList poses = Lists.newArrayList();
        Optional<Object> optionalOffsetDirection = Optional.empty();
        List<class_2338> firstPoses = FallenLargeTrunkPlacer.getSectionPoses(true, level, random, startPos, this.minHeight, this.maxHeight, trunkDirection);
        if (!firstPoses.isEmpty()) {
            class_2350.class_2351 axis = trunkDirection.method_10166();
            if (axis == class_2350.class_2351.field_11048) {
                axis = class_2350.class_2351.field_11051;
            } else if (axis == class_2350.class_2351.field_11051) {
                axis = class_2350.class_2351.field_11048;
            }
            class_2350 secondOffset = AdvancedMath.randomDir((class_2350.class_2351)axis);
            List<class_2338> secondPoses = FallenLargeTrunkPlacer.getSectionPoses(true, level, random, startPos.method_10093(secondOffset), this.minHeight, this.maxHeight, trunkDirection);
            if (!secondPoses.isEmpty()) {
                List<class_2338> thirdPoses = FallenLargeTrunkPlacer.getSectionPoses(false, level, random, startPos.method_10093(class_2350.field_11036), this.minHeight, this.maxHeight, trunkDirection);
                List<class_2338> fourthPoses = FallenLargeTrunkPlacer.getSectionPoses(false, level, random, startPos.method_10093(class_2350.field_11036).method_10093(secondOffset), this.minHeight, this.maxHeight, trunkDirection);
                poses.addAll(firstPoses);
                poses.addAll(secondPoses);
                poses.addAll(thirdPoses);
                poses.addAll(fourthPoses);
                optionalOffsetDirection = Optional.of(secondOffset);
            }
        }
        return Pair.of((Object)poses, optionalOffsetDirection);
    }

    @NotNull
    private static List<class_2338> getSectionPoses(boolean requiresUnderneath, @NotNull class_3746 level, @NotNull class_5819 random, @NotNull class_2338 startPos, int minHeight, int maxHeight, @NotNull class_2350 trunkDirection) {
        ArrayList finalizedPoses = Lists.newArrayList();
        int height = random.method_39332(minHeight, maxHeight);
        int differenceFromMaxHeight = maxHeight - height;
        int directionOffset = differenceFromMaxHeight <= 0 ? 0 : random.method_39332(0, maxHeight - height);
        startPos = startPos.method_10079(trunkDirection, directionOffset);
        class_2338 endPos = startPos.method_10079(trunkDirection, height);
        class_2338 secondToEndPos = endPos.method_10093(trunkDirection.method_10153());
        Iterable poses = class_2338.method_10097((class_2338)startPos, (class_2338)endPos);
        int aboveSolidAmount = 0;
        boolean isEndAboveSolid = false;
        if (!requiresUnderneath) {
            poses.forEach(pos -> finalizedPoses.add(pos.method_10062()));
            return finalizedPoses;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 blockPos : poses) {
            mutable.method_10101((class_2382)blockPos);
            if (class_2944.method_27371((class_3746)level, (class_2338)mutable)) {
                if (FallenLargeTrunkPlacer.isPosSolidGround(level, (class_2338)mutable.method_10098(class_2350.field_11033))) {
                    ++aboveSolidAmount;
                    mutable.method_10098(class_2350.field_11036);
                    if (!mutable.equals((Object)endPos) && !mutable.equals((Object)secondToEndPos)) continue;
                    isEndAboveSolid = true;
                    continue;
                }
                mutable.method_10098(class_2350.field_11036);
                if (!mutable.equals((Object)startPos)) continue;
                return List.of();
            }
            return List.of();
        }
        if (isEndAboveSolid || (double)aboveSolidAmount / (double)height > 0.5) {
            poses.forEach(pos -> finalizedPoses.add(pos.method_10062()));
            return finalizedPoses;
        }
        return List.of();
    }

    @NotNull
    private static List<class_2338> findStumpPoses(class_3746 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2350 trunkDirection, class_2350 offsetDirection) {
        for (int i = 0; i < 3; ++i) {
            List<class_2338> stumpPoses;
            int step;
            int distance = STUMP_DISTANCE_FROM_TRUNK.method_35008(random);
            class_2350 stumpSearchDirection = trunkDirection.method_10153();
            class_2338 searchStartPos = pos.method_10079(stumpSearchDirection, 1 + distance);
            class_2338.class_2339 stumpPos = searchStartPos.method_25503();
            List<class_2338> initialStumpPoses = FallenLargeTrunkPlacer.getStumpPosesIfPossible(level, (class_2338)stumpPos, stumpSearchDirection, offsetDirection);
            if (!initialStumpPoses.isEmpty()) {
                return initialStumpPoses;
            }
            for (step = 1; step <= 10; ++step) {
                stumpPos.method_10098(class_2350.field_11036);
                stumpPoses = FallenLargeTrunkPlacer.getStumpPosesIfPossible(level, (class_2338)stumpPos, stumpSearchDirection, offsetDirection);
                if (stumpPoses.isEmpty()) continue;
                return stumpPoses;
            }
            stumpPos.method_10101((class_2382)searchStartPos);
            for (step = 1; step <= 3; ++step) {
                stumpPos.method_10098(class_2350.field_11033);
                stumpPoses = FallenLargeTrunkPlacer.getStumpPosesIfPossible(level, (class_2338)stumpPos, stumpSearchDirection, offsetDirection);
                if (stumpPoses.isEmpty()) continue;
                return stumpPoses;
            }
        }
        return List.of();
    }

    @NotNull
    private static @Unmodifiable List<class_2338> getStumpPosesIfPossible(@NotNull class_3746 level, @NotNull class_2338 pos, @NotNull class_2350 stumpSearchDirection, class_2350 offsetDirection) {
        ArrayList finalizedPoses = Lists.newArrayList();
        class_2338.class_2339 stumpPos = pos.method_25503();
        class_2338.class_2339 belowStumpPos = stumpPos.method_25503().method_10098(class_2350.field_11033);
        if (!FallenLargeTrunkPlacer.canPlaceStumpAtPos(level, (class_2338)belowStumpPos, (class_2338)stumpPos)) {
            return List.of();
        }
        finalizedPoses.add(stumpPos.method_10062());
        stumpPos.method_25505((class_2382)pos, offsetDirection);
        belowStumpPos.method_25505((class_2382)stumpPos, class_2350.field_11033);
        if (!FallenLargeTrunkPlacer.canPlaceStumpAtPos(level, (class_2338)belowStumpPos, (class_2338)stumpPos)) {
            return List.of();
        }
        finalizedPoses.add(stumpPos.method_10062());
        stumpPos.method_25505((class_2382)pos, stumpSearchDirection);
        belowStumpPos.method_25505((class_2382)stumpPos, class_2350.field_11033);
        if (!FallenLargeTrunkPlacer.canPlaceStumpAtPos(level, (class_2338)belowStumpPos, (class_2338)stumpPos)) {
            return List.of();
        }
        finalizedPoses.add(stumpPos.method_10062());
        stumpPos.method_25505((class_2382)pos, offsetDirection).method_10098(stumpSearchDirection);
        belowStumpPos.method_25505((class_2382)stumpPos, class_2350.field_11033);
        if (!FallenLargeTrunkPlacer.canPlaceStumpAtPos(level, (class_2338)belowStumpPos, (class_2338)stumpPos)) {
            return List.of();
        }
        finalizedPoses.add(stumpPos.method_10062());
        return finalizedPoses;
    }

    private static boolean canPlaceStumpAtPos(class_3746 level, @NotNull class_2338 floorPos, class_2338 pos) {
        return FallenLargeTrunkPlacer.isPosSolidGround(level, floorPos) && level.method_16358(floorPos, blockState -> blockState.method_26164(WWBlockTags.FALLEN_TREE_STUMP_PLACEABLE_ON)) && class_2944.method_27371((class_3746)level, (class_2338)pos) && FallenLargeTrunkPlacer.isFreeWithinStumpHeight(level, pos);
    }

    private static boolean isPosSolidGround(class_3746 level, @NotNull class_2338 pos) {
        return !class_2944.method_27371((class_3746)level, (class_2338)pos) && !class_2944.method_16420((class_3746)level, (class_2338)pos);
    }

    private static boolean isFreeWithinStumpHeight(class_3746 level, @NotNull class_2338 pos) {
        class_2338.class_2339 mutablePos = pos.method_25503();
        for (int i = 0; i < 3; ++i) {
            if (!class_2944.method_27371((class_3746)level, (class_2338)mutablePos)) {
                return false;
            }
            mutablePos.method_10098(class_2350.field_11036);
        }
        return true;
    }
}

