/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.modification;

import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.tag.WWBiomeTags;
import net.frozenblock.wilderwild.worldgen.features.placed.WWAquaticPlaced;
import net.minecraft.class_2893;
import net.minecraft.class_2960;

public final class WWAquaticGeneration {
    private WWAquaticGeneration() {
        throw new UnsupportedOperationException("WWAquaticGeneration contains only static declarations.");
    }

    public static void generateAquaticFeatures() {
        WWAquaticGeneration.generateAlgae();
        WWAquaticGeneration.generatePlankton();
        WWAquaticGeneration.generateSeaWhips();
        WWAquaticGeneration.generateSeagrass();
        WWAquaticGeneration.generateSpongeBuds();
        WWAquaticGeneration.generateBarnacles();
        WWAquaticGeneration.generateCattails();
        WWAquaticGeneration.generateSeaAnemones();
        WWAquaticGeneration.generateTubeWorms();
        WWAquaticGeneration.generateHydrothermalVent();
        WWAquaticGeneration.generateMoss();
    }

    private static void generateAlgae() {
        BiomeModifications.create((class_2960)WWConstants.id("algae_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.algae) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_ALGAE_SMALL)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_ALGAE_SMALL.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_ALGAE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_ALGAE.getKey());
                }
            }
        });
    }

    private static void generatePlankton() {
        BiomeModifications.create((class_2960)WWConstants.id("plankton_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.plankton) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_PLANKTON)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_PLANKTON.getKey());
                }
            }
        });
    }

    private static void generateSeagrass() {
        BiomeModifications.create((class_2960)WWConstants.id("seagrass_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.seagrass) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_MEADOW_SEAGRASS)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.SEAGRASS_MEADOW.getKey());
                }
            }
        });
    }

    private static void generateSpongeBuds() {
        BiomeModifications.create((class_2960)WWConstants.id("sponge_bud_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.spongeBud) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SPONGE_BUD)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.SPONGE_BUDS.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SPONGE_BUD_RARE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.SPONGE_BUDS_RARE.getKey());
                }
            }
        });
    }

    private static void generateBarnacles() {
        BiomeModifications.create((class_2960)WWConstants.id("barnacle_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.barnacle) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_BARNACLES_COMMON)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.BARNACLES_COMMON.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_BARNACLES_STRUCTURE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.BARNACLES_STRUCTURE.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_BARNACLES)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.BARNACLES.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_BARNACLES_SPARSE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.BARNACLES_SPARSE.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_BARNACLES_RARE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.BARNACLES_RARE.getKey());
                }
            }
        });
    }

    private static void generateCattails() {
        BiomeModifications.create((class_2960)WWConstants.id("cattail_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.cattail) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_CATTAIL)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_CATTAIL.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_CATTAIL_UNCOMMON)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_CATTAIL_UNCOMMON.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_CATTAIL_COMMON)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_CATTAIL_COMMON.getKey());
                }
            }
        });
    }

    private static void generateSeaAnemones() {
        BiomeModifications.create((class_2960)WWConstants.id("sea_anemone_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.seaAnemone) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SEA_ANEMONE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_SEA_ANEMONE.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SEA_ANEMONE_SPARSE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_SEA_ANEMONE_SPARSE.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SEA_ANEMONE_RARE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_SEA_ANEMONE_RARE.getKey());
                }
            }
        });
    }

    private static void generateSeaWhips() {
        BiomeModifications.create((class_2960)WWConstants.id("sea_whip_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.seaWhip) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SEA_WHIP)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_SEA_WHIP.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SEA_WHIP_SPARSE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_SEA_WHIP_SPARSE.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_SEA_WHIP_RARE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_SEA_WHIP_RARE.getKey());
                }
            }
        });
    }

    private static void generateTubeWorms() {
        BiomeModifications.create((class_2960)WWConstants.id("tube_worm_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.tubeWorm) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_TUBE_WORMS)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_TUBE_WORMS.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_TUBE_WORMS_RARE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.PATCH_TUBE_WORMS_RARE.getKey());
                }
            }
        });
    }

    private static void generateHydrothermalVent() {
        BiomeModifications.create((class_2960)WWConstants.id("hydrothermal_vent_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            if (WWWorldgenConfig.get().aquaticGeneration.hydrothermalVent) {
                BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
                boolean useTubeWorms = WWWorldgenConfig.get().aquaticGeneration.tubeWorm;
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_HYDROTHERMAL_VENT)) {
                    generationSettings.addFeature(class_2893.class_2895.field_35182, useTubeWorms ? WWAquaticPlaced.HYDROTHERMAL_VENT_TUBE_WORMS.getKey() : WWAquaticPlaced.HYDROTHERMAL_VENT.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_HYDROTHERMAL_VENT_RARE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_35182, useTubeWorms ? WWAquaticPlaced.HYDROTHERMAL_VENT_TUBE_WORMS_RARE.getKey() : WWAquaticPlaced.HYDROTHERMAL_VENT_RARE.getKey());
                }
            }
        });
    }

    private static void generateMoss() {
        BiomeModifications.create((class_2960)WWConstants.id("ocean_moss_generation")).add(ModificationPhase.ADDITIONS, BiomeSelectors.all(), (biomeSelectionContext, context) -> {
            BiomeModificationContext.GenerationSettingsContext generationSettings = context.getGenerationSettings();
            if (WWWorldgenConfig.get().aquaticGeneration.oceanMossGeneration && biomeSelectionContext.hasTag(WWBiomeTags.HAS_OCEAN_MOSS)) {
                generationSettings.addFeature(class_2893.class_2895.field_13177, WWAquaticPlaced.OCEAN_MOSS.getKey());
            }
            if (WWWorldgenConfig.get().aquaticGeneration.oceanAuburnMossGeneration) {
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_CREEPING_AUBURN_MOSS_UNDERWATER)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.AUBURN_CREEPING_MOSS_UNDERWATER.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_AUBURN_MOSS_UNDERWATER)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.AUBURN_MOSS_UNDERWATER.getKey());
                }
                if (biomeSelectionContext.hasTag(WWBiomeTags.HAS_AUBURN_MOSS_UNDERWATER_RARE)) {
                    generationSettings.addFeature(class_2893.class_2895.field_13178, WWAquaticPlaced.AUBURN_MOSS_UNDERWATER_RARE.getKey());
                }
            }
        });
    }
}

