/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datagen.model;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.block.HugePaleMushroomBlock;
import net.frozenblock.wilderwild.block.ShelfFungiBlock;
import net.frozenblock.wilderwild.block.state.properties.TubeWormsPart;
import net.frozenblock.wilderwild.client.renderer.item.properties.FireflyBottleColorProperty;
import net.frozenblock.wilderwild.client.renderer.special.StoneChestSpecialRenderer;
import net.frozenblock.wilderwild.entity.variant.firefly.FireflyColors;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WWItems;
import net.minecraft.class_10410;
import net.minecraft.class_10439;
import net.minecraft.class_10494;
import net.minecraft.class_10515;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5691;
import org.jetbrains.annotations.NotNull;

public final class WWModelHelper {
    public static final List<Pair<class_2746, Function<class_2960, class_4935>>> MULTIFACE_GENERATOR_NO_UV_LOCK = List.of(Pair.of((Object)class_2741.field_12489, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model)), Pair.of((Object)class_2741.field_12487, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)), Pair.of((Object)class_2741.field_12540, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)), Pair.of((Object)class_2741.field_12527, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)), Pair.of((Object)class_2741.field_12519, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893)), Pair.of((Object)class_2741.field_12546, resourceLocation -> class_4935.method_25824().method_25828(class_4936.field_22887, resourceLocation).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)));
    private static final class_4942 LEAF_LITTER_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_leaf_litter")), Optional.empty(), new class_4945[]{class_4945.field_23011});
    private static final class_4946.class_4947 LEAF_LITTER_PROVIDER = class_4946.method_25918(class_4944::method_25872, (class_4942)LEAF_LITTER_MODEL);
    private static final class_4942 VERTICAL_HOLLOWED_LOG_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_hollowed_log")), Optional.empty(), new class_4945[]{class_4945.field_23018, class_4945.field_27791, class_4945.field_23013});
    private static final class_4942 HORIZONTAL_HOLLOWED_LOG_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_hollowed_log_horizontal")), Optional.of("_horizontal"), new class_4945[]{class_4945.field_23018, class_4945.field_27791, class_4945.field_23013});
    private static final class_4942 MESOGLEA_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_mesoglea")), Optional.empty(), new class_4945[]{class_4945.field_23011});
    private static final class_4942 NEMATOCYST_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_nematocyst")), Optional.empty(), new class_4945[]{class_4945.field_27791, class_4945.field_23033});
    private static final class_4942 SHELF_FUNGI_1_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_shelf_fungi_1")), Optional.of("_1"), new class_4945[]{class_4945.field_23015, class_4945.field_23014});
    private static final class_4942 SHELF_FUNGI_2_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_shelf_fungi_2")), Optional.of("_2"), new class_4945[]{class_4945.field_23015, class_4945.field_23014});
    private static final class_4942 SHELF_FUNGI_3_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_shelf_fungi_3")), Optional.of("_3"), new class_4945[]{class_4945.field_23015, class_4945.field_23014});
    private static final class_4942 SHELF_FUNGI_4_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_shelf_fungi_4")), Optional.of("_4"), new class_4945[]{class_4945.field_23015, class_4945.field_23014});
    private static final class_4942 MULTIFACE_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_multiface_block")), Optional.empty(), new class_4945[]{class_4945.field_23011});
    private static final class_4942 ALGAE_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_algae")), Optional.empty(), new class_4945[]{class_4945.field_23011});
    private static final class_4942 PLANKTON_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_plankton")), Optional.empty(), new class_4945[]{class_4945.field_23011});
    private static final class_4942 SEA_ANEMONE_MODEL = new class_4942(Optional.of(WWConstants.id("block/template_sea_anemone")), Optional.empty(), new class_4945[]{class_4945.field_23034, class_4945.field_23015});

    public static void createLeafLitter(@NotNull class_4910 generator, class_2248 litter) {
        WWModelHelper.createLeafLitter(generator, litter, litter);
    }

    public static void createLeafLitter(@NotNull class_4910 generator, class_2248 litter, class_2248 source) {
        class_2960 modelId = LEAF_LITTER_PROVIDER.get(source).method_25916(litter, generator.field_22831);
        generator.method_25600(litter);
        generator.field_22830.accept(class_4910.method_25644((class_2248)litter, (class_2960)modelId));
    }

    public static void createHollowedLog(@NotNull class_4910 generator, class_2248 hollowedLog, class_2248 sideAndEndSource, class_2248 insideSource) {
        WWModelHelper.createHollowedLog(generator, hollowedLog, sideAndEndSource, insideSource, sideAndEndSource);
    }

    public static void createStrippedHollowedLog(@NotNull class_4910 generator, class_2248 hollowedLog, class_2248 sideSource, class_2248 insideAndEndSource) {
        WWModelHelper.createHollowedLog(generator, hollowedLog, sideSource, insideAndEndSource, insideAndEndSource);
    }

    public static void createHollowedLog(@NotNull class_4910 generator, class_2248 hollowedLog, class_2248 sideSource, class_2248 insideSource, class_2248 endSource) {
        class_4944 sideTextureMapping = class_4944.method_25897((class_2248)sideSource);
        class_4944 insideTextureMapping = class_4944.method_25897((class_2248)insideSource);
        class_4944 endTextureMapping = class_4944.method_25897((class_2248)endSource);
        class_4944 hollowedTextureMapping = new class_4944();
        hollowedTextureMapping.method_25868(class_4945.field_23018, sideTextureMapping.method_25867(class_4945.field_23018));
        hollowedTextureMapping.method_25868(class_4945.field_27791, insideTextureMapping.method_25867(class_4945.field_23018));
        hollowedTextureMapping.method_25868(class_4945.field_23013, endTextureMapping.method_25867(class_4945.field_23013));
        class_2960 verticalModelId = VERTICAL_HOLLOWED_LOG_MODEL.method_25846(hollowedLog, hollowedTextureMapping, generator.field_22831);
        class_2960 horizontalModelId = HORIZONTAL_HOLLOWED_LOG_MODEL.method_25846(hollowedLog, hollowedTextureMapping, generator.field_22831);
        class_4925 multiVariantGenerator = class_4925.method_25769((class_2248)hollowedLog).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12496).method_25793((Comparable)class_2350.class_2351.field_11052, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)verticalModelId)).method_25793((Comparable)class_2350.class_2351.field_11051, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModelId).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)));
        generator.field_22830.accept(multiVariantGenerator);
        generator.field_22831.accept(class_4941.method_25840((class_1792)hollowedLog.method_8389()), new class_4940(verticalModelId));
    }

    public static void createStoneChest(@NotNull class_4910 generator, class_2248 stoneChest, class_2248 particleTexture, class_2960 texture) {
        generator.method_65403(stoneChest, particleTexture);
        class_1792 item = stoneChest.method_8389();
        class_2960 resourceLocation2 = class_4943.field_55252.method_48525(item, class_4944.method_25901((class_2248)particleTexture), generator.field_22831);
        class_10439.class_10441 unbaked = class_10410.method_65482((class_2960)resourceLocation2, (class_10515.class_10516)new StoneChestSpecialRenderer.Unbaked(texture));
        generator.field_55238.method_65460(item, unbaked);
    }

    public static void createMesoglea(@NotNull class_4910 generator, class_2248 mesogleaBlock) {
        class_4944 mesogleaTextureMapping = new class_4944();
        mesogleaTextureMapping.method_25868(class_4945.field_23011, class_4944.method_25860((class_2248)mesogleaBlock));
        class_2960 modelId = MESOGLEA_MODEL.method_25846(mesogleaBlock, mesogleaTextureMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)mesogleaBlock, (class_2960)modelId));
        generator.field_22831.accept(class_4941.method_25840((class_1792)mesogleaBlock.method_8389()), new class_4940(modelId));
    }

    public static void createNematocyst(@NotNull class_4910 generator, class_2248 nematocystBlock) {
        class_4922 multiPartGenerator = class_4922.method_25758((class_2248)nematocystBlock);
        class_4944 nematocystTextureMapping = new class_4944();
        nematocystTextureMapping.method_25868(class_4945.field_27791, class_4944.method_25860((class_2248)nematocystBlock));
        nematocystTextureMapping.method_25868(class_4945.field_23033, class_4944.method_25866((class_2248)nematocystBlock, (String)"_outer"));
        class_2960 nematocystModel = NEMATOCYST_MODEL.method_25846(nematocystBlock, nematocystTextureMapping, generator.field_22831);
        class_4918.class_4921 terminalCondition = (class_4918.class_4921)class_156.method_654((Object)class_4918.method_25744(), terminalConditionx -> MULTIFACE_GENERATOR_NO_UV_LOCK.stream().map(Pair::getFirst).forEach(booleanPropertyx -> terminalConditionx.method_25751((class_2769)booleanPropertyx, (Comparable)Boolean.valueOf(false))));
        for (Pair<class_2746, Function<class_2960, class_4935>> pair : MULTIFACE_GENERATOR_NO_UV_LOCK) {
            class_2746 booleanProperty = (class_2746)pair.getFirst();
            Function function = (Function)pair.getSecond();
            if (!nematocystBlock.method_9564().method_28498((class_2769)booleanProperty)) continue;
            multiPartGenerator.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)booleanProperty, (Comparable)Boolean.valueOf(true)), (class_4935)function.apply(nematocystModel));
            multiPartGenerator.method_25760((class_4918)terminalCondition, (class_4935)function.apply(nematocystModel));
        }
        generator.method_25600(nematocystBlock);
        generator.field_22830.accept(multiPartGenerator);
    }

    public static void createHangingFroglight(@NotNull class_4910 generator, class_2248 bodyBlock, @NotNull class_2248 headBlock) {
        generator.method_25537(headBlock.method_8389());
        generator.method_25603(headBlock, class_4910.class_4913.field_22840);
        generator.method_25603(bodyBlock, class_4910.class_4913.field_22840);
    }

    public static void createShelfFungi(@NotNull class_4910 generator, @NotNull class_2248 shelfFungiBlock) {
        class_4944 shelfFungiTextureMapping = new class_4944();
        shelfFungiTextureMapping.method_25868(class_4945.field_23015, class_4944.method_25860((class_2248)shelfFungiBlock));
        shelfFungiTextureMapping.method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)shelfFungiBlock, (String)"_bottom"));
        class_2960 model1 = SHELF_FUNGI_1_MODEL.method_25846(shelfFungiBlock, shelfFungiTextureMapping, generator.field_22831);
        class_2960 model2 = SHELF_FUNGI_2_MODEL.method_25846(shelfFungiBlock, shelfFungiTextureMapping, generator.field_22831);
        class_2960 model3 = SHELF_FUNGI_3_MODEL.method_25846(shelfFungiBlock, shelfFungiTextureMapping, generator.field_22831);
        class_2960 model4 = SHELF_FUNGI_4_MODEL.method_25846(shelfFungiBlock, shelfFungiTextureMapping, generator.field_22831);
        generator.method_25537(shelfFungiBlock.method_8389());
        generator.field_22830.accept(class_4925.method_25769((class_2248)shelfFungiBlock).method_25775((class_4926)class_4926.method_25783((class_2769)ShelfFungiBlock.STAGE).method_25793((Comparable)Integer.valueOf(1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model1)).method_25793((Comparable)Integer.valueOf(2), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model2)).method_25793((Comparable)Integer.valueOf(3), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model3)).method_25793((Comparable)Integer.valueOf(4), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model4))).method_25775((class_4926)class_4926.method_25784((class_2769)ShelfFungiBlock.field_11007, (class_2769)ShelfFungiBlock.field_11177).method_25797((Comparable)class_2738.field_12473, (Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2738.field_12473, (Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2738.field_12473, (Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2738.field_12473, (Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2738.field_12475, (Comparable)class_2350.field_11043, class_4935.method_25824()).method_25797((Comparable)class_2738.field_12475, (Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2738.field_12475, (Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2738.field_12475, (Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25797((Comparable)class_2738.field_12471, (Comparable)class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2738.field_12471, (Comparable)class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25797((Comparable)class_2738.field_12471, (Comparable)class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25797((Comparable)class_2738.field_12471, (Comparable)class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893))));
    }

    public static void createMultifaceBlock(@NotNull class_4910 generator, class_2248 multifaceBlock) {
        class_4944 multifaceTextureMapping = new class_4944();
        multifaceTextureMapping.method_25868(class_4945.field_23011, class_4944.method_25860((class_2248)multifaceBlock));
        MULTIFACE_MODEL.method_25846(multifaceBlock, multifaceTextureMapping, generator.field_22831);
        generator.method_33520(multifaceBlock);
    }

    public static void generateCopperHorn(class_4915 generator, class_1792 item) {
        class_10439.class_10441 unbaked = class_10410.method_65481((class_2960)class_4941.method_25840((class_1792)item));
        class_10439.class_10441 unbaked2 = class_10410.method_65481((class_2960)WWConstants.id("item/copper_horn_tooting"));
        generator.method_65436(item, class_10410.method_65479(), unbaked2, unbaked);
    }

    public static void generateMilkweedPod(class_4915 generator, class_1792 item) {
        class_10439.class_10441 unbaked = class_10410.method_65481((class_2960)class_4941.method_25840((class_1792)item));
        class_10439.class_10441 unbaked2 = class_10410.method_65481((class_2960)WWConstants.id("item/milkweed_pod_blowing"));
        generator.method_65436(item, class_10410.method_65479(), unbaked2, unbaked);
    }

    public static void generateEchoGlass(class_4915 generator, class_1792 item) {
        generator.field_55245.method_65460(item, class_10410.method_65484((class_2769)WWBlockStateProperties.DAMAGE, (class_10439.class_10441)class_10410.method_65481((class_2960)class_4941.method_25840((class_1792)item)), Map.of(1, class_10410.method_65481((class_2960)WWConstants.id("item/echo_glass_1")), 2, class_10410.method_65481((class_2960)WWConstants.id("item/echo_glass_2")), 3, class_10410.method_65481((class_2960)WWConstants.id("item/echo_glass_3")))));
    }

    public static void generatePaleMushroomBlock(@NotNull class_4910 generator) {
        HugePaleMushroomBlock block = WWBlocks.PALE_MUSHROOM_BLOCK;
        class_2960 resourceLocation = class_4943.field_22937.method_25846((class_2248)block, class_4944.method_25872((class_2248)block), generator.field_22831);
        class_2960 insideTexture = class_4944.method_25866((class_2248)block, (String)"_inside");
        generator.field_22830.accept(class_4922.method_25758((class_2248)block).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)insideTexture)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)insideTexture).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)insideTexture).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)insideTexture).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)insideTexture).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)insideTexture).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)false)));
        generator.method_25623((class_2248)block, class_4946.field_23036.method_25922((class_2248)block, "_inventory", generator.field_22831));
    }

    public static void generateFireflyBottles(@NotNull class_4915 generator) {
        ArrayList switchCases = new ArrayList();
        FireflyColors.getVanillaColors().forEach(fireflyColor -> {
            if (fireflyColor.equals(WWConstants.string("on"))) {
                return;
            }
            class_2960 colorKey = class_2960.method_60654((String)fireflyColor);
            class_2960 location = class_2960.method_60655((String)colorKey.method_12836(), (String)("item/" + colorKey.method_12832() + "_firefly_bottle"));
            switchCases.add(class_10410.method_65497((Object)colorKey, (class_10439.class_10441)class_10410.method_65481((class_2960)class_4943.field_22938.method_25852(location, class_4944.method_25895((class_2960)location), generator.field_55246))));
        });
        generator.field_55245.method_65460((class_1792)WWItems.FIREFLY_BOTTLE, class_10410.method_65493((class_10494)new FireflyBottleColorProperty(), (class_10439.class_10441)class_10410.method_65481((class_2960)generator.method_65434((class_1792)WWItems.FIREFLY_BOTTLE, class_4943.field_22938)), switchCases));
    }

    public static void createHibiscus(@NotNull class_4910 generator, class_2248 block, class_2248 pottedBlock, class_4910.class_4913 plantType) {
        generator.method_25548(block, plantType);
        class_4944 textureMapping = class_4944.method_25883((class_4945)class_4945.field_23026, (class_2960)class_4944.method_25860((class_2248)pottedBlock));
        class_2960 resourceLocation = plantType.method_25727().method_25846(pottedBlock, textureMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)pottedBlock, (class_2960)resourceLocation));
    }

    public static void createIcicle(@NotNull class_4910 generator) {
        class_4926.class_4928 c2 = class_4926.method_25784((class_2769)class_2741.field_28062, (class_2769)class_2741.field_28063);
        for (class_5691 dripstoneThickness : class_5691.values()) {
            c2.method_25797((Comparable)class_2350.field_11036, (Comparable)dripstoneThickness, WWModelHelper.createIcicleVariant(generator, class_2350.field_11036, dripstoneThickness));
        }
        for (class_5691 dripstoneThickness : class_5691.values()) {
            c2.method_25797((Comparable)class_2350.field_11033, (Comparable)dripstoneThickness, WWModelHelper.createIcicleVariant(generator, class_2350.field_11033, dripstoneThickness));
        }
        generator.field_22830.accept(class_4925.method_25769((class_2248)WWBlocks.ICICLE).method_25775((class_4926)c2));
    }

    @NotNull
    private static class_4935 createIcicleVariant(@NotNull class_4910 generator, @NotNull class_2350 direction, @NotNull class_5691 dripstoneThickness) {
        String string = "_" + direction.method_15434() + "_" + dripstoneThickness.method_15434();
        class_4944 textureMapping = class_4944.method_25880((class_2960)class_4944.method_25866((class_2248)WWBlocks.ICICLE, (String)string));
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4943.field_28080.method_25847((class_2248)WWBlocks.ICICLE, string, textureMapping, generator.field_22831));
    }

    public static void createFragileIce(@NotNull class_4910 generator) {
        class_2960 leastCrackedModelId = generator.method_25557((class_2248)WWBlocks.FRAGILE_ICE, "_0", class_4943.field_22972, class_4944::method_25875);
        generator.field_22830.accept(class_4925.method_25769((class_2248)WWBlocks.FRAGILE_ICE).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12556).method_25793((Comparable)Integer.valueOf(0), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leastCrackedModelId)).method_25793((Comparable)Integer.valueOf(1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)generator.method_25557((class_2248)WWBlocks.FRAGILE_ICE, "_1", class_4943.field_22972, class_4944::method_25875))).method_25793((Comparable)Integer.valueOf(2), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)generator.method_25557((class_2248)WWBlocks.FRAGILE_ICE, "_2", class_4943.field_22972, class_4944::method_25875)))));
        generator.field_55238.method_65460(WWBlocks.FRAGILE_ICE.method_8389(), class_10410.method_65481((class_2960)leastCrackedModelId));
    }

    public static void createSeaAnemone(@NotNull class_4910 generator, class_2248 seaAnemoneBlock) {
        class_4944 seaAnemoneTextureMapping = new class_4944();
        seaAnemoneTextureMapping.method_25868(class_4945.field_23034, class_4944.method_25866((class_2248)seaAnemoneBlock, (String)"_stem"));
        seaAnemoneTextureMapping.method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)seaAnemoneBlock, (String)"_top"));
        class_2960 modelId = SEA_ANEMONE_MODEL.method_25846(seaAnemoneBlock, seaAnemoneTextureMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)seaAnemoneBlock, (class_2960)modelId));
        generator.method_25537(seaAnemoneBlock.method_8389());
    }

    public static void createSeaWhip(@NotNull class_4910 generator) {
        generator.method_25537(WWBlocks.SEA_WHIP.method_8389());
        generator.method_25603((class_2248)WWBlocks.SEA_WHIP, class_4910.class_4913.field_22840);
    }

    public static void createAlgae(@NotNull class_4910 generator) {
        generator.method_25600((class_2248)WWBlocks.ALGAE);
        class_2960 model = generator.method_25557((class_2248)WWBlocks.ALGAE, "", ALGAE_MODEL, class_4944::method_25869);
        generator.field_22830.accept(class_4910.method_25644((class_2248)WWBlocks.ALGAE, (class_2960)model));
    }

    public static void createPlankton(@NotNull class_4910 generator) {
        generator.method_25600((class_2248)WWBlocks.PLANKTON);
        class_2960 model = generator.method_25557((class_2248)WWBlocks.PLANKTON, "", ALGAE_MODEL, class_4944::method_25869);
        class_2960 glowingModel = generator.method_25557((class_2248)WWBlocks.PLANKTON, "_glowing", PLANKTON_MODEL, class_4944::method_25869);
        generator.field_22830.accept(class_4925.method_25769((class_2248)WWBlocks.PLANKTON).method_25775((class_4926)class_4926.method_25783((class_2769)WWBlockStateProperties.GLOWING).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)glowingModel))));
    }

    public static void createTubeWorms(@NotNull class_4910 generator) {
        generator.method_25600((class_2248)WWBlocks.TUBE_WORMS);
        class_2960 singleModel = generator.method_25557((class_2248)WWBlocks.TUBE_WORMS, "", class_4943.field_22932, class_4944::method_25869);
        class_2960 topModel = generator.method_25557((class_2248)WWBlocks.TUBE_WORMS, "_top", class_4943.field_22932, class_4944::method_25869);
        class_2960 middleModel = generator.method_25557((class_2248)WWBlocks.TUBE_WORMS, "_middle", class_4943.field_22932, class_4944::method_25869);
        class_2960 bottomModel = generator.method_25557((class_2248)WWBlocks.TUBE_WORMS, "_bottom", class_4943.field_22932, class_4944::method_25869);
        generator.field_22830.accept(class_4925.method_25769((class_2248)WWBlocks.TUBE_WORMS).method_25775((class_4926)class_4926.method_25783(WWBlockStateProperties.TUBE_WORMS_PART).method_25793((Comparable)((Object)TubeWormsPart.SINGLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)singleModel)).method_25793((Comparable)((Object)TubeWormsPart.TOP), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModel)).method_25793((Comparable)((Object)TubeWormsPart.MIDDLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)middleModel)).method_25793((Comparable)((Object)TubeWormsPart.BOTTOM), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomModel))));
    }

    public static void createCattail(@NotNull class_4910 generator) {
        generator.method_25537(WWBlocks.CATTAIL.method_8389());
        class_2960 topModel = generator.method_25557(WWBlocks.CATTAIL, "_top", class_4943.field_22932, class_4944::method_25869);
        class_2960 bottomModel = generator.method_25557(WWBlocks.CATTAIL, "_bottom", class_4943.field_22932, class_4944::method_25869);
        class_2960 swayingTopStrong = generator.method_25557(WWBlocks.CATTAIL, "_swaying_top", class_4943.field_22932, class_4944::method_25869);
        class_2960 swayingTopWeak = generator.method_25557(WWBlocks.CATTAIL, "_swaying_top_weak", class_4943.field_22932, class_4944::method_25869);
        class_2960 swayingBottom = generator.method_25557(WWBlocks.CATTAIL, "_swaying_bottom", class_4943.field_22932, class_4944::method_25869);
        generator.field_22830.accept(class_4925.method_25769((class_2248)WWBlocks.CATTAIL).method_25775((class_4926)class_4926.method_25785((class_2769)class_2741.field_12533, (class_2769)class_2741.field_12508, (class_2769)WWBlockStateProperties.SWAYING).method_25806((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomModel)).method_25806((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomModel)).method_25806((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomModel)).method_25806((Comparable)class_2756.field_12607, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)swayingBottom)).method_25806((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModel)).method_25806((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)swayingTopWeak)).method_25806((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModel)).method_25806((Comparable)class_2756.field_12609, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)swayingTopStrong))));
    }
}

