/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.ai.penguin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.frozenblock.wilderwild.entity.Penguin;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinBoostBoat;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinCall;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinFindEscapePos;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinFollowReturnPos;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinLayDown;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinLayEgg;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinMarkAsEscaping;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinMeetCaller;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinPostEscape;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinPreSearch;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinReturnToWater;
import net.frozenblock.wilderwild.entity.ai.penguin.PenguinStandUp;
import net.frozenblock.wilderwild.entity.ai.penguin.SetTrackedBoatLookTarget;
import net.frozenblock.wilderwild.registry.WWActivities;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.frozenblock.wilderwild.registry.WWSensorTypes;
import net.frozenblock.wilderwild.tag.WWItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4103;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4806;
import net.minecraft.class_4813;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5134;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_5756;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7097;
import net.minecraft.class_7893;
import net.minecraft.class_7895;
import net.minecraft.class_7898;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PenguinAi {
    private static final float SPEED_MULTIPLIER_WHEN_ATTACKING = 1.15f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.15f;
    private static final class_6019 ADULT_FOLLOW_RANGE = class_6019.method_35017((int)3, (int)16);
    public static final class_6019 IDLE_TIME = class_6019.method_35017((int)1200, (int)2400);
    public static final class_6019 DIVE_TIME = class_6019.method_35017((int)400, (int)1200);
    public static final int STAND_UP_DURATION = 48;
    public static final int CALL_DURATION = 60;
    private static final ImmutableList<class_4149<? extends class_4148<? super Penguin>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_25362, (Object)class_4149.field_18467, WWSensorTypes.PENGUIN_SPECIFIC_SENSOR, WWSensorTypes.PENGUIN_TEMPTATIONS, WWSensorTypes.PENGUIN_ATTACKABLES, (Object)class_4149.field_37447, WWSensorTypes.LAND_POS_SENSOR, WWSensorTypes.TRACKED_BOAT_SENSOR);
    private static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_39408, (Object)class_4140.field_18445, (Object)class_4140.field_18446, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18442, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object)class_4140.field_28327, (Object)class_4140.field_18448, (Object)class_4140.field_25359, (Object)class_4140.field_37443, (Object[])new class_4140[]{class_4140.field_22355, class_4140.field_30243, class_4140.field_18441, class_4140.field_18443, class_4140.field_18444, class_4140.field_22354, WWMemoryModuleTypes.NEARBY_PENGUINS, WWMemoryModuleTypes.CLOSE_PENGUINS, class_4140.field_22475, class_4140.field_18438, class_4140.field_37442, WWMemoryModuleTypes.IDLE_TIME, WWMemoryModuleTypes.DIVE_TICKS, class_4140.field_30246, WWMemoryModuleTypes.LAYING_DOWN, WWMemoryModuleTypes.STARTING_SEARCH, WWMemoryModuleTypes.SEARCHING_FOR_WATER, WWMemoryModuleTypes.ESCAPING, WWMemoryModuleTypes.LAND_POS, WWMemoryModuleTypes.WATER_POS, WWMemoryModuleTypes.STANDING_UP, WWMemoryModuleTypes.TRACKED_BOAT, WWMemoryModuleTypes.WANTS_TO_CALL, WWMemoryModuleTypes.CALL_COOLDOWN_TICKS, WWMemoryModuleTypes.CALLING, WWMemoryModuleTypes.CALLER});
    private static final class_7893<Penguin> HUNTING_COOLDOWN_SETTER = class_7898.method_47224(instance -> instance.group((App)instance.method_47235(class_4140.field_30246)).apply((Applicative)instance, memoryAccessor -> (world, penguin, l) -> {
        memoryAccessor.method_47250((Object)true, 600L);
        return true;
    }));

    @NotNull
    public static class_4095.class_5303<Penguin> brainProvider() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    public static class_4095<?> makeBrain(@NotNull Penguin penguin, @NotNull class_4095<Penguin> brain) {
        PenguinAi.initCoreActivity(brain);
        PenguinAi.initStandUpActivity(brain);
        PenguinAi.initChaseActivity(brain);
        PenguinAi.initCallActivity(brain);
        PenguinAi.initMeetActivity(brain, penguin);
        PenguinAi.initFightActivity(brain, penguin);
        PenguinAi.initIdleActivity(brain);
        PenguinAi.initPreSearchActivity(brain);
        PenguinAi.initSearchActivity(brain);
        PenguinAi.initSwimActivity(brain);
        PenguinAi.initEscapeActivity(brain);
        PenguinAi.initPostEscapeActivity(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_6028(2.0f), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)((Object)new PenguinLayEgg(WWBlocks.PENGUIN_EGG)), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(WWMemoryModuleTypes.IDLE_TIME), (Object)new class_5753(WWMemoryModuleTypes.DIVE_TICKS), (Object)new class_5753(WWMemoryModuleTypes.CALL_COOLDOWN_TICKS)));
    }

    private static void initStandUpActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24527(WWActivities.STAND_UP, 10, ImmutableList.of(new PenguinStandUp(48)), WWMemoryModuleTypes.STANDING_UP);
    }

    private static void initChaseActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24529(WWActivities.CHASE, ImmutableList.of((Object)Pair.of((Object)0, SetTrackedBoatLookTarget.create()), (Object)Pair.of((Object)0, PenguinBoostBoat.create()), (Object)Pair.of((Object)0, (Object)class_4120.method_47109(entity -> true, entity -> Float.valueOf(2.0f), (int)2)), (Object)Pair.of((Object)0, (Object)class_4813.method_46922(class_4215::method_41331, WWMemoryModuleTypes.TRACKED_BOAT))), (Set)ImmutableSet.of((Object)Pair.of(WWMemoryModuleTypes.TRACKED_BOAT, (Object)class_4141.field_18456)));
    }

    private static void initCallActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24530(WWActivities.CALL, ImmutableList.of((Object)Pair.of((Object)20, new PenguinCall(60))), (Set)ImmutableSet.of((Object)Pair.of(WWMemoryModuleTypes.WANTS_TO_CALL, (Object)class_4141.field_18456), (Object)Pair.of(WWMemoryModuleTypes.NEARBY_PENGUINS, (Object)class_4141.field_18456), (Object)Pair.of(WWMemoryModuleTypes.CALL_COOLDOWN_TICKS, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_18448, (Object)class_4141.field_18457), (Object[])new Pair[]{Pair.of((Object)class_4140.field_28327, (Object)class_4141.field_18457)}), (Set)ImmutableSet.of(WWMemoryModuleTypes.WANTS_TO_CALL, WWMemoryModuleTypes.CALLING));
    }

    private static void initMeetActivity(@NotNull class_4095<Penguin> brain, Penguin penguin) {
        brain.method_24529(class_4168.field_18598, ImmutableList.of((Object)Pair.of((Object)0, PenguinMeetCaller.create()), (Object)Pair.of((Object)0, (Object)class_4120.method_47109(entity -> true, entity -> Float.valueOf(1.25f), (int)2)), (Object)Pair.of((Object)0, (Object)class_4813.method_46922(class_4215::method_41331, WWMemoryModuleTypes.CALLER))), (Set)ImmutableSet.of((Object)Pair.of(WWMemoryModuleTypes.CALLER, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_18448, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_28327, (Object)class_4141.field_18457)));
    }

    private static void initFightActivity(@NotNull class_4095<Penguin> brain, @NotNull Penguin penguin) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of(HUNTING_COOLDOWN_SETTER, (Object)class_4828.method_47139((serverLevel, livingEntity) -> !penguin.canTargetEntity((class_1297)livingEntity), PenguinAi::onTargetInvalid, (boolean)true), (Object)class_4119.method_47065(livingEntity -> PenguinAi.isTarget(penguin, livingEntity), (float)((float)penguin.method_45325(class_5134.field_23717))), (Object)class_4822.method_47098(PenguinAi::getSpeedModifierChasing), (Object)class_4816.method_46987((int)30), (Object)class_4813.method_46922(class_4215::method_41331, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static void initIdleActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24529(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_7895.method_47067((float)8.0f, (class_6019)class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)0.6f)), (Object)Pair.of((Object)2, (Object)new class_4806(WWEntityTypes.PENGUIN, 1.15f, 2)), (Object)Pair.of((Object)3, (Object)new class_5754(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)4, (Object)class_7097.method_47168((int)6, (float)1.0f)), (Object)Pair.of((Object)5, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)class_7898.method_47225(class_1297::method_24828), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.SEARCHING_FOR_WATER, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.IDLE_TIME, (Object)class_4141.field_18456), (Object)Pair.of(WWMemoryModuleTypes.LAYING_DOWN, (Object)class_4141.field_18457)));
    }

    private static void initPreSearchActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24529(WWActivities.PRE_SEARCH, ImmutableList.of((Object)Pair.of((Object)0, new PenguinPreSearch())), (Set)ImmutableSet.of((Object)Pair.of(WWMemoryModuleTypes.NEARBY_PENGUINS, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.IDLE_TIME, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.CALL_COOLDOWN_TICKS, (Object)class_4141.field_18457), (Object[])new Pair[]{Pair.of(WWMemoryModuleTypes.WANTS_TO_CALL, (Object)class_4141.field_18457), Pair.of(WWMemoryModuleTypes.ESCAPING, (Object)class_4141.field_18457), Pair.of(WWMemoryModuleTypes.STARTING_SEARCH, (Object)class_4141.field_18457), Pair.of(WWMemoryModuleTypes.SEARCHING_FOR_WATER, (Object)class_4141.field_18457)}));
    }

    private static void initSearchActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24530(WWActivities.SEARCH, ImmutableList.of((Object)Pair.of((Object)0, new PenguinLayDown()), (Object)Pair.of((Object)0, (Object)class_7895.method_47067((float)8.0f, (class_6019)class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)0.6f)), (Object)Pair.of((Object)2, (Object)new class_4806(WWEntityTypes.PENGUIN, 1.15f, 2)), (Object)Pair.of((Object)3, (Object)new class_5754(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)4, (Object)class_5756.method_47176((int)8, (float)0.8f)), (Object)Pair.of((Object)5, PenguinReturnToWater.create(0.8f)), (Object)Pair.of((Object)6, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)class_7898.method_47225(class_1297::method_24828), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.IDLE_TIME, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.ESCAPING, (Object)class_4141.field_18457)), (Set)ImmutableSet.of(WWMemoryModuleTypes.SEARCHING_FOR_WATER, WWMemoryModuleTypes.LAYING_DOWN));
    }

    private static void initSwimActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24529(class_4168.field_37504, ImmutableList.of((Object)Pair.of((Object)1, (Object)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)0.6f)), (Object)Pair.of((Object)2, (Object)new class_4806(WWEntityTypes.PENGUIN, 1.15f, 2)), (Object)Pair.of((Object)3, (Object)new class_5754(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)4, (Object)class_4824.method_47120(PenguinAi::canAttack, (serverLevel, penguin) -> penguin.method_18868().method_18904(class_4140.field_30243))), (Object)Pair.of((Object)5, (Object)new class_4103((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (Set)ImmutableSet.of(), class_4103.class_4104.field_18348, class_4103.class_4216.field_18856, (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47027((float)1.0f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)3), (Object)Pair.of((Object)class_7898.method_47225(class_1297::method_5816), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18456), (Object)Pair.of(WWMemoryModuleTypes.DIVE_TICKS, (Object)class_4141.field_18456)));
    }

    private static void initEscapeActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24529(WWActivities.ESCAPE, ImmutableList.of((Object)Pair.of((Object)0, new PenguinMarkAsEscaping()), (Object)Pair.of((Object)0, (Object)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)0.6f)), (Object)Pair.of((Object)1, PenguinFollowReturnPos.create(1.5f)), (Object)Pair.of((Object)1, PenguinFindEscapePos.create(10, 1.5f)), (Object)Pair.of((Object)2, (Object)new class_4806(WWEntityTypes.PENGUIN, 1.15f, 2)), (Object)Pair.of((Object)3, (Object)new class_5754(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)4, (Object)new class_4103((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (Set)ImmutableSet.of(), class_4103.class_4104.field_18348, class_4103.class_4216.field_18856, (List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47027((float)1.0f), (Object)1), (Object)Pair.of((Object)class_4818.method_47018((float)1.0f, (boolean)true), (Object)1), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)class_7898.method_47225(class_1297::method_5816), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18456), (Object)Pair.of(WWMemoryModuleTypes.DIVE_TICKS, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.STARTING_SEARCH, (Object)class_4141.field_18457)));
    }

    private static void initPostEscapeActivity(@NotNull class_4095<Penguin> brain) {
        brain.method_24529(WWActivities.POST_ESCAPE, ImmutableList.of((Object)Pair.of((Object)0, new PenguinPostEscape())), (Set)ImmutableSet.of((Object)Pair.of((Object)class_4140.field_37442, (Object)class_4141.field_18457), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.DIVE_TICKS, (Object)class_4141.field_18457), (Object)Pair.of(WWMemoryModuleTypes.ESCAPING, (Object)class_4141.field_18456), (Object)Pair.of(WWMemoryModuleTypes.STARTING_SEARCH, (Object)class_4141.field_18457)));
    }

    public static void updateActivity(@NotNull Penguin penguin) {
        if (!penguin.method_6109()) {
            penguin.method_18868().method_24531((List)ImmutableList.of((Object)WWActivities.STAND_UP, (Object)WWActivities.CHASE, (Object)WWActivities.CALL, (Object)class_4168.field_18598, (Object)class_4168.field_22396, (Object)WWActivities.PRE_SEARCH, (Object)WWActivities.ESCAPE, (Object)WWActivities.POST_ESCAPE, (Object)WWActivities.SEARCH, (Object)class_4168.field_37504, (Object)class_4168.field_18595));
        } else {
            penguin.method_18868().method_24531((List)ImmutableList.of((Object)WWActivities.STAND_UP, (Object)WWActivities.CHASE, (Object)class_4168.field_18598, (Object)WWActivities.ESCAPE, (Object)WWActivities.POST_ESCAPE, (Object)WWActivities.SEARCH, (Object)class_4168.field_37504, (Object)class_4168.field_18595));
        }
    }

    @NotNull
    public static Optional<List<Penguin>> getNearbyPenguins(@NotNull Penguin penguin) {
        return penguin.method_18868().method_18904(WWMemoryModuleTypes.NEARBY_PENGUINS);
    }

    @NotNull
    public static Optional<List<Penguin>> getClosePenguins(@NotNull Penguin penguin) {
        return penguin.method_18868().method_18904(WWMemoryModuleTypes.CLOSE_PENGUINS);
    }

    private static boolean isTarget(@NotNull Penguin penguin, @NotNull class_1309 livingEntity) {
        return penguin.method_18868().method_18904(class_4140.field_22355).filter(livingEntity2 -> livingEntity2 == livingEntity).isPresent();
    }

    private static boolean isCaller(@NotNull Penguin penguin, @NotNull class_1309 livingEntity) {
        return penguin.method_18868().method_18904(WWMemoryModuleTypes.CALLER).filter(uuid -> livingEntity.method_5667().equals(uuid)).isPresent();
    }

    private static float getSpeedModifierChasing(@Nullable class_1309 livingEntity) {
        return 1.15f;
    }

    private static void onTargetInvalid(class_3218 serverLevel, @NotNull Penguin penguin, @NotNull class_1309 target) {
        if (penguin.method_5968() == target) {
            penguin.method_18868().method_18875(class_4140.field_22355);
        }
        penguin.method_5942().method_6340();
    }

    private static boolean canAttack(class_3218 serverLevel, @NotNull Penguin penguin) {
        return !penguin.method_6109() && !class_4215.method_41331((class_1309)penguin) && penguin.method_18868().method_18876(class_4140.field_30246, class_4141.field_18457);
    }

    public static void addCallMemoryIfPenguinsClose(@NotNull Penguin penguin) {
        class_4095<Penguin> brain = penguin.method_18868();
        if (PenguinAi.hasNearbyPenguins(penguin) && brain.method_18876(WWMemoryModuleTypes.CALL_COOLDOWN_TICKS, class_4141.field_18457)) {
            brain.method_24525(WWMemoryModuleTypes.WANTS_TO_CALL, (Object)class_3902.field_17274, 12000L);
        }
    }

    public static boolean hasNearbyPenguins(@NotNull Penguin penguin) {
        return !PenguinAi.getNearbyPenguins(penguin).orElse(List.of()).isEmpty();
    }

    public static void addCallerMemoryToNearbyPenguins(@NotNull Penguin caller) {
        UUID uuid = caller.method_5667();
        List penguins = PenguinAi.getNearbyPenguins(caller).orElse(List.of());
        class_4095<Penguin> callerBrain = caller.method_18868();
        Optional idleTime = callerBrain.method_18904(WWMemoryModuleTypes.IDLE_TIME);
        penguins.forEach(penguin -> {
            if (penguin != caller) {
                class_4095<Penguin> brain = penguin.method_18868();
                brain.method_24525(WWMemoryModuleTypes.CALLER, (Object)uuid, 400L);
                brain.method_18878(WWMemoryModuleTypes.CALL_COOLDOWN_TICKS, (Object)400);
                brain.method_18875(WWMemoryModuleTypes.WANTS_TO_CALL);
                idleTime.ifPresentOrElse(time -> brain.method_18878(WWMemoryModuleTypes.IDLE_TIME, (Object)Math.max(time + penguin.method_59922().method_43051(0, 100), 0)), () -> brain.method_18875(WWMemoryModuleTypes.IDLE_TIME));
            }
        });
    }

    public static Optional<class_1309> getCaller(@NotNull class_1309 entity, UUID callerID) {
        Optional penguins = entity.method_18868().method_18904(WWMemoryModuleTypes.NEARBY_PENGUINS);
        if (penguins.isPresent()) {
            List penguinList = (List)penguins.get();
            for (Penguin penguin : penguinList) {
                if (!penguin.method_5667().equals(callerID)) continue;
                return Optional.of(penguin);
            }
        }
        return Optional.empty();
    }

    public static Predicate<class_1799> getTemptations() {
        return itemStack -> itemStack.method_31573(WWItemTags.PENGUIN_FOOD);
    }
}

