/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import java.util.ArrayList;
import net.frozenblock.wilderwild.block.impl.ChestUtil;
import net.frozenblock.wilderwild.config.WWBlockConfig;
import net.frozenblock.wilderwild.networking.packet.WWStoneChestLidPacket;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneChestBlockEntity
extends class_2595 {
    public static final float LID_SLAM_INTERVAL = 0.0425f;
    public static final float MAX_OPEN_PERCENTAGE = 0.5f;
    public static final int MAX_TIME_OPEN = 180;
    public static final double MIN_PERCENTAGE_OF_TIME_OPEN = 0.2;
    public static final double BREAK_PARTICLE_Y_OFFSET = 0.3;
    public static final float BREAK_PARTICLE_OFFSET = 0.21875f;
    public static final double BREAK_PARTICLE_SPEED = 0.05;
    public static final int MIN_BREAK_PARTICLES = 1;
    public static final int MAX_BREAK_PARTICLES = 3;
    public float openProgress;
    public float prevOpenProgress;
    public float highestLidPoint;
    public int stillLidTicks;
    public int cooldownTicks;
    public boolean closing;
    protected long updateTime;

    public StoneChestBlockEntity(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        super(WWBlockEntityTypes.STONE_CHEST, blockPos, blockState);
    }

    public static void serverStoneTick(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, @NotNull StoneChestBlockEntity stoneChest) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        long gameTime = level.method_8510();
        if (gameTime == stoneChest.updateTime) {
            return;
        }
        StoneChestBlockEntity coupledStoneChest = ChestUtil.getCoupledStoneChestBlockEntity((class_1936)serverLevel, pos, state).orElse(null);
        if (stoneChest.cooldownTicks > 0) {
            --stoneChest.cooldownTicks;
        }
        stoneChest.prevOpenProgress = stoneChest.openProgress;
        if (stoneChest.stillLidTicks > 0) {
            --stoneChest.stillLidTicks;
        } else if (stoneChest.openProgress > 0.0f) {
            level.method_8455(pos, stoneChest.method_11010().method_26204());
            serverLevel.method_33596(null, (class_6880)class_5712.field_28177, pos);
            stoneChest.openProgress = Math.max(0.0f, stoneChest.openProgress - 0.0425f);
            if (!stoneChest.closing) {
                stoneChest.closing = true;
                StoneChestBlockEntity.playSound((class_1937)serverLevel, pos, state, WWSounds.BLOCK_STONE_CHEST_CLOSE_START, WWSounds.BLOCK_STONE_CHEST_CLOSE_START_UNDERWATER, 0.3f);
            }
            if (stoneChest.openProgress <= 0.0f) {
                stoneChest.onLidSlam((class_1937)serverLevel, pos, state, coupledStoneChest);
            }
        }
        stoneChest.updateTime = gameTime;
        stoneChest.syncLidValuesAndUpdate(coupledStoneChest);
    }

    public static void clientStoneTick(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull StoneChestBlockEntity stoneChest) {
        long gameTime = level.method_8510();
        if (gameTime == stoneChest.updateTime) {
            return;
        }
        StoneChestBlockEntity coupledStoneChest = ChestUtil.getCoupledStoneChestBlockEntity((class_1936)level, pos, state).orElse(null);
        stoneChest.prevOpenProgress = stoneChest.openProgress;
        if (stoneChest.cooldownTicks > 0) {
            --stoneChest.cooldownTicks;
        }
        if (stoneChest.stillLidTicks > 0) {
            --stoneChest.stillLidTicks;
        } else if (stoneChest.openProgress > 0.0f) {
            stoneChest.closing = true;
            stoneChest.openProgress = Math.max(0.0f, stoneChest.openProgress - 0.0425f);
            if (stoneChest.openProgress <= 0.0f) {
                stoneChest.onLidSlam(level, pos, state, coupledStoneChest);
            }
        }
        stoneChest.updateTime = gameTime;
        stoneChest.syncLidValuesAndUpdate(coupledStoneChest);
    }

    public static void playSound(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3414 soundEvent, @NotNull class_3414 waterloggedSoundEvent, float volume) {
        class_2745 chestType = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.5;
        double z = (double)pos.method_10260() + 0.5;
        if (chestType == class_2745.field_12571) {
            class_2350 direction = class_2281.method_9758((class_2680)state);
            x += (double)direction.method_10148() * 0.5;
            z += (double)direction.method_10165() * 0.5;
        } else if (chestType == class_2745.field_12574) {
            class_2350 direction = class_2281.method_9758((class_2680)state);
            x -= (double)direction.method_10148() * 0.5;
            z -= (double)direction.method_10165() * 0.5;
        }
        level.method_43128(null, x, y, z, (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false && WWBlockConfig.get().chestBubbling ? waterloggedSoundEvent : soundEvent, class_3419.field_15245, volume, level.field_9229.method_43057() * 0.18f + 0.9f);
    }

    public void method_11014(@NotNull class_11368 valueInput) {
        super.method_11014(valueInput);
        this.openProgress = valueInput.method_71423("openProgress", 0.0f);
        this.highestLidPoint = valueInput.method_71423("highestLidPoint", 0.0f);
        this.stillLidTicks = valueInput.method_71424("stillLidTicks", 0);
        this.cooldownTicks = valueInput.method_71424("cooldownTicks", 0);
        this.closing = valueInput.method_71433("closing", false);
    }

    protected void method_11007(@NotNull class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71464("openProgress", this.openProgress);
        valueOutput.method_71464("highestLidPoint", this.highestLidPoint);
        valueOutput.method_71465("stillLidTicks", this.stillLidTicks);
        valueOutput.method_71465("cooldownTicks", this.cooldownTicks);
        valueOutput.method_71472("closing", this.closing);
    }

    public float method_11274(float partialTick) {
        return this.getOpenProgress(partialTick);
    }

    public float getOpenProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevOpenProgress, (float)this.openProgress);
    }

    public void liftLid(float liftAmount) {
        this.highestLidPoint = this.openProgress = class_3532.method_15363((float)(this.openProgress + liftAmount * 1.5f), (float)0.0f, (float)0.5f);
        this.stillLidTicks = (int)(Math.max((double)this.openProgress, 0.2) * 180.0 * WWBlockConfig.get().stoneChest.getStoneChestTimer());
        if (this.field_11863 != null) {
            this.field_11863.method_8455(this.method_11016(), this.method_11010().method_26204());
        }
    }

    public void setLid(float liftAmount) {
        this.highestLidPoint = this.openProgress = class_3532.method_15363((float)liftAmount, (float)0.0f, (float)0.5f);
        this.stillLidTicks = (int)(Math.max((double)this.openProgress, 0.2) * 180.0 * WWBlockConfig.get().stoneChest.getStoneChestTimer());
        if (this.field_11863 != null) {
            this.field_11863.method_8455(this.method_11016(), this.method_11010().method_26204());
        }
    }

    public int getComparatorOutput() {
        return (int)(this.openProgress * 30.0f);
    }

    public void onLidSlam(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable StoneChestBlockEntity otherStoneChest) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            if (this.highestLidPoint > 0.2f) {
                server.method_65096((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.625, (double)pos.method_10260() + 0.5, level.field_9229.method_39332(3, (int)(this.highestLidPoint * 10.0f) + 2), 0.21875, 0.0, 0.21875, 0.05);
                if (otherStoneChest != null) {
                    class_2338 otherPos = otherStoneChest.field_11867;
                    server.method_65096((class_2394)new class_2388(class_2398.field_11217, state), (double)otherPos.method_10263() + 0.5, (double)otherPos.method_10264() + 0.625, (double)otherPos.method_10260() + 0.5, level.field_9229.method_39332(3, (int)(this.highestLidPoint * 10.0f) + 3), 0.21875, 0.0, 0.21875, 0.05);
                }
            }
            StoneChestBlockEntity.playSound(level, pos, state, WWSounds.BLOCK_STONE_CHEST_SLAM, WWSounds.BLOCK_STONE_CHEST_SLAM_UNDERWATER, 0.5f + this.highestLidPoint / 5.0f);
        }
        this.closing = false;
        this.cooldownTicks = 15;
        this.highestLidPoint = 0.0f;
    }

    public boolean method_5443(@NotNull class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return super.method_5443(player) && !this.closing && (double)this.openProgress >= 0.3;
    }

    public void syncLidValuesAndUpdate(@Nullable StoneChestBlockEntity otherStoneChest) {
        boolean shouldSend;
        boolean bl = shouldSend = this.field_11863 != null && !this.field_11863.method_8608() && this.openProgress != this.prevOpenProgress;
        if (otherStoneChest != null) {
            this.syncValues(otherStoneChest);
            if (shouldSend) {
                WWStoneChestLidPacket.sendToAll(otherStoneChest);
            }
        }
        if (shouldSend) {
            WWStoneChestLidPacket.sendToAll(this);
        }
    }

    private void syncValues(@NotNull StoneChestBlockEntity otherStoneChest) {
        if (otherStoneChest.openProgress != this.openProgress && this.field_11863 != null) {
            this.field_11863.method_8455(otherStoneChest.method_11016(), otherStoneChest.method_11010().method_26204());
        }
        otherStoneChest.openProgress = this.openProgress;
        otherStoneChest.prevOpenProgress = this.prevOpenProgress;
        otherStoneChest.highestLidPoint = this.highestLidPoint;
        otherStoneChest.stillLidTicks = this.stillLidTicks;
        otherStoneChest.cooldownTicks = this.cooldownTicks;
        otherStoneChest.closing = this.closing;
        otherStoneChest.updateTime = this.updateTime;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.stone_chest");
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        if (this.field_11863 == null) {
            return;
        }
        this.method_54873(null);
        this.nonAncientItems().forEach(itemStack -> class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)itemStack));
        ArrayList<class_1799> ancientItems = this.ancientItems();
        if (!ancientItems.isEmpty()) {
            this.field_11863.method_8396(null, pos, WWSounds.BLOCK_STONE_CHEST_ITEM_CRUMBLE, class_3419.field_15245, 0.4f, 0.9f + this.field_11863.field_9229.method_43057() * 0.1f);
            for (class_1799 taunt : ancientItems) {
                for (int taunts = 0; taunts < taunt.method_7947(); ++taunts) {
                    StoneChestBlockEntity.spawnBreakParticles(this.field_11863, taunt, pos);
                }
            }
        }
    }

    @NotNull
    public ArrayList<class_1799> nonAncientItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1799 item : this.method_11282()) {
            class_9279 data = (class_9279)item.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            if (data.method_57461().method_10545("wilderwild_is_ancient") || item.method_7960()) continue;
            items.add(item);
        }
        return items;
    }

    @NotNull
    public ArrayList<class_1799> ancientItems() {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1799 item : this.method_11282()) {
            class_9279 data = (class_9279)item.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            if (!data.method_57461().method_10545("wilderwild_is_ancient") || item.method_7960()) continue;
            items.add(item);
        }
        return items;
    }

    private static void spawnBreakParticles(@NotNull class_1937 level, @NotNull class_1799 stack, @NotNull class_2338 pos) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        serverLevel.method_65096((class_2394)new class_2392(class_2398.field_11218, stack), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.3, (double)pos.method_10260() + 0.5, level.method_8409().method_39332(1, 3), 0.21875, 0.21875, 0.21875, 0.05);
    }
}

