/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.config;

import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.FrozenBools;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.json.JsonConfig;
import net.frozenblock.lib.config.api.instance.json.JsonType;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.api.sync.SyncBehavior;
import net.frozenblock.lib.config.api.sync.annotation.EntrySyncData;
import net.frozenblock.wilderwild.WWPreLoadConstants;

public final class WWBlockConfig {
    public static final Config<WWBlockConfig> INSTANCE = ConfigRegistry.register((Config)new JsonConfig<WWBlockConfig>("wilderwild", WWBlockConfig.class, WWPreLoadConstants.configPath("block", true), JsonType.JSON5){

        public void onSave() throws Exception {
            super.onSave();
            this.onSync(null);
        }

        public void onSync(WWBlockConfig syncInstance) {
            WWBlockConfig config = (WWBlockConfig)this.config();
            MESOGLEA_BUBBLE_COLUMNS = config.mesoglea.mesogleaBubbleColumns;
            FIRE_MAGMA_PARTICLES = config.fire.extraMagmaParticles;
            SNOWLOGGING = config.snowlogging.snowlogging && !FabricLoader.getInstance().isModLoaded("antique-atlas");
            SNOWLOG_WALLS = SNOWLOGGING && config.snowlogging.snowlogWalls;
            NATURAL_SNOWLOGGING = SNOWLOGGING && config.snowlogging.naturalSnowlogging;
            SHRIEKER_OUTLINE = config.sculk.shriekerOutline;
            HANGING_TENDRIL_GENERATION = config.sculk.tendrilGeneration;
            OSSEOUS_SCULK_GENERATION = config.sculk.osseousSculkGeneration;
            SCULK_BUILDING_BLOCKS_GENERATION = config.sculk.sculkBuildingBlocksGeneration;
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                Client.MESOGLEA_FLUID = config.mesoglea.mesogleaFluid;
                Client.POLLEN_ENABLED = config.pollenParticles;
                Client.SOUL_FIRE_SOUNDS = config.fire.soulFireSounds;
                Client.BILLBOARD_TENDRILS = config.sculk.billboardTendrils;
            }
        }
    });
    public static volatile boolean MESOGLEA_BUBBLE_COLUMNS = true;
    public static volatile boolean FIRE_MAGMA_PARTICLES = true;
    public static volatile boolean SNOWLOGGING = true;
    public static volatile boolean SNOWLOG_WALLS = false;
    public static volatile boolean NATURAL_SNOWLOGGING = true;
    public static volatile boolean SHRIEKER_OUTLINE = true;
    public static volatile boolean HANGING_TENDRIL_GENERATION = true;
    public static volatile boolean OSSEOUS_SCULK_GENERATION = true;
    public static volatile boolean SCULK_BUILDING_BLOCKS_GENERATION = true;
    @ConfigEntry.Gui.CollapsibleObject
    public final BlockSoundsConfig blockSounds = new BlockSoundsConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final StoneChestConfig stoneChest = new StoneChestConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final TermiteConfig termite = new TermiteConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final MesogleaConfig mesoglea = new MesogleaConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final SnowloggingConfig snowlogging = new SnowloggingConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final FireConfig fire = new FireConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final SculkConfig sculk = new SculkConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public final FlowerConfig flower = new FlowerConfig();
    @EntrySyncData(value="reachBoostBeacon")
    public boolean reachBoostBeacon = true;
    @EntrySyncData(value="pollenParticles", behavior=SyncBehavior.UNSYNCABLE)
    public boolean pollenParticles = true;
    @EntrySyncData(value="logHollowing")
    public boolean logHollowing = true;
    @EntrySyncData(value="cactusPlacement")
    public boolean cactusPlacement = false;
    @EntrySyncData(value="newReinforcedDeepslate")
    public boolean newReinforcedDeepslate = true;
    @EntrySyncData(value="froglightGoopGrowth")
    public boolean froglightGoopGrowth = true;
    @EntrySyncData(value="frostedIceCracking")
    public boolean frostedIceCracking = true;
    @EntrySyncData(value="chestBubbling")
    public boolean chestBubbling = true;
    @EntrySyncData(value="thickBigFungusGrowth")
    public boolean thickBigFungusGrowth = true;

    public static boolean canSnowlog() {
        return SNOWLOGGING && !FrozenBools.IS_DATAGEN;
    }

    public static boolean canSnowlogWalls() {
        return WWBlockConfig.canSnowlog() && SNOWLOG_WALLS;
    }

    public static boolean canSnowlogNaturally() {
        return WWBlockConfig.canSnowlog() && NATURAL_SNOWLOGGING;
    }

    public static WWBlockConfig get() {
        return WWBlockConfig.get(false);
    }

    public static WWBlockConfig get(boolean real) {
        if (real) {
            return (WWBlockConfig)INSTANCE.instance();
        }
        return (WWBlockConfig)INSTANCE.config();
    }

    public static WWBlockConfig getWithSync() {
        return (WWBlockConfig)INSTANCE.configWithSync();
    }

    public static class BlockSoundsConfig {
        @EntrySyncData(value="cactusSounds")
        public boolean cactusSounds = true;
        @EntrySyncData(value="claySounds")
        public boolean claySounds = true;
        @EntrySyncData(value="coarseDirtSounds")
        public boolean coarseDirtSounds = true;
        @EntrySyncData(value="deadBushSounds")
        public boolean deadBushSounds = true;
        @EntrySyncData(value="flowerSounds")
        public boolean flowerSounds = true;
        @EntrySyncData(value="grassSounds")
        public boolean grassSounds = true;
        @EntrySyncData(value="magmaSounds")
        public boolean magmaSounds = true;
        @EntrySyncData(value="saplingSounds")
        public boolean saplingSounds = true;
        @EntrySyncData(value="iceSounds")
        public boolean iceSounds = true;
        @EntrySyncData(value="frostedIceSounds")
        public boolean frostedIceSounds = true;
        @EntrySyncData(value="gravelSounds")
        public boolean gravelSounds = true;
        @EntrySyncData(value="leafSounds")
        public boolean leafSounds = true;
        @EntrySyncData(value="lilyPadSounds")
        public boolean lilyPadSounds = true;
        @EntrySyncData(value="melonSounds")
        public boolean melonSounds = true;
        @EntrySyncData(value="mossSounds")
        public boolean mossSounds = true;
        @EntrySyncData(value="mushroomBlockSounds")
        public boolean mushroomBlockSounds = true;
        @EntrySyncData(value="podzolSounds")
        public boolean podzolSounds = true;
        @EntrySyncData(value="reinforcedDeepslateSounds")
        public boolean reinforcedDeepslateSounds = true;
        @EntrySyncData(value="sandstoneSounds")
        public boolean sandstoneSounds = true;
        @EntrySyncData(value="sugarCaneSounds")
        public boolean sugarCaneSounds = true;
        @EntrySyncData(value="witherRoseSounds")
        public boolean witherRoseSounds = true;
    }

    public static class StoneChestConfig {
        @EntrySyncData(value="stoneChestTimer")
        public int stoneChestTimer = 100;
        @EntrySyncData(value="addStoneChests")
        public boolean addStoneChests = true;

        public double getStoneChestTimer() {
            return (double)this.stoneChestTimer * 0.01;
        }
    }

    public static class TermiteConfig {
        @EntrySyncData(value="onlyEatNaturalBlocks")
        public boolean onlyEatNaturalBlocks = true;
        @EntrySyncData(value="maxDistance")
        public int maxDistance = 32;
        @EntrySyncData(value="maxNaturalDistance")
        public int maxNaturalDistance = 10;
    }

    public static class MesogleaConfig {
        @EntrySyncData(value="mesogleaFluid", behavior=SyncBehavior.UNSYNCABLE)
        public boolean mesogleaFluid = false;
        @EntrySyncData(value="mesogleaBubbleColumns")
        public boolean mesogleaBubbleColumns = true;
    }

    public static class SnowloggingConfig {
        @EntrySyncData(value="snowlogging")
        public boolean snowlogging = true;
        @EntrySyncData(value="snowlogWalls")
        public boolean snowlogWalls = false;
        @EntrySyncData(value="naturalSnowlogging")
        public boolean naturalSnowlogging = true;
    }

    public static class FireConfig {
        @EntrySyncData(value="soulFireSounds", behavior=SyncBehavior.UNSYNCABLE)
        public boolean soulFireSounds = true;
        @EntrySyncData(value="extraMagmaParticles")
        public boolean extraMagmaParticles = true;
    }

    public static class SculkConfig {
        @EntrySyncData(value="shriekerGargling", behavior=SyncBehavior.UNSYNCABLE)
        public boolean shriekerGargling = true;
        @EntrySyncData(value="shriekerOutline", behavior=SyncBehavior.UNSYNCABLE)
        public boolean shriekerOutline = true;
        @EntrySyncData(value="billboardTendrils", behavior=SyncBehavior.UNSYNCABLE)
        public boolean billboardTendrils = true;
        @EntrySyncData(value="tendrilsCarryEvents")
        public boolean tendrilsCarryEvents = false;
        @EntrySyncData(value="tendrilGeneration")
        public boolean tendrilGeneration = true;
        @EntrySyncData(value="osseousSculkGeneration")
        public boolean osseousSculkGeneration = true;
        @EntrySyncData(value="sculkBuildingBlocksGeneration")
        public boolean sculkBuildingBlocksGeneration = true;
    }

    public static class FlowerConfig {
        @EntrySyncData(value="bonemealDandelions")
        public boolean bonemealDandelions = true;
        @EntrySyncData(value="shearSeedingDandelions")
        public boolean shearSeedingDandelions = true;
        @EntrySyncData(value="bonemealLilypads")
        public boolean bonemealLilypads = true;
        @EntrySyncData(value="shearFloweringLilypads")
        public boolean shearFloweringLilypads = true;
    }

    public static final class Client {
        public static volatile boolean MESOGLEA_FLUID = false;
        public static volatile boolean POLLEN_ENABLED = true;
        public static volatile boolean SOUL_FIRE_SOUNDS = true;
        public static volatile boolean BILLBOARD_TENDRILS = true;
    }
}

