/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.wind.api.BlowingHelper;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.wilderwild.advancement.GeyserPushMobTrigger;
import net.frozenblock.wilderwild.block.GeyserBlock;
import net.frozenblock.wilderwild.block.impl.GeyserParticleHandler;
import net.frozenblock.wilderwild.block.state.properties.GeyserStage;
import net.frozenblock.wilderwild.block.state.properties.GeyserType;
import net.frozenblock.wilderwild.mod_compat.FrozenLibIntegration;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWCriteria;
import net.frozenblock.wilderwild.tag.WWEntityTags;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GeyserBlockEntity
extends class_2586 {
    private static final WindDisturbanceLogic<GeyserBlockEntity> DUMMY_WIND_LOGIC = new WindDisturbanceLogic((source, level1, windOrigin, affectedArea, windTarget) -> WindDisturbance.DUMMY_RESULT);
    public static final double ERUPTION_DISTANCE = 6.0;
    public static final double VENT_DISTANCE = 3.0;
    public static final int ERUPTION_DISTANCE_IN_BLOCKS = 5;
    public static final int VENT_DISTANCE_IN_BLOCKS = 2;
    public static final int MIN_ACTIVE_TICKS = 100;
    public static final int MAX_ACTIVE_TICKS = 200;
    public static final int MIN_DORMANT_TICKS = 400;
    public static final int MAX_DORMANT_TICKS = 900;
    public static final int MIN_ERUPTION_TICKS = 20;
    public static final int MAX_ERUPTION_TICKS = 40;
    public static final int ERUPTION_TICKS_UNNATURAL = 30;
    public static final float ERUPTION_PROGRESS_INTERVAL = 0.1f;
    public static final int TICK_DELAY_START_MIN = 20;
    public static final int TICK_DELAY_START_MAX = 100;
    public static final double EFFECTIVE_PUSH_INTENSITY = 0.4;
    public static final double INEFFECTIVE_PUSH_INTENSITY = 0.2;
    public static final double EFFECTIVE_ADDITIONAL_WIND_INTENSITY = 0.5;
    public static final double BASE_WIND_INTENSITY = 0.5;
    public static final int FIRE_TICKS_MAX = 260;
    private boolean hasRunFirstCheck = false;
    private int ticksUntilNextEvent;
    private float eruptionProgress;

    public GeyserBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        super(WWBlockEntityTypes.GEYSER, pos, state);
    }

    public boolean method_11004(int eventId, int data) {
        if (eventId == 1 && this.field_11863.field_9236) {
            this.eruptionProgress = 0.0f;
            this.ticksUntilNextEvent = data;
            return true;
        }
        return super.method_11004(eventId, data);
    }

    public void tickServer(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, class_5819 random) {
        GeyserType geyserType = (GeyserType)((Object)state.method_11654(GeyserBlock.GEYSER_TYPE));
        GeyserStage geyserStage = (GeyserStage)((Object)state.method_11654(GeyserBlock.GEYSER_STAGE));
        class_2350 direction = (class_2350)state.method_11654(GeyserBlock.FACING);
        boolean natural = (Boolean)state.method_11654((class_2769)GeyserBlock.NATURAL);
        if (!this.hasRunFirstCheck) {
            level.method_64310(pos, this.method_11010().method_26204(), level.field_9229.method_43051(20, 100));
            this.hasRunFirstCheck = true;
        } else if (GeyserBlock.isActive(geyserType)) {
            if (geyserType == GeyserType.HYDROTHERMAL_VENT) {
                this.eruptionProgress = 1.0f;
                this.handleEruption(level, pos, geyserType, direction, natural);
                this.setActive(level, pos, state, random);
            } else if (geyserStage == GeyserStage.ERUPTING) {
                if (this.eruptionProgress == 0.0f) {
                    this.ticksUntilNextEvent = natural ? random.method_43051(20, 40) : 30;
                    level.method_8396(null, pos, geyserType.getEruptionSound(), class_3419.field_15245, 0.7f, 0.9f + random.method_43057() * 0.2f);
                    this.field_11863.method_8427(pos, state.method_26204(), 1, this.ticksUntilNextEvent);
                }
                this.eruptionProgress = Math.min(1.0f, this.eruptionProgress + 0.1f);
                this.handleEruption(level, pos, geyserType, direction, natural);
            }
            --this.ticksUntilNextEvent;
            if (this.ticksUntilNextEvent <= 0) {
                this.advanceStage(level, pos, state, geyserStage, natural, random);
            }
        } else {
            this.setDormant(level, pos, state, random);
        }
    }

    @NotNull
    @Contract(value="_, _ -> new")
    private static class_238 aabb(@NotNull class_2338 startPos, @NotNull class_2338 endPos) {
        return new class_238((double)Math.min(startPos.method_10263(), endPos.method_10263()), (double)Math.min(startPos.method_10264(), endPos.method_10264()), (double)Math.min(startPos.method_10260(), endPos.method_10260()), (double)Math.max(startPos.method_10263(), endPos.method_10263()) + 1.0, (double)Math.max(startPos.method_10264(), endPos.method_10264()) + 1.0, (double)Math.max(startPos.method_10260(), endPos.method_10260()) + 1.0);
    }

    private void handleEruption(class_1937 level, @NotNull class_2338 pos, GeyserType geyserType, class_2350 direction, boolean natural) {
        class_2338 maxEndPos = pos.method_10079(direction, 6);
        boolean vent = geyserType == GeyserType.HYDROTHERMAL_VENT;
        Optional<class_2338> cutoffPos = Optional.empty();
        Optional<class_2338> damageCutoffPos = Optional.empty();
        class_2338.class_2339 mutablePos = pos.method_25503();
        for (int i = 0; i < (vent ? 2 : 5); ++i) {
            boolean mismatchesLava;
            if (!level.method_22340((class_2338)mutablePos.method_10098(direction))) continue;
            class_2680 state = level.method_8320((class_2338)mutablePos);
            if (!BlowingHelper.canBlowingPassThrough((class_4538)level, (class_2338)mutablePos, (class_2680)state, (class_2350)direction)) break;
            boolean mismatchesAir = geyserType == GeyserType.AIR && !state.method_26227().method_15769();
            boolean mismatchesWater = geyserType.isWater() && !state.method_26227().method_39360((class_3611)class_3612.field_15910);
            boolean bl = mismatchesLava = geyserType == GeyserType.LAVA && !state.method_26227().method_39360((class_3611)class_3612.field_15908);
            if ((mismatchesAir || mismatchesWater || mismatchesLava) && cutoffPos.isEmpty()) {
                cutoffPos = Optional.of(mutablePos.method_10062());
            }
            if (geyserType != GeyserType.LAVA || !state.method_26227().method_15767(class_3486.field_15517) || !damageCutoffPos.isEmpty()) continue;
            damageCutoffPos = Optional.of(mutablePos.method_10062());
        }
        class_238 eruption = GeyserBlockEntity.aabb(pos, mutablePos.method_10062());
        mutablePos.method_10098(direction.method_10153());
        class_238 effectiveEruption = cutoffPos.map(blockPos -> GeyserBlockEntity.aabb(pos, blockPos.method_10062().method_10093(direction.method_10153()))).orElseGet(() -> GeyserBlockEntity.aabb(pos, mutablePos.method_10062()));
        class_238 damagingEruption = damageCutoffPos.map(blockPos -> GeyserBlockEntity.aabb(pos, blockPos.method_10062().method_10093(direction.method_10153()))).orElseGet(() -> GeyserBlockEntity.aabb(pos, mutablePos.method_10062()));
        class_238 maxPossibleEruptionBox = this.getPossibleEruptionBoundingBox(pos, maxEndPos);
        List entities = level.method_18023(class_5575.method_31795(class_1297.class), maxPossibleEruptionBox, class_1301.field_6154.and(class_1301.field_6155));
        class_243 geyserStartPos = class_243.method_24953((class_2382)pos);
        WindDisturbance effectiveWindDisturbance = new WindDisturbance(Optional.of(this), geyserStartPos, effectiveEruption.method_1014(0.5).method_60314(direction.method_23955().mul(0.5f)), WindDisturbanceLogic.getWindDisturbanceLogic((class_2960)FrozenLibIntegration.GEYSER_EFFECTIVE_WIND_DISTURBANCE).orElse(DUMMY_WIND_LOGIC));
        WindDisturbance baseWindDisturbance = new WindDisturbance(Optional.of(this), geyserStartPos, eruption.method_1014(0.5).method_60314(direction.method_23955().mul(0.5f)), WindDisturbanceLogic.getWindDisturbanceLogic((class_2960)FrozenLibIntegration.GEYSER_BASE_WIND_DISTURBANCE).orElse(DUMMY_WIND_LOGIC));
        if (!vent) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                WindManager windManager = WindManager.getOrCreateWindManager((class_3218)serverLevel);
                windManager.addWindDisturbance(effectiveWindDisturbance);
                windManager.addWindDisturbance(baseWindDisturbance);
            } else if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                GeyserBlockEntity.addWindDisturbanceToClient(effectiveWindDisturbance);
                GeyserBlockEntity.addWindDisturbanceToClient(baseWindDisturbance);
            }
        }
        double eruptionDistance = vent ? 3.0 : 6.0;
        class_243 movement = class_243.method_24954((class_2382)direction.method_62675());
        for (class_1297 entity : entities) {
            class_1665 abstractArrow;
            boolean applyMovement;
            class_238 boundingBox = entity.method_5829();
            if (!eruption.method_994(boundingBox)) continue;
            boolean bl = applyMovement = !entity.method_5864().method_20210(WWEntityTags.GEYSER_CANNOT_PUSH);
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (player.method_31549().field_7479) {
                    applyMovement = false;
                } else if (direction == class_2350.field_11036) {
                    class_243 lastImpactPos = player.field_49989;
                    class_243 playerPos = player.method_19538();
                    player.field_49989 = new class_243(playerPos.method_10216(), lastImpactPos != null ? Math.min(lastImpactPos.method_10214(), playerPos.method_10214()) : playerPos.method_10214(), playerPos.method_10215());
                    player.method_60984(true);
                }
            } else if (entity instanceof class_1665 && (abstractArrow = (class_1665)entity).method_65059()) {
                applyMovement = false;
            }
            if (applyMovement) {
                double intensity = (eruptionDistance - Math.min(entity.method_19538().method_1022(geyserStartPos), eruptionDistance)) / eruptionDistance;
                double pushIntensity = (effectiveEruption.method_994(boundingBox) && !vent ? 0.4 : 0.2) * (entity.method_5864().method_20210(WWEntityTags.GEYSER_PUSHES_FURTHER) ? 1.5 : 1.0);
                double overallIntensity = intensity * pushIntensity;
                entity.method_45319(movement.method_1021(overallIntensity));
                entity.field_6007 = true;
            }
            if (!damagingEruption.method_994(boundingBox)) continue;
            if (applyMovement && level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                for (class_3222 serverPlayer : serverLevel.method_18766(serverPlayerx -> serverPlayerx.method_5707(geyserStartPos) < GeyserPushMobTrigger.TRIGGER_DISTANCE_FROM_PLAYER)) {
                    WWCriteria.GEYSER_PUSH_MOB_TRIGGER.trigger(serverPlayer, entity, !natural, geyserType);
                }
            }
            double damageIntensity = Math.max((eruptionDistance - Math.min(entity.method_19538().method_1022(geyserStartPos), eruptionDistance)) / eruptionDistance, eruptionDistance * 0.1);
            if (geyserType != GeyserType.LAVA || entity.method_5753()) continue;
            entity.method_56073((int)(260.0 * damageIntensity));
            entity.method_64419(level.method_48963().method_48794(), 1.0f);
        }
        for (class_2338 blockPos2 : class_2338.method_10097((class_2338)pos, (class_2338)mutablePos.method_10062())) {
            if (!maxPossibleEruptionBox.method_1006(class_243.method_24953((class_2382)blockPos2)) || !level.method_22340(blockPos2)) continue;
            class_2680 state = level.method_8320(blockPos2);
            if (geyserType == GeyserType.LAVA) {
                if (state.method_26164(class_3481.field_23799) && state.method_28498((class_2769)class_2741.field_12548)) {
                    level.method_8501(blockPos2, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)));
                }
                if (!state.method_26164(class_3481.field_26983) && !state.method_26164(class_3481.field_26984) || !state.method_28498((class_2769)class_2741.field_12548)) continue;
                level.method_8501(blockPos2, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)));
                continue;
            }
            if (state.method_26164(class_3481.field_21952)) {
                if (!level.method_8608()) {
                    level.method_8444(null, 1009, pos, 0);
                }
                level.method_8650(blockPos2, false);
            }
            if (state.method_26164(class_3481.field_23799) && state.method_28498((class_2769)class_2741.field_12548)) {
                level.method_8501(blockPos2, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)));
            }
            if (!state.method_26164(class_3481.field_26983) && !state.method_26164(class_3481.field_26984) || !state.method_28498((class_2769)class_2741.field_12548)) continue;
            level.method_8501(blockPos2, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)));
        }
    }

    @NotNull
    private class_238 getPossibleEruptionBoundingBox(@NotNull class_2338 pos, @NotNull class_2338 maxEndPos) {
        double xDifference = maxEndPos.method_10263() - pos.method_10263();
        double yDifference = maxEndPos.method_10264() - pos.method_10264();
        double zDifference = maxEndPos.method_10260() - pos.method_10260();
        double endX = (double)pos.method_10263() + xDifference * (double)this.eruptionProgress;
        double endY = (double)pos.method_10264() + yDifference * (double)this.eruptionProgress;
        double endZ = (double)pos.method_10260() + zDifference * (double)this.eruptionProgress;
        return new class_238(Math.min((double)pos.method_10263(), endX), Math.min((double)pos.method_10264(), endY), Math.min((double)pos.method_10260(), endZ), Math.max((double)pos.method_10263(), endX) + 1.0, Math.max((double)pos.method_10264(), endY) + 1.0, Math.max((double)pos.method_10260(), endZ) + 1.0);
    }

    public void advanceStage(class_1937 level, class_2338 pos, @NotNull class_2680 state, GeyserStage geyserStage, boolean natural, class_5819 random) {
        if (geyserStage == GeyserStage.ERUPTING || !natural) {
            this.eruptionProgress = 0.0f;
            this.setStageAndCooldown(level, pos, state, GeyserStage.DORMANT, random);
        } else if (geyserStage == GeyserStage.DORMANT) {
            this.setStageAndCooldown(level, pos, state, GeyserStage.ACTIVE, random);
        } else if (geyserStage == GeyserStage.ACTIVE) {
            if (!this.canErupt(level, pos, natural, random)) {
                return;
            }
            this.setStageAndCooldown(level, pos, state, GeyserStage.ERUPTING, random);
        }
    }

    private boolean canErupt(class_1937 level, class_2338 pos, boolean natural, class_5819 random) {
        double distance;
        if (!natural) {
            return true;
        }
        class_243 gesyerCenter = class_243.method_24953((class_2382)pos);
        class_1657 player = level.method_8604(gesyerCenter.method_10216(), gesyerCenter.method_10214(), gesyerCenter.method_10215(), -1.0, entity -> !entity.method_7325() && entity.method_5805());
        if (player != null && Math.sqrt(distance = player.method_5707(gesyerCenter)) <= 48.0) {
            return random.method_43048((int)(distance * 1.5) + 5) == 0;
        }
        return false;
    }

    public void setDormant(class_1937 level, class_2338 pos, class_2680 state, class_5819 random) {
        this.setStageAndCooldown(level, pos, state, GeyserStage.DORMANT, random);
    }

    public void setActive(class_1937 level, class_2338 pos, class_2680 state, class_5819 random) {
        this.setStageAndCooldown(level, pos, state, GeyserStage.ACTIVE, random);
    }

    public void setStageAndCooldown(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state, GeyserStage geyserStage, class_5819 random) {
        level.method_8501(pos, (class_2680)state.method_11657(GeyserBlock.GEYSER_STAGE, (Comparable)((Object)geyserStage)));
        if (geyserStage == GeyserStage.ACTIVE) {
            this.ticksUntilNextEvent = random.method_43051(100, 200);
        } else if (geyserStage != GeyserStage.ERUPTING) {
            this.ticksUntilNextEvent = random.method_43051(400, 900);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void tickClient(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, class_5819 random) {
        GeyserType geyserType = (GeyserType)((Object)state.method_11654(GeyserBlock.GEYSER_TYPE));
        GeyserStage geyserStage = (GeyserStage)((Object)state.method_11654(GeyserBlock.GEYSER_STAGE));
        class_2350 direction = (class_2350)state.method_11654(GeyserBlock.FACING);
        boolean natural = (Boolean)state.method_11654((class_2769)GeyserBlock.NATURAL);
        if (GeyserBlock.isActive(geyserType) && (geyserStage == GeyserStage.ERUPTING || geyserType == GeyserType.HYDROTHERMAL_VENT)) {
            this.eruptionProgress = Math.min(1.0f, this.eruptionProgress + 0.1f);
            this.handleEruption(level, pos, geyserType, direction, natural);
            GeyserParticleHandler.spawnEruptionParticles(level, pos, geyserType, direction, random);
        }
    }

    protected void method_11007(@NotNull class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10556("HasRunFirstCheck", this.hasRunFirstCheck);
        tag.method_10569("TicksUntilNextEvent", this.ticksUntilNextEvent);
        tag.method_10548("EruptionProgress", this.eruptionProgress);
    }

    public void method_11014(@NotNull class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.hasRunFirstCheck = tag.method_68566("HasRunFirstCheck", false);
        this.ticksUntilNextEvent = tag.method_68083("TicksUntilNextEvent", 0);
        this.eruptionProgress = tag.method_66563("EruptionProgress", 0.0f);
    }

    @Environment(value=EnvType.CLIENT)
    private static void addWindDisturbanceToClient(@NotNull WindDisturbance windDisturbance) {
        ClientWindManager.addWindDisturbance((WindDisturbance)windDisturbance);
    }
}

