/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.FrozenBools;
import net.frozenblock.lib.config.api.instance.ConfigModification;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.entity.api.category.entrypoint.FrozenMobCategoryEntrypoint;
import net.frozenblock.lib.entity.impl.category.FrozenMobCategory;
import net.frozenblock.lib.entrypoint.api.FrozenModInitializer;
import net.frozenblock.lib.feature_flag.api.FeatureFlagApi;
import net.frozenblock.wilderwild.WWFeatureFlags;
import net.frozenblock.wilderwild.command.SpreadSculkCommand;
import net.frozenblock.wilderwild.config.WWBlockConfig;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.datafix.minecraft.WWMinecraftDataFixer;
import net.frozenblock.wilderwild.datafix.wilderwild.WWDataFixer;
import net.frozenblock.wilderwild.entity.Jellyfish;
import net.frozenblock.wilderwild.mod_compat.WWModIntegrations;
import net.frozenblock.wilderwild.networking.WWNetworking;
import net.frozenblock.wilderwild.registry.WWActivities;
import net.frozenblock.wilderwild.registry.WWBiomes;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WWCreativeInventorySorting;
import net.frozenblock.wilderwild.registry.WWCriteria;
import net.frozenblock.wilderwild.registry.WWDamageTypes;
import net.frozenblock.wilderwild.registry.WWDataComponents;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.frozenblock.wilderwild.registry.WWGameEvents;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWLootTables;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.frozenblock.wilderwild.registry.WWMobEffects;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.frozenblock.wilderwild.registry.WWPotions;
import net.frozenblock.wilderwild.registry.WWResources;
import net.frozenblock.wilderwild.registry.WWSensorTypes;
import net.frozenblock.wilderwild.registry.WWSoundTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.registry.WWVillagers;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.frozenblock.wilderwild.worldgen.modification.WWWorldgen;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class WilderWild
extends FrozenModInitializer
implements FrozenMobCategoryEntrypoint {
    public WilderWild() {
        super("wilderwild");
    }

    public void onInitialize(String modId, ModContainer container) {
        WWResources.register(container);
        if (FrozenBools.IS_DATAGEN) {
            ConfigRegistry.register(WWBlockConfig.INSTANCE, (ConfigModification)new ConfigModification(config -> {
                config.snowlogging.snowlogging = false;
            }));
        }
        WWFeatureFlags.init();
        FeatureFlagApi.rebuild();
        WWMinecraftDataFixer.applyDataFixes(container);
        WWDataFixer.applyDataFixes(container);
        WilderWildRegistries.initRegistry();
        WWDataComponents.init();
        WWBlocks.registerBlocks();
        WWCreativeInventorySorting.init();
        WWItems.registerItems();
        WWGameEvents.registerEvents();
        WWSounds.init();
        WWSoundTypes.init();
        WWBlockEntityTypes.register();
        WWEntityTypes.init();
        WWDamageTypes.init();
        WWActivities.init();
        WWMemoryModuleTypes.register();
        WWSensorTypes.register();
        WWLootTables.init();
        WWParticleTypes.registerParticles();
        WWMobEffects.init();
        WWPotions.init();
        WWCriteria.init();
        WWFeatures.init();
        WWBiomes.init();
        WWWorldgen.generateWildWorldGen();
        WWBlocks.registerBlockProperties();
        WWVillagers.register();
        WWModIntegrations.init();
        WWBlocks.registerBlockProperties();
        WWNetworking.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> SpreadSculkCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STOPPED.register(listener -> Jellyfish.clearLevelToNonPearlescentCount());
        ServerTickEvents.START_SERVER_TICK.register(listener -> Jellyfish.clearLevelToNonPearlescentCount());
    }

    public void newCategories(@NotNull ArrayList<FrozenMobCategory> context) {
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("firefly"), (int)WWEntityConfig.get().firefly.fireflySpawnCap, (boolean)true, (boolean)false, (int)80));
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("butterfly"), (int)WWEntityConfig.get().butterfly.butterflySpawnCap, (boolean)true, (boolean)false, (int)80));
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("jellyfish"), (int)WWEntityConfig.get().jellyfish.jellyfishSpawnCap, (boolean)true, (boolean)false, (int)64));
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("crab"), (int)WWEntityConfig.get().crab.crabSpawnCap, (boolean)true, (boolean)false, (int)64));
        context.add(FrozenMobCategoryEntrypoint.createCategory((class_2960)this.id("tumbleweed"), (int)WWEntityConfig.get().tumbleweed.tumbleweedSpawnCap, (boolean)true, (boolean)false, (int)64));
    }
}

