/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2473;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8813;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaobabNutBlock
extends class_2473 {
    public static final class_2758 AGE = class_2741.field_12556;
    public static final int MAX_AGE = 2;
    public static final class_2746 HANGING = class_2741.field_16561;
    public static final MapCodec<BaobabNutBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_8813.field_46510.fieldOf("tree").forGetter(baobabNutBlock -> baobabNutBlock.field_11477), (App)BaobabNutBlock.method_54096()).apply((Applicative)instance, BaobabNutBlock::new));
    public static final double HANGING_GROWTH_CHANCE = 0.4;
    private static final class_265[] SHAPES = new class_265[]{class_259.method_1084((class_265)class_2248.method_9541((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (class_265)class_2248.method_9541((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)), class_259.method_1084((class_265)class_2248.method_9541((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (class_265)class_2248.method_9541((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)), class_259.method_1084((class_265)class_2248.method_9541((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (class_265)class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0)), class_2248.method_9541((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)};

    public BaobabNutBlock(class_8813 treeGrower, @NotNull class_4970.class_2251 settings) {
        super(treeGrower, settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean isHanging(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)HANGING);
    }

    private static boolean isFullyGrown(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 2;
    }

    @NotNull
    public MapCodec<? extends BaobabNutBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11476, AGE, HANGING});
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        return (class_2680)Objects.requireNonNull(super.method_9605(ctx)).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(2));
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_243 vec3d = state.method_26226(pos);
        class_265 voxelShape = (Boolean)state.method_11654((class_2769)HANGING) == false ? SHAPES[4] : SHAPES[(Integer)state.method_11654((class_2769)AGE)];
        return voxelShape.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public boolean method_9558(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_2338 pos) {
        return state.method_27852((class_2248)this) && (BaobabNutBlock.isHanging(state) ? level.method_8320(pos.method_10084()).method_27852(WWBlocks.BAOBAB_LEAVES) : super.method_9558(state, level, pos));
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (state.method_27852((class_2248)this) && level.method_22339(pos.method_10084()) >= 9) {
            if (!BaobabNutBlock.isHanging(state)) {
                if (random.method_43048(7) == 0) {
                    this.method_10507(level, pos, state, random);
                }
            } else if (random.method_43058() <= 0.4 && !BaobabNutBlock.isFullyGrown(state)) {
                level.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 2);
            }
        }
    }

    public boolean method_9651(@NotNull class_4538 world, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return state.method_27852((class_2248)this) && (!BaobabNutBlock.isHanging(state) || !BaobabNutBlock.isFullyGrown(state));
    }

    public boolean method_9650(@NotNull class_1937 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return state.method_27852((class_2248)this) && BaobabNutBlock.isHanging(state) ? !BaobabNutBlock.isFullyGrown(state) : super.method_9650(level, random, pos, state);
    }

    public void method_9652(@NotNull class_3218 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        if (state.method_27852((class_2248)this) && BaobabNutBlock.isHanging(state) && !BaobabNutBlock.isFullyGrown(state)) {
            level.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 2);
        } else {
            super.method_9652(level, random, pos, state);
        }
    }

    public void method_19286(@NotNull class_1937 world, @NotNull class_2680 state, @NotNull class_3965 hit, @NotNull class_1676 projectile) {
        world.method_8651(hit.method_17777(), true, (class_1297)projectile);
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_3726 collisionContext) {
        return BaobabNutBlock.isHanging(blockState) ? super.method_9549(blockState, blockGetter, blockPos, collisionContext) : class_259.method_1073();
    }

    @NotNull
    public class_2680 getDefaultHangingState() {
        return this.getHangingState(0);
    }

    @NotNull
    public class_2680 getHangingState(int age) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)HANGING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age));
    }
}

