/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.frozenblock.wilderwild.block.entity.IcicleBlockEntity;
import net.frozenblock.wilderwild.block.impl.SnowloggingUtils;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WWDamageTypes;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.frozenblock.wilderwild.worldgen.impl.util.IcicleUtils;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends class_2237
implements class_5688,
class_3737 {
    public static final MapCodec<IcicleBlock> CODEC = IcicleBlock.method_54094(IcicleBlock::new);
    private static final class_4051 TARGETING_CONDITIONS = class_4051.method_36626().method_18424().method_36627().method_18418(32.0);
    public static final class_2754<class_2350> TIP_DIRECTION = class_2741.field_28062;
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 TIP_SHAPE_UP = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    private static final class_265 TIP_SHAPE_DOWN = class_2248.method_9541((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public IcicleBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)class_5691.field_28065)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
        SnowloggingUtils.appendSnowlogProperties(builder);
    }

    public boolean method_9558(@NotNull class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return IcicleBlock.isValidIciclePlacement(levelReader, blockPos, (class_2350)blockState.method_11654(TIP_DIRECTION));
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 tickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return blockState;
        }
        class_2350 tipDirection = (class_2350)blockState.method_11654(TIP_DIRECTION);
        if (tipDirection == class_2350.field_11033 && tickAccess.method_8397().method_8674(blockPos, (Object)this)) {
            return blockState;
        }
        if (direction == tipDirection.method_10153() && !this.method_9558(blockState, levelReader, blockPos)) {
            tickAccess.method_64310(blockPos, (class_2248)this, tipDirection == class_2350.field_11033 ? 2 : 1);
            return blockState;
        }
        boolean merged = blockState.method_11654(THICKNESS) == class_5691.field_28064;
        class_5691 icicleThickness = IcicleBlock.calculateIcicleThickness(levelReader, blockPos, tipDirection, merged);
        return (class_2680)blockState.method_11657(THICKNESS, (Comparable)icicleThickness);
    }

    protected void method_19286(@NotNull class_1937 level, class_2680 blockState, class_3965 blockHitResult, class_1676 projectile) {
        if (!level.field_9236) {
            class_3218 serverLevel;
            class_2338 blockPos = blockHitResult.method_17777();
            if (level instanceof class_3218 && projectile.method_36971(serverLevel = (class_3218)level, blockPos) && projectile.method_54457(serverLevel) && projectile.method_18798().method_1033() > 0.4) {
                level.method_22352(blockPos, true);
            }
        }
    }

    public void triggerFall(@NotNull class_1937 level, @NotNull class_2338 blockPos) {
        level.method_64310(blockPos, (class_2248)this, 2);
    }

    protected void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (IcicleBlock.isIceSpike(blockState) && !this.method_9558(blockState, (class_4538)serverLevel, blockPos)) {
            serverLevel.method_22352(blockPos, true);
        } else {
            IcicleBlock.spawnFallingIcicle(blockState, serverLevel, blockPos);
        }
    }

    protected void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, @NotNull class_5819 randomSource) {
        if (IcicleBlock.isHangingIcicleStartPos(blockState, (class_4538)serverLevel, blockPos)) {
            if (randomSource.method_43057() <= 0.165f) {
                IcicleBlock.growIcicleIfPossible(blockState, serverLevel, blockPos);
            } else if (this.canRandomFall(serverLevel, blockPos, randomSource)) {
                this.triggerFall((class_1937)serverLevel, blockPos);
            } else if (randomSource.method_43057() <= 0.135f) {
                IcicleBlock.placeIciclesNearby(serverLevel, blockPos, 3, randomSource.method_43051(1, 2));
            }
        }
    }

    public static void placeIciclesNearby(@NotNull class_3218 level, @NotNull class_2338 blockPos, int distance, int maxNewIcicles) {
        if (IcicleBlock.canGrow(level.method_8320(blockPos.method_10084()), level.method_8320(blockPos.method_10086(2)))) {
            Iterator posesToCheck = class_2338.method_10097((class_2338)blockPos.method_10069(-distance, -distance, -distance), (class_2338)blockPos.method_10069(distance, distance, distance)).iterator();
            int count = 0;
            while (count < maxNewIcicles) {
                if (!posesToCheck.hasNext()) {
                    return;
                }
                class_2338 nextPos = (class_2338)posesToCheck.next();
                if (!level.method_8320(nextPos).method_26164(WWBlockTags.ICICLE_GROWS_WHEN_UNDER) || !IcicleUtils.spreadIcicleOnRandomTick(level, nextPos)) continue;
                ++count;
            }
        }
    }

    private boolean canRandomFall(class_3218 level, class_2338 pos, @NotNull class_5819 random) {
        if (random.method_43057() <= 0.075f && level.method_8320(pos.method_10084()).method_26164(WWBlockTags.ICICLE_FALLS_FROM)) {
            class_243 centerPos = class_243.method_24953((class_2382)pos);
            class_1657 player = level.method_64387(TARGETING_CONDITIONS, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215());
            if (player != null) {
                boolean isPlayerAbove = player.method_24515().method_10264() > pos.method_10264();
                double distance = player.method_5707(centerPos);
                return Math.sqrt(distance) <= 32.0 && (!isPlayerAbove || random.method_43057() <= 0.25f);
            }
            return random.method_43057() <= 0.05f;
        }
        return false;
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 blockPlaceContext) {
        class_2350 direction;
        class_2338 blockPos;
        class_1937 levelAccessor = blockPlaceContext.method_8045();
        class_2350 direction2 = IcicleBlock.calculateTipDirection((class_4538)levelAccessor, blockPos = blockPlaceContext.method_8037(), direction = blockPlaceContext.method_32760().method_10153());
        if (direction2 == null) {
            return null;
        }
        class_5691 icicleThickness = IcicleBlock.calculateIcicleThickness((class_4538)levelAccessor, blockPos, direction2, !blockPlaceContext.method_8046());
        return icicleThickness == null ? null : SnowloggingUtils.getSnowPlacementState((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(TIP_DIRECTION, (Comparable)direction2)).method_11657(THICKNESS, (Comparable)icicleThickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.method_8316(blockPos).method_15772() == class_3612.field_15910)), blockPlaceContext);
    }

    @NotNull
    protected class_3610 method_9545(@NotNull class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(blockState);
    }

    protected class_265 method_9571(class_2680 blockState) {
        return class_259.method_1073();
    }

    @NotNull
    protected class_265 method_9530(@NotNull class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        class_5691 icicleThickness = (class_5691)blockState.method_11654(THICKNESS);
        class_265 voxelShape = icicleThickness == class_5691.field_28064 ? TIP_MERGE_SHAPE : (icicleThickness == class_5691.field_28065 ? (blockState.method_11654(TIP_DIRECTION) == class_2350.field_11033 ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (icicleThickness == class_5691.field_28066 ? FRUSTUM_SHAPE : (icicleThickness == class_5691.field_28067 ? MIDDLE_SHAPE : BASE_SHAPE)));
        class_243 vec3 = blockState.method_26226(blockPos);
        return voxelShape.method_1096(vec3.field_1352, 0.0, vec3.field_1350);
    }

    @NotNull
    protected class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return this.method_9530(blockState, blockGetter, blockPos, collisionContext);
    }

    protected boolean method_37403(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return false;
    }

    protected float method_32913() {
        return 0.175f;
    }

    public void method_10129(@NotNull class_1937 level, class_2338 blockPos, @NotNull class_1540 fallingBlockEntity) {
        level.method_20290(2001, blockPos, class_2248.method_9507((class_2680)fallingBlockEntity.method_6962()));
    }

    @NotNull
    public class_1282 method_32898(@NotNull class_1297 entity) {
        return entity.method_48923().method_48796(WWDamageTypes.FALLING_ICICLE, entity);
    }

    private static void spawnFallingIcicle(class_2680 blockState, class_3218 serverLevel, @NotNull class_2338 blockPos) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        class_2680 blockState2 = blockState;
        while (IcicleBlock.isHangingIcicle(blockState2)) {
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)serverLevel, (class_2338)mutableBlockPos, (class_2680)blockState2);
            fallingBlockEntity.method_49181();
            if (IcicleBlock.isTip(blockState2, true)) {
                int i = Math.max(1 + blockPos.method_10264() - mutableBlockPos.method_10264(), 6);
                fallingBlockEntity.method_6965((float)i, 10);
                break;
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
            blockState2 = serverLevel.method_8320((class_2338)mutableBlockPos);
        }
    }

    @VisibleForTesting
    public static void growIcicleIfPossible(class_2680 blockState, @NotNull class_3218 serverLevel, @NotNull class_2338 blockPos) {
        class_2680 tipState;
        class_2338 tipPos;
        class_2680 aboveTwiceState;
        class_2680 aboveState = serverLevel.method_8320(blockPos.method_10086(1));
        if (IcicleBlock.canGrow(aboveState, aboveTwiceState = serverLevel.method_8320(blockPos.method_10086(2))) && (tipPos = IcicleBlock.findTip(blockState, (class_1936)serverLevel, blockPos, 7, false)) != null && IcicleBlock.canDrip(tipState = serverLevel.method_8320(tipPos)) && IcicleBlock.canTipGrow(tipState, serverLevel, tipPos)) {
            IcicleBlock.grow(serverLevel, tipPos, class_2350.field_11033);
        }
    }

    public static void grow(@NotNull class_3218 serverLevel, @NotNull class_2338 blockPos, class_2350 direction) {
        class_2338 blockPos2 = blockPos.method_10093(direction);
        class_2680 blockState = serverLevel.method_8320(blockPos2);
        if (IcicleBlock.isUnmergedTipWithDirection(blockState, direction.method_10153())) {
            IcicleBlock.createMergedTips(blockState, (class_1936)serverLevel, blockPos2);
        } else if (blockState.method_26215() || blockState.method_27852(class_2246.field_10382)) {
            IcicleBlock.createIcicle((class_1936)serverLevel, blockPos2, direction, class_5691.field_28065);
        }
    }

    private static void createIcicle(@NotNull class_1936 levelAccessor, class_2338 blockPos, class_2350 direction, class_5691 icicleThickness) {
        class_2680 blockState = (class_2680)((class_2680)((class_2680)WWBlocks.ICICLE.method_9564().method_11657(TIP_DIRECTION, (Comparable)direction)).method_11657(THICKNESS, (Comparable)icicleThickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.method_8316(blockPos).method_15772() == class_3612.field_15910));
        levelAccessor.method_8652(blockPos, blockState, 3);
    }

    private static void createMergedTips(@NotNull class_2680 blockState, class_1936 levelAccessor, class_2338 blockPos) {
        boolean isUp = blockState.method_11654(TIP_DIRECTION) == class_2350.field_11036;
        IcicleBlock.createIcicle(levelAccessor, isUp ? blockPos.method_10084() : blockPos, class_2350.field_11033, class_5691.field_28064);
        IcicleBlock.createIcicle(levelAccessor, isUp ? blockPos : blockPos.method_10074(), class_2350.field_11036, class_5691.field_28064);
    }

    @Nullable
    public static class_2338 findTip(class_2680 blockState, class_1936 levelAccessor, class_2338 blockPos, int i, boolean bl) {
        if (IcicleBlock.isTip(blockState, bl)) {
            return blockPos;
        }
        class_2350 direction = (class_2350)blockState.method_11654(TIP_DIRECTION);
        BiPredicate<class_2338, class_2680> biPredicate = (blockPosx, blockStatex) -> blockStatex.method_27852((class_2248)WWBlocks.ICICLE) && blockStatex.method_11654(TIP_DIRECTION) == direction;
        return IcicleBlock.findBlockVertical(levelAccessor, blockPos, direction.method_10171(), biPredicate, blockStatex -> IcicleBlock.isTip(blockStatex, bl), i).orElse(null);
    }

    @Nullable
    private static class_2350 calculateTipDirection(class_4538 levelReader, class_2338 blockPos, class_2350 direction) {
        if (IcicleBlock.isValidIciclePlacement(levelReader, blockPos, direction)) {
            return direction;
        }
        if (!IcicleBlock.isValidIciclePlacement(levelReader, blockPos, direction.method_10153())) {
            return null;
        }
        return direction.method_10153();
    }

    private static class_5691 calculateIcicleThickness(@NotNull class_4538 levelReader, @NotNull class_2338 blockPos, @NotNull class_2350 direction, boolean bl) {
        class_2350 direction2 = direction.method_10153();
        class_2680 blockState = levelReader.method_8320(blockPos.method_10093(direction));
        if (IcicleBlock.isIcicleWithDirection(blockState, direction2)) {
            return !bl && blockState.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!IcicleBlock.isIcicleWithDirection(blockState, direction)) {
            return class_5691.field_28065;
        }
        class_5691 dripstoneThickness = (class_5691)blockState.method_11654(THICKNESS);
        if (dripstoneThickness != class_5691.field_28065 && dripstoneThickness != class_5691.field_28064) {
            class_2680 blockState2 = levelReader.method_8320(blockPos.method_10093(direction2));
            return !IcicleBlock.isIcicleWithDirection(blockState2, direction) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    public static boolean canDrip(class_2680 blockState) {
        return IcicleBlock.isHangingIcicle(blockState) && blockState.method_11654(THICKNESS) == class_5691.field_28065 && (Boolean)blockState.method_11654((class_2769)WATERLOGGED) == false;
    }

    public static boolean canTipGrow(@NotNull class_2680 blockState, @NotNull class_3218 serverLevel, @NotNull class_2338 blockPos) {
        class_2350 direction = (class_2350)blockState.method_11654(TIP_DIRECTION);
        class_2338 blockPos2 = blockPos.method_10093(direction);
        class_2680 blockState2 = serverLevel.method_8320(blockPos2);
        if (!blockState2.method_26227().method_15769()) {
            return false;
        }
        return blockState2.method_26215() || IcicleBlock.isUnmergedTipWithDirection(blockState2, direction.method_10153());
    }

    private static boolean isValidIciclePlacement(@NotNull class_4538 levelReader, @NotNull class_2338 blockPos, @NotNull class_2350 direction) {
        class_2338 blockPos2 = blockPos.method_10093(direction.method_10153());
        class_2680 blockState = levelReader.method_8320(blockPos2);
        return blockState.method_26206((class_1922)levelReader, blockPos2, direction) || IcicleBlock.isIcicleWithDirection(blockState, direction);
    }

    private static boolean isTip(@NotNull class_2680 blockState, boolean bl) {
        if (!blockState.method_27852((class_2248)WWBlocks.ICICLE)) {
            return false;
        }
        class_5691 dripstoneThickness = (class_5691)blockState.method_11654(THICKNESS);
        return dripstoneThickness == class_5691.field_28065 || bl && dripstoneThickness == class_5691.field_28064;
    }

    private static boolean isUnmergedTipWithDirection(class_2680 blockState, class_2350 direction) {
        return IcicleBlock.isTip(blockState, false) && blockState.method_11654(TIP_DIRECTION) == direction;
    }

    private static boolean isHangingIcicle(class_2680 blockState) {
        return IcicleBlock.isIcicleWithDirection(blockState, class_2350.field_11033);
    }

    private static boolean isIceSpike(class_2680 blockState) {
        return IcicleBlock.isIcicleWithDirection(blockState, class_2350.field_11036);
    }

    private static boolean isHangingIcicleStartPos(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        return IcicleBlock.isHangingIcicle(blockState) && !levelReader.method_8320(blockPos.method_10084()).method_27852((class_2248)WWBlocks.ICICLE);
    }

    protected boolean method_9516(class_2680 blockState, class_10 pathComputationType) {
        return false;
    }

    private static boolean isIcicleWithDirection(@NotNull class_2680 blockState, class_2350 direction) {
        return blockState.method_27852((class_2248)WWBlocks.ICICLE) && blockState.method_11654(TIP_DIRECTION) == direction;
    }

    public static boolean canGrow(@NotNull class_2680 blockState, class_2680 aboveState) {
        return blockState.method_27852((class_2248)WWBlocks.FRAGILE_ICE) || blockState.method_26164(WWBlockTags.ICICLE_GROWS_WHEN_UNDER) && IcicleBlock.isValidWaterForGrowing(aboveState);
    }

    public static boolean canSpreadTo(@NotNull class_2680 blockState) {
        return blockState.method_27852((class_2248)WWBlocks.FRAGILE_ICE) || blockState.method_26164(WWBlockTags.ICICLE_GROWS_WHEN_UNDER);
    }

    public static boolean isValidWaterForGrowing(@NotNull class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10382) && blockState.method_26227().method_15771();
    }

    private static Optional<class_2338> findBlockVertical(class_1936 levelAccessor, @NotNull class_2338 blockPos, class_2350.class_2352 axisDirection, BiPredicate<class_2338, class_2680> biPredicate, Predicate<class_2680> predicate, int i) {
        class_2350 direction = class_2350.method_10156((class_2350.class_2352)axisDirection, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (int j = 1; j < i; ++j) {
            mutableBlockPos.method_10098(direction);
            class_2680 blockState = levelAccessor.method_8320((class_2338)mutableBlockPos);
            if (predicate.test(blockState)) {
                return Optional.of(mutableBlockPos.method_10062());
            }
            if (!levelAccessor.method_31601(mutableBlockPos.method_10264()) && biPredicate.test((class_2338)mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new IcicleBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, class_2680 blockState, class_2591<T> type) {
        return !level.field_9236 ? IcicleBlock.method_31618(type, WWBlockEntityTypes.ICICLE, (worldx, pos, statex, blockEntity) -> blockEntity.serverTick(worldx, pos, statex)) : null;
    }
}

