/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.frozenblock.wilderwild.block.impl.SnowloggingUtils;
import net.frozenblock.wilderwild.config.WWAmbienceAndMiscConfig;
import net.frozenblock.wilderwild.entity.FallingLeafTicker;
import net.frozenblock.wilderwild.particle.options.WWFallingLeavesParticleOptions;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.minecraft.class_10595;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallingLeafUtil {
    private static final LeafParticleData DEFAULT_LEAF_PARTICLE_DATA = new LeafParticleData(class_2246.field_10503, 0.0125f, () -> 1.0, 4, 2.0f, 10.0f, true);
    private static final Map<class_2248, FallingLeafData> LEAVES_TO_FALLING_LEAF_DATA = new Object2ObjectLinkedOpenHashMap();
    private static final Map<class_2396<WWFallingLeavesParticleOptions>, LeafParticleData> PARTICLE_TO_LEAF_PARTICLE_DATA = new Object2ObjectLinkedOpenHashMap();

    public static void registerFallingLeafWithLitter(class_2248 block, class_10595 leafLitterBlock, float litterChance, class_2396<WWFallingLeavesParticleOptions> leafParticle, float particleChance, Supplier<Double> frequencyModifier, int textureSize, float particleGravityScale, float windScale, boolean swirl) {
        FallingLeafUtil.registerFallingLeaf(block, new FallingLeafData(Optional.of(leafLitterBlock), litterChance, leafParticle), leafParticle, new LeafParticleData(block, particleChance, frequencyModifier, textureSize, particleGravityScale, windScale, swirl));
    }

    public static void registerFallingLeaf(class_2248 block, class_2396<WWFallingLeavesParticleOptions> leafParticle, float particleChance, Supplier<Double> frequencyModifier, int textureSize, float particleGravityScale, float windScale, boolean swirl) {
        FallingLeafUtil.registerFallingLeaf(block, new FallingLeafData(Optional.empty(), 0.0f, leafParticle), leafParticle, new LeafParticleData(block, particleChance, frequencyModifier, textureSize, particleGravityScale, windScale, swirl));
    }

    private static void registerFallingLeaf(class_2248 block, FallingLeafData fallingLeafData, class_2396<WWFallingLeavesParticleOptions> leafParticle, @Nullable LeafParticleData leafParticleData) {
        if (block instanceof class_2397) {
            class_2397 leavesBlock = (class_2397)block;
            LEAVES_TO_FALLING_LEAF_DATA.put((class_2248)leavesBlock, fallingLeafData);
            if (leafParticleData != null) {
                PARTICLE_TO_LEAF_PARTICLE_DATA.put(leafParticle, leafParticleData);
            }
        } else {
            throw new IllegalStateException("Block should be an instance of LeavesBlock!");
        }
    }

    @NotNull
    public static Optional<FallingLeafData> getFallingLeafData(class_2248 block) {
        return Optional.ofNullable(LEAVES_TO_FALLING_LEAF_DATA.get(block));
    }

    public static LeafParticleData getLeafParticleData(class_2396<WWFallingLeavesParticleOptions> leafParticle) {
        return PARTICLE_TO_LEAF_PARTICLE_DATA.getOrDefault(leafParticle, DEFAULT_LEAF_PARTICLE_DATA);
    }

    public static void onRandomTick(@NotNull class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        Optional<FallingLeafData> optionalFallingLeafData = FallingLeafUtil.getFallingLeafData(state.method_26204());
        if (optionalFallingLeafData.isPresent()) {
            FallingLeafData fallingLeafData = optionalFallingLeafData.get();
            class_2338 belowPos = pos.method_10074();
            class_2680 belowState = world.method_8320(belowPos);
            if (!class_2248.method_9501((class_265)belowState.method_26220((class_1922)world, belowPos), (class_2350)class_2350.field_11036) && random.method_43057() <= fallingLeafData.litterChance()) {
                world.method_65096((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() - 0.1, (double)pos.method_10260() + 0.5, random.method_43051(12, 24), 0.3, 0.0, 0.3, 0.05);
                FallingLeafUtil.sendLeafClusterParticle(world, pos, fallingLeafData);
                fallingLeafData.leafLitterBlock.ifPresent(leafLitterBlock -> FallingLeafTicker.createAndSpawn(WWEntityTypes.FALLING_LEAVES, (class_1937)world, pos, (class_2248)leafLitterBlock));
            }
        }
    }

    public static void sendLeafClusterParticle(@NotNull class_3218 world, @NotNull class_2338 pos, @NotNull FallingLeafData fallingLeafData) {
        world.method_65096((class_2394)WWParticleTypes.LEAF_CLUSTER_SPAWNER, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static boolean isSafePosToPlaceLitter(@NotNull class_1937 world, class_2338 pos, @NotNull class_2680 stateToReplace, class_2248 leafLitterBlock) {
        if (stateToReplace.method_27852(class_2246.field_10477) || SnowloggingUtils.isSnowlogged(stateToReplace)) {
            return false;
        }
        if ((stateToReplace.method_26215() || stateToReplace.method_45474() || stateToReplace.method_27852(leafLitterBlock)) && stateToReplace.method_26227().method_15769()) {
            return leafLitterBlock.method_9558(leafLitterBlock.method_9564(), (class_4538)world, pos);
        }
        return false;
    }

    public static boolean addFallingLeafParticles(@NotNull class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        Optional<FallingLeafData> optionalFallingLeafData;
        if (WWAmbienceAndMiscConfig.Client.USE_WILDER_WILD_FALLING_LEAVES && (optionalFallingLeafData = FallingLeafUtil.getFallingLeafData(state.method_26204())).isPresent()) {
            class_2338 blockPos;
            class_2680 blockState;
            FallingLeafData fallingLeafData = optionalFallingLeafData.get();
            class_2396<WWFallingLeavesParticleOptions> leafParticle = fallingLeafData.particle();
            LeafParticleData leafParticleData = FallingLeafUtil.getLeafParticleData(leafParticle);
            if ((double)random.method_43057() <= (double)leafParticleData.particleChance() * leafParticleData.frequencyModifier().get() && !class_2248.method_9501((class_265)(blockState = world.method_8320(blockPos = pos.method_10074())).method_26220((class_1922)world, blockPos), (class_2350)class_2350.field_11036)) {
                class_5945.method_49099((class_1937)world, (class_2338)pos, (class_5819)random, (class_2394)FallingLeafUtil.createLeafParticleOptions(fallingLeafData));
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static WWFallingLeavesParticleOptions createLeafParticleOptions(@NotNull FallingLeafData fallingLeafData) {
        class_2396<WWFallingLeavesParticleOptions> leafParticle = fallingLeafData.particle();
        LeafParticleData leafParticleData = FallingLeafUtil.getLeafParticleData(leafParticle);
        return WWFallingLeavesParticleOptions.create(fallingLeafData.particle, leafParticleData.textureSize, leafParticleData.particleGravityScale, leafParticleData.windScale, leafParticleData.swirl);
    }

    public record FallingLeafData(Optional<class_10595> leafLitterBlock, float litterChance, class_2396<WWFallingLeavesParticleOptions> particle) {
    }

    public record LeafParticleData(class_2248 leavesBlock, float particleChance, Supplier<Double> frequencyModifier, int textureSize, float particleGravityScale, float windScale, boolean swirl) {
    }
}

