/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.impl;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.wilderwild.block.GeyserBlock;
import net.frozenblock.wilderwild.block.state.properties.GeyserType;
import net.frozenblock.wilderwild.particle.options.WindParticleOptions;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4066;
import net.minecraft.class_5819;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;

public class GeyserParticleHandler {
    public static final float DORMANT_BUBBLE_CHANCE = 0.0195f;
    public static final double DORMANT_BUBBLE_MIN_VELOCITY = 0.09;
    public static final double DORMANT_BUBBLE_MAX_VELOCITY = 0.12;
    public static final float ACTIVE_BUBBLE_CHANCE = 0.1f;
    public static final int MIN_ACTIVE_BUBBLES = 1;
    public static final int MAX_ACTIVE_BUBBLES = 3;
    public static final double ACTIVE_BUBBLE_MIN_VELOCITY_OFFSET = 0.4;
    public static final double ACTIVE_BUBBLE_MAX_VELOCITY_OFFSET = 0.8;
    public static final double ACTIVE_BUBBLE_RANDOM_VELOCITY = 0.1;
    public static final float ACTIVE_LAVA_CHANCE = 0.0575f;
    public static final int MIN_ACTIVE_LAVA = 1;
    public static final int MAX_ACTIVE_LAVA = 2;
    public static final double ACTIVE_LAVA_MIN_VELOCITY = 0.06;
    public static final double ACTIVE_LAVA_MAX_VELOCITY = 0.1;
    public static final double ACTIVE_LAVA_RANDOM_VELOCITY = 0.1;
    public static final float ACTIVE_FLAME_CHANCE = 0.0875f;
    public static final double ACTIVE_FLAME_MIN_VELOCITY = 0.2;
    public static final double ACTIVE_FLAME_MAX_VELOCITY = 0.4;
    public static final double ACTIVE_FLAME_RANDOM_VELOCITY = 0.1;
    public static final float ACTIVE_DUST_CHANCE = 0.185f;
    public static final int MIN_ACTIVE_DUST = 1;
    public static final int MAX_ACTIVE_DUST = 4;
    public static final double ACTIVE_DUST_MIN_VELOCITY = 0.06;
    public static final double ACTIVE_DUST_MAX_VELOCITY = 0.4;
    public static final double ACTIVE_DUST_RANDOM_VELOCITY = 0.4;
    public static final int VENT_MIN_PARTICLE_SPAWN_WIDTH = -5;
    public static final int VENT_MAX_PARTICLE_SPAWN_WIDTH = 5;
    public static final int VENT_MIN_PARTICLE_SPAWN_HEIGHT = -3;
    public static final int VENT_MAX_PARTICLE_SPAWN_HEIGHT = 7;
    public static final int VENT_PARTICLE_SPAWN_ATTEMPTS = 6;

    public static void spawnDormantParticles(@NotNull class_1937 level, class_2338 blockPos, @NotNull GeyserType geyserType, class_2350 direction, class_5819 random) {
        if (geyserType.isWater() && random.method_43057() <= 0.0195f) {
            class_243 particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
            class_243 particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.09, 0.12);
            level.method_8406((class_2394)class_2398.field_11247, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
        }
    }

    public static void spawnActiveParticles(@NotNull class_1937 level, class_2338 blockPos, @NotNull GeyserType geyserType, class_2350 direction, class_5819 random) {
        block8: {
            class_243 particleVelocity;
            class_243 particlePos;
            block7: {
                if (!geyserType.isWater()) break block7;
                if (!(random.method_43057() <= 0.1f)) break block8;
                int count = random.method_43051(1, 3);
                for (int i = 0; i < count; ++i) {
                    class_243 particlePos2 = GeyserBlock.getParticlePos(blockPos, direction, random);
                    class_243 particleVelocity2 = GeyserBlock.getParticleVelocity(direction, random, 0.4, 0.8);
                    particleVelocity2 = particleVelocity2.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos2, random, 0.1));
                    level.method_8406((class_2394)class_2398.field_11247, particlePos2.field_1352, particlePos2.field_1351, particlePos2.field_1350, particleVelocity2.field_1352, particleVelocity2.field_1351, particleVelocity2.field_1350);
                }
                break block8;
            }
            if (geyserType == GeyserType.LAVA) {
                if (random.method_43057() <= 0.0575f) {
                    int count = random.method_43051(1, 2);
                    for (int i = 0; i < count; ++i) {
                        particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                        particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.06, 0.1);
                        particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.1));
                        level.method_8406((class_2394)class_2398.field_11237, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
                    }
                }
                if (random.method_43057() <= 0.0875f) {
                    class_243 particlePos3 = GeyserBlock.getParticlePos(blockPos, direction, random);
                    class_243 particleVelocity3 = GeyserBlock.getParticleVelocity(direction, random, 0.2, 0.4);
                    particleVelocity3 = particleVelocity3.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos3, random, 0.1));
                    level.method_17452((class_2394)class_2398.field_11240, true, particlePos3.field_1352, particlePos3.field_1351, particlePos3.field_1350, particleVelocity3.field_1352, particleVelocity3.field_1351, particleVelocity3.field_1350);
                }
            }
            if (random.method_43057() <= 0.185f) {
                int count = random.method_43051(1, 4);
                for (int i = 0; i < count; ++i) {
                    particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                    particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.06, 0.4);
                    particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.4));
                    level.method_8406((class_2394)class_2398.field_46763, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnEruptionParticles(@NotNull class_1937 level, class_2338 blockPos, @NotNull GeyserType geyserType, class_2350 direction, class_5819 random) {
        block14: {
            class_243 particleVelocity;
            class_243 particlePos;
            int i;
            boolean vent;
            class_702 particleEngine;
            class_4066 particleStatus;
            block13: {
                int count;
                class_310 client = class_310.method_1551();
                particleStatus = (class_4066)client.field_1690.method_42475().method_41753();
                particleEngine = client.field_1713;
                boolean bl = vent = geyserType == GeyserType.HYDROTHERMAL_VENT;
                if (geyserType.isWater()) {
                    if (random.method_43057() <= 0.4f && (!vent || random.method_43056())) {
                        count = random.method_43051(1, 4);
                        for (i = 0; i < count; ++i) {
                            particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                            particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 1.7, 4.0);
                            particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.15));
                            level.method_17452((class_2394)class_2398.field_11247, !vent && random.method_43056(), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
                        }
                    }
                    if (vent && random.method_43057() <= 0.3f) {
                        count = random.method_43051(1, 2);
                        for (i = 0; i < count; ++i) {
                            particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                            particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.05, 0.15);
                            particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.055));
                            level.method_8406((class_2394)class_2398.field_11237, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
                        }
                    }
                } else if (random.method_43057() <= 0.5f) {
                    count = random.method_43051(1, 5);
                    for (i = 0; i < count; ++i) {
                        particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                        particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.8, 1.4);
                        particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.275));
                        level.method_8406((class_2394)class_2398.field_46763, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
                    }
                }
                if (geyserType != GeyserType.LAVA) break block13;
                if (random.method_43057() <= 0.7f) {
                    count = random.method_43051(1, 4);
                    for (i = 0; i < count; ++i) {
                        particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                        particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.2, 0.9);
                        particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.275));
                        level.method_8406((class_2394)class_2398.field_11237, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
                    }
                }
                count = random.method_43051(1, 5);
                for (i = 0; i < count; ++i) {
                    if (!(random.method_43057() <= 0.9f)) continue;
                    particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                    particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.1, 0.6);
                    particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.225));
                    level.method_17452((class_2394)class_2398.field_11240, false, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
                }
                int lavaCount = random.method_43051(1, 3);
                for (int i2 = 0; !(i2 >= lavaCount || particleStatus == class_4066.field_18198 && random.method_43056() || particleStatus == class_4066.field_18199 && random.method_43057() <= 0.675f); ++i2) {
                    class_243 particlePos2 = GeyserBlock.getParticlePos(blockPos, direction, random);
                    class_243 particleVelocity2 = GeyserBlock.getParticleVelocity(direction, random, 0.6, 0.8);
                    particleVelocity2 = particleVelocity2.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos2, random, 0.2));
                    class_703 lavaParticle = particleEngine.method_3056((class_2394)class_2398.field_11239, particlePos2.field_1352, particlePos2.field_1351, particlePos2.field_1350, particleVelocity2.field_1352, particleVelocity2.field_1351, particleVelocity2.field_1350);
                    if (lavaParticle == null) continue;
                    lavaParticle.field_3852 = particleVelocity2.field_1352;
                    lavaParticle.field_3869 = particleVelocity2.field_1351;
                    lavaParticle.field_3850 = particleVelocity2.field_1350;
                }
                break block14;
            }
            if (vent) break block14;
            int windCount = random.method_43051(0, 2);
            for (i = 0; !(i >= windCount || particleStatus == class_4066.field_18198 && random.method_43056() || particleStatus == class_4066.field_18199 && random.method_43057() <= 0.675f); ++i) {
                particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
                particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.6, 0.8);
                particleVelocity = particleVelocity.method_1019(GeyserBlock.getVelocityFromDistance(blockPos, direction, particlePos, random, 0.2));
                particleEngine.method_3056((class_2394)new WindParticleOptions(12, particleVelocity), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnBaseGeyserParticles(class_1937 level, class_2338 blockPos, class_2350 direction, class_5819 random, boolean vent) {
        int i;
        class_310 client = class_310.method_1551();
        class_4066 particleStatus = (class_4066)client.field_1690.method_42475().method_41753();
        if (particleStatus == class_4066.field_18199) {
            return;
        }
        class_702 particleEngine = client.field_1713;
        float chance = particleStatus == class_4066.field_18198 ? 0.3f : 1.0f;
        int count = vent ? random.method_43051(2, 5) : random.method_43051(0, 3);
        for (i = 0; i < count; ++i) {
            if (!(random.method_43057() <= chance)) continue;
            class_243 particlePos = GeyserBlock.getParticlePos(blockPos, direction, random);
            class_243 particleVelocity = GeyserBlock.getParticleVelocity(direction, random, 0.001, 0.005);
            class_703 particle = particleEngine.method_3056((class_2394)(vent ? class_2398.field_11237 : class_2398.field_46911), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
            if (particle == null) continue;
            particle.field_3852 = particleVelocity.field_1352;
            particle.field_3869 = particleVelocity.field_1351;
            particle.field_3850 = particleVelocity.field_1350;
        }
        if (vent) {
            i = blockPos.method_10263();
            int j = blockPos.method_10264();
            int k = blockPos.method_10260();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int l = 0; l < 6; ++l) {
                mutable.method_10103(i + class_3532.method_15395((class_5819)random, (int)-5, (int)5), j + class_3532.method_15395((class_5819)random, (int)-3, (int)7), k + class_3532.method_15395((class_5819)random, (int)-5, (int)5));
                class_2680 blockState = level.method_8320((class_2338)mutable);
                if (!blockState.method_27852(class_2246.field_10382) || blockState.method_26227().method_15761() != 8) continue;
                level.method_8406((class_2394)WWParticleTypes.UNDERWATER_ASH, (double)mutable.method_10263() + random.method_43058(), (double)mutable.method_10264() + random.method_43058(), (double)mutable.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
            }
        }
    }
}

