/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.termite;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.frozenblock.wilderwild.advancement.TermiteEatTrigger;
import net.frozenblock.wilderwild.block.termite.TermiteBlockBehavior;
import net.frozenblock.wilderwild.block.termite.TermiteBlockBehaviors;
import net.frozenblock.wilderwild.config.WWBlockConfig;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWCriteria;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TermiteManager {
    public static final int TERMITE_COUNT_ASLEEP = 1;
    public static final int TERMITE_COUNT_ASLEEP_NATURAL = 0;
    public static final int TERMITE_COUNT = 3;
    public static final int PARTICLE_COUNT_WHILE_EATING = 4;
    public static final int PARTICLE_COUNT = 6;
    public static final float BLOCK_SOUND_VOLUME = 0.6f;
    private final ArrayList<Termite> termites = new ArrayList();
    public int ticksToNextTermite;
    public int highestID;
    public static final int TERMITE_RELEASE_COUNTDOWN = 200;
    public static final int TERMITE_RELEASE_COUNTDOWN_NATURAL = 320;

    public static int maxTermites(boolean natural, boolean awake, boolean canSpawn) {
        if (!canSpawn) {
            return 0;
        }
        if (!awake) {
            return natural ? 0 : 1;
        }
        return 3;
    }

    public static boolean areTermitesSafe(@NotNull class_4538 level, @NotNull class_2338 pos) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        for (class_2350 direction : class_2350.values()) {
            if (!TermiteManager.isPosSafeForTermites(level, (class_2338)mutableBlockPos.method_10098(direction))) {
                return false;
            }
            mutableBlockPos.method_10104(direction, -1);
        }
        return true;
    }

    public static boolean isPosSafeForTermites(@NotNull class_4538 level, @NotNull class_2338 pos) {
        return TermiteManager.isStateSafeForTermites(level.method_8320(pos));
    }

    public static boolean isStateSafeForTermites(@NotNull class_2680 state) {
        return !state.method_26164(WWBlockTags.KILLS_TERMITE) && state.method_26227().method_15769();
    }

    public void addTermite(@NotNull class_2338 pos) {
        Termite termite = new Termite(pos, pos, 0, 0, 0, false, ++this.highestID);
        this.termites.add(termite);
    }

    public void tick(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural, boolean awake, boolean canSpawn, Runnable onTermitesUpdated) {
        int maxTermites = TermiteManager.maxTermites(natural, awake, canSpawn);
        AtomicBoolean termitesUpdated = new AtomicBoolean();
        class_5819 random = level.method_8409();
        this.termites.removeIf(termite -> {
            if (termite.tick(level, natural, random)) {
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    class_2338 termitePos = termite.getPos();
                    serverLevel.method_65096((class_2394)WWParticleTypes.TERMITE, (double)termitePos.method_10263() + 0.5, (double)termitePos.method_10264() + 0.5, (double)termitePos.method_10260() + 0.5, termite.eating ? 4 : 6, 0.0, 0.0, 0.0, 0.0);
                    termitesUpdated.set(true);
                }
            } else {
                level.method_8396(null, termite.pos, WWSounds.BLOCK_TERMITE_MOUND_ENTER, class_3419.field_15254, 0.6f, 1.0f);
                level.method_43275(null, (class_6880)class_5712.field_28733, class_243.method_24953((class_2382)pos));
                termitesUpdated.set(true);
                return true;
            }
            return false;
        });
        if (this.termites.size() < maxTermites) {
            if (this.ticksToNextTermite > 0) {
                --this.ticksToNextTermite;
            } else {
                this.addTermite(pos);
                level.method_43275(null, (class_6880)class_5712.field_28733, class_243.method_24953((class_2382)pos));
                level.method_8396(null, pos, WWSounds.BLOCK_TERMITE_MOUND_EXIT, class_3419.field_15254, 0.6f, 1.0f);
                this.ticksToNextTermite = natural ? 320 : 200;
                termitesUpdated.set(true);
            }
        }
        while (this.termites.size() > maxTermites) {
            Termite termite2 = this.termites.get(random.method_43048(this.termites.size()));
            level.method_8396(null, termite2.pos, WWSounds.BLOCK_TERMITE_MOUND_ENTER, class_3419.field_15254, 0.6f, 1.0f);
            this.termites.remove(termite2);
            level.method_43275(null, (class_6880)class_5712.field_28733, class_243.method_24953((class_2382)pos));
            termitesUpdated.set(true);
        }
        if (termitesUpdated.get()) {
            onTermitesUpdated.run();
        }
    }

    public void clearTermites(@NotNull class_1937 level) {
        for (Termite termite : this.termites) {
            level.method_8396(null, termite.pos, WWSounds.BLOCK_TERMITE_MOUND_ENTER, class_3419.field_15254, 0.6f, 1.0f);
        }
        this.termites.clear();
    }

    public ArrayList<Termite> termites() {
        return this.termites;
    }

    public void saveAdditional(@NotNull class_2487 tag) {
        tag.method_67493("termites", Termite.LIST_CODEC, (DynamicOps)class_2509.field_11560, this.termites);
        tag.method_10569("ticksToNextTermite", this.ticksToNextTermite);
        tag.method_10569("highestID", this.highestID);
    }

    public void load(@NotNull class_2487 tag) {
        this.termites.clear();
        tag.method_67492("termites", Termite.LIST_CODEC, (DynamicOps)class_2509.field_11560).ifPresent(this.termites::addAll);
        this.ticksToNextTermite = tag.method_68083("ticksToNextTermite", 0);
        this.highestID = tag.method_68083("highestID", 0);
    }

    public static class Termite {
        public static final int DESTROY_POWER_BEFORE_BLOCK_BREAKS = 200;
        public static final int DESTROY_POWER_LEAVES = 4;
        public static final int DESTROY_POWER_BREAKABLE = 2;
        public static final int DESTROY_POWER = 1;
        public static final int MAX_IDLE_TICKS = 2000;
        public static final int MAX_IDLE_TICKS_NATURAL = 1200;
        public static final int UPDATE_DELAY_IN_TICKS = 1;
        public static final int GNAW_PARTICLE_CHANCE = 4;
        public static final int MIN_GNAW_PARTICLES = 0;
        public static final int MAX_GNAW_PARTICLES = 3;
        public static final int MIN_EAT_PARTICLES = 18;
        public static final int MAX_EAT_PARTICLES = 25;
        public static final Codec<Termite> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("mound").forGetter(Termite::getMoundPos), (App)class_2338.field_25064.fieldOf("pos").forGetter(Termite::getPos), (App)Codec.intRange((int)0, (int)201).fieldOf("block_destroy_power").orElse((Object)0).forGetter(Termite::getBlockDestroyPower), (App)Codec.INT.fieldOf("idle_ticks").orElse((Object)0).forGetter(Termite::getIdleTicks), (App)Codec.INT.fieldOf("update_delay").orElse((Object)0).forGetter(Termite::getUpdateTicks), (App)Codec.BOOL.fieldOf("eating").orElse((Object)true).forGetter(Termite::getEating), (App)Codec.INT.fieldOf("id").orElse((Object)0).forGetter(Termite::getID)).apply((Applicative)instance, Termite::new));
        public static final Codec<List<Termite>> LIST_CODEC = CODEC.listOf();
        public class_2338 mound;
        public class_2338 pos;
        public int blockDestroyPower;
        public int idleTicks;
        public int update;
        public boolean eating;
        public int id;

        public Termite(@NotNull class_2338 mound, @NotNull class_2338 pos, int blockDestroyPower, int aliveTicks, int update) {
            this.mound = mound;
            this.pos = pos;
            this.blockDestroyPower = blockDestroyPower;
            this.idleTicks = aliveTicks;
            this.update = update;
        }

        public Termite(@NotNull class_2338 mound, @NotNull class_2338 pos, int blockDestroyPower, int aliveTicks, int update, boolean eating, int id) {
            this.mound = mound;
            this.pos = pos;
            this.blockDestroyPower = blockDestroyPower;
            this.idleTicks = aliveTicks;
            this.update = update;
            this.eating = eating;
            this.id = id;
        }

        public boolean tick(@NotNull class_1937 level, boolean natural, class_5819 random) {
            boolean exit = false;
            ++this.idleTicks;
            if (this.idleTicks > (natural ? 1200 : 2000) || Termite.isTooFar(natural, this.mound, this.pos)) {
                return false;
            }
            if (!TermiteManager.areTermitesSafe((class_4538)level, this.pos)) {
                return false;
            }
            if (Termite.isPosTickable((class_1936)level, this.pos)) {
                class_2680 blockState = level.method_8320(this.pos);
                Optional<class_6880<TermiteBlockBehavior>> optionalBlockBehavior = TermiteBlockBehaviors.getTermiteBlockBehavior(level.method_30349(), blockState.method_26204(), natural);
                if (optionalBlockBehavior.isPresent() && Termite.isEdibleProperty(blockState)) {
                    TermiteBlockBehavior termiteBlockBehavior = (TermiteBlockBehavior)optionalBlockBehavior.get().comp_349();
                    boolean destroysBlock = termiteBlockBehavior.destroysBlock();
                    this.eating = true;
                    exit = true;
                    int additionalPower = destroysBlock ? (blockState.method_26164(class_3481.field_15503) ? 4 : 2) : 1;
                    this.blockDestroyPower += additionalPower;
                    Termite.spawnGnawParticles(level, blockState, this.pos, random);
                    if (this.blockDestroyPower > 200) {
                        this.blockDestroyPower = 0;
                        int n = this.idleTicks = natural ? Math.max(0, this.idleTicks - 200 / additionalPower) : 0;
                        if (level instanceof class_3218) {
                            class_3218 serverLevel = (class_3218)level;
                            for (class_3222 serverPlayer : serverLevel.method_18766(serverPlayerx -> serverPlayerx.method_5707(this.getCenterOfPos()) < TermiteEatTrigger.TRIGGER_DISTANCE_FROM_PLAYER)) {
                                WWCriteria.TERMITE_EAT.trigger(serverPlayer, serverLevel, this.pos, !natural);
                            }
                        }
                        if (destroysBlock) {
                            level.method_22352(this.pos, true);
                        } else {
                            level.method_31595(this.pos, blockState);
                            class_2248 setBlock = termiteBlockBehavior.getOutputBlock().get();
                            class_2680 setState = termiteBlockBehavior.copyProperties() ? setBlock.method_34725(blockState) : setBlock.method_9564();
                            level.method_8501(this.pos, setState);
                        }
                        Termite.spawnEatParticles(level, blockState, this.pos, random);
                        termiteBlockBehavior.getEatSound().ifPresent(sound -> level.method_8396(null, this.pos, sound, class_3419.field_15245, 0.6f, 0.9f + random.method_43057() * 0.25f));
                        level.method_8396(null, this.pos, WWSounds.BLOCK_TERMITE_MOUND_TERMITE_GNAW_FINISH, class_3419.field_15245, 0.6f, 0.9f + random.method_43057() * 0.25f);
                    }
                } else {
                    class_2338 offset;
                    class_2680 state;
                    this.eating = false;
                    this.blockDestroyPower = 0;
                    class_2350 direction = class_2350.method_10162((class_5819)random);
                    if (blockState.method_26215()) {
                        direction = class_2350.field_11033;
                    }
                    if (!TermiteManager.isStateSafeForTermites(state = level.method_8320(offset = this.pos.method_10093(direction)))) {
                        return false;
                    }
                    if (this.update > 0 && !blockState.method_26215()) {
                        --this.update;
                        return true;
                    }
                    this.update = 1;
                    class_2338 priority = Termite.degradableBreakablePos(level, this.pos, natural, random);
                    if (priority != null) {
                        this.pos = priority;
                        exit = true;
                    } else {
                        class_2338 ledge = Termite.ledgePos(level, offset, natural);
                        class_2338 posUp = this.pos.method_10084();
                        class_2680 stateUp = level.method_8320(posUp);
                        if (Termite.exposedToAir(level, offset, natural) && Termite.isBlockMovable(state, direction) && (direction == class_2350.field_11033 || !state.method_26215() || this.mound.method_19771((class_2382)this.pos, 1.5) || ledge != null)) {
                            this.pos = Objects.requireNonNullElse(ledge, offset);
                            exit = true;
                        } else if (ledge != null && Termite.exposedToAir(level, ledge, natural)) {
                            this.pos = ledge;
                            exit = true;
                        } else if (!stateUp.method_26215() && Termite.isBlockMovable(stateUp, class_2350.field_11036) && Termite.exposedToAir(level, posUp, natural)) {
                            this.pos = posUp;
                            exit = true;
                        }
                    }
                }
            }
            return exit || Termite.exposedToAir(level, this.pos, natural);
        }

        @Nullable
        public static class_2338 ledgePos(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural) {
            class_2338.class_2339 mutableBlockPos = pos.method_25503();
            class_2680 state = level.method_8320((class_2338)mutableBlockPos);
            Optional<class_6880<TermiteBlockBehavior>> optionalBlockBehavior = TermiteBlockBehaviors.getTermiteBlockBehavior(level.method_30349(), state.method_26204(), natural);
            if (optionalBlockBehavior.isPresent()) {
                return mutableBlockPos;
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
            state = level.method_8320((class_2338)mutableBlockPos);
            if (!state.method_26215() && Termite.isBlockMovable(state, class_2350.field_11033) && Termite.exposedToAir(level, (class_2338)mutableBlockPos, natural)) {
                return mutableBlockPos.method_10062();
            }
            mutableBlockPos.method_10104(class_2350.field_11036, 2);
            state = level.method_8320((class_2338)mutableBlockPos);
            if (!state.method_26215() && Termite.isBlockMovable(state, class_2350.field_11036) && Termite.exposedToAir(level, (class_2338)mutableBlockPos, natural)) {
                return mutableBlockPos.method_10062();
            }
            return null;
        }

        @Nullable
        public static class_2338 degradableBreakablePos(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural, class_5819 random) {
            class_2338.class_2339 mutableBlockPos = pos.method_25503();
            List directions = class_156.method_43253((Object[])class_2350.values(), (class_5819)random);
            class_2680 upState = level.method_8320((class_2338)mutableBlockPos.method_10098(class_2350.field_11036));
            if (Termite.checkIfBlockIsEdibleAndFixPos(level, natural, mutableBlockPos, upState)) {
                return mutableBlockPos.method_10062();
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
            for (class_2350 direction : directions) {
                class_2680 state = level.method_8320((class_2338)mutableBlockPos.method_10098(direction));
                if (Termite.checkIfBlockIsEdibleAndFixPos(level, natural, mutableBlockPos, state)) {
                    return mutableBlockPos.method_10062();
                }
                mutableBlockPos.method_10104(direction, -1);
            }
            return null;
        }

        private static boolean checkIfBlockIsEdibleAndFixPos(@NotNull class_1937 level, boolean natural, @NotNull class_2338.class_2339 mutableBlockPos, @NotNull class_2680 state) {
            Optional<class_6880<TermiteBlockBehavior>> optionalBlockBehavior = TermiteBlockBehaviors.getTermiteBlockBehavior(level.method_30349(), state.method_26204(), natural);
            if (optionalBlockBehavior.isPresent() && Termite.isEdibleProperty(state)) {
                if (state.method_28498((class_2769)class_2741.field_12533) && state.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609) {
                    mutableBlockPos.method_10098(class_2350.field_11033);
                }
                return true;
            }
            return false;
        }

        public static boolean isEdibleProperty(@NotNull class_2680 state) {
            return !WWBlockConfig.get().termite.onlyEatNaturalBlocks || (state.method_28498((class_2769)WWBlockStateProperties.TERMITE_EDIBLE) ? (Boolean)state.method_11654((class_2769)WWBlockStateProperties.TERMITE_EDIBLE) != false : !state.method_26164(class_3481.field_15503) || !state.method_28498((class_2769)class_2741.field_12514) || (Boolean)state.method_11654((class_2769)class_2741.field_12514) == false);
        }

        public static boolean exposedToAir(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural) {
            class_2338.class_2339 mutableBlockPos = pos.method_25503();
            for (class_2350 direction : class_2350.values()) {
                class_2680 state = level.method_8320((class_2338)mutableBlockPos.method_10098(direction));
                Optional<class_6880<TermiteBlockBehavior>> optionalBlockBehavior = TermiteBlockBehaviors.getTermiteBlockBehavior(level.method_30349(), state.method_26204(), natural);
                if (state.method_26215() || !state.method_26212((class_1922)level, (class_2338)mutableBlockPos) && !state.method_26164(WWBlockTags.BLOCKS_TERMITE) || optionalBlockBehavior.isPresent() && Termite.isEdibleProperty(state)) {
                    return true;
                }
                mutableBlockPos.method_10104(direction, -1);
            }
            return false;
        }

        private static boolean isPosTickable(@NotNull class_1936 level, @NotNull class_2338 pos) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                return serverLevel.method_41411(pos);
            }
            return false;
        }

        public static boolean isBlockMovable(@NotNull class_2680 state, @NotNull class_2350 direction) {
            if (state.method_26164(WWBlockTags.BLOCKS_TERMITE)) {
                return false;
            }
            boolean moveableUp = direction != class_2350.field_11036 || !state.method_26164(class_3481.field_28040) && !state.method_26164(class_3481.field_44470) && !state.method_26164(class_3481.field_20339);
            boolean moveableDown = direction != class_2350.field_11033 || state.method_26227().method_15769();
            return moveableUp && moveableDown;
        }

        public static boolean isTooFar(boolean natural, @NotNull class_2338 mound, @NotNull class_2338 pos) {
            return !mound.method_19771((class_2382)pos, natural ? (double)WWBlockConfig.get().termite.maxNaturalDistance : (double)WWBlockConfig.get().termite.maxDistance);
        }

        public static void spawnGnawParticles(@NotNull class_1937 level, @NotNull class_2680 eatState, @NotNull class_2338 pos, class_5819 random) {
            if (level instanceof class_3218) {
                int count;
                class_3218 serverLevel = (class_3218)level;
                if (random.method_43048(4) == 0 && (count = random.method_43051(0, 3)) > 0) {
                    serverLevel.method_65096((class_2394)new class_2388(class_2398.field_11217, eatState), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, count, (double)0.3f, (double)0.3f, (double)0.3f, 0.05);
                }
            }
        }

        public static void spawnEatParticles(@NotNull class_1937 level, @NotNull class_2680 eatState, @NotNull class_2338 pos, class_5819 random) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_65096((class_2394)new class_2388(class_2398.field_11217, eatState), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, random.method_43051(18, 25), (double)0.3f, (double)0.3f, (double)0.3f, 0.05);
            }
        }

        @NotNull
        public class_2338 getMoundPos() {
            return this.mound;
        }

        @NotNull
        public class_2338 getPos() {
            return this.pos;
        }

        @NotNull
        public class_243 getCenterOfPos() {
            return class_243.method_24953((class_2382)this.pos);
        }

        public int getBlockDestroyPower() {
            return this.blockDestroyPower;
        }

        public int getIdleTicks() {
            return this.idleTicks;
        }

        public int getUpdateTicks() {
            return this.update;
        }

        public boolean getEating() {
            return this.eating;
        }

        public int getID() {
            return this.id;
        }
    }
}

