/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.config;

import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.json.JsonConfig;
import net.frozenblock.lib.config.api.instance.json.JsonType;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.api.sync.annotation.EntrySyncData;
import net.frozenblock.wilderwild.WWPreLoadConstants;
import net.frozenblock.wilderwild.worldgen.impl.conditionsource.BetaBeachConditionSource;
import net.frozenblock.wilderwild.worldgen.impl.conditionsource.SnowUnderMountainConditionSource;

public final class WWWorldgenConfig {
    public static final Config<WWWorldgenConfig> INSTANCE = ConfigRegistry.register((Config)new JsonConfig<WWWorldgenConfig>("wilderwild", WWWorldgenConfig.class, WWPreLoadConstants.configPath("worldgen", true), JsonType.JSON5){

        public void onSave() throws Exception {
            super.onSave();
            this.onSync(null);
        }

        public void onSync(WWWorldgenConfig sync) {
            WWWorldgenConfig config = (WWWorldgenConfig)this.config();
            BetaBeachConditionSource.GENERATE = config.betaBeaches;
            SnowUnderMountainConditionSource.GENERATE = config.snowUnderMountains;
            GENERATE_POLLEN = config.vegetation.pollen;
            GENERATE_SHELF_FUNGI = config.vegetation.shelfFungiGeneration;
            GENERATED_HOLLOWED_FALLEN_TREES = config.treeGeneration.hollowedFallenTrees;
            BIRCH_BRANCHES = config.treeGeneration.birchBranches;
            OAK_BRANCHES = config.treeGeneration.oakBranches;
            DARK_OAK_BRANCHES = config.treeGeneration.darkOakBranches;
            PALE_OAK_BRANCHES = config.treeGeneration.paleOakBranches;
            NEW_WITCH_HUTS = config.structure.newWitchHuts;
        }
    });
    public static volatile boolean GENERATE_POLLEN = true;
    public static volatile boolean GENERATE_SHELF_FUNGI = true;
    public static volatile boolean GENERATED_HOLLOWED_FALLEN_TREES = true;
    public static volatile boolean BIRCH_BRANCHES = true;
    public static volatile boolean OAK_BRANCHES = true;
    public static volatile boolean DARK_OAK_BRANCHES = true;
    public static volatile boolean PALE_OAK_BRANCHES = true;
    public static volatile boolean NEW_WITCH_HUTS = true;
    @ConfigEntry.Gui.CollapsibleObject
    public final BiomeGeneration biomeGeneration = new BiomeGeneration();
    @ConfigEntry.Gui.CollapsibleObject
    public final BiomePlacement biomePlacement = new BiomePlacement();
    @ConfigEntry.Gui.CollapsibleObject
    public final TreeGeneration treeGeneration = new TreeGeneration();
    @ConfigEntry.Gui.CollapsibleObject
    public final Vegetation vegetation = new Vegetation();
    @ConfigEntry.Gui.CollapsibleObject
    public final AquaticGeneration aquaticGeneration = new AquaticGeneration();
    @ConfigEntry.Gui.CollapsibleObject
    public final TransitionGeneration transitionGeneration = new TransitionGeneration();
    @ConfigEntry.Gui.CollapsibleObject
    public final Structure structure = new Structure();
    @ConfigEntry.Gui.CollapsibleObject
    public final SurfaceDecoration surfaceDecoration = new SurfaceDecoration();
    @EntrySyncData(value="betaBeaches")
    public boolean betaBeaches = true;
    @EntrySyncData(value="snowUnderMountains")
    public boolean snowUnderMountains = false;
    @EntrySyncData(value="termiteGen")
    public boolean termiteGen = true;
    @EntrySyncData(value="netherGeyserGen")
    public boolean netherGeyserGen = true;
    @EntrySyncData(value="snowBelowTrees")
    public boolean snowBelowTrees = true;

    public static WWWorldgenConfig get() {
        return WWWorldgenConfig.get(false);
    }

    public static WWWorldgenConfig get(boolean real) {
        if (real) {
            return (WWWorldgenConfig)INSTANCE.instance();
        }
        return (WWWorldgenConfig)INSTANCE.config();
    }

    public static WWWorldgenConfig getWithSync() {
        return (WWWorldgenConfig)INSTANCE.configWithSync();
    }

    public static class BiomeGeneration {
        @EntrySyncData(value="generateCypressWetlands")
        public boolean generateCypressWetlands = true;
        @EntrySyncData(value="generateMesogleaCaves")
        public boolean generateMesogleaCaves = true;
        @EntrySyncData(value="generateMixedForest")
        public boolean generateMixedForest = true;
        @EntrySyncData(value="generateOasis")
        public boolean generateOasis = true;
        @EntrySyncData(value="generateWarmRiver")
        public boolean generateWarmRiver = true;
        @EntrySyncData(value="generateWarmBeach")
        public boolean generateWarmBeach = true;
        @EntrySyncData(value="generateBirchTaiga")
        public boolean generateBirchTaiga = true;
        @EntrySyncData(value="generateOldGrowthBirchTaiga")
        public boolean generateOldGrowthBirchTaiga = true;
        @EntrySyncData(value="generateFlowerField")
        public boolean generateFlowerField = true;
        @EntrySyncData(value="generateAridSavanna")
        public boolean generateAridSavanna = true;
        @EntrySyncData(value="generateParchedForest")
        public boolean generateParchedForest = true;
        @EntrySyncData(value="generateAridForest")
        public boolean generateAridForest = true;
        @EntrySyncData(value="generateOldGrowthSnowyTaiga")
        public boolean generateOldGrowthSnowyTaiga = true;
        @EntrySyncData(value="generateBirchJungle")
        public boolean generateBirchJungle = true;
        @EntrySyncData(value="generateSparseBirchJungle")
        public boolean generateSparseBirchJungle = true;
        @EntrySyncData(value="generateOldGrowthDarkForest")
        public boolean generateOldGrowthDarkForest = true;
        @EntrySyncData(value="generateDarkBirchForest")
        public boolean generateDarkBirchForest = true;
        @EntrySyncData(value="generateSemiBirchForest")
        public boolean generateSemiBirchForest = true;
        @EntrySyncData(value="generateTemperateRainforest")
        public boolean generateTemperateRainforest = true;
        @EntrySyncData(value="generateRainforest")
        public boolean generateRainforest = true;
        @EntrySyncData(value="generateDarkTaiga")
        public boolean generateDarkTaiga = true;
        @EntrySyncData(value="generateDyingForest")
        public boolean generateDyingForest = true;
        @EntrySyncData(value="generateSnowyDyingForest")
        public boolean generateSnowyDyingForest = true;
        @EntrySyncData(value="generateDyingMixedForest")
        public boolean generateDyingMixedForest = true;
        @EntrySyncData(value="generateSnowyDyingMixedForest")
        public boolean generateSnowyDyingMixedForest = true;
        @EntrySyncData(value="generateMagmaticCaves")
        public boolean generateMagmaticCaves = true;
        @EntrySyncData(value="generateFrozenCaves")
        public boolean generateFrozenCaves = true;
        @EntrySyncData(value="generateMapleForest")
        public boolean generateMapleForest = true;
        @EntrySyncData(value="generateSparseForest")
        public boolean generateSparseForest = true;
        @EntrySyncData(value="generateTundra")
        public boolean generateTundra = true;
    }

    public static class BiomePlacement {
        @EntrySyncData(value="modifyWindsweptSavannaPlacement")
        public boolean modifyWindsweptSavannaPlacement = true;
        @EntrySyncData(value="modifyJunglePlacement")
        public boolean modifyJunglePlacement = true;
        @EntrySyncData(value="modifySwampPlacement")
        public boolean modifySwampPlacement = true;
        @EntrySyncData(value="modifyMangroveSwampPlacement")
        public boolean modifyMangroveSwampPlacement = true;
        @EntrySyncData(value="modifyCherryGrovePlacement")
        public boolean modifyCherryGrovePlacement = false;
        @EntrySyncData(value="modifyStonyShorePlacement")
        public boolean modifyStonyShorePlacement = true;
        @EntrySyncData(value="modifyTundraPlacement")
        public boolean modifyTundraPlacement = false;
    }

    public static class TreeGeneration {
        @EntrySyncData(value="treeGeneration")
        public boolean treeGeneration = true;
        @EntrySyncData(value="fallenTrees")
        public boolean fallenTrees = true;
        @EntrySyncData(value="hollowedFallenTrees")
        public boolean hollowedFallenTrees = true;
        @EntrySyncData(value="snappedTrees")
        public boolean snappedTrees = true;
        @EntrySyncData(value="baobab")
        public boolean baobab = true;
        @EntrySyncData(value="palm")
        public boolean palm = true;
        @EntrySyncData(value="willow")
        public boolean willow = true;
        @EntrySyncData(value="birchBranches")
        public boolean birchBranches = true;
        @EntrySyncData(value="oakBranches")
        public boolean oakBranches = true;
        @EntrySyncData(value="darkOakBranches")
        public boolean darkOakBranches = true;
        @EntrySyncData(value="paleOakBranches")
        public boolean paleOakBranches = true;
    }

    public static class Vegetation {
        @EntrySyncData(value="grassGeneration")
        public boolean grassGeneration = true;
        @EntrySyncData(value="dryGrassGeneration")
        public boolean dryGrassGeneration = true;
        @EntrySyncData(value="flowerGeneration")
        public boolean flowerGeneration = true;
        @EntrySyncData(value="shrubGeneration")
        public boolean shrubGeneration = true;
        @EntrySyncData(value="cactusGeneration")
        public boolean cactusGeneration = true;
        @EntrySyncData(value="shelfFungiGeneration")
        public boolean shelfFungiGeneration = true;
        @EntrySyncData(value="mushroomGeneration")
        public boolean mushroomGeneration = true;
        @EntrySyncData(value="paleMushroomGeneration")
        public boolean paleMushroomGeneration = true;
        @EntrySyncData(value="pollen")
        public boolean pollen = true;
        @EntrySyncData(value="tumbleweed")
        public boolean tumbleweed = true;
        @EntrySyncData(value="fireflyBushGen")
        public boolean fireflyBushGen = true;
        @EntrySyncData(value="leafLitterGen")
        public boolean leafLitterGen = true;
        @EntrySyncData(value="pumpkin")
        public boolean pumpkin = true;
    }

    public static class AquaticGeneration {
        @EntrySyncData(value="riverPool")
        public boolean riverPool = false;
        @EntrySyncData(value="cattail")
        public boolean cattail = true;
        @EntrySyncData(value="algae")
        public boolean algae = true;
        @EntrySyncData(value="plankton")
        public boolean plankton = true;
        @EntrySyncData(value="seagrass")
        public boolean seagrass = true;
        @EntrySyncData(value="spongeBud")
        public boolean spongeBud = true;
        @EntrySyncData(value="barnacle")
        public boolean barnacle = true;
        @EntrySyncData(value="seaAnemone")
        public boolean seaAnemone = true;
        @EntrySyncData(value="seaWhip")
        public boolean seaWhip = true;
        @EntrySyncData(value="tubeWorm")
        public boolean tubeWorm = true;
        @EntrySyncData(value="hydrothermalVent")
        public boolean hydrothermalVent = true;
        @EntrySyncData(value="oceanMossGeneration")
        public boolean oceanMossGeneration = true;
        @EntrySyncData(value="oceanAuburnMossGeneration")
        public boolean oceanAuburnMossGeneration = true;
    }

    public static class TransitionGeneration {
        @EntrySyncData(value="sandTransitions")
        public boolean sandTransitions = true;
        @EntrySyncData(value="redSandTransitions")
        public boolean redSandTransitions = true;
        @EntrySyncData(value="coarseTransitions")
        public boolean coarseTransitions = true;
        @EntrySyncData(value="gravelTransitions")
        public boolean gravelTransitions = true;
        @EntrySyncData(value="mudTransitions")
        public boolean mudTransitions = true;
        @EntrySyncData(value="stoneTransitions")
        public boolean stoneTransitions = true;
        @EntrySyncData(value="snowTransitions")
        public boolean snowTransitions = true;
    }

    public static class Structure {
        @EntrySyncData(value="newWitchHuts")
        public boolean newWitchHuts = true;
        @EntrySyncData(value="decayTrailRuins")
        public boolean decayTrailRuins = true;
        @EntrySyncData(value="newDesertVillages")
        public boolean newDesertVillages = true;
    }

    public static class SurfaceDecoration {
        @EntrySyncData(value="coarseDecoration")
        public boolean coarseDecoration = true;
        @EntrySyncData(value="gravelDecoration")
        public boolean gravelDecoration = true;
        @EntrySyncData(value="mudDecoration")
        public boolean mudDecoration = true;
        @EntrySyncData(value="packedMudDecoration")
        public boolean packedMudDecoration = true;
        @EntrySyncData(value="stoneDecoration")
        public boolean stoneDecoration = true;
        @EntrySyncData(value="mossDecoration")
        public boolean mossDecoration = true;
        @EntrySyncData(value="auburnMoss")
        public boolean auburnMoss = true;
        @EntrySyncData(value="paleMossDecoration")
        public boolean paleMossDecoration = true;
        @EntrySyncData(value="scorchedSandDecoration")
        public boolean scorchedSandDecoration = true;
        @EntrySyncData(value="scorchedRedSandDecoration")
        public boolean scorchedRedSandDecoration = true;
        @EntrySyncData(value="sandstoneDecoration")
        public boolean sandstoneDecoration = true;
        @EntrySyncData(value="clayDecoration")
        public boolean clayDecoration = true;
        @EntrySyncData(value="clearingDecoration")
        public boolean clearingDecoration = true;
        @EntrySyncData(value="snowPiles")
        public boolean snowPiles = true;
        @EntrySyncData(value="fragileIceDecoration")
        public boolean fragileIceDecoration = true;
        @EntrySyncData(value="icicleDecoration")
        public boolean icicleDecoration = true;
        @EntrySyncData(value="taigaBoulders")
        public boolean taigaBoulders = true;
        @EntrySyncData(value="lakes")
        public boolean lakes = true;
        @EntrySyncData(value="basins")
        public boolean basins = true;
    }
}

