/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.variant.moobloom.MoobloomVariant;
import net.frozenblock.wilderwild.entity.variant.moobloom.MoobloomVariants;
import net.frozenblock.wilderwild.registry.WWDataComponents;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1430;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4538;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowerCow
extends class_1430
implements class_5147 {
    public static final int MAX_FLOWERS = 4;
    private static final byte GROW_FLOWER_EVENT_ID = 61;
    private static final class_2940<String> VARIANT = class_2945.method_12791(FlowerCow.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> FLOWERS_LEFT = class_2945.method_12791(FlowerCow.class, (class_2941)class_2943.field_13327);
    private Optional<MoobloomVariant> moobloomVariant = Optional.empty();

    public FlowerCow(class_1299<? extends FlowerCow> entityType, class_1937 level) {
        super(entityType, level);
    }

    public float method_6144(class_2338 blockPos, @NotNull class_4538 levelReader) {
        return levelReader.method_8320(blockPos).method_26164(class_3481.field_20339) ? 10.0f : levelReader.method_42309(blockPos);
    }

    public static boolean checkFlowerCowSpawnRules(@NotNull class_1299<FlowerCow> type, @NotNull class_1936 level, class_3730 reason, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (!class_3730.method_54986((class_3730)reason) && !WWEntityConfig.get().moobloom.spawnMooblooms) {
            return false;
        }
        return FlowerCow.method_20663(type, (class_1936)level, (class_3730)reason, (class_2338)pos, (class_5819)random);
    }

    @NotNull
    public class_1315 method_5943(@NotNull class_5425 level, class_1266 difficultyInstance, class_3730 reason, @Nullable class_1315 spawnGroupData) {
        if (spawnGroupData instanceof FlowerCowSpawnGroupData) {
            FlowerCowSpawnGroupData flowerCowSpawnGroupData = (FlowerCowSpawnGroupData)((Object)spawnGroupData);
            this.setVariant((MoobloomVariant)flowerCowSpawnGroupData.type.comp_349());
        } else {
            Optional<class_6880.class_6883<MoobloomVariant>> optionalMoobloomVariantReference = MoobloomVariants.selectVariantToSpawn(level.method_8409(), this.method_56673(), class_10701.method_67169((class_5425)level, (class_2338)this.method_24515()));
            if (optionalMoobloomVariantReference.isPresent()) {
                spawnGroupData = new FlowerCowSpawnGroupData((class_6880<MoobloomVariant>)((class_6880)optionalMoobloomVariantReference.get()));
                this.setVariant((MoobloomVariant)optionalMoobloomVariantReference.get().comp_349());
            }
        }
        return super.method_5943(level, difficultyInstance, reason, spawnGroupData);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)MoobloomVariants.DEFAULT.method_29177().toString());
        builder.method_56912(FLOWERS_LEFT, (Object)4);
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (!this.method_6109() && this.method_6481(itemStack) && !this.hasMaxFlowersLeft()) {
            if (!this.method_37908().field_9236) {
                this.method_6475(player, interactionHand, itemStack);
                this.incrementFlowersLeft();
                this.method_37908().method_8421((class_1297)this, (byte)61);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (itemStack.method_31574(class_1802.field_8868)) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                if (this.method_27072()) {
                    this.method_6636(serverLevel, class_3419.field_15248, itemStack);
                    this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                    itemStack.method_7970(1, (class_1309)player, FlowerCow.method_56079((class_1268)interactionHand));
                    return class_1269.field_52422;
                }
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, interactionHand);
    }

    public void method_6636(class_3218 serverLevel, class_3419 soundSource, class_1799 itemStack) {
        this.method_37908().method_43129(null, (class_1297)this, WWSounds.ENTITY_MOOBLOOM_SHEAR, soundSource, 1.0f, 1.0f);
        class_2680 flowerState = this.getVariantByLocation().getFlowerBlockState();
        FlowerCow.spawnShearParticles(serverLevel, this, flowerState);
        this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23323(1.0), this.method_23321(), new class_1799((class_1935)flowerState.method_26204())));
        this.decrementFlowersLeft();
    }

    private static void spawnShearParticles(@NotNull class_3218 serverLevel, @NotNull FlowerCow flowerCow, class_2680 flowerBlockState) {
        serverLevel.method_65096((class_2394)new class_2388(class_2398.field_11217, flowerBlockState), flowerCow.method_23317(), flowerCow.method_23323(0.6666666666666666), flowerCow.method_23321(), 10, (double)flowerCow.method_17681() / 4.0, (double)flowerCow.method_17682() / 4.0, (double)flowerCow.method_17681() / 4.0, 0.05);
    }

    public void method_5711(byte b) {
        if (b == 61) {
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(b);
        }
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109() && this.hasFlowersLeft();
    }

    public void method_5674(@NotNull class_2940<?> key) {
        if (VARIANT.equals(key)) {
            this.moobloomVariant = Optional.of(this.getVariantByLocation());
        }
        super.method_5674(key);
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> dataComponentType) {
        if (dataComponentType == WWDataComponents.MOOBLOOM_VARIANT) {
            return (T)FlowerCow.method_66651(dataComponentType, this.getVariantAsHolder());
        }
        return (T)super.method_58694(dataComponentType);
    }

    protected void method_66649(class_9473 dataComponentGetter) {
        this.method_66650(dataComponentGetter, WWDataComponents.MOOBLOOM_VARIANT);
        super.method_66649(dataComponentGetter);
    }

    protected <T> boolean method_66654(class_9331<T> dataComponentType, T object) {
        if (dataComponentType == WWDataComponents.MOOBLOOM_VARIANT) {
            this.setVariant((MoobloomVariant)((class_6880)FlowerCow.method_66651(WWDataComponents.MOOBLOOM_VARIANT, object)).comp_349());
            return true;
        }
        return super.method_66654(dataComponentType, object);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        class_10704.method_67177((class_2487)compoundTag, this.getVariantAsHolder());
        compoundTag.method_10569("FlowersLeft", this.getFlowersLeft());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        class_10704.method_67178((class_2487)compoundTag, (class_5455)this.method_56673(), WilderWildRegistries.MOOBLOOM_VARIANT).ifPresent(variant -> this.setVariant((MoobloomVariant)variant.comp_349()));
        compoundTag.method_10550("FlowersLeft").ifPresent(this::setFlowersLeft);
    }

    public class_2960 getVariantLocation() {
        return class_2960.method_60654((String)((String)this.field_6011.method_12789(VARIANT)));
    }

    public MoobloomVariant getVariantByLocation() {
        return (MoobloomVariant)this.method_56673().method_30530(WilderWildRegistries.MOOBLOOM_VARIANT).method_63535(this.getVariantLocation());
    }

    public class_6880<MoobloomVariant> getVariantAsHolder() {
        return (class_6880)this.method_56673().method_30530(WilderWildRegistries.MOOBLOOM_VARIANT).method_10223(this.getVariantLocation()).orElseThrow();
    }

    public MoobloomVariant getVariantForRendering() {
        return this.moobloomVariant.orElse((MoobloomVariant)this.method_56673().method_30530(WilderWildRegistries.MOOBLOOM_VARIANT).method_29107(MoobloomVariants.DEFAULT));
    }

    public void setVariant(@NotNull MoobloomVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)Objects.requireNonNull(this.method_56673().method_30530(WilderWildRegistries.MOOBLOOM_VARIANT).method_10221((Object)variant)).toString());
    }

    public void setVariant(@NotNull class_2960 variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.toString());
    }

    public int getFlowersLeft() {
        return (Integer)this.field_6011.method_12789(FLOWERS_LEFT);
    }

    public void setFlowersLeft(int flowersLeft) {
        this.field_6011.method_12778(FLOWERS_LEFT, (Object)flowersLeft);
    }

    public boolean hasMaxFlowersLeft() {
        return this.getFlowersLeft() >= 4;
    }

    public boolean hasFlowersLeft() {
        return this.getFlowersLeft() > 0;
    }

    public void incrementFlowersLeft() {
        this.setFlowersLeft(this.getFlowersLeft() + 1);
    }

    public void decrementFlowersLeft() {
        this.setFlowersLeft(this.getFlowersLeft() - 1);
    }

    @Nullable
    public FlowerCow getBreedOffspring(class_3218 serverLevel, class_1296 ageableMob) {
        FlowerCow flowerCow = (FlowerCow)WWEntityTypes.MOOBLOOM.method_5883((class_1937)serverLevel, class_3730.field_16466);
        if (flowerCow != null && ageableMob instanceof FlowerCow) {
            FlowerCow otherFlowerCow = (FlowerCow)ageableMob;
            flowerCow.setVariant(this.getOffspringType(serverLevel, otherFlowerCow));
        }
        return flowerCow;
    }

    private MoobloomVariant getOffspringType(class_3218 serverLevel, @NotNull FlowerCow flowerCow) {
        MoobloomVariant otherFlowerType;
        MoobloomVariant flowerType = this.getVariantByLocation();
        if (flowerType == (otherFlowerType = flowerCow.getVariantByLocation())) {
            return flowerType;
        }
        return this.getOffspringVariant(serverLevel, flowerCow);
    }

    @NotNull
    private MoobloomVariant getOffspringVariant(class_3218 serverLevel, @NotNull FlowerCow otherFlowerCow) {
        MoobloomVariant moobloomVariant = this.getVariantByLocation();
        MoobloomVariant otherMoobloomVariant = otherFlowerCow.getVariantByLocation();
        class_2680 flowerBlock = moobloomVariant.getFlowerBlockState();
        class_2680 otherFlowerBlock = otherMoobloomVariant.getFlowerBlockState();
        Optional<class_1767> dyeColor = FlowerCow.getDyeColorFromFlower(serverLevel, flowerBlock.method_26204());
        Optional<class_1767> otherDyeColor = FlowerCow.getDyeColorFromFlower(serverLevel, otherFlowerBlock.method_26204());
        if (dyeColor.isPresent() && otherDyeColor.isPresent()) {
            class_1767 outputDyeColor = FlowerCow.getCombinedDyeColor(serverLevel, dyeColor.get(), otherDyeColor.get());
            Stream variantStream = serverLevel.method_30349().method_30530(WilderWildRegistries.MOOBLOOM_VARIANT).method_10220();
            for (MoobloomVariant registeredVariant : class_156.method_43252((Stream)variantStream, (class_5819)this.field_5974)) {
                class_2248 variantFlower = registeredVariant.getFlowerBlockState().method_26204();
                Optional<class_1767> flowerDyeColor = FlowerCow.getDyeColorFromFlower(serverLevel, variantFlower);
                if (!flowerDyeColor.isPresent() || !flowerDyeColor.get().equals((Object)outputDyeColor)) continue;
                return registeredVariant;
            }
        }
        return this.field_5974.method_43056() ? moobloomVariant : otherMoobloomVariant;
    }

    @NotNull
    private static Optional<class_1767> getDyeColorFromFlower(@NotNull class_3218 level, class_2248 flowerBlock) {
        class_9694 craftingInput = FlowerCow.makeCraftInputForFlower(flowerBlock);
        return level.method_64577().method_8132(class_3956.field_17545, (class_9695)craftingInput, (class_1937)level).map(recipeHolder -> ((class_3955)recipeHolder.comp_1933()).method_8116((class_9695)craftingInput, (class_7225.class_7874)level.method_30349())).map(class_1799::method_7909).filter(class_1769.class::isInstance).map(class_1769.class::cast).map(class_1769::method_7802);
    }

    private static class_1767 getCombinedDyeColor(@NotNull class_3218 level, class_1767 dyeColor, class_1767 otherDyeColor) {
        class_9694 craftingInput = FlowerCow.makeCraftInput(dyeColor, otherDyeColor);
        return level.method_64577().method_8132(class_3956.field_17545, (class_9695)craftingInput, (class_1937)level).map(recipeHolder -> ((class_3955)recipeHolder.comp_1933()).method_8116((class_9695)craftingInput, (class_7225.class_7874)level.method_30349())).map(class_1799::method_7909).filter(class_1769.class::isInstance).map(class_1769.class::cast).map(class_1769::method_7802).orElseGet(() -> level.field_9229.method_43056() ? dyeColor : otherDyeColor);
    }

    @NotNull
    private static class_9694 makeCraftInputForFlower(class_2248 flowerBlock) {
        return class_9694.method_59986((int)1, (int)1, List.of(new class_1799((class_1935)flowerBlock)));
    }

    @NotNull
    private static class_9694 makeCraftInput(class_1767 dyeColor, class_1767 dyeColor2) {
        return class_9694.method_59986((int)2, (int)1, List.of(new class_1799((class_1935)class_1769.method_7803((class_1767)dyeColor)), new class_1799((class_1935)class_1769.method_7803((class_1767)dyeColor2))));
    }

    public static class FlowerCowSpawnGroupData
    extends class_1296.class_4697 {
        public final class_6880<MoobloomVariant> type;

        public FlowerCowSpawnGroupData(class_6880<MoobloomVariant> holder) {
            super(true);
            this.type = holder;
        }
    }
}

