/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.ai.crab;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.frozenblock.wilderwild.entity.Crab;
import net.frozenblock.wilderwild.entity.ai.crab.CrabDig;
import net.frozenblock.wilderwild.entity.ai.crab.CrabEmerge;
import net.frozenblock.wilderwild.entity.ai.crab.CrabHeal;
import net.frozenblock.wilderwild.entity.ai.crab.CrabTryToEmerge;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.frozenblock.wilderwild.registry.WWSensorTypes;
import net.frozenblock.wilderwild.tag.WWDamageTypeTags;
import net.frozenblock.wilderwild.tag.WWItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4806;
import net.minecraft.class_4813;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_5134;
import net.minecraft.class_5355;
import net.minecraft.class_5754;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7521;
import net.minecraft.class_7893;
import net.minecraft.class_7898;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CrabAi {
    public static final double UNDERGROUND_PLAYER_RANGE = 4.0;
    public static final List<class_4149<? extends class_4148<? super Crab>>> SENSORS = List.of(class_4149.field_18466, class_4149.field_18467, class_4149.field_25362, class_4149.field_18469, WWSensorTypes.CRAB_ATTACKABLES, WWSensorTypes.CRAB_TEMPTATIONS, WWSensorTypes.CRAB_SPECIFIC_SENSOR, WWSensorTypes.CRAB_NEARBY_PLAYER_SENSOR, WWSensorTypes.CRAB_CAN_DIG_SENSOR);
    public static final List<? extends class_4140<?>> MEMORY_MODULES = List.of(class_4140.field_18441, class_4140.field_18442, class_4140.field_18443, class_4140.field_18444, class_4140.field_22354, WWMemoryModuleTypes.IS_PLAYER_NEARBY, class_4140.field_18446, class_4140.field_18445, class_4140.field_19293, class_4140.field_18449, class_4140.field_22355, class_4140.field_30243, class_4140.field_30246, class_4140.field_22475, class_4140.field_18451, class_4140.field_18452, class_4140.field_39408, class_4140.field_38112, class_4140.field_38103, WWMemoryModuleTypes.CAN_DIG, class_4140.field_28325, class_4140.field_28327, class_4140.field_28326, class_4140.field_18448, WWMemoryModuleTypes.IS_UNDERGROUND, WWMemoryModuleTypes.NEARBY_CRABS, WWMemoryModuleTypes.HEAL_COOLDOWN_TICKS, WWMemoryModuleTypes.FIRST_BRAIN_TICK, class_4140.field_22333, class_4140.field_25361);
    private static final float SPEED_MODIFIER = 1.0f;
    private static final float FOLLOWING_ADULT_SPEED_MODIFIER = 1.2f;
    private static final float CHASING_SPEED_MODIFIER = 1.3f;
    private static final class_6019 ADULT_FOLLOW_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final int DIGGING_DURATION = 95;
    private static final int EMERGE_DURATION = 29;
    private static final class_7893<Crab> DIG_COOLDOWN_SETTER = class_7898.method_47224(instance -> instance.group((App)instance.method_47235(class_4140.field_38103)).apply((Applicative)instance, memoryAccessor -> (world, crab, l) -> {
        if (instance.method_47233(memoryAccessor).isPresent()) {
            memoryAccessor.method_47250((Object)class_3902.field_17274, (long)CrabAi.getRandomDigCooldown(crab));
        }
        return true;
    }));
    private static final class_7893<Crab> HUNTING_COOLDOWN_SETTER = class_7898.method_47224(instance -> instance.group((App)instance.method_47235(class_4140.field_30246)).apply((Applicative)instance, memoryAccessor -> (world, crab, l) -> {
        memoryAccessor.method_47250((Object)true, 2400L);
        return true;
    }));

    public static void updateActivity(@NotNull Crab crab) {
        crab.method_18868().method_24531(List.of(class_4168.field_38202, class_4168.field_38203, class_4168.field_19043, class_4168.field_22396, class_4168.field_18595));
    }

    @NotNull
    public static class_4095<Crab> makeBrain(@NotNull Crab crab, @NotNull class_4095<Crab> brain) {
        CrabAi.addCoreActivity(brain);
        CrabAi.initEmergeActivity(brain);
        CrabAi.initDiggingActivity(brain);
        CrabAi.initHideActivity(brain);
        CrabAi.addIdleActivity(brain);
        CrabAi.addFightActivity(crab, brain);
        brain.method_18890(Set.of(class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivity(@NotNull class_4095<Crab> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_6028(1.65f, pathfinderMob -> {
            if (((Crab)((Object)pathfinderMob)).isDiggingOrEmerging()) {
                return WWDamageTypeTags.EMPTY;
            }
            return pathfinderMob.method_6109() ? class_8103.field_51990 : class_8103.field_51991;
        }), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)class_4829.method_47143()));
    }

    private static void initEmergeActivity(@NotNull class_4095<Crab> brain) {
        brain.method_24527(class_4168.field_38202, 5, ImmutableList.of(new CrabEmerge(29)), class_4140.field_38112);
    }

    private static void initDiggingActivity(@NotNull class_4095<Crab> brain) {
        brain.method_24529(class_4168.field_38203, ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_7521()), (Object)Pair.of((Object)1, new CrabDig(95))), Set.of(Pair.of(WWMemoryModuleTypes.FIRST_BRAIN_TICK, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_38103, (Object)class_4141.field_18457), Pair.of(WWMemoryModuleTypes.IS_UNDERGROUND, (Object)class_4141.field_18457), Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457), Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18457), Pair.of(WWMemoryModuleTypes.IS_PLAYER_NEARBY, (Object)class_4141.field_18457), Pair.of(WWMemoryModuleTypes.CAN_DIG, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_18445, (Object)class_4141.field_18457)));
    }

    private static void initHideActivity(@NotNull class_4095<Crab> brain) {
        brain.method_24529(class_4168.field_19043, ImmutableList.of((Object)Pair.of((Object)0, CrabTryToEmerge.create()), (Object)Pair.of((Object)1, CrabHeal.create())), Set.of(Pair.of(WWMemoryModuleTypes.IS_UNDERGROUND, (Object)class_4141.field_18456)));
    }

    private static void addIdleActivity(@NotNull class_4095<Crab> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)1, (Object)new class_4806(WWEntityTypes.CRAB, 0.8f, 2)), (Object)Pair.of((Object)2, (Object)new class_4118(List.of(Pair.of((Object)new class_5754(CrabAi::getSpeedModifier), (Object)1), Pair.of((Object)class_5355.method_46897((class_6019)ADULT_FOLLOW_RANGE, CrabAi::getSpeedModifierFollowingAdult), (Object)1)))), (Object)Pair.of((Object)3, (Object)class_4824.method_47119(CrabAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)4, (Object)new class_4118(Map.of(class_4140.field_18445, class_4141.field_18457, WWMemoryModuleTypes.FIRST_BRAIN_TICK, class_4141.field_18456), List.of(Pair.of((Object)class_4818.method_47027((float)1.0f), (Object)2), Pair.of((Object)class_4818.method_47014((float)1.0f), (Object)2), Pair.of((Object)new class_4101(30, 100), (Object)1), Pair.of((Object)class_7898.method_47225(class_1297::method_5799), (Object)5), Pair.of((Object)class_7898.method_47225(class_1297::method_24828), (Object)5))))));
    }

    private static void addFightActivity(@NotNull Crab crab, @NotNull class_4095<Crab> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of(DIG_COOLDOWN_SETTER, HUNTING_COOLDOWN_SETTER, (Object)class_4828.method_47139((level, livingEntity) -> !crab.canTargetEntity((class_1297)livingEntity), CrabAi::onTargetInvalid, (boolean)true), (Object)class_4119.method_47065(livingEntity -> CrabAi.isTarget(crab, livingEntity), (float)((float)crab.method_45325(class_5134.field_23717))), (Object)class_4822.method_47098(CrabAi::getSpeedModifierChasing), (Object)class_4816.method_46987((int)20), (Object)class_4813.method_46922(class_4215::method_41331, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    private static boolean isTarget(@NotNull Crab crab, @NotNull class_1309 livingEntity) {
        return crab.method_18868().method_18904(class_4140.field_22355).filter(livingEntity2 -> livingEntity2 == livingEntity).isPresent();
    }

    private static float getSpeedModifierChasing(@Nullable class_1309 livingEntity) {
        return 1.3f;
    }

    private static float getSpeedModifierFollowingAdult(class_1309 entity) {
        return 1.2f;
    }

    private static float getSpeedModifier(class_1309 entity) {
        return 1.0f;
    }

    private static void onTargetInvalid(class_3218 level, @NotNull Crab crab, @NotNull class_1309 target) {
        if (crab.method_5968() == target) {
            crab.method_18868().method_18875(class_4140.field_22355);
        }
        crab.endNavigation();
    }

    @NotNull
    private static Optional<? extends class_1309> findNearestValidAttackTarget(class_3218 level, @NotNull Crab crab) {
        Optional optional2;
        class_4095<Crab> brain = crab.method_18868();
        Optional optional = class_4215.method_24560((class_1309)crab, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && class_4148.method_37456((class_3218)level, (class_1309)crab, (class_1309)((class_1309)optional.get()))) {
            return optional;
        }
        if (brain.method_18896(class_4140.field_25361) && (optional2 = brain.method_18904(class_4140.field_22354)).isPresent()) {
            return optional2;
        }
        return brain.method_18904(class_4140.field_30243);
    }

    public static void wasHurtBy(class_3218 level, @NotNull Crab crab, class_1309 target) {
        if (crab.canTargetEntity((class_1297)target)) {
            if (!class_4148.method_37456((class_3218)level, (class_1309)crab, (class_1309)target)) {
                return;
            }
            if (class_4215.method_24558((class_1309)crab, (class_1309)target, (double)4.0)) {
                return;
            }
            if (crab.method_6109()) {
                if (class_4148.method_37456((class_3218)level, (class_1309)crab, (class_1309)target)) {
                    CrabAi.broadcastAngerTarget(level, crab, target);
                }
                return;
            }
            if (target.method_5864() == class_1299.field_6097 && level.method_64395().method_8355(class_1928.field_25402)) {
                CrabAi.setAngerTargetToNearestTargetablePlayerIfFound(level, crab, target);
                CrabAi.broadcastUniversalAnger(level, crab);
            } else {
                CrabAi.setAngerTarget(level, crab, target);
                CrabAi.broadcastAngerTarget(level, crab, target);
            }
        }
    }

    public static void setAngerTarget(class_3218 level, @NotNull Crab crab, class_1309 target) {
        if (crab.method_6109()) {
            return;
        }
        if (!class_4148.method_37456((class_3218)level, (class_1309)crab, (class_1309)target)) {
            return;
        }
        if (crab.method_18868().method_18876(WWMemoryModuleTypes.IS_UNDERGROUND, class_4141.field_18456)) {
            CrabAi.clearDigCooldown(crab);
        }
        crab.method_18868().method_18875(class_4140.field_19293);
        crab.method_18868().method_18878(class_4140.field_22355, (Object)target);
        crab.method_18868().method_24525(class_4140.field_22333, (Object)target.method_5667(), 600L);
        if (target.method_5864() == class_1299.field_6097 && level.method_64395().method_8355(class_1928.field_25402)) {
            crab.method_18868().method_24525(class_4140.field_25361, (Object)true, 600L);
        }
    }

    private static void broadcastUniversalAnger(class_3218 level, Crab crabEntity) {
        Optional<List<Crab>> nearbyCrabs = CrabAi.getNearbyCrabs(crabEntity);
        nearbyCrabs.ifPresent(crabs -> crabs.forEach(crab -> CrabAi.getNearestVisibleTargetablePlayer(crab).ifPresent(player -> CrabAi.setAngerTarget(level, crab, (class_1309)player))));
    }

    public static void broadcastAngerTarget(class_3218 level, @NotNull Crab crab, class_1309 target) {
        Optional<List<Crab>> nearbyCrabs = CrabAi.getNearbyCrabs(crab);
        nearbyCrabs.ifPresent(crabs -> crabs.forEach(listedCrab -> CrabAi.setAngerTargetIfCloserThanCurrent(level, listedCrab, target)));
    }

    private static void setAngerTargetIfCloserThanCurrent(class_3218 level, @NotNull Crab crab, class_1309 currentTarget) {
        Optional<class_1309> optional = CrabAi.getAngerTarget(crab);
        class_1309 livingEntity = class_4215.method_24562((class_1309)crab, optional, (class_1309)currentTarget);
        if (optional.isPresent() && optional.get() == livingEntity) {
            return;
        }
        CrabAi.setAngerTarget(level, crab, livingEntity);
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(class_3218 level, Crab crab, class_1309 currentTarget) {
        Optional<class_1657> optional = CrabAi.getNearestVisibleTargetablePlayer(crab);
        if (optional.isPresent()) {
            CrabAi.setAngerTarget(level, crab, (class_1309)optional.get());
        } else {
            CrabAi.setAngerTarget(level, crab, currentTarget);
        }
    }

    @NotNull
    private static Optional<class_1309> getAngerTarget(@NotNull Crab crab) {
        return crab.method_18868().method_18904(class_4140.field_22355);
    }

    @NotNull
    private static Optional<List<Crab>> getNearbyCrabs(@NotNull Crab crab) {
        return crab.method_18868().method_18904(WWMemoryModuleTypes.NEARBY_CRABS);
    }

    public static Optional<class_1657> getNearestVisibleTargetablePlayer(@NotNull Crab crab) {
        return crab.method_18868().method_18896(class_4140.field_22354) ? crab.method_18868().method_18904(class_4140.field_22354) : Optional.empty();
    }

    public static void setDigCooldown(@NotNull Crab crab) {
        crab.method_18868().method_24525(class_4140.field_38103, (Object)class_3902.field_17274, (long)CrabAi.getRandomDigCooldown((class_1309)crab));
    }

    public static void clearDigCooldown(@NotNull Crab crab) {
        crab.method_18868().method_18875(class_4140.field_38103);
    }

    public static boolean isUnderground(@NotNull Crab crab) {
        return crab.method_18868().method_18896(WWMemoryModuleTypes.IS_UNDERGROUND);
    }

    public static boolean isIdle(@NotNull Crab crab) {
        return crab.method_18868().method_18906(class_4168.field_18595);
    }

    @NotNull
    public static Predicate<class_1799> getTemptations() {
        return itemStack -> itemStack.method_31573(WWItemTags.CRAB_FOOD);
    }

    public static int getRandomDigCooldown(@NotNull class_1309 entity) {
        return entity.method_59922().method_43051(800, 2400);
    }

    public static int getRandomEmergeCooldown(@NotNull class_1309 entity) {
        return entity.method_59922().method_43051(800, 2400);
    }

    public static void stopWalking(@NotNull Crab crab) {
        crab.method_18868().method_18875(class_4140.field_18445);
        crab.endNavigation();
    }
}

