/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.ai.ostrich;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.frozenblock.wilderwild.entity.Ostrich;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichLayEgg;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichMeleeAttack;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichPanic;
import net.frozenblock.wilderwild.entity.ai.ostrich.OstrichRunAroundLikeCrazy;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.frozenblock.wilderwild.registry.WWSensorTypes;
import net.frozenblock.wilderwild.tag.WWItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_4806;
import net.minecraft.class_4813;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_5134;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_7687;
import net.minecraft.class_7894;
import net.minecraft.class_7895;
import net.minecraft.class_7898;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OstrichAi {
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_ATTACKING = 1.75f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 1.25f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 0.8f;
    private static final class_6019 ADULT_FOLLOW_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final ImmutableList<class_4149<? extends class_4148<? super Ostrich>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, WWSensorTypes.OSTRICH_TEMPTATIONS, (Object)class_4149.field_25362, (Object)class_4149.field_18467, WWSensorTypes.OSTRICH_SPECIFIC_SENSOR);
    private static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_39408, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_18446, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18442, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object)class_4140.field_40127, (Object)class_4140.field_28327, (Object[])new class_4140[]{class_4140.field_18448, class_4140.field_25359, class_4140.field_37443, class_4140.field_22333, class_4140.field_25361, class_4140.field_22355, class_4140.field_30243, class_4140.field_18441, class_4140.field_18443, class_4140.field_18444, class_4140.field_22354, WWMemoryModuleTypes.NEARBY_OSTRICHES, class_4140.field_22475});

    @NotNull
    public static class_4095.class_5303<Ostrich> brainProvider() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    public static class_4095<?> makeBrain(@NotNull Ostrich ostrich, @NotNull class_4095<Ostrich> brain) {
        OstrichAi.initCoreActivity(brain);
        OstrichAi.initIdleActivity(brain);
        OstrichAi.initFightActivity(ostrich, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(@NotNull class_4095<Ostrich> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)((Object)new OstrichLayEgg(WWBlocks.OSTRICH_EGG)), (Object)((Object)new OstrichPanic(2.0f, pathfinderMob -> pathfinderMob.method_6109() ? class_8103.field_51990 : class_8103.field_51991)), (Object)((Object)new OstrichRunAroundLikeCrazy(1.5f)), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(class_4140.field_40127), (Object)class_4829.method_47143()));
    }

    private static void initIdleActivity(@NotNull class_4095<Ostrich> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_7895.method_47069((class_1299)class_1299.field_6097, (float)6.0f, (class_6019)class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new class_4806(WWEntityTypes.OSTRICH, 0.8f, 2)), (Object)Pair.of((Object)2, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)new class_5754(livingEntity -> Float.valueOf(1.25f), livingEntity -> livingEntity.method_6109() ? 2.5 : 3.5), (Object)1), (Object)Pair.of((Object)class_7898.method_47227(Predicate.not(Ostrich::refuseToMove), (class_7894)class_5355.method_46896((class_6019)ADULT_FOLLOW_RANGE, (float)1.25f)), (Object)1)))), (Object)Pair.of((Object)3, (Object)class_4824.method_47119(OstrichAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)4, (Object)new class_7687((class_6017)class_6019.method_35017((int)150, (int)250), 80.0f, -70.0f, 70.0f)), (Object)Pair.of((Object)5, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_7898.method_47227(Predicate.not(Ostrich::refuseToMove), (class_7894)class_4818.method_47014((float)1.0f)), (Object)1), (Object)Pair.of((Object)class_7898.method_47227(Predicate.not(Ostrich::refuseToMove), (class_7894)class_4120.method_47104((float)1.0f, (int)3)), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))));
    }

    private static void initFightActivity(@NotNull Ostrich ostrich, @NotNull class_4095<Ostrich> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47139((level, livingEntity) -> !ostrich.canTargetEntity((class_1297)livingEntity), OstrichAi::onTargetInvalid, (boolean)true), (Object)class_4119.method_47065(livingEntity -> OstrichAi.isTarget(ostrich, livingEntity), (float)((float)ostrich.method_45325(class_5134.field_23717))), (Object)class_4822.method_47098(OstrichAi::getSpeedModifierChasing), OstrichMeleeAttack.create(5), (Object)class_4813.method_46922(class_4215::method_41331, (class_4140)class_4140.field_22355)), class_4140.field_22355);
    }

    public static void updateActivity(@NotNull Ostrich ostrich) {
        ostrich.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
    }

    private static boolean isTarget(@NotNull Ostrich ostrich, @NotNull class_1309 livingEntity) {
        return ostrich.method_18868().method_18904(class_4140.field_22355).filter(livingEntity2 -> livingEntity2 == livingEntity).isPresent();
    }

    private static void onTargetInvalid(class_3218 level, @NotNull Ostrich ostrich, @NotNull class_1309 target) {
        if (ostrich.method_5968() == target) {
            OstrichAi.removeAttackAndAngerTarget(ostrich);
        }
        ostrich.method_5942().method_6340();
    }

    @NotNull
    private static Optional<? extends class_1309> findNearestValidAttackTarget(class_3218 level, @NotNull Ostrich ostrich) {
        Optional optional2;
        class_4095<Ostrich> brain = ostrich.method_18868();
        Optional optional = class_4215.method_24560((class_1309)ostrich, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && class_4148.method_37456((class_3218)level, (class_1309)ostrich, (class_1309)((class_1309)optional.get()))) {
            return optional;
        }
        if (brain.method_18896(class_4140.field_25361) && (optional2 = brain.method_18904(class_4140.field_22354)).isPresent()) {
            return optional2;
        }
        return brain.method_18904(class_4140.field_30243);
    }

    public static void wasHurtBy(class_3218 level, @NotNull Ostrich ostrich, class_1309 target) {
        if (ostrich.canTargetEntity((class_1297)target)) {
            if (!class_4148.method_37456((class_3218)level, (class_1309)ostrich, (class_1309)target)) {
                return;
            }
            if (class_4215.method_24558((class_1309)ostrich, (class_1309)target, (double)4.0)) {
                return;
            }
            if (ostrich.method_6109()) {
                if (class_4148.method_37456((class_3218)level, (class_1309)ostrich, (class_1309)target)) {
                    OstrichAi.broadcastAngerTarget(level, ostrich, target);
                }
                return;
            }
            if (target.method_5864() == class_1299.field_6097 && level.method_64395().method_8355(class_1928.field_25402)) {
                OstrichAi.setAngerTargetToNearestTargetablePlayerIfFound(level, ostrich, target);
                OstrichAi.broadcastUniversalAnger(level, ostrich);
            } else {
                OstrichAi.setAngerTarget(level, ostrich, target);
                OstrichAi.broadcastAngerTarget(level, ostrich, target);
            }
        }
    }

    public static void setAngerTarget(class_3218 level, @NotNull Ostrich ostrich, class_1309 target) {
        if (ostrich.method_6109()) {
            return;
        }
        if (!class_4148.method_37456((class_3218)level, (class_1309)ostrich, (class_1309)target)) {
            return;
        }
        ostrich.method_18868().method_18875(class_4140.field_19293);
        ostrich.method_18868().method_18878(class_4140.field_22355, (Object)target);
        ostrich.method_18868().method_24525(class_4140.field_22333, (Object)target.method_5667(), 600L);
        if (target.method_5864() == class_1299.field_6097 && level.method_64395().method_8355(class_1928.field_25402)) {
            ostrich.method_18868().method_24525(class_4140.field_25361, (Object)true, 600L);
        }
    }

    private static void broadcastUniversalAnger(class_3218 level, Ostrich ostrichEntity) {
        Optional<List<Ostrich>> nearbyOstriches = OstrichAi.getNearbyOstriches(ostrichEntity);
        nearbyOstriches.ifPresent(ostriches -> ostriches.forEach(ostrich -> OstrichAi.getNearestVisibleTargetablePlayer(ostrich).ifPresent(player -> OstrichAi.setAngerTarget(level, ostrich, (class_1309)player))));
    }

    public static void broadcastAngerTarget(class_3218 level, @NotNull Ostrich crab, class_1309 target) {
        Optional<List<Ostrich>> nearbyOstriches = OstrichAi.getNearbyOstriches(crab);
        nearbyOstriches.ifPresent(ostriches -> ostriches.forEach(listedOstrich -> OstrichAi.setAngerTargetIfCloserThanCurrent(level, listedOstrich, target)));
    }

    private static void setAngerTargetIfCloserThanCurrent(class_3218 level, @NotNull Ostrich ostrich, class_1309 currentTarget) {
        Optional<class_1309> optional = OstrichAi.getAngerTarget(ostrich);
        class_1309 livingEntity = class_4215.method_24562((class_1309)ostrich, optional, (class_1309)currentTarget);
        if (optional.isPresent() && optional.get() == livingEntity) {
            return;
        }
        OstrichAi.setAngerTarget(level, ostrich, livingEntity);
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(class_3218 level, Ostrich ostrich, class_1309 currentTarget) {
        Optional<class_1657> optional = OstrichAi.getNearestVisibleTargetablePlayer(ostrich);
        if (optional.isPresent()) {
            OstrichAi.setAngerTarget(level, ostrich, (class_1309)optional.get());
        } else {
            OstrichAi.setAngerTarget(level, ostrich, currentTarget);
        }
    }

    @NotNull
    private static Optional<List<Ostrich>> getNearbyOstriches(@NotNull Ostrich ostrich) {
        return ostrich.method_18868().method_18904(WWMemoryModuleTypes.NEARBY_OSTRICHES);
    }

    public static Optional<class_1657> getNearestVisibleTargetablePlayer(@NotNull Ostrich ostrich) {
        return ostrich.method_18868().method_18896(class_4140.field_22354) ? ostrich.method_18868().method_18904(class_4140.field_22354) : Optional.empty();
    }

    @NotNull
    private static Optional<class_1309> getAngerTarget(@NotNull Ostrich ostrich) {
        return ostrich.method_18868().method_18904(class_4140.field_22355);
    }

    public static void removeAttackAndAngerTarget(@NotNull Ostrich ostrich) {
        class_4095<Ostrich> brain = ostrich.method_18868();
        brain.method_18875(class_4140.field_22355);
        brain.method_18875(class_4140.field_22333);
        brain.method_18875(class_4140.field_25361);
    }

    private static float getSpeedModifierChasing(@Nullable class_1309 livingEntity) {
        return 1.75f;
    }

    public static Predicate<class_1799> getTemptations() {
        return itemStack -> itemStack.method_31573(WWItemTags.OSTRICH_FOOD);
    }
}

