/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class TermiteParticle
extends class_4003 {
    private final TermiteRotationType xRot;
    private final TermiteRotationType yRot;
    private final TermiteRotationType zRot;
    private final boolean backwardsX;
    private final boolean backwardsY;
    private final boolean backwardsZ;
    private final float xOffset;
    private final float yOffset;
    private final float zOffset;
    private final float xSpinSpeed;
    private final float ySpinSpeed;
    private final float zSpinSpeed;
    private float prevScale = 0.0f;
    private float scale = 0.0f;
    private float targetScale = 0.0f;

    public TermiteParticle(@NotNull class_638 clientLevel, @NotNull class_4002 spriteProvider, double x, double y, double z) {
        super(clientLevel, x, y, z);
        this.method_18140(spriteProvider);
        this.field_3862 = false;
        this.field_3874 = x;
        this.field_3854 = y;
        this.field_3871 = z;
        class_5819 random = clientLevel.method_8409();
        this.xRot = random.method_43056() ? TermiteRotationType.COS : TermiteRotationType.SIN;
        this.yRot = random.method_43056() ? TermiteRotationType.COS : TermiteRotationType.SIN;
        this.zRot = random.method_43056() ? TermiteRotationType.COS : TermiteRotationType.SIN;
        this.backwardsX = random.method_43056();
        this.backwardsY = random.method_43056();
        this.backwardsZ = random.method_43056();
        this.xOffset = random.method_43057() * 240.0f;
        this.yOffset = random.method_43057() * 240.0f;
        this.zOffset = random.method_43057() * 240.0f;
        this.xSpinSpeed = 8.0f + random.method_43057() * 8.0f;
        this.ySpinSpeed = 8.0f + random.method_43057() * 8.0f;
        this.zSpinSpeed = 8.0f + random.method_43057() * 8.0f;
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3070() {
        this.prevScale = this.scale;
        this.scale += (this.targetScale - this.scale) * 0.65f;
        if (this.field_3866++ >= this.field_3847) {
            if (this.prevScale <= 0.05f) {
                this.method_3085();
            } else {
                this.targetScale = 0.0f;
            }
        } else {
            this.targetScale = 1.0f;
        }
    }

    private float cos(float progress, float offset, float spinSpeed) {
        return (float)Math.cos((double)(progress + offset) * Math.PI / (double)spinSpeed);
    }

    private float sin(float progress, float offset, float spinSpeed) {
        return (float)Math.sin((double)(progress + offset) * Math.PI / (double)spinSpeed);
    }

    private float rotate(@NotNull TermiteRotationType rotation, float progress, float offset, float spinSpeed) {
        return rotation == TermiteRotationType.COS ? this.cos(progress, offset, spinSpeed) : this.sin(progress, offset, spinSpeed);
    }

    protected void method_60373(class_4588 vertexConsumer, @NotNull class_4184 camera, Quaternionf quaternionf, float partialTick) {
        class_243 vec3 = camera.method_19326();
        float animationProgress = (float)this.field_3866 + partialTick;
        float xRotation = this.rotate(this.xRot, animationProgress, this.xOffset, this.xSpinSpeed) * (float)(this.backwardsX ? -1 : 1) * 0.65f;
        float yRotation = this.rotate(this.yRot, animationProgress, this.yOffset, this.ySpinSpeed) * (float)(this.backwardsY ? -1 : 1) * 0.65f;
        float zRotation = this.rotate(this.zRot, animationProgress, this.zOffset, this.zSpinSpeed) * (float)(this.backwardsZ ? -1 : 1) * 0.65f;
        float g = (float)(this.field_3874 - vec3.method_10216() + (double)xRotation);
        float h = (float)(this.field_3854 - vec3.method_10214() + (double)yRotation);
        float i = (float)(this.field_3871 - vec3.method_10215() + (double)zRotation);
        this.method_60374(vertexConsumer, quaternionf, g, h, i, partialTick);
    }

    protected int method_3068(float partialTick) {
        float animationProgress = (float)this.field_3866 + partialTick;
        float xRotation = this.rotate(this.xRot, animationProgress, this.xOffset, this.xSpinSpeed) * (float)(this.backwardsX ? -1 : 1) * 0.65f;
        float yRotation = this.rotate(this.yRot, animationProgress, this.yOffset, this.ySpinSpeed) * (float)(this.backwardsY ? -1 : 1) * 0.65f;
        float zRotation = this.rotate(this.zRot, animationProgress, this.zOffset, this.zSpinSpeed) * (float)(this.backwardsZ ? -1 : 1) * 0.65f;
        class_2338 blockPos = this.getLerpedTermiteBlockPos(this.field_3874, this.field_3854, this.field_3871, xRotation, yRotation, zRotation);
        return this.field_3851.method_22340(blockPos) ? class_761.method_23794((class_1920)this.field_3851, (class_2338)blockPos) : 0;
    }

    @NotNull
    private class_2338 getLerpedTermiteBlockPos(double x, double y, double z, float cos, float sin, float aCos) {
        return class_2338.method_49637((double)(x + (double)cos), (double)(y + (double)sin), (double)(z + (double)aCos));
    }

    public float method_18132(float partialTicks) {
        return this.field_17867 * class_3532.method_16439((float)partialTicks, (float)this.prevScale, (float)this.scale);
    }

    static enum TermiteRotationType {
        COS,
        SIN;

    }

    @Environment(value=EnvType.CLIENT)
    public record Factory(@NotNull class_4002 spriteProvider) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 termiteParticleOptions, @NotNull class_638 clientLevel, double x, double y, double z, double g, double h, double i) {
            TermiteParticle termite = new TermiteParticle(clientLevel, this.spriteProvider, x, y, z);
            termite.method_3083(1.0f);
            termite.method_3077(clientLevel.method_8409().method_43048(10) + 5 + termite.field_3866);
            termite.method_3087(0.75f);
            return termite;
        }
    }
}

