/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.particle;

import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.wilderwild.config.WWAmbienceAndMiscConfig;
import net.frozenblock.wilderwild.particle.options.WindParticleOptions;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class WindParticle
extends class_4003 {
    private static final Vector3f NORMALIZED_QUAT_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private final class_4002 spriteProvider;
    private int ageBeforeDissipating;
    private float prevYRot;
    private float yRot;
    private float prevXRot;
    private float xRot;
    private float prevRotMultiplier;
    private float rotMultiplier;
    private boolean shouldDissipate;
    private boolean flipped;
    private boolean chosenSide;

    WindParticle(@NotNull class_638 level, @NotNull class_4002 spriteProvider, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(level, x, y, z, velocityX, velocityY, velocityZ);
        this.field_17867 *= 3.0f;
        this.method_3080(0.3f, 0.3f);
        this.spriteProvider = spriteProvider;
        this.method_18142(spriteProvider);
        this.field_3847 = 19;
        this.field_3862 = false;
        this.field_28786 = 0.95f;
        this.field_3844 = 0.0f;
    }

    public void method_3070() {
        super.method_3070();
        this.prevYRot = this.yRot;
        this.prevXRot = this.xRot;
        if (!this.shouldDissipate) {
            double multXZ = 0.007;
            double multY = 0.0010425;
            class_243 pos = new class_243(this.field_3874, this.field_3854, this.field_3871);
            class_243 wind = ClientWindManager.getWindMovement((class_1937)this.field_3851, (class_243)pos, (double)1.0, (double)7.0, (double)5.0).method_1021(WWAmbienceAndMiscConfig.getParticleWindIntensity());
            this.field_3852 += wind.method_10216() * multXZ;
            this.field_3869 += wind.method_10214() * multY;
            this.field_3850 += wind.method_10215() * multXZ;
            double horizontalDistance = Math.sqrt(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850);
            double newYRot = class_3532.method_15349((double)this.field_3852, (double)this.field_3850) * 57.2957763671875;
            double newXRot = class_3532.method_15349((double)horizontalDistance, (double)this.field_3869) * 57.2957763671875;
            if (Math.abs(newYRot - (double)this.prevYRot) > 180.0) {
                newYRot += 360.0;
            }
            if (Math.abs(newXRot - (double)this.prevXRot) > 180.0) {
                newXRot += 360.0;
            }
            double newYRotDifference = newYRot - (double)this.yRot;
            double newXRotDifference = newXRot - (double)this.xRot;
            this.yRot += (float)newYRotDifference * 0.25f;
            this.xRot += (float)newXRotDifference * 0.25f;
            if (this.yRot > 360.0f) {
                this.yRot -= 360.0f;
                this.prevYRot -= 360.0f;
            } else if (this.yRot < 0.0f) {
                this.yRot += 360.0f;
                this.prevYRot += 360.0f;
            }
            if (this.xRot > 360.0f) {
                this.xRot -= 360.0f;
                this.prevXRot -= 360.0f;
            } else if (this.xRot < 0.0f) {
                this.xRot += 360.0f;
                this.prevXRot += 360.0f;
            }
        } else {
            this.field_28786 = 0.2f;
        }
        this.prevRotMultiplier = this.rotMultiplier;
        this.rotMultiplier = (float)Math.sin(this.xRot * (float)Math.PI / 180.0f);
        if (this.shouldDissipate && this.field_3866 > 7 && this.field_3866 < this.ageBeforeDissipating) {
            this.field_3866 = this.ageBeforeDissipating;
        }
        if (this.field_3866 >= this.ageBeforeDissipating && !this.chosenSide) {
            this.chosenSide = true;
            this.flipped = this.field_3851.field_9229.method_43056();
            this.field_3847 = this.ageBeforeDissipating + 11;
        }
        this.method_18142(this.spriteProvider);
    }

    public void method_3069(double x, double y, double z) {
        if (!this.shouldDissipate) {
            boolean canDissipate;
            class_243 vec3;
            double d = x;
            double e = y;
            double f = z;
            if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < class_3532.method_33723((double)100.0)) {
                vec3 = class_1297.method_20736(null, (class_243)new class_243(x, y, z), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
                x = vec3.field_1352;
                y = vec3.field_1351;
                z = vec3.field_1350;
            }
            vec3 = new class_243(d, e, f);
            boolean bl = canDissipate = this.field_3866 > 7;
            if (canDissipate && vec3.method_1033() < 0.0065) {
                this.shouldDissipate = true;
            }
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                this.method_3067(this.method_3064().method_989(x, y, z));
                this.method_3072();
            } else if (canDissipate) {
                this.shouldDissipate = true;
            }
            if (Math.abs(e) >= (double)1.0E-5f && Math.abs(y) < (double)1.0E-5f) {
                this.shouldDissipate = true;
            }
            boolean bl2 = this.field_3845 = e != y && e < 0.0;
            if (d != x) {
                this.field_3852 = 0.0;
                this.shouldDissipate = true;
            }
            if (f != z) {
                this.field_3850 = 0.0;
                this.shouldDissipate = true;
            }
        }
    }

    public void method_18142(@NotNull class_4002 spriteProvider) {
        if (!this.field_3843) {
            int i = this.field_3866 < 8 ? this.field_3866 : (this.field_3866 < this.ageBeforeDissipating ? 8 : this.field_3866 - this.ageBeforeDissipating + 9);
            this.method_18141(spriteProvider.method_18138(Math.min(i, 20), 20));
        }
    }

    public void method_3074(class_4588 buffer, @NotNull class_4184 renderInfo, float partialTicks) {
        float yRot = class_3532.method_16439((float)partialTicks, (float)this.prevYRot, (float)this.yRot) * ((float)Math.PI / 180);
        float xRot = class_3532.method_16439((float)partialTicks, (float)this.prevXRot, (float)this.xRot) * ((float)(-Math.PI) / 180);
        float cameraRotWhileVertical = -renderInfo.method_19330() * (1.0f - class_3532.method_16439((float)partialTicks, (float)this.prevRotMultiplier, (float)this.rotMultiplier)) * ((float)Math.PI / 180);
        float cameraXRot = renderInfo.method_19329();
        float rotationOffset = 90.0f;
        float x = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874);
        float y = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854);
        float z = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871);
        class_243 particlePos = new class_243((double)x, (double)y, (double)z);
        class_243 cameraPos = renderInfo.method_19326();
        double normalizedRelativeY = particlePos.method_1020((class_243)cameraPos).method_1029().method_1020((class_243)new class_243((double)this.field_3852, (double)this.field_3869, (double)this.field_3850).method_1029()).method_1029().field_1351;
        double particleRotation = AdvancedMath.getAngleFromOriginXZ((class_243)new class_243(this.field_3852, 0.0, this.field_3850));
        double angleToParticle = AdvancedMath.getAngleBetweenXZ((class_243)particlePos, (class_243)cameraPos);
        double relativeParticleAngle = (360.0 + (angleToParticle - particleRotation)) % 360.0;
        if (normalizedRelativeY > 0.0) {
            cameraXRot = class_3532.method_16439((float)class_3532.method_27285((float)((float)normalizedRelativeY)), (float)cameraXRot, (float)-90.0f);
        } else if (normalizedRelativeY < 0.0) {
            cameraXRot = class_3532.method_16439((float)class_3532.method_27285((float)((float)Math.abs(normalizedRelativeY))), (float)cameraXRot, (float)90.0f);
        }
        float fixedRotation = rotationOffset + cameraXRot;
        if (relativeParticleAngle > 0.0 && relativeParticleAngle < 180.0) {
            fixedRotation *= -1.0f;
        }
        float cameraRotWhileSideways = fixedRotation * class_3532.method_16439((float)partialTicks, (float)this.prevRotMultiplier, (float)this.rotMultiplier) * ((float)Math.PI / 180);
        this.renderParticle(buffer, cameraPos, partialTicks, this.flipped, transforms -> transforms.rotateY(yRot).rotateX(-xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical));
        this.renderParticle(buffer, cameraPos, partialTicks, !this.flipped, transforms -> transforms.rotateY((float)(-Math.PI) + yRot).rotateX(xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical));
    }

    private void renderParticle(class_4588 buffer, @NotNull class_243 cameraPos, float partialTicks, boolean flipped, @NotNull Consumer<Quaternionf> quaternionConsumer) {
        float f = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float g = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float h = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, NORMALIZED_QUAT_VECTOR.x(), NORMALIZED_QUAT_VECTOR.y(), NORMALIZED_QUAT_VECTOR.z());
        quaternionConsumer.accept(quaternionf);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float i = this.method_18132(partialTicks);
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f2 = vector3fs[j];
            vector3f2.rotate((Quaternionfc)quaternionf);
            vector3f2.mul(i);
            vector3f2.add(f, g, h);
        }
        float k = !flipped ? this.method_18133() : this.method_18134();
        float l = !flipped ? this.method_18134() : this.method_18133();
        float m = this.method_18135();
        float n = this.method_18136();
        int light = this.method_3068(partialTicks);
        buffer.method_22912(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).method_22913(l, n).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        buffer.method_22912(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).method_22913(l, m).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        buffer.method_22912(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).method_22913(k, m).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
        buffer.method_22912(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).method_22913(k, n).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Environment(value=EnvType.CLIENT)
    public record Factory(@NotNull class_4002 spriteProvider) implements class_707<WindParticleOptions>
    {
        @NotNull
        public class_703 createParticle(@NotNull WindParticleOptions options, @NotNull class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            class_243 velocity = options.getVelocity();
            WindParticle windParticle = new WindParticle(level, this.spriteProvider, x, y, z, 0.0, 0.0, 0.0);
            windParticle.ageBeforeDissipating = options.getLifespan();
            windParticle.field_3847 += windParticle.ageBeforeDissipating;
            windParticle.flipped = level.field_9229.method_43056();
            windParticle.field_3852 = velocity.field_1352;
            windParticle.field_3850 = velocity.field_1350;
            windParticle.field_3869 = velocity.field_1351;
            double horizontalDistance = Math.sqrt(windParticle.field_3852 * windParticle.field_3852 + windParticle.field_3850 * windParticle.field_3850);
            windParticle.yRot += (float)class_3532.method_15349((double)windParticle.field_3852, (double)windParticle.field_3850) * 57.295776f;
            windParticle.xRot += (float)class_3532.method_15349((double)horizontalDistance, (double)windParticle.field_3869) * 57.295776f;
            windParticle.prevYRot = windParticle.yRot;
            windParticle.prevXRot = windParticle.xRot;
            return windParticle;
        }
    }
}

