/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.frozenblock.wilderwild.block.impl.SnowloggingUtils;
import net.frozenblock.wilderwild.block.impl.SnowyBlockUtils;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class SnowBlanketFeature
extends class_3031<class_3111> {
    public SnowBlanketFeature(@NotNull Codec<class_3111> codec) {
        super(codec);
    }

    private static boolean placeSnowAtPos(@NotNull class_5281 level, @NotNull class_2338.class_2339 topPos, @NotNull class_2338.class_2339 bottomPos, @NotNull class_2338.class_2339 mutable, @NotNull Optional<class_6880<class_1959>> optionalBiomeHolder) {
        if (SnowBlanketFeature.placeSnowLayer(level, bottomPos, mutable, optionalBiomeHolder, true) == SnowGenerationState.CANCEL) {
            return false;
        }
        boolean returnValue = true;
        bottomPos.method_10098(class_2350.field_11036);
        while (bottomPos.method_10264() <= topPos.method_10264()) {
            SnowBlanketFeature.placeSnowLayer(level, bottomPos, mutable, optionalBiomeHolder, false);
            bottomPos.method_10098(class_2350.field_11036);
        }
        return returnValue;
    }

    @NotNull
    private static SnowGenerationState placeSnowLayer(@NotNull class_5281 level, @NotNull class_2338.class_2339 mutablePos, @NotNull class_2338.class_2339 mutablePos2, @NotNull Optional<class_6880<class_1959>> optionalBiomeHolder, boolean cancelIfCantSnow) {
        class_1959 biome = (class_1959)optionalBiomeHolder.orElse((class_6880<class_1959>)level.method_23753((class_2338)mutablePos)).comp_349();
        if (cancelIfCantSnow && biome.method_39927((class_2338)mutablePos, level.method_8615())) {
            return SnowGenerationState.CANCEL;
        }
        if (biome.method_8696((class_4538)level, (class_2338)mutablePos)) {
            class_2680 replacingState = SnowyBlockUtils.replaceWithWorldgenSnowyEquivalent(level, level.method_8320((class_2338)mutablePos), (class_2338)mutablePos);
            if (SnowloggingUtils.canSnowlog(replacingState) && !SnowloggingUtils.isSnowlogged(replacingState)) {
                level.method_8652((class_2338)mutablePos, (class_2680)replacingState.method_11657((class_2769)SnowloggingUtils.SNOW_LAYERS, (Comparable)Integer.valueOf(1)), 2);
            } else {
                level.method_8652((class_2338)mutablePos, class_2246.field_10477.method_9564(), 2);
            }
            class_2680 belowState = level.method_8320((class_2338)mutablePos2.method_25505((class_2382)mutablePos, class_2350.field_11033));
            if (belowState.method_28498((class_2769)class_2741.field_12512)) {
                level.method_8652((class_2338)mutablePos2, (class_2680)belowState.method_11657((class_2769)class_2741.field_12512, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return SnowGenerationState.CONTINUE;
    }

    private static int findLowestHeightForSnow(@NotNull class_5281 level, int x, int z) {
        class_2680 state;
        int bottomHeight = level.method_8624(class_2902.class_2903.field_13203, x, z);
        class_2338.class_2339 pos = new class_2338.class_2339().method_10103(x, bottomHeight, z);
        while (((state = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033))).method_26164(WWBlockTags.SNOW_GENERATION_CAN_SEARCH_THROUGH) || state.method_26215()) && state.method_26227().method_15769()) {
            --bottomHeight;
        }
        return bottomHeight;
    }

    public boolean method_13151(@NotNull class_5821<class_3111> context) {
        class_2338 pos = context.method_33655();
        class_5281 level = context.method_33652();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_2338.class_2339 mutableSnowPos = new class_2338.class_2339();
        class_2338.class_2339 mutableSnowPos2 = new class_2338.class_2339();
        class_2338.class_2339 mutableIcePos = new class_2338.class_2339();
        boolean returnValue = false;
        int posX = pos.method_10263();
        int posZ = pos.method_10260();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int bottomHeight;
                int x = posX + i;
                int z = posZ + j;
                int height = level.method_8624(class_2902.class_2903.field_13197, x, z);
                if (height <= (bottomHeight = SnowBlanketFeature.findLowestHeightForSnow(level, x, z))) continue;
                mutablePos.method_10103(x, height, z);
                mutableSnowPos.method_10103(x, bottomHeight, z);
                class_6880 biomeHolder = level.method_23753((class_2338)mutablePos);
                class_6880 lowerBiomeHolder = level.method_23753((class_2338)mutableSnowPos);
                mutableIcePos.method_25505((class_2382)mutableSnowPos, class_2350.field_11033);
                if (((class_1959)lowerBiomeHolder.comp_349()).method_8685((class_4538)level, (class_2338)mutableIcePos, false)) {
                    level.method_8652((class_2338)mutableIcePos, class_2246.field_10295.method_9564(), 2);
                }
                Optional<class_6880<class_1959>> optionalBiomeHolder = biomeHolder.equals((Object)lowerBiomeHolder) ? Optional.of(biomeHolder) : Optional.empty();
                returnValue = SnowBlanketFeature.placeSnowAtPos(level, mutablePos, mutableSnowPos, mutableSnowPos2, optionalBiomeHolder) || returnValue;
            }
        }
        return returnValue;
    }

    private static enum SnowGenerationState {
        CANCEL,
        CONTINUE;

    }
}

